/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.ui.resources.svg;

import com.jcloisterzone.XMLUtils;
import com.jcloisterzone.ui.ImmutablePoint;
import com.jcloisterzone.ui.resources.AreaRotationScaling;
import com.jcloisterzone.ui.resources.FeatureDescriptor;
import com.jcloisterzone.ui.resources.svg.SvgTransformationCollector;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class PointsParser {
    final URL resource;
    private Map<FeatureDescriptor, ImmutablePoint> points;
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());

    public PointsParser(URL resource) {
        this.resource = resource;
    }

    private void processPointElement(Element pointNode) {
        int cx = Integer.parseInt(pointNode.getAttribute("cx"));
        int cy = Integer.parseInt(pointNode.getAttribute("cy"));
        final Point destPoint = new Point();
        final Point srcPoint = new Point(cx, cy);
        SvgTransformationCollector transformCollector = new SvgTransformationCollector(pointNode, 1.0);
        transformCollector.collect(new SvgTransformationCollector.GeometryHandler(){
            final /* synthetic */ PointsParser this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void processApply(Element node, FeatureDescriptor fd, AffineTransform transform, AreaRotationScaling rotScaling) {
                assert (!this.this$0.points.containsKey(fd)) : fd + " already defined";
                transform.transform(srcPoint, destPoint);
                this.this$0.points.put(fd, new ImmutablePoint(destPoint.x / 10, destPoint.y / 10));
            }

            @Override
            public void processSubstract(Element node, String tileId, AffineTransform transform, boolean isFarm) {
                throw new UnsupportedOperationException("<subtract> not allowed for points.xml");
            }
        });
    }

    public Map<FeatureDescriptor, ImmutablePoint> parse() {
        try {
            return this.doParse();
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            this.logger.error(e.getMessage(), e);
            return new HashMap<FeatureDescriptor, ImmutablePoint>();
        }
    }

    private Map<FeatureDescriptor, ImmutablePoint> doParse() throws IOException, SAXException, ParserConfigurationException {
        Element root = XMLUtils.parseDocument(this.resource).getDocumentElement();
        NodeList nl = root.getElementsByTagName("point");
        this.points = new HashMap<FeatureDescriptor, ImmutablePoint>();
        for (int i = 0; i < nl.getLength(); ++i) {
            this.processPointElement((Element)nl.item(i));
        }
        return this.points;
    }
}

