/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.ui.resources.svg;

import com.jcloisterzone.XMLUtils;
import com.jcloisterzone.board.Location;
import com.jcloisterzone.board.Rotation;
import com.jcloisterzone.ui.resources.AreaRotationScaling;
import com.jcloisterzone.ui.resources.FeatureDescriptor;
import java.awt.geom.AffineTransform;
import java.util.ArrayDeque;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SvgTransformationCollector {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Element root;
    private final Location baseLocation;
    private final double imageSizeRatio;
    private final boolean isRectangular;
    private final AreaRotationScaling rotationScaling;
    private ArrayDeque<AffineTransform> transforms = new ArrayDeque();

    public SvgTransformationCollector(Element root, double imageSizeRatio) {
        this.imageSizeRatio = imageSizeRatio;
        this.isRectangular = Math.abs(imageSizeRatio - 1.0) > 1.0E-5;
        this.rotationScaling = AreaRotationScaling.fromXmlAttr(root.getAttribute("avoidRotationScaling"));
        this.root = root;
        this.baseLocation = root.hasAttribute("baseLocation") ? Location.valueOf(root.getAttribute("baseLocation")) : null;
    }

    public void collect(GeometryHandler handler) {
        try {
            this.collect(this.root, handler);
        }
        catch (Exception ex) {
            this.logger.error("Invalid geometry definition:\n" + XMLUtils.nodeToString(this.root), ex);
        }
    }

    private void concatenateRotation(AffineTransform af, Rotation rot) {
        if (Rotation.R0 == rot) {
            return;
        }
        if (this.isRectangular) {
            if (rot == Rotation.R90 || rot == Rotation.R270) {
                this.rotationScaling.concatAffineTransform(af, this.imageSizeRatio);
            }
            af.concatenate(AffineTransform.getScaleInstance(1.0, this.imageSizeRatio));
            af.concatenate(rot.getAffineTransform(1000));
            af.concatenate(AffineTransform.getScaleInstance(1.0, 1.0 / this.imageSizeRatio));
        } else {
            af.concatenate(rot.getAffineTransform(1000));
        }
    }

    private AreaRotationScaling getEffectiveRotationScaling(Rotation rot) {
        if (rot == Rotation.R90 || rot == Rotation.R270) {
            return this.rotationScaling.reverse();
        }
        return this.rotationScaling;
    }

    private void collect(Element parent, GeometryHandler handler) {
        NodeList nl = parent.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            if (!(nl.item(i) instanceof Element)) continue;
            Element child = (Element)nl.item(i);
            boolean hasTransform = child.hasAttribute("svg:transform");
            if (hasTransform) {
                this.transforms.push(this.createTransformation(child.getAttribute("svg:transform")));
            }
            switch (child.getNodeName()) {
                case "apply": {
                    Rotation rot;
                    String[] tokens = child.getTextContent().split(" ");
                    FeatureDescriptor fd = FeatureDescriptor.valueOf(tokens[0], this.root.getAttribute("feature"), tokens[1]);
                    AffineTransform af = this.getTransform();
                    AreaRotationScaling ars = this.rotationScaling;
                    if (this.baseLocation != null) {
                        rot = fd.getLocation().getRotationOf(this.baseLocation);
                        this.concatenateRotation(af, rot);
                        ars = this.getEffectiveRotationScaling(rot);
                    }
                    handler.processApply(child, fd, af, ars);
                    if (!XMLUtils.attributeBoolValue(child, "allRotations")) break;
                    assert (this.baseLocation == null) : "baseLocation is not allowed together with allRotations attribute";
                    rot = Rotation.R90;
                    for (int ri = 0; ri < 3; ++ri) {
                        ars = this.getEffectiveRotationScaling(rot);
                        AffineTransform afCpy = new AffineTransform(af);
                        Location rotatedLoc = fd.getLocation().rotateCW(rot);
                        FeatureDescriptor rotatedFd = new FeatureDescriptor(fd.getTileId(), fd.getFeatureType(), rotatedLoc);
                        this.concatenateRotation(afCpy, rot);
                        handler.processApply(child, rotatedFd, afCpy, ars);
                        rot = rot.next();
                    }
                    break;
                }
                case "subtract": {
                    assert (this.baseLocation == null) : "baseLocation is not allowed together with subtraction element";
                    String feature = this.root.getAttribute("feature");
                    assert (feature.equals("") || feature.equals("FARM")) : "Substraction area can be declared only generic or for FARM";
                    handler.processSubstract(child, child.getTextContent(), this.getTransform(), feature.equals("FARM"));
                    break;
                }
                case "g": {
                    assert (this.baseLocation == null);
                    this.collect(child, handler);
                }
            }
            if (!hasTransform) continue;
            this.transforms.pop();
        }
    }

    private AffineTransform getTransform() {
        AffineTransform af = new AffineTransform();
        for (AffineTransform item : this.transforms) {
            af.concatenate(item);
        }
        return af;
    }

    private AffineTransform createTransformation(String svg) {
        switch (svg) {
            case "rotate(90 500 500)": {
                return AffineTransform.getRotateInstance(1.5707963267948966, 500.0, 500.0);
            }
            case "rotate(180 500 500)": {
                return AffineTransform.getRotateInstance(Math.PI, 500.0, 500.0);
            }
            case "rotate(270 500 500)": {
                return AffineTransform.getRotateInstance(4.71238898038469, 500.0, 500.0);
            }
            case "translate(1000,0) scale(-1, 1)": {
                AffineTransform af = AffineTransform.getTranslateInstance(1000.0, 0.0);
                af.concatenate(AffineTransform.getScaleInstance(-1.0, 1.0));
                return af;
            }
        }
        throw new IllegalArgumentException("Unsupported transform: " + svg);
    }

    public static interface GeometryHandler {
        public void processApply(Element var1, FeatureDescriptor var2, AffineTransform var3, AreaRotationScaling var4);

        public void processSubstract(Element var1, String var2, AffineTransform var3, boolean var4);
    }
}

