/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.ui.resources.svg;

import com.jcloisterzone.XMLUtils;
import com.jcloisterzone.board.Location;
import com.jcloisterzone.board.Rotation;
import com.jcloisterzone.feature.Bridge;
import com.jcloisterzone.feature.City;
import com.jcloisterzone.feature.Farm;
import com.jcloisterzone.feature.Feature;
import com.jcloisterzone.feature.Road;
import com.jcloisterzone.plugin.Plugin;
import com.jcloisterzone.ui.ImmutablePoint;
import com.jcloisterzone.ui.resources.AreaRotationScaling;
import com.jcloisterzone.ui.resources.FeatureArea;
import com.jcloisterzone.ui.resources.FeatureDescriptor;
import com.jcloisterzone.ui.resources.svg.AreaWithZIndex;
import com.jcloisterzone.ui.resources.svg.PointsParser;
import com.jcloisterzone.ui.resources.svg.SvgToShapeConverter;
import com.jcloisterzone.ui.resources.svg.SvgTransformationCollector;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ThemeGeometry {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    public static ThemeGeometry DEFAULT_GEOMETRY;
    private static final Area BRIDGE_AREA_NS;
    private static final Area BRIDGE_AREA_WE;
    private final double imageSizeRatio;
    private final Map<FeatureDescriptor, FeatureArea> areas = new HashMap<FeatureDescriptor, FeatureArea>();
    private final Map<String, Area> subtractionAll = new HashMap<String, Area>();
    private final Map<String, Area> subtractionFarm = new HashMap<String, Area>();
    private final Set<FeatureDescriptor> complementFarms = new HashSet<FeatureDescriptor>();
    private final Map<FeatureDescriptor, ImmutablePoint> points;

    public ThemeGeometry(ClassLoader loader, String folder, double imageSizeRatio) throws IOException, SAXException, ParserConfigurationException {
        int i;
        this.imageSizeRatio = imageSizeRatio;
        Element shapes = XMLUtils.parseDocument(loader.getResource(folder + "/shapes.xml")).getDocumentElement();
        NodeList nl = shapes.getElementsByTagName("shape");
        for (i = 0; i < nl.getLength(); ++i) {
            this.processShapeElement((Element)nl.item(i));
        }
        nl = shapes.getElementsByTagName("complement-farm");
        for (i = 0; i < nl.getLength(); ++i) {
            this.processComplementFarm((Element)nl.item(i));
        }
        this.points = new PointsParser(loader.getResource(folder + "/points.xml")).parse();
    }

    public double getImageSizeRatio() {
        return this.imageSizeRatio;
    }

    private FeatureDescriptor createFeatureDescriptor(String featureName, String tileAndLocation) {
        String[] tokens = tileAndLocation.split(" ");
        return FeatureDescriptor.valueOf(tokens[0], featureName, tokens[1]);
    }

    private AreaWithZIndex createArea(Element shapeNode) {
        Integer zIndex = XMLUtils.attributeIntValue(shapeNode, "zIndex");
        NodeList nl = shapeNode.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Element el;
            if (!(nl.item(i) instanceof Element) || !(el = (Element)nl.item(i)).getNodeName().startsWith("svg:")) continue;
            Area area = new SvgToShapeConverter().convert(el);
            return new AreaWithZIndex(area, zIndex);
        }
        throw new IllegalArgumentException("Node doesn't contains svg shape.");
    }

    private int getZIndex(Integer explicit, FeatureDescriptor fd) {
        if (explicit != null) {
            return explicit;
        }
        Class<? extends Feature> ft = fd.getFeatureType();
        if (ft != null) {
            if (Road.class.isAssignableFrom(ft)) {
                return 30;
            }
            if (City.class.isAssignableFrom(ft)) {
                return 20;
            }
            if (Farm.class.isAssignableFrom(ft)) {
                return 10;
            }
        }
        return 40;
    }

    private void processShapeElement(Element shapeNode) {
        final AreaWithZIndex az = this.createArea(shapeNode);
        SvgTransformationCollector transformCollector = new SvgTransformationCollector(shapeNode, this.imageSizeRatio);
        transformCollector.collect(new SvgTransformationCollector.GeometryHandler(){
            final /* synthetic */ ThemeGeometry this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void processApply(Element node, FeatureDescriptor fd, AffineTransform transform, AreaRotationScaling rotationScaling) {
                assert (!this.this$0.areas.containsKey(fd)) : "Duplicate key " + fd;
                FeatureArea area = new FeatureArea(az.area.createTransformedArea(transform), this.this$0.getZIndex(az.zIndex, fd));
                area = area.setRotationScaling(rotationScaling);
                this.this$0.areas.put(fd, area);
            }

            @Override
            public void processSubstract(Element node, String tileId, AffineTransform transform, boolean isFarm) {
                Map target = isFarm ? this.this$0.subtractionFarm : this.this$0.subtractionAll;
                Area transformed = az.area.createTransformedArea(transform);
                if (target.containsKey(tileId)) {
                    transformed.add((Area)target.get(tileId));
                }
                target.put(tileId, transformed);
            }
        });
    }

    private void processComplementFarm(Element xml) {
        NodeList nl = xml.getElementsByTagName("apply");
        for (int i = 0; i < nl.getLength(); ++i) {
            Element apply = (Element)nl.item(i);
            FeatureDescriptor fd = this.createFeatureDescriptor("FARM", apply.getTextContent());
            this.complementFarms.add(fd);
        }
    }

    private FeatureDescriptor[] getLookups(String tileId, Class<? extends Feature> featureType, Location location) {
        FeatureDescriptor[] fd = new FeatureDescriptor[]{new FeatureDescriptor(tileId, featureType, location), new FeatureDescriptor("*", featureType, location)};
        return fd;
    }

    public FeatureArea getArea(String tileId, Class<? extends Feature> featureClass, Location loc) {
        FeatureDescriptor[] lookups;
        if (featureClass != null && featureClass.equals(Bridge.class)) {
            Area a = this.getBridgeArea(loc);
            FeatureArea fa = new FeatureArea(a, 50);
            fa = fa.setFixed(true);
            return fa;
        }
        for (FeatureDescriptor fd : lookups = this.getLookups(tileId, featureClass, loc)) {
            FeatureArea fa = this.areas.get(fd);
            if (fa == null) continue;
            return fa;
        }
        return null;
    }

    public Area getBridgeArea(Location loc) {
        if (loc == Location.NS) {
            return BRIDGE_AREA_NS;
        }
        if (loc == Location.WE) {
            return BRIDGE_AREA_WE;
        }
        throw new IllegalArgumentException("Incorrect location");
    }

    public Area getSubtractionArea(String tileId, boolean isFarm) {
        Area area;
        if (isFarm && (area = this.getSubtractionArea(this.subtractionFarm, tileId)) != null) {
            return area;
        }
        return this.getSubtractionArea(this.subtractionAll, tileId);
    }

    private Area getSubtractionArea(Map<String, Area> subtractions, String tileId) {
        Area area = subtractions.get(tileId);
        return area;
    }

    public Boolean isFarmComplement(String tileId, Location loc) {
        FeatureDescriptor[] lookups;
        for (FeatureDescriptor fd : lookups = this.getLookups(tileId, Farm.class, loc)) {
            if (!this.areas.containsKey(fd)) continue;
            return Boolean.FALSE;
        }
        for (FeatureDescriptor fd : lookups) {
            if (!this.complementFarms.contains(fd)) continue;
            return Boolean.TRUE;
        }
        return null;
    }

    public ImmutablePoint getMeeplePlacement(String tileId, Class<? extends Feature> feature, Location location) {
        FeatureDescriptor fd;
        FeatureDescriptor[] lookups = this.getLookups(tileId, feature, location);
        ImmutablePoint point = null;
        FeatureDescriptor[] featureDescriptorArray = lookups;
        int n = featureDescriptorArray.length;
        for (int i = 0; i < n && (point = this.points.get(fd = featureDescriptorArray[i])) == null; ++i) {
        }
        return point;
    }

    static {
        try {
            DEFAULT_GEOMETRY = new ThemeGeometry(Plugin.class.getClassLoader(), "defaults/tiles", 1.0);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            LoggerFactory.getLogger(ThemeGeometry.class).error(e.getMessage(), e);
        }
        Area a = new Area(new Rectangle(400, 0, 200, 1000));
        a.subtract(new Area(new Ellipse2D.Double(300.0, 150.0, 200.0, 700.0)));
        BRIDGE_AREA_NS = new Area(a);
        a.transform(Rotation.R270.getAffineTransform(1000));
        BRIDGE_AREA_WE = a;
    }
}

