/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.ui.view;

import com.google.common.eventbus.Subscribe;
import com.jcloisterzone.event.ClientListChangedEvent;
import com.jcloisterzone.game.Game;
import com.jcloisterzone.game.PlayerSlot;
import com.jcloisterzone.ui.Client;
import com.jcloisterzone.ui.GameController;
import com.jcloisterzone.ui.MenuBar;
import com.jcloisterzone.ui.controls.chat.ChatPanel;
import com.jcloisterzone.ui.controls.chat.GameChatPanel;
import com.jcloisterzone.ui.panel.BackgroundPanel;
import com.jcloisterzone.ui.panel.ConnectedClientsPanel;
import com.jcloisterzone.ui.panel.CreateGamePanel;
import com.jcloisterzone.ui.view.AbstractUiView;
import com.jcloisterzone.ui.view.GameChatView;
import com.jcloisterzone.ui.view.GameView;
import com.jcloisterzone.ui.view.StartView;
import com.jcloisterzone.ui.view.UiView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class GameSetupView
extends AbstractUiView
implements GameChatView {
    private final GameController gc;
    private final Game game;
    private final boolean mutableSlots;
    private BackgroundPanel root;
    private ChatPanel chatPanel;
    private CreateGamePanel createGamePanel;
    private ConnectedClientsPanel connectedClientsPanel;

    public GameSetupView(Client client, GameController gc, boolean mutableSlots) {
        super(client);
        this.gc = gc;
        this.game = gc.getGame();
        this.mutableSlots = mutableSlots;
    }

    public GameController getGameController() {
        return this.gc;
    }

    public Game getGame() {
        return this.game;
    }

    @Override
    public void show(Container pane) {
        Game game = this.gc.getGame();
        this.root = new BackgroundPanel();
        this.root.setLayout(new BorderLayout());
        pane.add(this.root);
        this.showCreateGamePanel(this.root, this.mutableSlots, game.getPlayerSlots());
        this.gc.register(this);
        this.registerChildComponents(this.root, this.gc);
        MenuBar menu = this.client.getJMenuBar();
        menu.setItemActionListener(MenuBar.MenuItem.LEAVE_GAME, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GameSetupView.this.gc.leaveGame();
            }
        });
        menu.setItemEnabled(MenuBar.MenuItem.LEAVE_GAME, true);
        this.createGamePanel.updateSupportedExpansions(game.mergeSupportedExpansions());
    }

    private void showCreateGamePanel(Container panel, boolean mutableSlots, PlayerSlot[] slots) {
        this.createGamePanel = new CreateGamePanel(this.client, this.gc, mutableSlots, slots);
        this.createGamePanel.setBackground(this.client.getTheme().getMainBg());
        BackgroundPanel envelope = new BackgroundPanel();
        envelope.setLayout(new MigLayout("align 50% 50%", "[]", "[]"));
        envelope.add((Component)this.createGamePanel, "grow");
        panel.add((Component)envelope, "Center");
        JPanel chatColumn = new JPanel();
        chatColumn.setOpaque(false);
        chatColumn.setLayout(new MigLayout("ins 0, gap 0 10", "[grow]", "[60px][grow]"));
        chatColumn.setPreferredSize(new Dimension(250, panel.getHeight()));
        panel.add((Component)chatColumn, "West");
        this.connectedClientsPanel = new ConnectedClientsPanel(this.client, this.game.getName());
        chatColumn.add((Component)this.connectedClientsPanel, "cell 0 0, grow");
        this.chatPanel = new GameChatPanel(this.client, this.game);
        chatColumn.add((Component)this.chatPanel, "cell 0 1, grow");
    }

    @Override
    public boolean requestHide(UiView nextView) {
        if (!(nextView instanceof GameView)) {
            return this.client.closeGame();
        }
        return true;
    }

    @Override
    public void hide(UiView nextView) {
        this.gc.unregister(this);
        this.unregisterChildComponents(this.root, this.gc);
        MenuBar menu = this.client.getJMenuBar();
        menu.setItemEnabled(MenuBar.MenuItem.LEAVE_GAME, false);
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent e) {
        if (this.chatPanel.getInput().hasFocus()) {
            return false;
        }
        if (e.getID() == 401 && (e.getKeyChar() == '`' || e.getKeyChar() == ';')) {
            e.consume();
            this.chatPanel.activateChat();
            return true;
        }
        return false;
    }

    @Subscribe
    public void clientListChanged(ClientListChangedEvent ev) {
        this.connectedClientsPanel.updateClients(ev.getClients());
    }

    @Override
    public void onWebsocketClose(int code, String reason, boolean remote) {
        this.client.mountView(new StartView(this.client));
    }

    @Override
    public ChatPanel getChatPanel() {
        return this.chatPanel;
    }
}

