/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.ui.view;

import com.google.common.eventbus.Subscribe;
import com.jcloisterzone.Player;
import com.jcloisterzone.bugreport.BugReportDialog;
import com.jcloisterzone.event.ClientListChangedEvent;
import com.jcloisterzone.game.Game;
import com.jcloisterzone.game.save.SavedGame;
import com.jcloisterzone.game.save.SavedGameParser;
import com.jcloisterzone.ui.Client;
import com.jcloisterzone.ui.GameController;
import com.jcloisterzone.ui.I18nUtils;
import com.jcloisterzone.ui.MenuBar;
import com.jcloisterzone.ui.SavegameFileFilter;
import com.jcloisterzone.ui.controls.ControlPanel;
import com.jcloisterzone.ui.controls.chat.ChatPanel;
import com.jcloisterzone.ui.dialog.GameSetupDialog;
import com.jcloisterzone.ui.grid.GridPanel;
import com.jcloisterzone.ui.grid.MainPanel;
import com.jcloisterzone.ui.view.AbstractUiView;
import com.jcloisterzone.ui.view.GameChatView;
import com.jcloisterzone.ui.view.UiView;
import com.jcloisterzone.wsio.Connection;
import com.jcloisterzone.wsio.message.UndoMessage;
import java.awt.Container;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowStateListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import javax.imageio.ImageIO;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GameView
extends AbstractUiView
implements WindowStateListener,
GameChatView {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String RECONNECTING_ERR_MSG = "RECONNECTING";
    private final GameController gc;
    private final Game game;
    private boolean gameRunning = true;
    private ChatPanel chatPanel;
    private MainPanel mainPanel;
    private Timer timer;
    boolean repeatLeft;
    boolean repeatRight;
    boolean repeatUp;
    boolean repeatDown;
    boolean repeatZoomIn;
    boolean repeatZoomOut;

    public GameView(Client client, GameController gc) {
        super(client);
        this.gc = gc;
        this.game = gc.getGame();
        gc.setGameView(this);
    }

    public boolean isGameRunning() {
        return this.gameRunning;
    }

    public void setGameRunning(boolean gameRunning) {
        this.gameRunning = gameRunning;
    }

    public GameController getGameController() {
        return this.gc;
    }

    public Game getGame() {
        return this.game;
    }

    @Override
    public void show(Container pane) {
        this.mainPanel = new MainPanel(this.client, this, this.chatPanel);
        this.mainPanel.setBackground(this.client.getTheme().getMainBg());
        pane.add(this.mainPanel);
        this.gc.getReportingTool().setContainer(this.mainPanel);
        this.registerChildComponents(this.mainPanel, this.gc);
        this.timer = new Timer(true);
        this.timer.scheduleAtFixedRate((TimerTask)new KeyRepeater(), 0L, 40L);
        MenuBar menu = this.client.getJMenuBar();
        menu.setItemActionListener(MenuBar.MenuItem.SAVE, e -> this.handleSave());
        menu.setItemActionListener(MenuBar.MenuItem.UNDO, e -> {
            menu.setItemEnabled(MenuBar.MenuItem.UNDO, false);
            this.gc.getConnection().send(new UndoMessage());
        });
        menu.setItemActionListener(MenuBar.MenuItem.ZOOM_IN, e -> this.zoom(2.0));
        menu.setItemActionListener(MenuBar.MenuItem.ZOOM_OUT, e -> this.zoom(-2.0));
        menu.setItemActionListener(MenuBar.MenuItem.ROTATE_BOARD, e -> this.rotateBoard());
        menu.setItemActionListener(MenuBar.MenuItem.GAME_EVENTS, e -> {
            JCheckBoxMenuItem ch = (JCheckBoxMenuItem)e.getSource();
            this.mainPanel.getGridPanel().toggleGameEvents(ch.isSelected());
        });
        if (menu.isSelected(MenuBar.MenuItem.LAST_PLACEMENTS)) {
            this.mainPanel.getGridPanel().toggleGameEvents(true);
        }
        menu.setItemActionListener(MenuBar.MenuItem.LAST_PLACEMENTS, e -> {
            JCheckBoxMenuItem ch = (JCheckBoxMenuItem)e.getSource();
            this.mainPanel.toggleRecentHistory(ch.isSelected());
        });
        if (menu.isSelected(MenuBar.MenuItem.LAST_PLACEMENTS)) {
            this.mainPanel.toggleRecentHistory(true);
        }
        menu.setItemActionListener(MenuBar.MenuItem.FARM_HINTS, e -> {
            JCheckBoxMenuItem ch = (JCheckBoxMenuItem)e.getSource();
            this.mainPanel.setShowFarmHints(ch.isSelected());
        });
        if (menu.isSelected(MenuBar.MenuItem.FARM_HINTS)) {
            this.mainPanel.setShowFarmHints(true);
        }
        menu.setItemActionListener(MenuBar.MenuItem.PROJECTED_POINTS, e -> {
            JCheckBoxMenuItem ch = (JCheckBoxMenuItem)e.getSource();
            this.getControlPanel().setShowProjectedPoints(ch.isSelected());
        });
        if (menu.isSelected(MenuBar.MenuItem.PROJECTED_POINTS)) {
            this.getControlPanel().setShowProjectedPoints(true);
        }
        menu.setItemActionListener(MenuBar.MenuItem.DISCARDED_TILES, e -> this.client.getDiscardedTilesDialog().setVisible(true));
        menu.setItemActionListener(MenuBar.MenuItem.GAME_SETUP, e -> this.showGameSetupDialog());
        menu.setItemActionListener(MenuBar.MenuItem.TAKE_SCREENSHOT, e -> this.takeScreenshot());
        menu.setItemActionListener(MenuBar.MenuItem.REPORT_BUG, e -> new BugReportDialog(this.gc.getReportingTool()));
        menu.setItemActionListener(MenuBar.MenuItem.LEAVE_GAME, e -> this.gc.leaveGame());
        menu.setItemEnabled(MenuBar.MenuItem.FARM_HINTS, true);
        menu.setItemEnabled(MenuBar.MenuItem.GAME_EVENTS, true);
        menu.setItemEnabled(MenuBar.MenuItem.LAST_PLACEMENTS, true);
        menu.setItemEnabled(MenuBar.MenuItem.PROJECTED_POINTS, true);
        menu.setItemEnabled(MenuBar.MenuItem.REPORT_BUG, true);
        menu.setItemEnabled(MenuBar.MenuItem.GAME_SETUP, true);
        menu.setItemEnabled(MenuBar.MenuItem.TAKE_SCREENSHOT, true);
        menu.setItemEnabled(MenuBar.MenuItem.LEAVE_GAME, true);
        menu.setItemEnabled(MenuBar.MenuItem.ZOOM_IN, true);
        menu.setItemEnabled(MenuBar.MenuItem.ZOOM_OUT, true);
        menu.setItemEnabled(MenuBar.MenuItem.ROTATE_BOARD, true);
        menu.setItemEnabled(MenuBar.MenuItem.SAVE, true);
        menu.setItemEnabled(MenuBar.MenuItem.LOAD, false);
        menu.setItemEnabled(MenuBar.MenuItem.NEW_GAME, false);
        menu.setItemEnabled(MenuBar.MenuItem.CONNECT_P2P, false);
        menu.setItemEnabled(MenuBar.MenuItem.PLAY_ONLINE, false);
        this.client.addWindowStateListener(this);
    }

    @Override
    public boolean requestHide(UiView nextView) {
        if (this.gameRunning && this.gc.getChannel() == null) {
            return this.client.closeGame();
        }
        return true;
    }

    @Override
    public void hide(UiView nextView) {
        this.timer.cancel();
        this.unregisterChildComponents(this.mainPanel, this.gc);
        Connection conn = this.gc.getConnection();
        if (conn != null) {
            conn.stopReconnecting();
        }
        MenuBar menu = this.client.getJMenuBar();
        menu.setItemEnabled(MenuBar.MenuItem.FARM_HINTS, false);
        menu.setItemEnabled(MenuBar.MenuItem.GAME_EVENTS, false);
        menu.setItemEnabled(MenuBar.MenuItem.LAST_PLACEMENTS, false);
        menu.setItemEnabled(MenuBar.MenuItem.PROJECTED_POINTS, false);
        menu.setItemEnabled(MenuBar.MenuItem.ZOOM_IN, false);
        menu.setItemEnabled(MenuBar.MenuItem.ZOOM_OUT, false);
        menu.setItemEnabled(MenuBar.MenuItem.ROTATE_BOARD, false);
        menu.setItemEnabled(MenuBar.MenuItem.LEAVE_GAME, false);
        menu.setItemEnabled(MenuBar.MenuItem.TAKE_SCREENSHOT, false);
        menu.setItemEnabled(MenuBar.MenuItem.DISCARDED_TILES, false);
        this.client.removeWindowStateListener(this);
    }

    @Override
    public void windowStateChanged(WindowEvent e) {
        ChatPanel chatPanel = this.getGridPanel().getChatPanel();
        if (chatPanel != null) {
            chatPanel.windowStateChanged(e);
        }
    }

    public void closeGame() {
        this.gameRunning = false;
        this.getMainPanel().closeGame();
        this.getControlPanel().clearActions();
        MenuBar menu = this.client.getJMenuBar();
        menu.setItemEnabled(MenuBar.MenuItem.DISCARDED_TILES, false);
        menu.setItemEnabled(MenuBar.MenuItem.UNDO, false);
        menu.setItemEnabled(MenuBar.MenuItem.REPORT_BUG, false);
        if (this.gc.getChannel() == null) {
            menu.setItemEnabled(MenuBar.MenuItem.NEW_GAME, true);
            menu.setItemEnabled(MenuBar.MenuItem.CONNECT_P2P, true);
            menu.setItemEnabled(MenuBar.MenuItem.PLAY_ONLINE, true);
            menu.setItemEnabled(MenuBar.MenuItem.LOAD, true);
        }
    }

    @Override
    public void onWebsocketClose(int code, String reason, boolean remote) {
        String message = I18nUtils._tr("Connection lost", new Object[0]) + ". " + I18nUtils._tr("Reconnecting...", new Object[0]);
        if (code == 1001 || code == 1006 || code == 4000 || remote) {
            int initialDelay;
            int n = initialDelay = code == 1001 ? 3000 : 500;
            if (this.gc.getChannel() == null) {
                if (!this.game.isOver()) {
                    this.gc.getConnection().reconnect(null, initialDelay);
                    this.getGridPanel().showErrorMessage(message, RECONNECTING_ERR_MSG);
                }
            } else {
                this.gc.getConnection().reconnect(this.game.isOver() ? null : this.game.getGameId(), initialDelay);
                this.getGridPanel().showErrorMessage(message, RECONNECTING_ERR_MSG);
            }
        }
    }

    @Override
    public void onWebsocketError(Exception ex) {
        String message = ex.getMessage();
        if (message == null || message.length() == 0) {
            message = ex.getClass().getSimpleName();
        }
        this.logger.error(message, ex);
        this.getGridPanel().showErrorMessage(message, null);
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent e) {
        block13: {
            block12: {
                if (this.chatPanel != null && this.chatPanel.getInput().hasFocus()) {
                    return false;
                }
                if (e.getID() != 401) break block12;
                if (e.getKeyChar() == '`' || e.getKeyChar() == ';') {
                    e.consume();
                    this.chatPanel.activateChat();
                    return true;
                }
                switch (e.getKeyCode()) {
                    case 10: 
                    case 32: {
                        this.mainPanel.getControlPanel().pass();
                        return true;
                    }
                    case 9: {
                        if (e.getModifiers() == 0) {
                            this.mainPanel.getGridPanel().forward();
                        } else if (e.getModifiers() == 1) {
                            this.mainPanel.getGridPanel().backward();
                        }
                        break block13;
                    }
                    default: {
                        return this.dispatchReptable(e, true);
                    }
                }
            }
            if (e.getID() == 402) {
                boolean result = this.dispatchReptable(e, false);
                if (result) {
                    e.consume();
                }
                return result;
            }
            if (e.getID() == 400) {
                e.setKeyChar(Character.toLowerCase(e.getKeyChar()));
                return this.dispatchKeyTyped(e);
            }
        }
        return false;
    }

    private boolean dispatchReptable(KeyEvent e, boolean pressed) {
        if (e.getKeyChar() == '+') {
            this.repeatZoomIn = pressed;
            return true;
        }
        if (e.getKeyChar() == '-') {
            this.repeatZoomOut = pressed;
            return true;
        }
        if (e.getModifiers() != 0) {
            return false;
        }
        switch (e.getKeyCode()) {
            case 37: 
            case 65: {
                this.repeatLeft = pressed;
                return true;
            }
            case 39: 
            case 68: {
                this.repeatRight = pressed;
                return true;
            }
            case 40: 
            case 83: {
                this.repeatDown = pressed;
                return true;
            }
            case 38: 
            case 87: {
                this.repeatUp = pressed;
                return true;
            }
        }
        return false;
    }

    private boolean dispatchKeyTyped(KeyEvent e) {
        if (e.getModifiers() != 0) {
            return false;
        }
        if (e.getKeyChar() == '+' || e.getKeyChar() == '-') {
            e.consume();
            return true;
        }
        return false;
    }

    public MainPanel getMainPanel() {
        return this.mainPanel;
    }

    @Override
    public ChatPanel getChatPanel() {
        return this.chatPanel;
    }

    public void setChatPanel(ChatPanel chatPanel) {
        this.chatPanel = chatPanel;
    }

    public GridPanel getGridPanel() {
        return this.mainPanel.getGridPanel();
    }

    public ControlPanel getControlPanel() {
        return this.mainPanel.getControlPanel();
    }

    public void zoom(double steps) {
        GridPanel gp = this.getGridPanel();
        if (gp != null) {
            gp.zoom(steps);
        }
    }

    public void rotateBoard() {
        GridPanel gp = this.getGridPanel();
        if (gp != null) {
            gp.rotateBoard();
        }
    }

    @Subscribe
    public void clientListChanged(ClientListChangedEvent ev) {
        if (!this.game.isOver()) {
            this.getMainPanel().repaint();
        }
    }

    public void handleSave() {
        File file;
        JFileChooser fc = new JFileChooser(this.client.getSavesDirectory());
        fc.setFileSelectionMode(0);
        fc.setDialogTitle(I18nUtils._tr("Save game", new Object[0]));
        fc.setDialogType(1);
        fc.setFileFilter(new SavegameFileFilter());
        fc.setLocale(this.client.getLocale());
        int returnVal = fc.showSaveDialog(this.client);
        if (returnVal == 0 && (file = fc.getSelectedFile()) != null) {
            if (!file.getName().endsWith(".jcz")) {
                file = new File(file.getAbsolutePath() + ".jcz");
            }
            try (FileWriter writer = new FileWriter(file);){
                SavedGame save = new SavedGame(this.game);
                SavedGameParser parser = new SavedGameParser("pretty".equals(this.getClient().getConfig().getSaved_games().getFormat()));
                save.setAnnotations(this.game.getGameAnnotations());
                parser.toJson(save, writer);
            }
            catch (IOException ex) {
                this.logger.error(ex.getMessage(), ex);
                JOptionPane.showMessageDialog(this.client, ex.getLocalizedMessage(), I18nUtils._tr("Error", new Object[0]), 0);
            }
        }
    }

    private void showGameSetupDialog() {
        new GameSetupDialog(this.client, this.gc.getGame()).setVisible(true);
    }

    public void takeScreenshot() {
        GridPanel container = this.getGridPanel();
        File screenshotFolder = this.client.getScreenshotDirectory();
        StringBuilder players = new StringBuilder();
        boolean hasAi = false;
        for (Player p : this.game.getState().getPlayers().getPlayers()) {
            if (p.getSlot().isAi()) {
                hasAi = true;
                continue;
            }
            players.append(p.getNick());
            players.append("_");
        }
        if (hasAi) {
            players.append("AI_");
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd-HHmmss");
        File filename = new File(screenshotFolder, players.toString() + sdf.format(new Date()) + ".png");
        try (FileOutputStream fos = new FileOutputStream(filename);){
            BufferedImage im = container.takeScreenshot();
            ImageIO.write((RenderedImage)im, "PNG", fos);
            this.client.playSound("audio/shutter.wav");
        }
        catch (IOException ex) {
            this.logger.error(ex.getMessage(), ex);
            JOptionPane.showMessageDialog(this.client, ex.getLocalizedMessage(), I18nUtils._tr("Error", new Object[0]), 0);
        }
    }

    class KeyRepeater
    extends TimerTask {
        KeyRepeater() {
        }

        @Override
        public void run() {
            GridPanel gridPanel = GameView.this.mainPanel.getGridPanel();
            if (gridPanel == null) {
                return;
            }
            if (GameView.this.repeatLeft) {
                gridPanel.moveCenter(-1, 0);
            }
            if (GameView.this.repeatRight) {
                gridPanel.moveCenter(1, 0);
            }
            if (GameView.this.repeatUp) {
                gridPanel.moveCenter(0, -1);
            }
            if (GameView.this.repeatDown) {
                gridPanel.moveCenter(0, 1);
            }
            if (GameView.this.repeatZoomIn) {
                gridPanel.zoom(0.3);
            }
            if (GameView.this.repeatZoomOut) {
                gridPanel.zoom(-0.3);
            }
        }
    }
}

