/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.wsio;

import com.jcloisterzone.wsio.WsSubscribe;
import com.jcloisterzone.wsio.message.WsMessage;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageDispatcher {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());

    public void dispatch(WsMessage msg, Object context, Object ... targets) {
        if (targets.length == 0) {
            throw new IllegalArgumentException("No targets");
        }
        for (Object target : targets) {
            if (target == null) continue;
            this.dispatchOn(msg, context, target);
        }
    }

    private boolean dispatchOn(WsMessage msg, Object context, Object target) {
        Class<?> type = target.getClass();
        for (Method m : type.getMethods()) {
            Class<?>[] params;
            Class<?> cls;
            WsSubscribe handler = m.getAnnotation(WsSubscribe.class);
            if (handler == null || !(cls = (params = m.getParameterTypes())[params.length - 1]).isInstance(msg)) continue;
            try {
                if (params.length == 1) {
                    m.invoke(target, msg);
                } else {
                    m.invoke(target, context, msg);
                }
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                this.logger.error(e.getMessage(), e);
            }
            catch (IllegalAccessException e) {
                this.logger.error(e.getMessage(), e);
            }
            return true;
        }
        return false;
    }
}

