/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.wsio;

import com.jcloisterzone.bugreport.ReportingTool;
import com.jcloisterzone.config.Config;
import com.jcloisterzone.wsio.Connection;
import com.jcloisterzone.wsio.MessageListener;
import com.jcloisterzone.wsio.MessageParser;
import com.jcloisterzone.wsio.message.HelloMessage;
import com.jcloisterzone.wsio.message.JoinGameMessage;
import com.jcloisterzone.wsio.message.PingMessage;
import com.jcloisterzone.wsio.message.WelcomeMessage;
import com.jcloisterzone.wsio.message.WsMessage;
import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.drafts.Draft_17;
import org.java_websocket.exceptions.WebsocketNotConnectedException;
import org.java_websocket.handshake.ServerHandshake;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketConnection
implements Connection {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private ReportingTool reportingTool;
    private MessageParser parser = new MessageParser();
    private WebSocketClientImpl ws;
    private URI uri;
    private final MessageListener listener;
    private String sessionId;
    private String clientId;
    private String secret;
    private String nickname;
    private boolean closedByUser;
    private int pingInterval = 0;
    private String maintenance;
    private Set<String> alreadyReceived = new HashSet<String>();
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private ScheduledFuture<?> pingFuture;
    private ScheduledFuture<?> reconnectFuture;
    private String tryReconnectTo = null;

    public WebSocketConnection(String username, Config config, URI uri, MessageListener listener) {
        this.clientId = config.getClient_id();
        this.secret = config.getSecret();
        this.listener = listener;
        this.uri = uri;
        this.ws = new WebSocketClientImpl(uri, username, null);
        this.ws.connect();
    }

    private void doReconnectAttempt() {
        if (this.tryReconnectTo != null) {
            this.logger.info("Reconnection attempt.");
            this.ws = new WebSocketClientImpl(this.uri, this.nickname, this.tryReconnectTo);
            try {
                if (this.ws.connectBlocking()) {
                    this.stopReconnecting();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    @Override
    public void reconnect(String gameId, long initialDelay) {
        this.tryReconnectTo = gameId;
        this.reconnectFuture = this.scheduler.scheduleWithFixedDelay(this::doReconnectAttempt, initialDelay, 1000L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void stopReconnecting() {
        this.tryReconnectTo = null;
        if (this.reconnectFuture != null) {
            this.reconnectFuture.cancel(false);
            this.reconnectFuture = null;
        }
    }

    private void cancelPing() {
        if (this.pingFuture != null) {
            this.pingFuture.cancel(false);
            this.pingFuture = null;
        }
    }

    private void schedulePing() {
        if (this.pingInterval == 0) {
            return;
        }
        if (this.pingFuture != null) {
            this.pingFuture.cancel(false);
        }
        this.pingFuture = this.scheduler.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                WebSocketConnection.this.send(new PingMessage());
            }
        }, this.pingInterval, this.pingInterval, TimeUnit.SECONDS);
    }

    @Override
    public void send(WsMessage msg) {
        if (this.ws.isClosed() || this.ws.isClosing()) {
            return;
        }
        this.schedulePing();
        try {
            if (msg.getMessageId() == null) {
                msg.setMessageId(UUID.randomUUID().toString());
            }
            this.ws.send(this.parser.toJson(msg));
        }
        catch (WebsocketNotConnectedException ex) {
            this.listener.onWebsocketClose(0, ex.getMessage(), true);
        }
    }

    @Override
    public void close() {
        this.closedByUser = true;
        this.ws.close();
    }

    @Override
    public boolean isClosed() {
        return this.ws.isClosed() || this.ws.isClosing();
    }

    @Override
    public String getSessionId() {
        return this.sessionId;
    }

    @Override
    public String getNickname() {
        return this.nickname;
    }

    public ReportingTool getReportingTool() {
        return this.reportingTool;
    }

    public void setReportingTool(ReportingTool reportingTool) {
        this.reportingTool = reportingTool;
    }

    public MessageParser getParser() {
        return this.parser;
    }

    public String getMaintenance() {
        return this.maintenance;
    }

    class WebSocketClientImpl
    extends WebSocketClient {
        private String username;
        private String reconnectGameId;

        public WebSocketClientImpl(URI serverURI, String username, String reconnectGameId) {
            super(serverURI, new Draft_17(), null, 9000);
            this.username = username;
            this.reconnectGameId = reconnectGameId;
        }

        @Override
        public void onClose(int code, String reason, boolean remote) {
            WebSocketConnection.this.cancelPing();
            WebSocketConnection.this.listener.onWebsocketClose(code, reason, remote && !WebSocketConnection.this.closedByUser);
        }

        @Override
        public void onError(Exception ex) {
            if (WebSocketConnection.this.reconnectFuture != null) {
                return;
            }
            if (ex instanceof WebsocketNotConnectedException) {
                WebSocketConnection.this.cancelPing();
                WebSocketConnection.this.listener.onWebsocketClose(0, ex.getMessage(), true);
            } else {
                WebSocketConnection.this.listener.onWebsocketError(ex);
            }
        }

        @Override
        public synchronized void onMessage(String payload) {
            if (this.isClosing()) {
                return;
            }
            WsMessage msg = null;
            try {
                msg = WebSocketConnection.this.parser.fromJson(payload);
            }
            catch (Exception e) {
                WebSocketConnection.this.logger.error("Can't parse message: " + payload);
                this.close(4000, "Can't parse message");
                return;
            }
            if (WebSocketConnection.this.alreadyReceived.contains(msg.getMessageId())) {
                WebSocketConnection.this.logger.info("Already received message dropped: " + payload);
                return;
            }
            if (WebSocketConnection.this.logger.isInfoEnabled()) {
                WebSocketConnection.this.logger.info(payload);
            }
            if (msg instanceof WelcomeMessage) {
                WelcomeMessage welcome = (WelcomeMessage)msg;
                WebSocketConnection.this.sessionId = welcome.getSessionId();
                WebSocketConnection.this.nickname = welcome.getNickname();
                WebSocketConnection.this.pingInterval = welcome.getPingInterval();
                WebSocketConnection.this.maintenance = welcome.getMaintenance();
            }
            WebSocketConnection.this.listener.onWebsocketMessage(msg);
        }

        @Override
        public void onOpen(ServerHandshake arg0) {
            WebSocketConnection.this.send(new HelloMessage(this.username, WebSocketConnection.this.clientId, WebSocketConnection.this.secret));
            if (this.reconnectGameId != null) {
                JoinGameMessage msg = new JoinGameMessage();
                msg.setGameId(this.reconnectGameId);
                WebSocketConnection.this.send(msg);
            }
        }
    }

    public static class MessageLostException
    extends Exception {
        public MessageLostException(String message) {
            super(message);
        }
    }
}

