/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.wsio.message.adapters;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.jcloisterzone.game.Token;
import com.jcloisterzone.game.capability.BridgeCapability;
import com.jcloisterzone.game.capability.CastleCapability;
import com.jcloisterzone.game.capability.FerriesCapability;
import com.jcloisterzone.game.capability.GoldminesCapability;
import com.jcloisterzone.game.capability.LittleBuildingsCapability;
import com.jcloisterzone.game.capability.TowerCapability;
import com.jcloisterzone.game.capability.TunnelCapability;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;

public class TokenAdapter
extends TypeAdapter<Token> {
    @Override
    public void write(JsonWriter out, Token value) throws IOException {
        out.beginArray();
        out.value(value.getClass().getName());
        out.value(value.name());
        out.endArray();
    }

    @Override
    public Token read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.STRING) {
            String token;
            switch (token = in.nextString()) {
                case "TOWER_PIECE": {
                    return TowerCapability.TowerToken.TOWER_PIECE;
                }
                case "BRIDGE": {
                    return BridgeCapability.BrigeToken.BRIDGE;
                }
                case "LB_SHED": {
                    return LittleBuildingsCapability.LittleBuilding.LB_SHED;
                }
                case "LB_HOUSE": {
                    return LittleBuildingsCapability.LittleBuilding.LB_HOUSE;
                }
                case "LB_TOWER": {
                    return LittleBuildingsCapability.LittleBuilding.LB_TOWER;
                }
                case "CASTLE": {
                    return CastleCapability.CastleToken.CASTLE;
                }
                case "FERRY": {
                    return FerriesCapability.FerryToken.FERRY;
                }
                case "GOLD": {
                    return GoldminesCapability.GoldToken.GOLD;
                }
                case "TUNNEL_A": {
                    return TunnelCapability.Tunnel.TUNNEL_A;
                }
                case "TUNNEL_B": {
                    return TunnelCapability.Tunnel.TUNNEL_B;
                }
                case "TUNNEL_C": {
                    return TunnelCapability.Tunnel.TUNNEL_C;
                }
            }
            throw new IOException("Unknown token " + token);
        }
        in.beginArray();
        String clsName = in.nextString();
        String tokenName = in.nextString();
        in.endArray();
        try {
            Class<?> cls = Class.forName(clsName, true, Token.class.getClassLoader());
            return (Token)cls.getMethod("valueOf", String.class).invoke(null, tokenName);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new IOException(e);
        }
    }
}

