"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const test_utils_1 = require("@joplin/lib/testing/test-utils");
const testUtils_1 = require("./utils/testUtils");
const Folder_1 = require("@joplin/lib/models/Folder");
const Command = require('./command-mkbook');
describe('command-mkbook', () => {
    beforeEach(async () => {
        await (0, test_utils_1.setupDatabaseAndSynchronizer)(1);
        await (0, test_utils_1.switchClient)(1);
        await (0, testUtils_1.setupApplication)();
    });
    it('should create a subfolder in first folder', async () => {
        const command = (0, testUtils_1.setupCommandForTesting)(Command);
        await command.action({ 'new-notebook': 'folder1', options: {} });
        await command.action({ 'new-notebook': 'folder1_1', options: { parent: 'folder1' } });
        const folder1 = await Folder_1.default.loadByTitle('folder1');
        const folder1_1 = await Folder_1.default.loadByTitle('folder1_1');
        expect(folder1.title).toBe('folder1');
        expect(folder1_1.parent_id).toBe(folder1.id);
    });
    it('should not be possible to create a subfolder without an argument.', async () => {
        const command = (0, testUtils_1.setupCommandForTesting)(Command);
        await command.action({ 'new-notebook': 'folder2', options: {} });
        await expect(command.action({ 'new-notebook': 'folder2_1', options: { parent: true } })).rejects.toThrowError();
    });
    it('should not be possible to create subfolder in ambiguous destination folder', async () => {
        const command = (0, testUtils_1.setupCommandForTesting)(Command);
        await command.action({ 'new-notebook': 'folder3', options: {} });
        await command.action({ 'new-notebook': 'folder3', options: {} }); // ambiguous folder
        await expect(command.action({ 'new-notebook': 'folder3_1', options: { parent: 'folder3' } })).rejects.toThrowError();
        // check if duplicate entries have been created.
        const folderAll = await Folder_1.default.all();
        const folders3 = folderAll.filter(x => x.title === 'folder3');
        expect(folders3.length).toBe(2);
        // check if something has been created in one of the duplicate entries.
        expect(await Folder_1.default.childrenIds(folders3[0].id)).toEqual([]);
        expect(await Folder_1.default.childrenIds(folders3[1].id)).toEqual([]);
    });
});
//# sourceMappingURL=command-mkbook.test.js.map