"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const ShareService_1 = require("@joplin/lib/services/share/ShareService");
const mockShareService_1 = require("@joplin/lib/testing/share/mockShareService");
const test_utils_1 = require("@joplin/lib/testing/test-utils");
const testUtils_1 = require("./utils/testUtils");
const Note_1 = require("@joplin/lib/models/Note");
const Folder_1 = require("@joplin/lib/models/Folder");
const Command = require('./command-unpublish');
describe('command-unpublish', () => {
    beforeEach(async () => {
        await (0, test_utils_1.setupDatabaseAndSynchronizer)(1);
        await (0, test_utils_1.switchClient)(1);
        await (0, testUtils_1.setupApplication)();
        (0, mockShareService_1.default)({
            getShares: async () => {
                return { items: [{ id: 'test-id' }] };
            },
            postShares: async () => {
                throw new Error('Unexpected call to postShares');
            },
            getShareInvitations: async () => null,
        }, ShareService_1.default.instance());
    });
    test('should unpublish a note', async () => {
        const command = (0, testUtils_1.setupCommandForTesting)(Command, () => { });
        const testFolder = await Folder_1.default.save({ title: 'Test' });
        const testNote = await Note_1.default.save({ title: 'test', parent_id: testFolder.id, is_shared: 1 });
        await command.action({
            note: testNote.id,
        });
        await (0, test_utils_1.waitFor)(async () => {
            expect(await Note_1.default.load(testNote.id)).toMatchObject({
                is_shared: 0,
            });
        });
    });
});
//# sourceMappingURL=command-unpublish.test.js.map