"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const base_command_1 = require("./base-command");
const app_1 = require("./app");
const locale_1 = require("@joplin/lib/locale");
const BaseModel_1 = require("@joplin/lib/BaseModel");
const Folder_1 = require("@joplin/lib/models/Folder");
class Command extends base_command_1.default {
    usage() {
        return 'use <notebook>';
    }
    description() {
        return (0, locale_1._)('Switches to [notebook] - all further operations will happen within this notebook.');
    }
    compatibleUis() {
        return ['cli'];
    }
    // eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
    async action(args) {
        const folder = await (0, app_1.default)().loadItem(BaseModel_1.default.TYPE_FOLDER, args['notebook']);
        if (!folder)
            throw new Error((0, locale_1._)('Cannot find "%s".', args['notebook']));
        // Auto-expand parent folders in GUI if present
        if ((0, app_1.default)().gui() && (0, app_1.default)().gui().widget && (0, app_1.default)().gui().widget('folderList')) {
            const folderListWidget = (0, app_1.default)().gui().widget('folderList');
            if (folderListWidget.expandToFolder) {
                // Get all folders to pass to expandToFolder
                const folders = await Folder_1.default.all();
                folderListWidget.folders = folders; // Ensure widget has current folders
                folderListWidget.expandToFolder(folder.id);
            }
        }
        (0, app_1.default)().switchCurrentFolder(folder);
    }
}
module.exports = Command;
//# sourceMappingURL=command-use.js.map