import {
  Decoder,
  Encoder,
  EventStreamMarshaller as IEventStreamMarshaller,
  Message,
} from "@aws-sdk/types";
export interface EventStreamMarshaller extends IEventStreamMarshaller {}
export interface EventStreamMarshallerOptions {
  utf8Encoder: Encoder;
  utf8Decoder: Decoder;
}
export declare class EventStreamMarshaller {
  private readonly universalMarshaller;
  constructor({ utf8Encoder, utf8Decoder }: EventStreamMarshallerOptions);
  deserialize<T>(
    body: ReadableStream<Uint8Array> | AsyncIterable<Uint8Array>,
    deserializer: (input: Record<string, Message>) => Promise<T>
  ): AsyncIterable<T>;
  serialize<T>(
    input: AsyncIterable<T>,
    serializer: (event: T) => Message
  ): ReadableStream | AsyncIterable<Uint8Array>;
}
