"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.authenticateWithCode = void 0;
exports.newFileApi = newFileApi;
exports.initFileApi = initFileApi;
const file_api_driver_joplinServer_1 = require("./file-api-driver-joplinServer");
const Setting_1 = require("./models/Setting");
const locale_js_1 = require("./locale.js");
const JoplinServerApi_1 = require("./JoplinServerApi");
const file_api_1 = require("./file-api");
const SyncTargetJoplinServer_1 = require("./SyncTargetJoplinServer");
async function newFileApi(id, options) {
    const apiOptions = {
        baseUrl: () => options.path(),
        userContentBaseUrl: () => options.userContentPath(),
        username: () => '',
        password: () => '',
        session: () => ({ id: Setting_1.default.value('sync.11.id'), user_id: Setting_1.default.value('sync.11.userId') }),
        env: Setting_1.default.value('env'),
    };
    const api = new JoplinServerApi_1.default(apiOptions);
    const driver = new file_api_driver_joplinServer_1.default(api);
    const fileApi = new file_api_1.FileApi('', driver);
    fileApi.setSyncTargetId(id);
    await fileApi.initialize();
    return fileApi;
}
async function initFileApi(syncTargetId, logger, options) {
    const fileApi = await newFileApi(syncTargetId, options);
    fileApi.setLogger(logger);
    return fileApi;
}
const authenticateWithCode = async (code) => {
    try {
        const response = await fetch(`${Setting_1.default.value('sync.11.path')}/api/login_with_code/${code}`);
        if (response.status !== 200) {
            return false;
        }
        const token = await response.json();
        Setting_1.default.setValue('sync.11.id', token.id);
        Setting_1.default.setValue('sync.11.userId', token.user_id);
    }
    catch (_e) {
        return false;
    }
    return true;
};
exports.authenticateWithCode = authenticateWithCode;
// A sync target for Joplin Server that uses SAML for authentication.
//
// Based on the regular Joplin Server sync target.
class SyncTargetJoplinServerSAML extends SyncTargetJoplinServer_1.default {
    static id() {
        return 11;
    }
    static targetName() {
        return 'joplinServerSaml';
    }
    static label() {
        return `${(0, locale_js_1._)('Joplin Server')} (Beta, SAML)`;
    }
    async isAuthenticated() {
        return Setting_1.default.value('sync.11.id') !== '';
    }
    static requiresPassword() {
        return false;
    }
    async initFileApi() {
        return initFileApi(SyncTargetJoplinServerSAML.id(), this.logger(), {
            path: () => Setting_1.default.value('sync.11.path'),
            userContentPath: () => Setting_1.default.value('sync.11.userContentPath'),
            username: () => '',
            password: () => '',
        });
    }
}
exports.default = SyncTargetJoplinServerSAML;
//# sourceMappingURL=SyncTargetJoplinServerSAML.js.map