"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.runtime = exports.declaration = void 0;
const locale_1 = require("../locale");
const ShareService_1 = require("../services/share/ShareService");
const Logger_1 = require("@joplin/utils/Logger");
const shim_1 = require("../shim");
const logger = Logger_1.default.create('leaveSharedFolder');
exports.declaration = {
    name: 'leaveSharedFolder',
    label: () => (0, locale_1._)('Leave notebook...'),
};
const runtime = () => {
    return {
        execute: async (_context, folderId = null, { force = false } = {}) => {
            const answer = force ? true : await shim_1.default.showConfirmationDialog((0, locale_1._)('This will remove the notebook from your collection and you will no longer have access to its content. Do you wish to continue?'));
            if (!answer)
                return;
            try {
                // Since we are going to delete the notebook, do some extra safety checks. In particular:
                // - Check that the notebook is indeed being shared.
                // - Check that it does **not** belong to the current user.
                const shares = await ShareService_1.default.instance().refreshShares();
                const share = shares.find(s => s.folder_id === folderId);
                if (!share)
                    throw new Error((0, locale_1._)('Could not verify the share status of this notebook - aborting. Please try again when you are connected to the internet.'));
                await ShareService_1.default.instance().leaveSharedFolder(folderId, share.user.id);
            }
            catch (error) {
                logger.error(error);
                await shim_1.default.showErrorDialog((0, locale_1._)('Error: %s', error.message));
            }
        },
        enabledCondition: 'joplinServerConnected && folderIsShareRootAndNotOwnedByUser',
    };
};
exports.runtime = runtime;
//# sourceMappingURL=leaveSharedFolder.js.map