"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const test_utils_1 = require("../testing/test-utils");
const toggleAllFolders_1 = require("./toggleAllFolders");
const Setting_1 = require("../models/Setting");
const reducer_1 = require("../reducer");
const command = (0, toggleAllFolders_1.runtime)();
const makeContext = () => {
    return {
        state: reducer_1.defaultState,
        dispatch: () => { },
    };
};
describe('toggleAllFolders', () => {
    beforeEach(async () => {
        await (0, test_utils_1.setupDatabase)(0);
        await (0, test_utils_1.switchClient)(0);
    });
    test('expanding all should expand the folders header, if previously collapsed', async () => {
        Setting_1.default.setValue('folderHeaderIsExpanded', false);
        // Collapsing all should leave the folder header as-is
        const context = makeContext();
        await command.execute(context, true);
        expect(Setting_1.default.value('folderHeaderIsExpanded')).toBe(false);
        // Expanding all should also expand the folder header
        await command.execute(context, false);
        expect(Setting_1.default.value('folderHeaderIsExpanded')).toBe(true);
    });
});
//# sourceMappingURL=toggleAllFolders.test.js.map