"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const immer_1 = require("immer");
const Logger_1 = require("@joplin/utils/Logger");
const shim_1 = require("../../../../shim");
const PluginService_1 = require("../../../../services/plugins/PluginService");
const locale_1 = require("../../../../locale");
const logger = Logger_1.default.create('useOnInstallHandler');
const useOnInstallHandler = (setInstallingPluginIds, pluginSettingsRef, getRepoApi, onPluginSettingsChange, isUpdate) => {
    const React = shim_1.default.react();
    return React.useCallback(async (event) => {
        const pluginId = event.item.manifest.id;
        // eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
        setInstallingPluginIds((prev) => {
            return Object.assign(Object.assign({}, prev), { [pluginId]: true });
        });
        let installError = null;
        try {
            const repoApi = typeof getRepoApi === 'function' ? getRepoApi() : getRepoApi;
            if (isUpdate) {
                await PluginService_1.default.instance().updatePluginFromRepo(repoApi, pluginId);
            }
            else {
                await PluginService_1.default.instance().installPluginFromRepo(repoApi, pluginId);
            }
        }
        catch (error) {
            installError = error;
            logger.error(error);
        }
        if (!installError) {
            const pluginSettings = pluginSettingsRef.current;
            const newSettings = (0, immer_1.produce)(pluginSettings, (draft) => {
                draft[pluginId] = (0, PluginService_1.defaultPluginSetting)();
                if (isUpdate) {
                    if (pluginSettings[pluginId]) {
                        draft[pluginId].enabled = pluginSettings[pluginId].enabled;
                    }
                    draft[pluginId].hasBeenUpdated = true;
                }
            });
            onPluginSettingsChange({ value: newSettings });
        }
        // eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
        setInstallingPluginIds((prev) => {
            return Object.assign(Object.assign({}, prev), { [pluginId]: false });
        });
        if (installError) {
            await shim_1.default.showMessageBox((0, locale_1._)('Could not install plugin: %s', installError.message), { buttons: [(0, locale_1._)('OK')] });
        }
    }, [getRepoApi, isUpdate, pluginSettingsRef, onPluginSettingsChange, setInstallingPluginIds]);
};
exports.default = useOnInstallHandler;
//# sourceMappingURL=useOnInstallHandler.js.map