"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const getPluginIssueReportUrl = (pluginManifest) => {
    const githubUrlExp = /^https?:\/\/(?:www\.)?github\.com\/([^/]+)\/([^/?]+)/;
    const gitlabUrlExp = /^https?:\/\/(?:www\.)?gitlab\.com\/([^/]+)\/([^/]+)/;
    let githubUrlMatch = null;
    let gitlabUrlMatch = null;
    const urls = [pluginManifest.repository_url, pluginManifest.homepage_url].filter(url => !!url);
    for (const url of urls) {
        githubUrlMatch !== null && githubUrlMatch !== void 0 ? githubUrlMatch : (githubUrlMatch = githubUrlExp.exec(url));
        gitlabUrlMatch !== null && gitlabUrlMatch !== void 0 ? gitlabUrlMatch : (gitlabUrlMatch = gitlabUrlExp.exec(url));
    }
    if (githubUrlMatch) {
        const organization = githubUrlMatch[1];
        // Some plugins include a trailing .git after the repository name
        const project = githubUrlMatch[2].replace(/\.git$/, '');
        return `https://github.com/${organization}/${project}/issues`;
    }
    else if (gitlabUrlMatch) {
        const organization = gitlabUrlMatch[1];
        const project = gitlabUrlMatch[2];
        return `https://gitlab.com/${organization}/${project}/-/issues`;
    }
    return null;
};
exports.default = getPluginIssueReportUrl;
//# sourceMappingURL=getPluginIssueReportUrl.js.map