"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const Folder_1 = require("../../models/Folder");
const Note_1 = require("../../models/Note");
const test_utils_1 = require("../../testing/test-utils");
const emptyTrash_1 = require("./emptyTrash");
describe('emptyTrash', () => {
    beforeEach(async () => {
        await (0, test_utils_1.setupDatabaseAndSynchronizer)(1);
        await (0, test_utils_1.switchClient)(1);
    });
    it('should empty the trash', async () => {
        const folder1 = await Folder_1.default.save({});
        const folder2 = await Folder_1.default.save({ parent_id: folder1.id });
        const folder3 = await Folder_1.default.save({});
        await Note_1.default.save({ parent_id: folder1.id });
        await Note_1.default.save({ parent_id: folder2.id });
        await Note_1.default.save({ parent_id: folder3.id });
        await Folder_1.default.delete(folder1.id, { toTrash: true });
        await (0, emptyTrash_1.default)();
        expect(await Folder_1.default.count()).toBe(1);
        expect(await Note_1.default.count()).toBe(1);
    });
});
//# sourceMappingURL=emptyTrash.test.js.map