"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const RemoteMessenger_1 = require("./RemoteMessenger");
// This allows using a WindowMessenger in a web worker, with window-like objects.
const getLocalWindow = () => {
    return typeof window !== 'undefined' ? window : self;
};
class WindowMessenger extends RemoteMessenger_1.default {
    constructor(channelId, remoteWindow, localApi) {
        super(channelId, localApi);
        this.remoteWindow = remoteWindow;
        this.handleMessageEvent = (event) => {
            if (event.source !== this.remoteWindow) {
                return;
            }
            void this.onMessage(event.data);
        };
        getLocalWindow().addEventListener('message', this.handleMessageEvent);
        this.onReadyToReceive();
    }
    postMessage(message) {
        this.remoteWindow.postMessage(message, '*');
    }
    onClose() {
        getLocalWindow().removeEventListener('message', this.handleMessageEvent);
    }
}
exports.default = WindowMessenger;
//# sourceMappingURL=WindowMessenger.js.map