"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const RemoteMessenger_1 = require("./RemoteMessenger");
class WorkerMessenger extends RemoteMessenger_1.default {
    constructor(channelId, worker, localApi) {
        super(channelId, localApi);
        this.worker = worker;
        this.handleMessageEvent = (event) => {
            void this.onMessage(event.data);
        };
        worker.addEventListener('message', this.handleMessageEvent);
        this.onReadyToReceive();
    }
    postMessage(message) {
        this.worker.postMessage(message);
    }
    onClose() {
        this.worker.removeEventListener('message', this.handleMessageEvent);
    }
}
exports.default = WorkerMessenger;
//# sourceMappingURL=WorkerMessenger.js.map