"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const execa = require("execa");
const commandToString_1 = require("./commandToString");
const splitCommandString_1 = require("./splitCommandString");
const process_1 = require("process");
exports.default = async (command, options = null) => {
    const detached = options ? options.detached : false;
    // When launching a detached executable it's better not to pipe the stdout and stderr, as this
    // will most likely cause an EPIPE error.
    options = Object.assign({ showInput: !detached, showStdout: !detached, showStderr: !detached, quiet: false, env: {} }, options);
    if (options.quiet) {
        options.showInput = false;
        options.showStdout = false;
        options.showStderr = false;
    }
    if (options.showInput) {
        if (typeof command === 'string') {
            process_1.stdout.write(`> ${command}\n`);
        }
        else {
            process_1.stdout.write(`> ${(0, commandToString_1.default)(command[0], command.slice(1))}\n`);
        }
    }
    const args = typeof command === 'string' ? (0, splitCommandString_1.default)(command) : command;
    const executableName = args[0];
    args.splice(0, 1);
    // eslint-disable-next-line @typescript-eslint/no-explicit-any -- Workaround for type definition conflicts. Expo currently overrides NodeJs.ProcessEnv, making NODE_ENV required. This changes the type of the "env" argument to execa.
    const promise = execa(executableName, args, { env: options.env });
    if (options.showStdout && promise.stdout)
        promise.stdout.pipe(process.stdout);
    if (options.showStderr && promise.stderr)
        promise.stderr.pipe(process.stderr);
    const result = await promise;
    return result.stdout.trim();
};
//# sourceMappingURL=execCommand.js.map