"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.extractUrls = exports.isSelfClosingTag = exports.attributesHtml = exports.htmlentitiesDecode = exports.htmlentities = void 0;
const Entities = require('html-entities').AllHtmlEntities;
const htmlparser2 = require('@joplin/fork-htmlparser2');
const selfClosingElements = [
    'area',
    'base',
    'basefont',
    'br',
    'col',
    'command',
    'embed',
    'frame',
    'hr',
    'img',
    'input',
    'isindex',
    'keygen',
    'link',
    'meta',
    'param',
    'source',
    'track',
    'wbr',
];
const entitiesInstance = new Entities();
exports.htmlentities = entitiesInstance.encode;
exports.htmlentitiesDecode = entitiesInstance.decode;
// eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
const attributesHtml = (attr) => {
    const output = [];
    for (const n in attr) {
        if (!attr.hasOwnProperty(n))
            continue;
        output.push(`${n}="${(0, exports.htmlentities)(attr[n])}"`);
    }
    return output.join(' ');
};
exports.attributesHtml = attributesHtml;
const isSelfClosingTag = (tagName) => {
    return selfClosingElements.includes(tagName.toLowerCase());
};
exports.isSelfClosingTag = isSelfClosingTag;
const extractUrls = (html) => {
    if (!html || !html.trim())
        return [];
    const output = [];
    let currentLink = null;
    const parser = new htmlparser2.Parser({
        onopentag: (name, attrs) => {
            if (name === 'a') {
                currentLink = {
                    url: attrs && attrs.href ? attrs.href : '',
                    title: '',
                };
            }
        },
        ontext: (text) => {
            if (currentLink)
                currentLink.title += text;
        },
        onclosetag: (name) => {
            if (name === 'a') {
                if (!currentLink)
                    throw new Error('Found a closing anchor tag without an opening one');
                output.push(currentLink);
                currentLink = null;
            }
        },
    }, { decodeEntities: true });
    parser.write(html);
    parser.end();
    return output;
};
exports.extractUrls = extractUrls;
//# sourceMappingURL=html.js.map