import {
  Endpoint,
  Provider,
  RegionInfoProvider,
  UrlParser,
} from "@aws-sdk/types";
export interface EndpointsInputConfig {
  endpoint?: string | Endpoint | Provider<Endpoint>;
  tls?: boolean;
  useDualstackEndpoint?: boolean | Provider<boolean>;
}
interface PreviouslyResolved {
  regionInfoProvider: RegionInfoProvider;
  urlParser: UrlParser;
  region: Provider<string>;
  useFipsEndpoint: Provider<boolean>;
}
export interface EndpointsResolvedConfig
  extends Required<EndpointsInputConfig> {
  endpoint: Provider<Endpoint>;
  isCustomEndpoint?: boolean;
  useDualstackEndpoint: Provider<boolean>;
}
export declare const resolveEndpointsConfig: <T>(
  input: T & EndpointsInputConfig & PreviouslyResolved
) => T & EndpointsResolvedConfig;
export {};
