"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createRequest = void 0;
async function createRequest(client, command) {
    const interceptMiddleware = (next) => async (args) => {
        return { output: { request: args.request }, response: undefined };
    };
    const clientStack = client.middlewareStack.clone();
    clientStack.add(interceptMiddleware, {
        step: "build",
        priority: "low",
    });
    const handler = command.resolveMiddleware(clientStack, client.config, undefined);
    return await handler(command).then((output) => output.output.request);
}
exports.createRequest = createRequest;
