"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.runtime = exports.declaration = void 0;
const locale_1 = require("../locale");
const Note_1 = require("../models/Note");
exports.declaration = {
    name: 'deleteNote',
    label: () => (0, locale_1._)('Delete note'),
    iconName: 'fa-times',
};
const runtime = () => {
    return {
        execute: async (context, noteIds = null) => {
            if (noteIds === null)
                noteIds = context.state.selectedNoteIds;
            if (!noteIds.length)
                return;
            await Note_1.default.batchDelete(noteIds, { toTrash: true, sourceDescription: 'deleteNote command' });
            context.dispatch({
                type: 'ITEMS_TRASHED',
                value: {
                    noteIds,
                    folderIds: [],
                },
            });
        },
        enabledCondition: '!noteIsReadOnly && !inTrash && someNotesSelected',
    };
};
exports.runtime = runtime;
//# sourceMappingURL=deleteNote.js.map