"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const os_1 = require("os");
const path_utils_1 = require("./path-utils");
exports.default = (profileFromArgs, appName, altInstanceId) => {
    let profileDir = '';
    let homeDir = '';
    if (profileFromArgs) {
        profileDir = profileFromArgs;
        homeDir = profileDir;
    }
    else if (process && process.env && process.env.PORTABLE_EXECUTABLE_DIR) {
        profileDir = `${process.env.PORTABLE_EXECUTABLE_DIR}/JoplinProfile`;
        homeDir = process.env.PORTABLE_EXECUTABLE_DIR;
    }
    else {
        if (!altInstanceId) {
            profileDir = `${(0, os_1.homedir)()}/.config/${appName}`;
        }
        else {
            profileDir = `${(0, os_1.homedir)()}/.config/${appName}-${altInstanceId}`;
        }
        homeDir = (0, os_1.homedir)();
    }
    return {
        rootProfileDir: (0, path_utils_1.toSystemSlashes)(profileDir, 'linux'),
        homeDir: (0, path_utils_1.toSystemSlashes)(homeDir, 'linux'),
    };
};
//# sourceMappingURL=determineBaseAppDirs.js.map