"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const callbackUrlUtils_1 = require("../../callbackUrlUtils");
const isItemId_1 = require("../../models/utils/isItemId");
exports.default = (query) => {
    if (!query)
        return '';
    if ((0, isItemId_1.default)(query) || (0, callbackUrlUtils_1.isCallbackUrl)(query))
        return query;
    const output = [];
    const splitted = query.split(' ');
    for (let i = 0; i < splitted.length; i++) {
        const s = splitted[i].trim();
        if (!s)
            continue;
        output.push(`${s}*`);
    }
    return output.join(' ');
};
//# sourceMappingURL=gotoAnythingStyleQuery.js.map