"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.allNotesFolders = allNotesFolders;
exports.remoteNotesAndFolders = remoteNotesAndFolders;
exports.remoteNotesFoldersResources = remoteNotesFoldersResources;
exports.remoteResources = remoteResources;
exports.localNotesFoldersSameAsRemote = localNotesFoldersSameAsRemote;
const BaseModel_1 = require("../BaseModel");
const test_utils_1 = require("../testing/../testing/test-utils");
const Folder_1 = require("../models/Folder");
const Note_1 = require("../models/Note");
const BaseItem_1 = require("../models/BaseItem");
async function allNotesFolders() {
    const folders = await Folder_1.default.all();
    const notes = await Note_1.default.all();
    return folders.concat(notes);
}
async function remoteItemsByTypes(types) {
    const list = await (0, test_utils_1.fileApi)().list('', { includeDirs: false, syncItemsOnly: true });
    if (list.hasMore)
        throw new Error('Not implemented!!!');
    const files = list.items;
    const output = [];
    for (const file of files) {
        const remoteContent = await (0, test_utils_1.fileApi)().get(file.path);
        const content = await BaseItem_1.default.unserialize(remoteContent);
        if (types.indexOf(content.type_) < 0)
            continue;
        output.push(content);
    }
    return output;
}
async function remoteNotesAndFolders() {
    return remoteItemsByTypes([BaseModel_1.default.TYPE_NOTE, BaseModel_1.default.TYPE_FOLDER]);
}
async function remoteNotesFoldersResources() {
    return remoteItemsByTypes([BaseModel_1.default.TYPE_NOTE, BaseModel_1.default.TYPE_FOLDER, BaseModel_1.default.TYPE_RESOURCE]);
}
async function remoteResources() {
    return remoteItemsByTypes([BaseModel_1.default.TYPE_RESOURCE]);
}
// eslint-disable-next-line @typescript-eslint/ban-types, @typescript-eslint/no-explicit-any -- Old code before rule was applied, Old code before rule was applied
async function localNotesFoldersSameAsRemote(locals, expect) {
    let error = null;
    try {
        const nf = await remoteNotesAndFolders();
        expect(locals.length).toBe(nf.length);
        for (let i = 0; i < locals.length; i++) {
            const dbItem = locals[i];
            const path = BaseItem_1.default.systemPath(dbItem);
            const remote = await (0, test_utils_1.fileApi)().stat(path);
            expect(!!remote).toBe(true);
            if (!remote)
                continue;
            let remoteContent = await (0, test_utils_1.fileApi)().get(path);
            remoteContent = dbItem.type_ === BaseModel_1.default.TYPE_NOTE ? await Note_1.default.unserialize(remoteContent) : await Folder_1.default.unserialize(remoteContent);
            expect(remoteContent.title).toBe(dbItem.title);
        }
    }
    catch (e) {
        error = e;
    }
    expect(error).toBe(null);
}
//# sourceMappingURL=test-utils-synchronizer.js.map