"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.accountTypeToString = accountTypeToString;
var AccountType;
(function (AccountType) {
    AccountType[AccountType["Default"] = 0] = "Default";
    AccountType[AccountType["Basic"] = 1] = "Basic";
    AccountType[AccountType["Pro"] = 2] = "Pro";
    AccountType[AccountType["Team"] = 3] = "Team";
})(AccountType || (AccountType = {}));
// eslint-disable-next-line import/prefer-default-export
function accountTypeToString(accountType) {
    if (accountType === AccountType.Default)
        return 'Default';
    if (accountType === AccountType.Basic)
        return 'Basic';
    if (accountType === AccountType.Pro)
        return 'Pro';
    if (accountType === AccountType.Team)
        return 'Team';
    const exhaustivenessCheck = accountType;
    throw new Error(`Invalid type: ${exhaustivenessCheck}`);
}
//# sourceMappingURL=types.js.map