"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.bytesToHuman = exports.GB = exports.MB = exports.KB = void 0;
exports.KB = 1024;
exports.MB = exports.KB * exports.KB;
exports.GB = exports.KB * exports.MB;
const bytesToHuman = (bytes) => {
    const units = ['Bytes', 'KB', 'MB', 'GB'];
    let unitIndex = 0;
    while (bytes >= 1024 && unitIndex < units.length - 1) {
        bytes /= 1024;
        unitIndex++;
    }
    return `${bytes.toFixed(1)} ${units[unitIndex]}`;
};
exports.bytesToHuman = bytesToHuman;
//# sourceMappingURL=bytes.js.map