"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const vm = require("vm");
const BasePluginRunner_1 = require("@joplin/lib/services/plugins/BasePluginRunner");
const executeSandboxCall_1 = require("@joplin/lib/services/plugins/utils/executeSandboxCall");
const mapEventHandlersToIds_1 = require("@joplin/lib/services/plugins/utils/mapEventHandlersToIds");
const uuid_1 = require("@joplin/lib/uuid");
const sandboxProxy = require('@joplin/lib/services/plugins/sandboxProxy');
function createConsoleWrapper(pluginId) {
    // eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
    const wrapper = {};
    for (const n in console) {
        // eslint-disable-next-line no-console
        if (!console.hasOwnProperty(n))
            continue;
        // eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
        wrapper[n] = (...args) => {
            const newArgs = args.slice();
            newArgs.splice(0, 0, `Plugin "${pluginId}":`);
            // eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
            return console[n](...newArgs);
        };
    }
    return wrapper;
}
class PluginRunner extends BasePluginRunner_1.default {
    constructor() {
        super();
        this.eventHandlers_ = {};
        // eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
        this.activeSandboxCalls_ = {};
        this.sandboxProxies = new Map();
        this.eventHandler = this.eventHandler.bind(this);
    }
    // eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
    async eventHandler(eventHandlerId, args) {
        const cb = this.eventHandlers_[eventHandlerId];
        return cb(...args);
    }
    newSandboxProxy(pluginId, sandbox) {
        let stopped = false;
        // eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
        const target = async (path, args) => {
            if (stopped) {
                throw new Error(`Plugin with ID ${pluginId} has been stopped. Cannot execute sandbox call.`);
            }
            const callId = `${pluginId}::${path}::${uuid_1.default.createNano()}`;
            this.activeSandboxCalls_[callId] = true;
            const promise = (0, executeSandboxCall_1.default)(pluginId, sandbox, `joplin.${path}`, (0, mapEventHandlersToIds_1.default)(args, this.eventHandlers_), this.eventHandler);
            // eslint-disable-next-line promise/prefer-await-to-then -- Old code before rule was applied
            void promise.finally(() => {
                delete this.activeSandboxCalls_[callId];
            });
            return promise;
        };
        const proxy = {
            joplin: sandboxProxy(target),
            console: createConsoleWrapper(pluginId),
            stop: () => {
                stopped = true;
            },
        };
        this.sandboxProxies.set(pluginId, proxy);
        return proxy;
    }
    async run(plugin, sandbox) {
        // eslint-disable-next-line @typescript-eslint/ban-types -- Old code before rule was applied
        return new Promise((resolve, reject) => {
            const onStarted = () => {
                plugin.off('started', onStarted);
                resolve();
            };
            plugin.on('started', onStarted);
            const vmSandbox = vm.createContext(this.newSandboxProxy(plugin.id, sandbox));
            try {
                vm.runInContext(plugin.scriptText, vmSandbox);
            }
            catch (error) {
                reject(error);
            }
        });
    }
    async stop(plugin) {
        // TODO: Node VM doesn't support stopping plugins without running them in a child process.
        // For now, we stop the plugin by making interactions with the Joplin API throw Errors.
        const proxy = this.sandboxProxies.get(plugin.id);
        proxy === null || proxy === void 0 ? void 0 : proxy.stop();
    }
    async waitForSandboxCalls() {
        const startTime = Date.now();
        // eslint-disable-next-line @typescript-eslint/ban-types -- Old code before rule was applied
        return new Promise((resolve, reject) => {
            const iid = setInterval(() => {
                if (!Object.keys(this.activeSandboxCalls_).length) {
                    clearInterval(iid);
                    resolve();
                }
                if (Date.now() - startTime > 4000) {
                    clearInterval(iid);
                    reject(new Error(`Timeout while waiting for sandbox calls to complete: ${JSON.stringify(this.activeSandboxCalls_)}`));
                }
            }, 10);
        });
    }
}
exports.default = PluginRunner;
//# sourceMappingURL=PluginRunner.js.map