# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: b2bi
using AWS.Compat
using AWS.UUIDs

"""
    create_capability(configuration, name, type)
    create_capability(configuration, name, type, params::Dict{String,<:Any})

Instantiates a capability based on the specified parameters. A trading capability contains
the information required to transform incoming EDI documents into JSON or XML outputs.

# Arguments
- `configuration`: Specifies a structure that contains the details for a capability.
- `name`: Specifies the name of the capability, used to identify it.
- `type`: Specifies the type of the capability. Currently, only edi is supported.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientToken"`: Reserved for future use.
- `"instructionsDocuments"`: Specifies one or more locations in Amazon S3, each specifying
  an EDI document that can be used with this capability. Each item contains the name of the
  bucket and the key, to identify the document's location.
- `"tags"`: Specifies the key-value pairs assigned to ARNs that you can use to group and
  search for resources by type. You can attach this metadata to resources (capabilities,
  partnerships, and so on) for any purpose.
"""
function create_capability(
    configuration, name, type; aws_config::AbstractAWSConfig=current_aws_config()
)
    return b2bi(
        "CreateCapability",
        Dict{String,Any}(
            "configuration" => configuration,
            "name" => name,
            "type" => type,
            "clientToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_capability(
    configuration,
    name,
    type,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return b2bi(
        "CreateCapability",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "configuration" => configuration,
                    "name" => name,
                    "type" => type,
                    "clientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_partnership(capabilities, email, name, profile_id)
    create_partnership(capabilities, email, name, profile_id, params::Dict{String,<:Any})

Creates a partnership between a customer and a trading partner, based on the supplied
parameters. A partnership represents the connection between you and your trading partner.
It ties together a profile and one or more trading capabilities.

# Arguments
- `capabilities`: Specifies a list of the capabilities associated with this partnership.
- `email`: Specifies the email address associated with this trading partner.
- `name`: Specifies a descriptive name for the partnership.
- `profile_id`: Specifies the unique, system-generated identifier for the profile connected
  to this partnership.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientToken"`: Reserved for future use.
- `"phone"`: Specifies the phone number associated with the partnership.
- `"tags"`: Specifies the key-value pairs assigned to ARNs that you can use to group and
  search for resources by type. You can attach this metadata to resources (capabilities,
  partnerships, and so on) for any purpose.
"""
function create_partnership(
    capabilities, email, name, profileId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return b2bi(
        "CreatePartnership",
        Dict{String,Any}(
            "capabilities" => capabilities,
            "email" => email,
            "name" => name,
            "profileId" => profileId,
            "clientToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_partnership(
    capabilities,
    email,
    name,
    profileId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return b2bi(
        "CreatePartnership",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "capabilities" => capabilities,
                    "email" => email,
                    "name" => name,
                    "profileId" => profileId,
                    "clientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_profile(business_name, logging, name, phone)
    create_profile(business_name, logging, name, phone, params::Dict{String,<:Any})

Creates a customer profile. You can have up to five customer profiles, each representing a
distinct private network. A profile is the mechanism used to create the concept of a
private network.

# Arguments
- `business_name`: Specifies the name for the business associated with this profile.
- `logging`: Specifies whether or not logging is enabled for this profile.
- `name`: Specifies the name of the profile.
- `phone`: Specifies the phone number associated with the profile.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientToken"`: Reserved for future use.
- `"email"`: Specifies the email address associated with this customer profile.
- `"tags"`: Specifies the key-value pairs assigned to ARNs that you can use to group and
  search for resources by type. You can attach this metadata to resources (capabilities,
  partnerships, and so on) for any purpose.
"""
function create_profile(
    businessName, logging, name, phone; aws_config::AbstractAWSConfig=current_aws_config()
)
    return b2bi(
        "CreateProfile",
        Dict{String,Any}(
            "businessName" => businessName,
            "logging" => logging,
            "name" => name,
            "phone" => phone,
            "clientToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_profile(
    businessName,
    logging,
    name,
    phone,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return b2bi(
        "CreateProfile",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "businessName" => businessName,
                    "logging" => logging,
                    "name" => name,
                    "phone" => phone,
                    "clientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_transformer(edi_type, file_format, mapping_template, name)
    create_transformer(edi_type, file_format, mapping_template, name, params::Dict{String,<:Any})

Creates a transformer. A transformer describes how to process the incoming EDI documents
and extract the necessary information to the output file.

# Arguments
- `edi_type`: Specifies the details for the EDI standard that is being used for the
  transformer. Currently, only X12 is supported. X12 is a set of standards and corresponding
  messages that define specific business documents.
- `file_format`: Specifies that the currently supported file formats for EDI
  transformations are JSON and XML.
- `mapping_template`: Specifies the mapping template for the transformer. This template is
  used to map the parsed EDI file using JSONata or XSLT.
- `name`: Specifies the name of the transformer, used to identify it.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientToken"`: Reserved for future use.
- `"sampleDocument"`: Specifies a sample EDI document that is used by a transformer as a
  guide for processing the EDI data.
- `"tags"`: Specifies the key-value pairs assigned to ARNs that you can use to group and
  search for resources by type. You can attach this metadata to resources (capabilities,
  partnerships, and so on) for any purpose.
"""
function create_transformer(
    ediType,
    fileFormat,
    mappingTemplate,
    name;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return b2bi(
        "CreateTransformer",
        Dict{String,Any}(
            "ediType" => ediType,
            "fileFormat" => fileFormat,
            "mappingTemplate" => mappingTemplate,
            "name" => name,
            "clientToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_transformer(
    ediType,
    fileFormat,
    mappingTemplate,
    name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return b2bi(
        "CreateTransformer",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ediType" => ediType,
                    "fileFormat" => fileFormat,
                    "mappingTemplate" => mappingTemplate,
                    "name" => name,
                    "clientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_capability(capability_id)
    delete_capability(capability_id, params::Dict{String,<:Any})

Deletes the specified capability. A trading capability contains the information required to
transform incoming EDI documents into JSON or XML outputs.

# Arguments
- `capability_id`: Specifies a system-assigned unique identifier for the capability.

"""
function delete_capability(capabilityId; aws_config::AbstractAWSConfig=current_aws_config())
    return b2bi(
        "DeleteCapability",
        Dict{String,Any}("capabilityId" => capabilityId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_capability(
    capabilityId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return b2bi(
        "DeleteCapability",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("capabilityId" => capabilityId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_partnership(partnership_id)
    delete_partnership(partnership_id, params::Dict{String,<:Any})

Deletes the specified partnership. A partnership represents the connection between you and
your trading partner. It ties together a profile and one or more trading capabilities.

# Arguments
- `partnership_id`: Specifies the unique, system-generated identifier for a partnership.

"""
function delete_partnership(
    partnershipId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return b2bi(
        "DeletePartnership",
        Dict{String,Any}("partnershipId" => partnershipId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_partnership(
    partnershipId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return b2bi(
        "DeletePartnership",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("partnershipId" => partnershipId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_profile(profile_id)
    delete_profile(profile_id, params::Dict{String,<:Any})

Deletes the specified profile. A profile is the mechanism used to create the concept of a
private network.

# Arguments
- `profile_id`: Specifies the unique, system-generated identifier for the profile.

"""
function delete_profile(profileId; aws_config::AbstractAWSConfig=current_aws_config())
    return b2bi(
        "DeleteProfile",
        Dict{String,Any}("profileId" => profileId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_profile(
    profileId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return b2bi(
        "DeleteProfile",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("profileId" => profileId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_transformer(transformer_id)
    delete_transformer(transformer_id, params::Dict{String,<:Any})

Deletes the specified transformer. A transformer describes how to process the incoming EDI
documents and extract the necessary information to the output file.

# Arguments
- `transformer_id`: Specifies the system-assigned unique identifier for the transformer.

"""
function delete_transformer(
    transformerId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return b2bi(
        "DeleteTransformer",
        Dict{String,Any}("transformerId" => transformerId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_transformer(
    transformerId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return b2bi(
        "DeleteTransformer",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("transformerId" => transformerId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_capability(capability_id)
    get_capability(capability_id, params::Dict{String,<:Any})

Retrieves the details for the specified capability. A trading capability contains the
information required to transform incoming EDI documents into JSON or XML outputs.

# Arguments
- `capability_id`: Specifies a system-assigned unique identifier for the capability.

"""
function get_capability(capabilityId; aws_config::AbstractAWSConfig=current_aws_config())
    return b2bi(
        "GetCapability",
        Dict{String,Any}("capabilityId" => capabilityId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_capability(
    capabilityId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return b2bi(
        "GetCapability",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("capabilityId" => capabilityId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_partnership(partnership_id)
    get_partnership(partnership_id, params::Dict{String,<:Any})

Retrieves the details for a partnership, based on the partner and profile IDs specified. A
partnership represents the connection between you and your trading partner. It ties
together a profile and one or more trading capabilities.

# Arguments
- `partnership_id`: Specifies the unique, system-generated identifier for a partnership.

"""
function get_partnership(partnershipId; aws_config::AbstractAWSConfig=current_aws_config())
    return b2bi(
        "GetPartnership",
        Dict{String,Any}("partnershipId" => partnershipId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_partnership(
    partnershipId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return b2bi(
        "GetPartnership",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("partnershipId" => partnershipId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_profile(profile_id)
    get_profile(profile_id, params::Dict{String,<:Any})

Retrieves the details for the profile specified by the profile ID. A profile is the
mechanism used to create the concept of a private network.

# Arguments
- `profile_id`: Specifies the unique, system-generated identifier for the profile.

"""
function get_profile(profileId; aws_config::AbstractAWSConfig=current_aws_config())
    return b2bi(
        "GetProfile",
        Dict{String,Any}("profileId" => profileId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_profile(
    profileId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return b2bi(
        "GetProfile",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("profileId" => profileId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_transformer(transformer_id)
    get_transformer(transformer_id, params::Dict{String,<:Any})

Retrieves the details for the transformer specified by the transformer ID. A transformer
describes how to process the incoming EDI documents and extract the necessary information
to the output file.

# Arguments
- `transformer_id`: Specifies the system-assigned unique identifier for the transformer.

"""
function get_transformer(transformerId; aws_config::AbstractAWSConfig=current_aws_config())
    return b2bi(
        "GetTransformer",
        Dict{String,Any}("transformerId" => transformerId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_transformer(
    transformerId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return b2bi(
        "GetTransformer",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("transformerId" => transformerId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_transformer_job(transformer_id, transformer_job_id)
    get_transformer_job(transformer_id, transformer_job_id, params::Dict{String,<:Any})

Returns the details of the transformer run, based on the Transformer job ID.

# Arguments
- `transformer_id`: Specifies the system-assigned unique identifier for the transformer.
- `transformer_job_id`: Specifies the unique, system-generated identifier for a transformer
  run.

"""
function get_transformer_job(
    transformerId, transformerJobId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return b2bi(
        "GetTransformerJob",
        Dict{String,Any}(
            "transformerId" => transformerId, "transformerJobId" => transformerJobId
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_transformer_job(
    transformerId,
    transformerJobId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return b2bi(
        "GetTransformerJob",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "transformerId" => transformerId, "transformerJobId" => transformerJobId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_capabilities()
    list_capabilities(params::Dict{String,<:Any})

Lists the capabilities associated with your Amazon Web Services account for your current or
specified region. A trading capability contains the information required to transform
incoming EDI documents into JSON or XML outputs.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: Specifies the maximum number of capabilities to return.
- `"nextToken"`: When additional results are obtained from the command, a NextToken
  parameter is returned in the output. You can then pass the NextToken parameter in a
  subsequent command to continue listing additional resources.
"""
function list_capabilities(; aws_config::AbstractAWSConfig=current_aws_config())
    return b2bi("ListCapabilities"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function list_capabilities(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return b2bi(
        "ListCapabilities", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_partnerships()
    list_partnerships(params::Dict{String,<:Any})

Lists the partnerships associated with your Amazon Web Services account for your current or
specified region. A partnership represents the connection between you and your trading
partner. It ties together a profile and one or more trading capabilities.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: Specifies the maximum number of capabilities to return.
- `"nextToken"`: When additional results are obtained from the command, a NextToken
  parameter is returned in the output. You can then pass the NextToken parameter in a
  subsequent command to continue listing additional resources.
- `"profileId"`: Specifies the unique, system-generated identifier for the profile
  connected to this partnership.
"""
function list_partnerships(; aws_config::AbstractAWSConfig=current_aws_config())
    return b2bi("ListPartnerships"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function list_partnerships(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return b2bi(
        "ListPartnerships", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_profiles()
    list_profiles(params::Dict{String,<:Any})

Lists the profiles associated with your Amazon Web Services account for your current or
specified region. A profile is the mechanism used to create the concept of a private
network.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: Specifies the maximum number of profiles to return.
- `"nextToken"`: When additional results are obtained from the command, a NextToken
  parameter is returned in the output. You can then pass the NextToken parameter in a
  subsequent command to continue listing additional resources.
"""
function list_profiles(; aws_config::AbstractAWSConfig=current_aws_config())
    return b2bi("ListProfiles"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function list_profiles(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return b2bi(
        "ListProfiles", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_tags_for_resource(resource_arn)
    list_tags_for_resource(resource_arn, params::Dict{String,<:Any})

Lists all of the tags associated with the Amazon Resource Name (ARN) that you specify. The
resource can be a capability, partnership, profile, or transformer.

# Arguments
- `resource_arn`: Requests the tags associated with a particular Amazon Resource Name
  (ARN). An ARN is an identifier for a specific Amazon Web Services resource, such as a
  capability, partnership, profile, or transformer.

"""
function list_tags_for_resource(
    ResourceARN; aws_config::AbstractAWSConfig=current_aws_config()
)
    return b2bi(
        "ListTagsForResource",
        Dict{String,Any}("ResourceARN" => ResourceARN);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tags_for_resource(
    ResourceARN,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return b2bi(
        "ListTagsForResource",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ResourceARN" => ResourceARN), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_transformers()
    list_transformers(params::Dict{String,<:Any})

Lists the available transformers. A transformer describes how to process the incoming EDI
documents and extract the necessary information to the output file.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: Specifies the number of items to return for the API response.
- `"nextToken"`: When additional results are obtained from the command, a NextToken
  parameter is returned in the output. You can then pass the NextToken parameter in a
  subsequent command to continue listing additional resources.
"""
function list_transformers(; aws_config::AbstractAWSConfig=current_aws_config())
    return b2bi("ListTransformers"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function list_transformers(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return b2bi(
        "ListTransformers", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    start_transformer_job(input_file, output_location, transformer_id)
    start_transformer_job(input_file, output_location, transformer_id, params::Dict{String,<:Any})

Runs a job, using a transformer, to parse input EDI (electronic data interchange) file into
the output structures used by Amazon Web Services B2BI Data Interchange. If you only want
to transform EDI (electronic data interchange) documents, you don't need to create
profiles, partnerships or capabilities. Just create and configure a transformer, and then
run the StartTransformerJob API to process your files.

# Arguments
- `input_file`: Specifies the location of the input file for the transformation. The
  location consists of an Amazon S3 bucket and prefix.
- `output_location`: Specifies the location of the output file for the transformation. The
  location consists of an Amazon S3 bucket and prefix.
- `transformer_id`: Specifies the system-assigned unique identifier for the transformer.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientToken"`: Reserved for future use.
"""
function start_transformer_job(
    inputFile,
    outputLocation,
    transformerId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return b2bi(
        "StartTransformerJob",
        Dict{String,Any}(
            "inputFile" => inputFile,
            "outputLocation" => outputLocation,
            "transformerId" => transformerId,
            "clientToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_transformer_job(
    inputFile,
    outputLocation,
    transformerId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return b2bi(
        "StartTransformerJob",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "inputFile" => inputFile,
                    "outputLocation" => outputLocation,
                    "transformerId" => transformerId,
                    "clientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_resource(resource_arn, tags)
    tag_resource(resource_arn, tags, params::Dict{String,<:Any})

Attaches a key-value pair to a resource, as identified by its Amazon Resource Name (ARN).
Resources are capability, partnership, profile, transformers and other entities. There is
no response returned from this call.

# Arguments
- `resource_arn`: Specifies an Amazon Resource Name (ARN) for a specific Amazon Web
  Services resource, such as a capability, partnership, profile, or transformer.
- `tags`: Specifies the key-value pairs assigned to ARNs that you can use to group and
  search for resources by type. You can attach this metadata to resources (capabilities,
  partnerships, and so on) for any purpose.

"""
function tag_resource(ResourceARN, Tags; aws_config::AbstractAWSConfig=current_aws_config())
    return b2bi(
        "TagResource",
        Dict{String,Any}("ResourceARN" => ResourceARN, "Tags" => Tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_resource(
    ResourceARN,
    Tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return b2bi(
        "TagResource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ResourceARN" => ResourceARN, "Tags" => Tags),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    test_mapping(file_format, input_file_content, mapping_template)
    test_mapping(file_format, input_file_content, mapping_template, params::Dict{String,<:Any})

Maps the input file according to the provided template file. The API call downloads the
file contents from the Amazon S3 location, and passes the contents in as a string, to the
inputFileContent parameter.

# Arguments
- `file_format`: Specifies that the currently supported file formats for EDI
  transformations are JSON and XML.
- `input_file_content`: Specify the contents of the EDI (electronic data interchange) XML
  or JSON file that is used as input for the transform.
- `mapping_template`: Specifies the mapping template for the transformer. This template is
  used to map the parsed EDI file using JSONata or XSLT.

"""
function test_mapping(
    fileFormat,
    inputFileContent,
    mappingTemplate;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return b2bi(
        "TestMapping",
        Dict{String,Any}(
            "fileFormat" => fileFormat,
            "inputFileContent" => inputFileContent,
            "mappingTemplate" => mappingTemplate,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function test_mapping(
    fileFormat,
    inputFileContent,
    mappingTemplate,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return b2bi(
        "TestMapping",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "fileFormat" => fileFormat,
                    "inputFileContent" => inputFileContent,
                    "mappingTemplate" => mappingTemplate,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    test_parsing(edi_type, file_format, input_file)
    test_parsing(edi_type, file_format, input_file, params::Dict{String,<:Any})

Parses the input EDI (electronic data interchange) file. The input file has a file size
limit of 250 KB.

# Arguments
- `edi_type`: Specifies the details for the EDI standard that is being used for the
  transformer. Currently, only X12 is supported. X12 is a set of standards and corresponding
  messages that define specific business documents.
- `file_format`: Specifies that the currently supported file formats for EDI
  transformations are JSON and XML.
- `input_file`: Specifies an S3Location object, which contains the Amazon S3 bucket and
  prefix for the location of the input file.

"""
function test_parsing(
    ediType, fileFormat, inputFile; aws_config::AbstractAWSConfig=current_aws_config()
)
    return b2bi(
        "TestParsing",
        Dict{String,Any}(
            "ediType" => ediType, "fileFormat" => fileFormat, "inputFile" => inputFile
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function test_parsing(
    ediType,
    fileFormat,
    inputFile,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return b2bi(
        "TestParsing",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ediType" => ediType,
                    "fileFormat" => fileFormat,
                    "inputFile" => inputFile,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_resource(resource_arn, tag_keys)
    untag_resource(resource_arn, tag_keys, params::Dict{String,<:Any})

Detaches a key-value pair from the specified resource, as identified by its Amazon Resource
Name (ARN). Resources are capability, partnership, profile, transformers and other entities.

# Arguments
- `resource_arn`: Specifies an Amazon Resource Name (ARN) for a specific Amazon Web
  Services resource, such as a capability, partnership, profile, or transformer.
- `tag_keys`: Specifies the key-value pairs assigned to ARNs that you can use to group and
  search for resources by type. You can attach this metadata to resources (capabilities,
  partnerships, and so on) for any purpose.

"""
function untag_resource(
    ResourceARN, TagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return b2bi(
        "UntagResource",
        Dict{String,Any}("ResourceARN" => ResourceARN, "TagKeys" => TagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_resource(
    ResourceARN,
    TagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return b2bi(
        "UntagResource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ResourceARN" => ResourceARN, "TagKeys" => TagKeys),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_capability(capability_id)
    update_capability(capability_id, params::Dict{String,<:Any})

Updates some of the parameters for a capability, based on the specified parameters. A
trading capability contains the information required to transform incoming EDI documents
into JSON or XML outputs.

# Arguments
- `capability_id`: Specifies a system-assigned unique identifier for the capability.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"configuration"`: Specifies a structure that contains the details for a capability.
- `"instructionsDocuments"`: Specifies one or more locations in Amazon S3, each specifying
  an EDI document that can be used with this capability. Each item contains the name of the
  bucket and the key, to identify the document's location.
- `"name"`: Specifies a new name for the capability, to replace the existing name.
"""
function update_capability(capabilityId; aws_config::AbstractAWSConfig=current_aws_config())
    return b2bi(
        "UpdateCapability",
        Dict{String,Any}("capabilityId" => capabilityId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_capability(
    capabilityId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return b2bi(
        "UpdateCapability",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("capabilityId" => capabilityId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_partnership(partnership_id)
    update_partnership(partnership_id, params::Dict{String,<:Any})

Updates some of the parameters for a partnership between a customer and trading partner. A
partnership represents the connection between you and your trading partner. It ties
together a profile and one or more trading capabilities.

# Arguments
- `partnership_id`: Specifies the unique, system-generated identifier for a partnership.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"capabilities"`: List of the capabilities associated with this partnership.
- `"name"`: The name of the partnership, used to identify it.
"""
function update_partnership(
    partnershipId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return b2bi(
        "UpdatePartnership",
        Dict{String,Any}("partnershipId" => partnershipId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_partnership(
    partnershipId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return b2bi(
        "UpdatePartnership",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("partnershipId" => partnershipId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_profile(profile_id)
    update_profile(profile_id, params::Dict{String,<:Any})

Updates the specified parameters for a profile. A profile is the mechanism used to create
the concept of a private network.

# Arguments
- `profile_id`: Specifies the unique, system-generated identifier for the profile.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"businessName"`: Specifies the name for the business associated with this profile.
- `"email"`: Specifies the email address associated with this customer profile.
- `"name"`: The name of the profile, used to identify it.
- `"phone"`: Specifies the phone number associated with the profile.
"""
function update_profile(profileId; aws_config::AbstractAWSConfig=current_aws_config())
    return b2bi(
        "UpdateProfile",
        Dict{String,Any}("profileId" => profileId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_profile(
    profileId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return b2bi(
        "UpdateProfile",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("profileId" => profileId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_transformer(transformer_id)
    update_transformer(transformer_id, params::Dict{String,<:Any})

Updates the specified parameters for a transformer. A transformer describes how to process
the incoming EDI documents and extract the necessary information to the output file.

# Arguments
- `transformer_id`: Specifies the system-assigned unique identifier for the transformer.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ediType"`: Specifies the details for the EDI standard that is being used for the
  transformer. Currently, only X12 is supported. X12 is a set of standards and corresponding
  messages that define specific business documents.
- `"fileFormat"`: Specifies that the currently supported file formats for EDI
  transformations are JSON and XML.
- `"mappingTemplate"`: Specifies the mapping template for the transformer. This template is
  used to map the parsed EDI file using JSONata or XSLT.
- `"name"`: Specify a new name for the transformer, if you want to update it.
- `"sampleDocument"`: Specifies a sample EDI document that is used by a transformer as a
  guide for processing the EDI data.
- `"status"`: Specifies the transformer's status. You can update the state of the
  transformer, from active to inactive, or inactive to active.
"""
function update_transformer(
    transformerId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return b2bi(
        "UpdateTransformer",
        Dict{String,Any}("transformerId" => transformerId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_transformer(
    transformerId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return b2bi(
        "UpdateTransformer",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("transformerId" => transformerId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
