# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: iotfleethub
using AWS.Compat
using AWS.UUIDs

"""
    create_application(application_name, role_arn)
    create_application(application_name, role_arn, params::Dict{String,<:Any})

Creates a Fleet Hub for IoT Device Management web application. When creating a Fleet Hub
application, you must create an organization instance of IAM Identity Center if you don't
already have one. The Fleet Hub application you create must also be in the same Amazon Web
Services Region of the organization instance of IAM Identity Center. For more information
see Enabling IAM Identity Center and Organization instances of IAM Identity Center.

# Arguments
- `application_name`: The name of the web application.
- `role_arn`: The ARN of the role that the web application assumes when it interacts with
  Amazon Web Services IoT Core.  The name of the role must be in the form
  AWSIotFleetHub_random_string .

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"applicationDescription"`: An optional description of the web application.
- `"clientToken"`: A unique case-sensitive identifier that you can provide to ensure the
  idempotency of the request. Don't reuse this client token if a new idempotent request is
  required.
- `"tags"`: A set of key/value pairs that you can use to manage the web application
  resource.
"""
function create_application(
    applicationName, roleArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iotfleethub(
        "POST",
        "/applications",
        Dict{String,Any}(
            "applicationName" => applicationName,
            "roleArn" => roleArn,
            "clientToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_application(
    applicationName,
    roleArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iotfleethub(
        "POST",
        "/applications",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "applicationName" => applicationName,
                    "roleArn" => roleArn,
                    "clientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_application(application_id)
    delete_application(application_id, params::Dict{String,<:Any})

Deletes a Fleet Hub for IoT Device Management web application.

# Arguments
- `application_id`: The unique Id of the web application.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientToken"`: A unique case-sensitive identifier that you can provide to ensure the
  idempotency of the request. Don't reuse this client token if a new idempotent request is
  required.
"""
function delete_application(
    applicationId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iotfleethub(
        "DELETE",
        "/applications/$(applicationId)",
        Dict{String,Any}("clientToken" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_application(
    applicationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iotfleethub(
        "DELETE",
        "/applications/$(applicationId)",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("clientToken" => string(uuid4())), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_application(application_id)
    describe_application(application_id, params::Dict{String,<:Any})

Gets information about a Fleet Hub for IoT Device Management web application.

# Arguments
- `application_id`: The unique Id of the web application.

"""
function describe_application(
    applicationId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iotfleethub(
        "GET",
        "/applications/$(applicationId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_application(
    applicationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iotfleethub(
        "GET",
        "/applications/$(applicationId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_applications()
    list_applications(params::Dict{String,<:Any})

Gets a list of Fleet Hub for IoT Device Management web applications for the current account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"nextToken"`: A token used to get the next set of results.
"""
function list_applications(; aws_config::AbstractAWSConfig=current_aws_config())
    return iotfleethub(
        "GET", "/applications"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_applications(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iotfleethub(
        "GET",
        "/applications",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_tags_for_resource(resource_arn)
    list_tags_for_resource(resource_arn, params::Dict{String,<:Any})

Lists the tags for the specified resource.

# Arguments
- `resource_arn`: The ARN of the resource.

"""
function list_tags_for_resource(
    resourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iotfleethub(
        "GET",
        "/tags/$(resourceArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tags_for_resource(
    resourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iotfleethub(
        "GET",
        "/tags/$(resourceArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_resource(resource_arn, tags)
    tag_resource(resource_arn, tags, params::Dict{String,<:Any})

Adds to or modifies the tags of the specified resource. Tags are metadata which can be used
to manage a resource.

# Arguments
- `resource_arn`: The ARN of the resource.
- `tags`: The new or modified tags for the resource.

"""
function tag_resource(resourceArn, tags; aws_config::AbstractAWSConfig=current_aws_config())
    return iotfleethub(
        "POST",
        "/tags/$(resourceArn)",
        Dict{String,Any}("tags" => tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_resource(
    resourceArn,
    tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iotfleethub(
        "POST",
        "/tags/$(resourceArn)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("tags" => tags), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_resource(resource_arn, tag_keys)
    untag_resource(resource_arn, tag_keys, params::Dict{String,<:Any})

Removes the specified tags (metadata) from the resource.

# Arguments
- `resource_arn`: The ARN of the resource.
- `tag_keys`: A list of the keys of the tags to be removed from the resource.

"""
function untag_resource(
    resourceArn, tagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iotfleethub(
        "DELETE",
        "/tags/$(resourceArn)",
        Dict{String,Any}("tagKeys" => tagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_resource(
    resourceArn,
    tagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iotfleethub(
        "DELETE",
        "/tags/$(resourceArn)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("tagKeys" => tagKeys), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_application(application_id)
    update_application(application_id, params::Dict{String,<:Any})

Updates information about a Fleet Hub for IoT Device Management web application.

# Arguments
- `application_id`: The unique Id of the web application.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"applicationDescription"`: An optional description of the web application.
- `"applicationName"`: The name of the web application.
- `"clientToken"`: A unique case-sensitive identifier that you can provide to ensure the
  idempotency of the request. Don't reuse this client token if a new idempotent request is
  required.
"""
function update_application(
    applicationId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iotfleethub(
        "PATCH",
        "/applications/$(applicationId)",
        Dict{String,Any}("clientToken" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_application(
    applicationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iotfleethub(
        "PATCH",
        "/applications/$(applicationId)",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("clientToken" => string(uuid4())), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
