# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: keyspaces
using AWS.Compat
using AWS.UUIDs

"""
    create_keyspace(keyspace_name)
    create_keyspace(keyspace_name, params::Dict{String,<:Any})

The CreateKeyspace operation adds a new keyspace to your account. In an Amazon Web Services
account, keyspace names must be unique within each Region.  CreateKeyspace is an
asynchronous operation. You can monitor the creation status of the new keyspace by using
the GetKeyspace operation. For more information, see Creating keyspaces in the Amazon
Keyspaces Developer Guide.

# Arguments
- `keyspace_name`: The name of the keyspace to be created.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"replicationSpecification"`:  The replication specification of the keyspace includes:
  replicationStrategy - the required value is SINGLE_REGION or MULTI_REGION.    regionList -
  if the replicationStrategy is MULTI_REGION, the regionList requires the current Region and
  at least one additional Amazon Web Services Region where the keyspace is going to be
  replicated in. The maximum number of supported replication Regions including the current
  Region is six.
- `"tags"`: A list of key-value pair tags to be attached to the keyspace. For more
  information, see Adding tags and labels to Amazon Keyspaces resources in the Amazon
  Keyspaces Developer Guide.
"""
function create_keyspace(keyspaceName; aws_config::AbstractAWSConfig=current_aws_config())
    return keyspaces(
        "CreateKeyspace",
        Dict{String,Any}("keyspaceName" => keyspaceName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_keyspace(
    keyspaceName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return keyspaces(
        "CreateKeyspace",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("keyspaceName" => keyspaceName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_table(keyspace_name, schema_definition, table_name)
    create_table(keyspace_name, schema_definition, table_name, params::Dict{String,<:Any})

The CreateTable operation adds a new table to the specified keyspace. Within a keyspace,
table names must be unique.  CreateTable is an asynchronous operation. When the request is
received, the status of the table is set to CREATING. You can monitor the creation status
of the new table by using the GetTable operation, which returns the current status of the
table. You can start using a table when the status is ACTIVE. For more information, see
Creating tables in the Amazon Keyspaces Developer Guide.

# Arguments
- `keyspace_name`: The name of the keyspace that the table is going to be created in.
- `schema_definition`: The schemaDefinition consists of the following parameters. For each
  column to be created:    name - The name of the column.    type - An Amazon Keyspaces data
  type. For more information, see Data types in the Amazon Keyspaces Developer Guide.   The
  primary key of the table consists of the following columns:    partitionKeys - The
  partition key can be a single column, or it can be a compound value composed of two or more
  columns. The partition key portion of the primary key is required and determines how Amazon
  Keyspaces stores your data.    name - The name of each partition key column.
  clusteringKeys - The optional clustering column portion of your primary key determines how
  the data is clustered and sorted within each partition.    name - The name of the
  clustering column.     orderBy - Sets the ascendant (ASC) or descendant (DESC) order
  modifier. To define a column as static use staticColumns - Static columns store values that
  are shared by all rows in the same partition:    name - The name of the column.    type -
  An Amazon Keyspaces data type.
- `table_name`: The name of the table.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"autoScalingSpecification"`: The optional auto scaling settings for a table in
  provisioned capacity mode. Specifies if the service can manage throughput capacity
  automatically on your behalf. Auto scaling helps you provision throughput capacity for
  variable workloads efficiently by increasing and decreasing your table's read and write
  capacity automatically in response to application traffic. For more information, see
  Managing throughput capacity automatically with Amazon Keyspaces auto scaling in the Amazon
  Keyspaces Developer Guide. By default, auto scaling is disabled for a table.
- `"capacitySpecification"`: Specifies the read/write throughput capacity mode for the
  table. The options are:    throughputMode:PAY_PER_REQUEST and
  throughputMode:PROVISIONED - Provisioned capacity mode requires readCapacityUnits and
  writeCapacityUnits as input.   The default is throughput_mode:PAY_PER_REQUEST. For more
  information, see Read/write capacity modes in the Amazon Keyspaces Developer Guide.
- `"clientSideTimestamps"`:  Enables client-side timestamps for the table. By default, the
  setting is disabled. You can enable client-side timestamps with the following option:
  status: \"enabled\"    Once client-side timestamps are enabled for a table, this setting
  cannot be disabled.
- `"comment"`: This parameter allows to enter a description of the table.
- `"defaultTimeToLive"`: The default Time to Live setting in seconds for the table. For
  more information, see Setting the default TTL value for a table in the Amazon Keyspaces
  Developer Guide.
- `"encryptionSpecification"`: Specifies how the encryption key for encryption at rest is
  managed for the table. You can choose one of the following KMS key (KMS key):
  type:AWS_OWNED_KMS_KEY - This key is owned by Amazon Keyspaces.
  type:CUSTOMER_MANAGED_KMS_KEY - This key is stored in your account and is created, owned,
  and managed by you. This option requires the kms_key_identifier of the KMS key in Amazon
  Resource Name (ARN) format as input.   The default is type:AWS_OWNED_KMS_KEY. For more
  information, see Encryption at rest in the Amazon Keyspaces Developer Guide.
- `"pointInTimeRecovery"`: Specifies if pointInTimeRecovery is enabled or disabled for the
  table. The options are:    status=ENABLED     status=DISABLED    If it's not specified, the
  default is status=DISABLED. For more information, see Point-in-time recovery in the Amazon
  Keyspaces Developer Guide.
- `"replicaSpecifications"`: The optional Amazon Web Services Region specific settings of a
  multi-Region table. These settings overwrite the general settings of the table for the
  specified Region.  For a multi-Region table in provisioned capacity mode, you can configure
  the table's read capacity differently for each Region's replica. The write capacity,
  however, remains synchronized between all replicas to ensure that there's enough capacity
  to replicate writes across all Regions. To define the read capacity for a table replica in
  a specific Region, you can do so by configuring the following parameters.    region: The
  Region where these settings are applied. (Required)    readCapacityUnits: The provisioned
  read capacity units. (Optional)    readCapacityAutoScaling: The read capacity auto scaling
  settings for the table. (Optional)
- `"tags"`: A list of key-value pair tags to be attached to the resource.  For more
  information, see Adding tags and labels to Amazon Keyspaces resources in the Amazon
  Keyspaces Developer Guide.
- `"ttl"`: Enables Time to Live custom settings for the table. The options are:
  status:enabled     status:disabled    The default is status:disabled. After ttl is enabled,
  you can't disable it for the table. For more information, see Expiring data by using Amazon
  Keyspaces Time to Live (TTL) in the Amazon Keyspaces Developer Guide.
"""
function create_table(
    keyspaceName,
    schemaDefinition,
    tableName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return keyspaces(
        "CreateTable",
        Dict{String,Any}(
            "keyspaceName" => keyspaceName,
            "schemaDefinition" => schemaDefinition,
            "tableName" => tableName,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_table(
    keyspaceName,
    schemaDefinition,
    tableName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return keyspaces(
        "CreateTable",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "keyspaceName" => keyspaceName,
                    "schemaDefinition" => schemaDefinition,
                    "tableName" => tableName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_keyspace(keyspace_name)
    delete_keyspace(keyspace_name, params::Dict{String,<:Any})

The DeleteKeyspace operation deletes a keyspace and all of its tables.

# Arguments
- `keyspace_name`: The name of the keyspace to be deleted.

"""
function delete_keyspace(keyspaceName; aws_config::AbstractAWSConfig=current_aws_config())
    return keyspaces(
        "DeleteKeyspace",
        Dict{String,Any}("keyspaceName" => keyspaceName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_keyspace(
    keyspaceName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return keyspaces(
        "DeleteKeyspace",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("keyspaceName" => keyspaceName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_table(keyspace_name, table_name)
    delete_table(keyspace_name, table_name, params::Dict{String,<:Any})

The DeleteTable operation deletes a table and all of its data. After a DeleteTable request
is received, the specified table is in the DELETING state until Amazon Keyspaces completes
the deletion. If the table is in the ACTIVE state, you can delete it. If a table is either
in the CREATING or UPDATING states, then Amazon Keyspaces returns a ResourceInUseException.
If the specified table does not exist, Amazon Keyspaces returns a
ResourceNotFoundException. If the table is already in the DELETING state, no error is
returned.

# Arguments
- `keyspace_name`: The name of the keyspace of the to be deleted table.
- `table_name`: The name of the table to be deleted.

"""
function delete_table(
    keyspaceName, tableName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return keyspaces(
        "DeleteTable",
        Dict{String,Any}("keyspaceName" => keyspaceName, "tableName" => tableName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_table(
    keyspaceName,
    tableName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return keyspaces(
        "DeleteTable",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("keyspaceName" => keyspaceName, "tableName" => tableName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_keyspace(keyspace_name)
    get_keyspace(keyspace_name, params::Dict{String,<:Any})

Returns the name and the Amazon Resource Name (ARN) of the specified table.

# Arguments
- `keyspace_name`: The name of the keyspace.

"""
function get_keyspace(keyspaceName; aws_config::AbstractAWSConfig=current_aws_config())
    return keyspaces(
        "GetKeyspace",
        Dict{String,Any}("keyspaceName" => keyspaceName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_keyspace(
    keyspaceName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return keyspaces(
        "GetKeyspace",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("keyspaceName" => keyspaceName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_table(keyspace_name, table_name)
    get_table(keyspace_name, table_name, params::Dict{String,<:Any})

Returns information about the table, including the table's name and current status, the
keyspace name, configuration settings, and metadata. To read table metadata using GetTable,
Select action permissions for the table and system tables are required to complete the
operation.

# Arguments
- `keyspace_name`: The name of the keyspace that the table is stored in.
- `table_name`: The name of the table.

"""
function get_table(
    keyspaceName, tableName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return keyspaces(
        "GetTable",
        Dict{String,Any}("keyspaceName" => keyspaceName, "tableName" => tableName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_table(
    keyspaceName,
    tableName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return keyspaces(
        "GetTable",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("keyspaceName" => keyspaceName, "tableName" => tableName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_table_auto_scaling_settings(keyspace_name, table_name)
    get_table_auto_scaling_settings(keyspace_name, table_name, params::Dict{String,<:Any})

Returns auto scaling related settings of the specified table in JSON format. If the table
is a multi-Region table, the Amazon Web Services Region specific auto scaling settings of
the table are included. Amazon Keyspaces auto scaling helps you provision throughput
capacity for variable workloads efficiently by increasing and decreasing your table's read
and write capacity automatically in response to application traffic. For more information,
see Managing throughput capacity automatically with Amazon Keyspaces auto scaling in the
Amazon Keyspaces Developer Guide.   GetTableAutoScalingSettings can't be used as an action
in an IAM policy.  To define permissions for GetTableAutoScalingSettings, you must allow
the following two actions in the IAM policy statement's Action element:
application-autoscaling:DescribeScalableTargets
application-autoscaling:DescribeScalingPolicies

# Arguments
- `keyspace_name`: The name of the keyspace.
- `table_name`: The name of the table.

"""
function get_table_auto_scaling_settings(
    keyspaceName, tableName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return keyspaces(
        "GetTableAutoScalingSettings",
        Dict{String,Any}("keyspaceName" => keyspaceName, "tableName" => tableName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_table_auto_scaling_settings(
    keyspaceName,
    tableName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return keyspaces(
        "GetTableAutoScalingSettings",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("keyspaceName" => keyspaceName, "tableName" => tableName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_keyspaces()
    list_keyspaces(params::Dict{String,<:Any})

Returns a list of keyspaces.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The total number of keyspaces to return in the output. If the total
  number of keyspaces available is more than the value specified, a NextToken is provided in
  the output. To resume pagination, provide the NextToken value as an argument of a
  subsequent API invocation.
- `"nextToken"`: The pagination token. To resume pagination, provide the NextToken value as
  argument of a subsequent API invocation.
"""
function list_keyspaces(; aws_config::AbstractAWSConfig=current_aws_config())
    return keyspaces(
        "ListKeyspaces"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_keyspaces(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return keyspaces(
        "ListKeyspaces", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_tables(keyspace_name)
    list_tables(keyspace_name, params::Dict{String,<:Any})

Returns a list of tables for a specified keyspace.

# Arguments
- `keyspace_name`: The name of the keyspace.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The total number of tables to return in the output. If the total number
  of tables available is more than the value specified, a NextToken is provided in the
  output. To resume pagination, provide the NextToken value as an argument of a subsequent
  API invocation.
- `"nextToken"`: The pagination token. To resume pagination, provide the NextToken value as
  an argument of a subsequent API invocation.
"""
function list_tables(keyspaceName; aws_config::AbstractAWSConfig=current_aws_config())
    return keyspaces(
        "ListTables",
        Dict{String,Any}("keyspaceName" => keyspaceName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tables(
    keyspaceName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return keyspaces(
        "ListTables",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("keyspaceName" => keyspaceName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_tags_for_resource(resource_arn)
    list_tags_for_resource(resource_arn, params::Dict{String,<:Any})

Returns a list of all tags associated with the specified Amazon Keyspaces resource.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the Amazon Keyspaces resource.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The total number of tags to return in the output. If the total number of
  tags available is more than the value specified, a NextToken is provided in the output. To
  resume pagination, provide the NextToken value as an argument of a subsequent API
  invocation.
- `"nextToken"`: The pagination token. To resume pagination, provide the NextToken value as
  argument of a subsequent API invocation.
"""
function list_tags_for_resource(
    resourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return keyspaces(
        "ListTagsForResource",
        Dict{String,Any}("resourceArn" => resourceArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tags_for_resource(
    resourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return keyspaces(
        "ListTagsForResource",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("resourceArn" => resourceArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    restore_table(source_keyspace_name, source_table_name, target_keyspace_name, target_table_name)
    restore_table(source_keyspace_name, source_table_name, target_keyspace_name, target_table_name, params::Dict{String,<:Any})

Restores the table to the specified point in time within the earliest_restorable_timestamp
and the current time. For more information about restore points, see  Time window for PITR
continuous backups in the Amazon Keyspaces Developer Guide. Any number of users can execute
up to 4 concurrent restores (any type of restore) in a given account. When you restore
using point in time recovery, Amazon Keyspaces restores your source table's schema and data
to the state based on the selected timestamp (day:hour:minute:second) to a new table. The
Time to Live (TTL) settings are also restored to the state based on the selected timestamp.
In addition to the table's schema, data, and TTL settings, RestoreTable restores the
capacity mode, auto scaling settings, encryption settings, and point-in-time recovery
settings from the source table. Unlike the table's schema data and TTL settings, which are
restored based on the selected timestamp, these settings are always restored based on the
table's settings as of the current time or when the table was deleted. You can also
overwrite these settings during restore:   Read/write capacity mode   Provisioned
throughput capacity units   Auto scaling settings   Point-in-time (PITR) settings   Tags
For more information, see PITR restore settings in the Amazon Keyspaces Developer Guide.
Note that the following settings are not restored, and you must configure them manually for
the new table:   Identity and Access Management (IAM) policies   Amazon CloudWatch metrics
and alarms

# Arguments
- `source_keyspace_name`: The keyspace name of the source table.
- `source_table_name`: The name of the source table.
- `target_keyspace_name`: The name of the target keyspace.
- `target_table_name`: The name of the target table.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"autoScalingSpecification"`: The optional auto scaling settings for the restored table
  in provisioned capacity mode. Specifies if the service can manage throughput capacity of a
  provisioned table automatically on your behalf. Amazon Keyspaces auto scaling helps you
  provision throughput capacity for variable workloads efficiently by increasing and
  decreasing your table's read and write capacity automatically in response to application
  traffic. For more information, see Managing throughput capacity automatically with Amazon
  Keyspaces auto scaling in the Amazon Keyspaces Developer Guide.
- `"capacitySpecificationOverride"`: Specifies the read/write throughput capacity mode for
  the target table. The options are:    throughputMode:PAY_PER_REQUEST
  throughputMode:PROVISIONED - Provisioned capacity mode requires readCapacityUnits and
  writeCapacityUnits as input.   The default is throughput_mode:PAY_PER_REQUEST. For more
  information, see Read/write capacity modes in the Amazon Keyspaces Developer Guide.
- `"encryptionSpecificationOverride"`: Specifies the encryption settings for the target
  table. You can choose one of the following KMS key (KMS key):    type:AWS_OWNED_KMS_KEY -
  This key is owned by Amazon Keyspaces.     type:CUSTOMER_MANAGED_KMS_KEY - This key is
  stored in your account and is created, owned, and managed by you. This option requires the
  kms_key_identifier of the KMS key in Amazon Resource Name (ARN) format as input.    The
  default is type:AWS_OWNED_KMS_KEY. For more information, see Encryption at rest in the
  Amazon Keyspaces Developer Guide.
- `"pointInTimeRecoveryOverride"`: Specifies the pointInTimeRecovery settings for the
  target table. The options are:    status=ENABLED     status=DISABLED    If it's not
  specified, the default is status=DISABLED. For more information, see Point-in-time recovery
  in the Amazon Keyspaces Developer Guide.
- `"replicaSpecifications"`: The optional Region specific settings of a multi-Regional
  table.
- `"restoreTimestamp"`: The restore timestamp in ISO 8601 format.
- `"tagsOverride"`: A list of key-value pair tags to be attached to the restored table.
  For more information, see Adding tags and labels to Amazon Keyspaces resources in the
  Amazon Keyspaces Developer Guide.
"""
function restore_table(
    sourceKeyspaceName,
    sourceTableName,
    targetKeyspaceName,
    targetTableName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return keyspaces(
        "RestoreTable",
        Dict{String,Any}(
            "sourceKeyspaceName" => sourceKeyspaceName,
            "sourceTableName" => sourceTableName,
            "targetKeyspaceName" => targetKeyspaceName,
            "targetTableName" => targetTableName,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function restore_table(
    sourceKeyspaceName,
    sourceTableName,
    targetKeyspaceName,
    targetTableName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return keyspaces(
        "RestoreTable",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "sourceKeyspaceName" => sourceKeyspaceName,
                    "sourceTableName" => sourceTableName,
                    "targetKeyspaceName" => targetKeyspaceName,
                    "targetTableName" => targetTableName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_resource(resource_arn, tags)
    tag_resource(resource_arn, tags, params::Dict{String,<:Any})

Associates a set of tags with a Amazon Keyspaces resource. You can then activate these
user-defined tags so that they appear on the Cost Management Console for cost allocation
tracking. For more information, see Adding tags and labels to Amazon Keyspaces resources in
the Amazon Keyspaces Developer Guide. For IAM policy examples that show how to control
access to Amazon Keyspaces resources based on tags, see Amazon Keyspaces resource access
based on tags in the Amazon Keyspaces Developer Guide.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the Amazon Keyspaces resource to which
  to add tags.
- `tags`: The tags to be assigned to the Amazon Keyspaces resource.

"""
function tag_resource(resourceArn, tags; aws_config::AbstractAWSConfig=current_aws_config())
    return keyspaces(
        "TagResource",
        Dict{String,Any}("resourceArn" => resourceArn, "tags" => tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_resource(
    resourceArn,
    tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return keyspaces(
        "TagResource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("resourceArn" => resourceArn, "tags" => tags),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_resource(resource_arn, tags)
    untag_resource(resource_arn, tags, params::Dict{String,<:Any})

Removes the association of tags from a Amazon Keyspaces resource.

# Arguments
- `resource_arn`: The Amazon Keyspaces resource that the tags will be removed from. This
  value is an Amazon Resource Name (ARN).
- `tags`: A list of existing tags to be removed from the Amazon Keyspaces resource.

"""
function untag_resource(
    resourceArn, tags; aws_config::AbstractAWSConfig=current_aws_config()
)
    return keyspaces(
        "UntagResource",
        Dict{String,Any}("resourceArn" => resourceArn, "tags" => tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_resource(
    resourceArn,
    tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return keyspaces(
        "UntagResource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("resourceArn" => resourceArn, "tags" => tags),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_table(keyspace_name, table_name)
    update_table(keyspace_name, table_name, params::Dict{String,<:Any})

Adds new columns to the table or updates one of the table's settings, for example capacity
mode, auto scaling, encryption, point-in-time recovery, or ttl settings. Note that you can
only update one specific table setting per update operation.

# Arguments
- `keyspace_name`: The name of the keyspace the specified table is stored in.
- `table_name`: The name of the table.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"addColumns"`: For each column to be added to the specified table:    name - The name of
  the column.    type - An Amazon Keyspaces data type. For more information, see Data types
  in the Amazon Keyspaces Developer Guide.
- `"autoScalingSpecification"`: The optional auto scaling settings to update for a table in
  provisioned capacity mode. Specifies if the service can manage throughput capacity of a
  provisioned table automatically on your behalf. Amazon Keyspaces auto scaling helps you
  provision throughput capacity for variable workloads efficiently by increasing and
  decreasing your table's read and write capacity automatically in response to application
  traffic. If auto scaling is already enabled for the table, you can use UpdateTable to
  update the minimum and maximum values or the auto scaling policy settings independently.
  For more information, see Managing throughput capacity automatically with Amazon Keyspaces
  auto scaling in the Amazon Keyspaces Developer Guide.
- `"capacitySpecification"`: Modifies the read/write throughput capacity mode for the
  table. The options are:    throughputMode:PAY_PER_REQUEST and
  throughputMode:PROVISIONED - Provisioned capacity mode requires readCapacityUnits and
  writeCapacityUnits as input.   The default is throughput_mode:PAY_PER_REQUEST. For more
  information, see Read/write capacity modes in the Amazon Keyspaces Developer Guide.
- `"clientSideTimestamps"`: Enables client-side timestamps for the table. By default, the
  setting is disabled. You can enable client-side timestamps with the following option:
  status: \"enabled\"    Once client-side timestamps are enabled for a table, this setting
  cannot be disabled.
- `"defaultTimeToLive"`: The default Time to Live setting in seconds for the table. For
  more information, see Setting the default TTL value for a table in the Amazon Keyspaces
  Developer Guide.
- `"encryptionSpecification"`: Modifies the encryption settings of the table. You can
  choose one of the following KMS key (KMS key):    type:AWS_OWNED_KMS_KEY - This key is
  owned by Amazon Keyspaces.     type:CUSTOMER_MANAGED_KMS_KEY - This key is stored in your
  account and is created, owned, and managed by you. This option requires the
  kms_key_identifier of the KMS key in Amazon Resource Name (ARN) format as input.    The
  default is AWS_OWNED_KMS_KEY. For more information, see Encryption at rest in the Amazon
  Keyspaces Developer Guide.
- `"pointInTimeRecovery"`: Modifies the pointInTimeRecovery settings of the table. The
  options are:    status=ENABLED     status=DISABLED    If it's not specified, the default is
  status=DISABLED. For more information, see Point-in-time recovery in the Amazon Keyspaces
  Developer Guide.
- `"replicaSpecifications"`: The Region specific settings of a multi-Regional table.
- `"ttl"`: Modifies Time to Live custom settings for the table. The options are:
  status:enabled     status:disabled    The default is status:disabled. After ttl is enabled,
  you can't disable it for the table. For more information, see Expiring data by using Amazon
  Keyspaces Time to Live (TTL) in the Amazon Keyspaces Developer Guide.
"""
function update_table(
    keyspaceName, tableName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return keyspaces(
        "UpdateTable",
        Dict{String,Any}("keyspaceName" => keyspaceName, "tableName" => tableName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_table(
    keyspaceName,
    tableName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return keyspaces(
        "UpdateTable",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("keyspaceName" => keyspaceName, "tableName" => tableName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
