# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: kinesis_analytics
using AWS.Compat
using AWS.UUIDs

"""
    add_application_cloud_watch_logging_option(application_name, cloud_watch_logging_option, current_application_version_id)
    add_application_cloud_watch_logging_option(application_name, cloud_watch_logging_option, current_application_version_id, params::Dict{String,<:Any})

 This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only
supports SQL applications. Version 2 of the API supports SQL and Java applications. For
more information about version 2, see Amazon Kinesis Data Analytics API V2 Documentation.
Adds a CloudWatch log stream to monitor application configuration errors. For more
information about using CloudWatch log streams with Amazon Kinesis Analytics applications,
see Working with Amazon CloudWatch Logs.

# Arguments
- `application_name`: The Kinesis Analytics application name.
- `cloud_watch_logging_option`: Provides the CloudWatch log stream Amazon Resource Name
  (ARN) and the IAM role ARN. Note: To write application messages to CloudWatch, the IAM role
  that is used must have the PutLogEvents policy action enabled.
- `current_application_version_id`: The version ID of the Kinesis Analytics application.

"""
function add_application_cloud_watch_logging_option(
    ApplicationName,
    CloudWatchLoggingOption,
    CurrentApplicationVersionId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kinesis_analytics(
        "AddApplicationCloudWatchLoggingOption",
        Dict{String,Any}(
            "ApplicationName" => ApplicationName,
            "CloudWatchLoggingOption" => CloudWatchLoggingOption,
            "CurrentApplicationVersionId" => CurrentApplicationVersionId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function add_application_cloud_watch_logging_option(
    ApplicationName,
    CloudWatchLoggingOption,
    CurrentApplicationVersionId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kinesis_analytics(
        "AddApplicationCloudWatchLoggingOption",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ApplicationName" => ApplicationName,
                    "CloudWatchLoggingOption" => CloudWatchLoggingOption,
                    "CurrentApplicationVersionId" => CurrentApplicationVersionId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    add_application_input(application_name, current_application_version_id, input)
    add_application_input(application_name, current_application_version_id, input, params::Dict{String,<:Any})

 This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only
supports SQL applications. Version 2 of the API supports SQL and Java applications. For
more information about version 2, see Amazon Kinesis Data Analytics API V2 Documentation.
Adds a streaming source to your Amazon Kinesis application. For conceptual information, see
Configuring Application Input.  You can add a streaming source either when you create an
application or you can use this operation to add a streaming source after you create an
application. For more information, see CreateApplication. Any configuration update,
including adding a streaming source using this operation, results in a new version of the
application. You can use the DescribeApplication operation to find the current application
version.  This operation requires permissions to perform the
kinesisanalytics:AddApplicationInput action.

# Arguments
- `application_name`: Name of your existing Amazon Kinesis Analytics application to which
  you want to add the streaming source.
- `current_application_version_id`: Current version of your Amazon Kinesis Analytics
  application. You can use the DescribeApplication operation to find the current application
  version.
- `input`: The Input to add.

"""
function add_application_input(
    ApplicationName,
    CurrentApplicationVersionId,
    Input;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kinesis_analytics(
        "AddApplicationInput",
        Dict{String,Any}(
            "ApplicationName" => ApplicationName,
            "CurrentApplicationVersionId" => CurrentApplicationVersionId,
            "Input" => Input,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function add_application_input(
    ApplicationName,
    CurrentApplicationVersionId,
    Input,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kinesis_analytics(
        "AddApplicationInput",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ApplicationName" => ApplicationName,
                    "CurrentApplicationVersionId" => CurrentApplicationVersionId,
                    "Input" => Input,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    add_application_input_processing_configuration(application_name, current_application_version_id, input_id, input_processing_configuration)
    add_application_input_processing_configuration(application_name, current_application_version_id, input_id, input_processing_configuration, params::Dict{String,<:Any})

 This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only
supports SQL applications. Version 2 of the API supports SQL and Java applications. For
more information about version 2, see Amazon Kinesis Data Analytics API V2 Documentation.
Adds an InputProcessingConfiguration to an application. An input processor preprocesses
records on the input stream before the application's SQL code executes. Currently, the only
input processor available is AWS Lambda.

# Arguments
- `application_name`: Name of the application to which you want to add the input processing
  configuration.
- `current_application_version_id`: Version of the application to which you want to add the
  input processing configuration. You can use the DescribeApplication operation to get the
  current application version. If the version specified is not the current version, the
  ConcurrentModificationException is returned.
- `input_id`: The ID of the input configuration to add the input processing configuration
  to. You can get a list of the input IDs for an application using the DescribeApplication
  operation.
- `input_processing_configuration`: The InputProcessingConfiguration to add to the
  application.

"""
function add_application_input_processing_configuration(
    ApplicationName,
    CurrentApplicationVersionId,
    InputId,
    InputProcessingConfiguration;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kinesis_analytics(
        "AddApplicationInputProcessingConfiguration",
        Dict{String,Any}(
            "ApplicationName" => ApplicationName,
            "CurrentApplicationVersionId" => CurrentApplicationVersionId,
            "InputId" => InputId,
            "InputProcessingConfiguration" => InputProcessingConfiguration,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function add_application_input_processing_configuration(
    ApplicationName,
    CurrentApplicationVersionId,
    InputId,
    InputProcessingConfiguration,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kinesis_analytics(
        "AddApplicationInputProcessingConfiguration",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ApplicationName" => ApplicationName,
                    "CurrentApplicationVersionId" => CurrentApplicationVersionId,
                    "InputId" => InputId,
                    "InputProcessingConfiguration" => InputProcessingConfiguration,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    add_application_output(application_name, current_application_version_id, output)
    add_application_output(application_name, current_application_version_id, output, params::Dict{String,<:Any})

 This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only
supports SQL applications. Version 2 of the API supports SQL and Java applications. For
more information about version 2, see Amazon Kinesis Data Analytics API V2 Documentation.
Adds an external destination to your Amazon Kinesis Analytics application. If you want
Amazon Kinesis Analytics to deliver data from an in-application stream within your
application to an external destination (such as an Amazon Kinesis stream, an Amazon Kinesis
Firehose delivery stream, or an AWS Lambda function), you add the relevant configuration to
your application using this operation. You can configure one or more outputs for your
application. Each output configuration maps an in-application stream and an external
destination.  You can use one of the output configurations to deliver data from your
in-application error stream to an external destination so that you can analyze the errors.
For more information, see Understanding Application Output (Destination).   Any
configuration update, including adding a streaming source using this operation, results in
a new version of the application. You can use the DescribeApplication operation to find the
current application version. For the limits on the number of application inputs and outputs
you can configure, see Limits. This operation requires permissions to perform the
kinesisanalytics:AddApplicationOutput action.

# Arguments
- `application_name`: Name of the application to which you want to add the output
  configuration.
- `current_application_version_id`: Version of the application to which you want to add the
  output configuration. You can use the DescribeApplication operation to get the current
  application version. If the version specified is not the current version, the
  ConcurrentModificationException is returned.
- `output`: An array of objects, each describing one output configuration. In the output
  configuration, you specify the name of an in-application stream, a destination (that is, an
  Amazon Kinesis stream, an Amazon Kinesis Firehose delivery stream, or an AWS Lambda
  function), and record the formation to use when writing to the destination.

"""
function add_application_output(
    ApplicationName,
    CurrentApplicationVersionId,
    Output;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kinesis_analytics(
        "AddApplicationOutput",
        Dict{String,Any}(
            "ApplicationName" => ApplicationName,
            "CurrentApplicationVersionId" => CurrentApplicationVersionId,
            "Output" => Output,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function add_application_output(
    ApplicationName,
    CurrentApplicationVersionId,
    Output,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kinesis_analytics(
        "AddApplicationOutput",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ApplicationName" => ApplicationName,
                    "CurrentApplicationVersionId" => CurrentApplicationVersionId,
                    "Output" => Output,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    add_application_reference_data_source(application_name, current_application_version_id, reference_data_source)
    add_application_reference_data_source(application_name, current_application_version_id, reference_data_source, params::Dict{String,<:Any})

 This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only
supports SQL applications. Version 2 of the API supports SQL and Java applications. For
more information about version 2, see Amazon Kinesis Data Analytics API V2 Documentation.
Adds a reference data source to an existing application. Amazon Kinesis Analytics reads
reference data (that is, an Amazon S3 object) and creates an in-application table within
your application. In the request, you provide the source (S3 bucket name and object key
name), name of the in-application table to create, and the necessary mapping information
that describes how data in Amazon S3 object maps to columns in the resulting in-application
table.  For conceptual information, see Configuring Application Input. For the limits on
data sources you can add to your application, see Limits.   This operation requires
permissions to perform the kinesisanalytics:AddApplicationOutput action.

# Arguments
- `application_name`: Name of an existing application.
- `current_application_version_id`: Version of the application for which you are adding the
  reference data source. You can use the DescribeApplication operation to get the current
  application version. If the version specified is not the current version, the
  ConcurrentModificationException is returned.
- `reference_data_source`: The reference data source can be an object in your Amazon S3
  bucket. Amazon Kinesis Analytics reads the object and copies the data into the
  in-application table that is created. You provide an S3 bucket, object key name, and the
  resulting in-application table that is created. You must also provide an IAM role with the
  necessary permissions that Amazon Kinesis Analytics can assume to read the object from your
  S3 bucket on your behalf.

"""
function add_application_reference_data_source(
    ApplicationName,
    CurrentApplicationVersionId,
    ReferenceDataSource;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kinesis_analytics(
        "AddApplicationReferenceDataSource",
        Dict{String,Any}(
            "ApplicationName" => ApplicationName,
            "CurrentApplicationVersionId" => CurrentApplicationVersionId,
            "ReferenceDataSource" => ReferenceDataSource,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function add_application_reference_data_source(
    ApplicationName,
    CurrentApplicationVersionId,
    ReferenceDataSource,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kinesis_analytics(
        "AddApplicationReferenceDataSource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ApplicationName" => ApplicationName,
                    "CurrentApplicationVersionId" => CurrentApplicationVersionId,
                    "ReferenceDataSource" => ReferenceDataSource,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_application(application_name)
    create_application(application_name, params::Dict{String,<:Any})

 This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only
supports SQL applications. Version 2 of the API supports SQL and Java applications. For
more information about version 2, see Amazon Kinesis Data Analytics API V2 Documentation.
Creates an Amazon Kinesis Analytics application. You can configure each application with
one streaming source as input, application code to process the input, and up to three
destinations where you want Amazon Kinesis Analytics to write the output data from your
application. For an overview, see How it Works.  In the input configuration, you map the
streaming source to an in-application stream, which you can think of as a constantly
updating table. In the mapping, you must provide a schema for the in-application stream and
map each data column in the in-application stream to a data element in the streaming
source. Your application code is one or more SQL statements that read input data, transform
it, and generate output. Your application code can create one or more SQL artifacts like
SQL streams or pumps. In the output configuration, you can configure the application to
write data from in-application streams created in your applications to up to three
destinations.  To read data from your source stream or write data to destination streams,
Amazon Kinesis Analytics needs your permissions. You grant these permissions by creating
IAM roles. This operation requires permissions to perform the
kinesisanalytics:CreateApplication action.   For introductory exercises to create an Amazon
Kinesis Analytics application, see Getting Started.

# Arguments
- `application_name`: Name of your Amazon Kinesis Analytics application (for example,
  sample-app).

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ApplicationCode"`: One or more SQL statements that read input data, transform it, and
  generate output. For example, you can write a SQL statement that reads data from one
  in-application stream, generates a running average of the number of advertisement clicks by
  vendor, and insert resulting rows in another in-application stream using pumps. For more
  information about the typical pattern, see Application Code.  You can provide such series
  of SQL statements, where output of one statement can be used as the input for the next
  statement. You store intermediate results by creating in-application streams and pumps.
  Note that the application code must create the streams with names specified in the Outputs.
  For example, if your Outputs defines output streams named ExampleOutputStream1 and
  ExampleOutputStream2, then your application code must create these streams.
- `"ApplicationDescription"`: Summary description of the application.
- `"CloudWatchLoggingOptions"`: Use this parameter to configure a CloudWatch log stream to
  monitor application configuration errors. For more information, see Working with Amazon
  CloudWatch Logs.
- `"Inputs"`: Use this parameter to configure the application input. You can configure your
  application to receive input from a single streaming source. In this configuration, you map
  this streaming source to an in-application stream that is created. Your application code
  can then query the in-application stream like a table (you can think of it as a constantly
  updating table). For the streaming source, you provide its Amazon Resource Name (ARN) and
  format of data on the stream (for example, JSON, CSV, etc.). You also must provide an IAM
  role that Amazon Kinesis Analytics can assume to read this stream on your behalf. To create
  the in-application stream, you need to specify a schema to transform your data into a
  schematized version used in SQL. In the schema, you provide the necessary mapping of the
  data elements in the streaming source to record columns in the in-app stream.
- `"Outputs"`: You can configure application output to write data from any of the
  in-application streams to up to three destinations. These destinations can be Amazon
  Kinesis streams, Amazon Kinesis Firehose delivery streams, AWS Lambda destinations, or any
  combination of the three. In the configuration, you specify the in-application stream name,
  the destination stream or Lambda function Amazon Resource Name (ARN), and the format to use
  when writing data. You must also provide an IAM role that Amazon Kinesis Analytics can
  assume to write to the destination stream or Lambda function on your behalf. In the output
  configuration, you also provide the output stream or Lambda function ARN. For stream
  destinations, you provide the format of data in the stream (for example, JSON, CSV). You
  also must provide an IAM role that Amazon Kinesis Analytics can assume to write to the
  stream or Lambda function on your behalf.
- `"Tags"`: A list of one or more tags to assign to the application. A tag is a key-value
  pair that identifies an application. Note that the maximum number of application tags
  includes system tags. The maximum number of user-defined application tags is 50. For more
  information, see Using Tagging.
"""
function create_application(
    ApplicationName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kinesis_analytics(
        "CreateApplication",
        Dict{String,Any}("ApplicationName" => ApplicationName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_application(
    ApplicationName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kinesis_analytics(
        "CreateApplication",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("ApplicationName" => ApplicationName), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_application(application_name, create_timestamp)
    delete_application(application_name, create_timestamp, params::Dict{String,<:Any})

 This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only
supports SQL applications. Version 2 of the API supports SQL and Java applications. For
more information about version 2, see Amazon Kinesis Data Analytics API V2 Documentation.
Deletes the specified application. Amazon Kinesis Analytics halts application execution and
deletes the application, including any application artifacts (such as in-application
streams, reference table, and application code). This operation requires permissions to
perform the kinesisanalytics:DeleteApplication action.

# Arguments
- `application_name`: Name of the Amazon Kinesis Analytics application to delete.
- `create_timestamp`:  You can use the DescribeApplication operation to get this value.

"""
function delete_application(
    ApplicationName, CreateTimestamp; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kinesis_analytics(
        "DeleteApplication",
        Dict{String,Any}(
            "ApplicationName" => ApplicationName, "CreateTimestamp" => CreateTimestamp
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_application(
    ApplicationName,
    CreateTimestamp,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kinesis_analytics(
        "DeleteApplication",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ApplicationName" => ApplicationName,
                    "CreateTimestamp" => CreateTimestamp,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_application_cloud_watch_logging_option(application_name, cloud_watch_logging_option_id, current_application_version_id)
    delete_application_cloud_watch_logging_option(application_name, cloud_watch_logging_option_id, current_application_version_id, params::Dict{String,<:Any})

 This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only
supports SQL applications. Version 2 of the API supports SQL and Java applications. For
more information about version 2, see Amazon Kinesis Data Analytics API V2 Documentation.
Deletes a CloudWatch log stream from an application. For more information about using
CloudWatch log streams with Amazon Kinesis Analytics applications, see Working with Amazon
CloudWatch Logs.

# Arguments
- `application_name`: The Kinesis Analytics application name.
- `cloud_watch_logging_option_id`: The CloudWatchLoggingOptionId of the CloudWatch logging
  option to delete. You can get the CloudWatchLoggingOptionId by using the
  DescribeApplication operation.
- `current_application_version_id`: The version ID of the Kinesis Analytics application.

"""
function delete_application_cloud_watch_logging_option(
    ApplicationName,
    CloudWatchLoggingOptionId,
    CurrentApplicationVersionId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kinesis_analytics(
        "DeleteApplicationCloudWatchLoggingOption",
        Dict{String,Any}(
            "ApplicationName" => ApplicationName,
            "CloudWatchLoggingOptionId" => CloudWatchLoggingOptionId,
            "CurrentApplicationVersionId" => CurrentApplicationVersionId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_application_cloud_watch_logging_option(
    ApplicationName,
    CloudWatchLoggingOptionId,
    CurrentApplicationVersionId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kinesis_analytics(
        "DeleteApplicationCloudWatchLoggingOption",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ApplicationName" => ApplicationName,
                    "CloudWatchLoggingOptionId" => CloudWatchLoggingOptionId,
                    "CurrentApplicationVersionId" => CurrentApplicationVersionId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_application_input_processing_configuration(application_name, current_application_version_id, input_id)
    delete_application_input_processing_configuration(application_name, current_application_version_id, input_id, params::Dict{String,<:Any})

 This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only
supports SQL applications. Version 2 of the API supports SQL and Java applications. For
more information about version 2, see Amazon Kinesis Data Analytics API V2 Documentation.
Deletes an InputProcessingConfiguration from an input.

# Arguments
- `application_name`: The Kinesis Analytics application name.
- `current_application_version_id`: The version ID of the Kinesis Analytics application.
- `input_id`: The ID of the input configuration from which to delete the input processing
  configuration. You can get a list of the input IDs for an application by using the
  DescribeApplication operation.

"""
function delete_application_input_processing_configuration(
    ApplicationName,
    CurrentApplicationVersionId,
    InputId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kinesis_analytics(
        "DeleteApplicationInputProcessingConfiguration",
        Dict{String,Any}(
            "ApplicationName" => ApplicationName,
            "CurrentApplicationVersionId" => CurrentApplicationVersionId,
            "InputId" => InputId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_application_input_processing_configuration(
    ApplicationName,
    CurrentApplicationVersionId,
    InputId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kinesis_analytics(
        "DeleteApplicationInputProcessingConfiguration",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ApplicationName" => ApplicationName,
                    "CurrentApplicationVersionId" => CurrentApplicationVersionId,
                    "InputId" => InputId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_application_output(application_name, current_application_version_id, output_id)
    delete_application_output(application_name, current_application_version_id, output_id, params::Dict{String,<:Any})

 This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only
supports SQL applications. Version 2 of the API supports SQL and Java applications. For
more information about version 2, see Amazon Kinesis Data Analytics API V2 Documentation.
Deletes output destination configuration from your application configuration. Amazon
Kinesis Analytics will no longer write data from the corresponding in-application stream to
the external output destination. This operation requires permissions to perform the
kinesisanalytics:DeleteApplicationOutput action.

# Arguments
- `application_name`: Amazon Kinesis Analytics application name.
- `current_application_version_id`: Amazon Kinesis Analytics application version. You can
  use the DescribeApplication operation to get the current application version. If the
  version specified is not the current version, the ConcurrentModificationException is
  returned.
- `output_id`: The ID of the configuration to delete. Each output configuration that is
  added to the application, either when the application is created or later using the
  AddApplicationOutput operation, has a unique ID. You need to provide the ID to uniquely
  identify the output configuration that you want to delete from the application
  configuration. You can use the DescribeApplication operation to get the specific OutputId.

"""
function delete_application_output(
    ApplicationName,
    CurrentApplicationVersionId,
    OutputId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kinesis_analytics(
        "DeleteApplicationOutput",
        Dict{String,Any}(
            "ApplicationName" => ApplicationName,
            "CurrentApplicationVersionId" => CurrentApplicationVersionId,
            "OutputId" => OutputId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_application_output(
    ApplicationName,
    CurrentApplicationVersionId,
    OutputId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kinesis_analytics(
        "DeleteApplicationOutput",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ApplicationName" => ApplicationName,
                    "CurrentApplicationVersionId" => CurrentApplicationVersionId,
                    "OutputId" => OutputId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_application_reference_data_source(application_name, current_application_version_id, reference_id)
    delete_application_reference_data_source(application_name, current_application_version_id, reference_id, params::Dict{String,<:Any})

 This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only
supports SQL applications. Version 2 of the API supports SQL and Java applications. For
more information about version 2, see Amazon Kinesis Data Analytics API V2 Documentation.
Deletes a reference data source configuration from the specified application configuration.
If the application is running, Amazon Kinesis Analytics immediately removes the
in-application table that you created using the AddApplicationReferenceDataSource
operation.  This operation requires permissions to perform the
kinesisanalytics.DeleteApplicationReferenceDataSource action.

# Arguments
- `application_name`: Name of an existing application.
- `current_application_version_id`: Version of the application. You can use the
  DescribeApplication operation to get the current application version. If the version
  specified is not the current version, the ConcurrentModificationException is returned.
- `reference_id`: ID of the reference data source. When you add a reference data source to
  your application using the AddApplicationReferenceDataSource, Amazon Kinesis Analytics
  assigns an ID. You can use the DescribeApplication operation to get the reference ID.

"""
function delete_application_reference_data_source(
    ApplicationName,
    CurrentApplicationVersionId,
    ReferenceId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kinesis_analytics(
        "DeleteApplicationReferenceDataSource",
        Dict{String,Any}(
            "ApplicationName" => ApplicationName,
            "CurrentApplicationVersionId" => CurrentApplicationVersionId,
            "ReferenceId" => ReferenceId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_application_reference_data_source(
    ApplicationName,
    CurrentApplicationVersionId,
    ReferenceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kinesis_analytics(
        "DeleteApplicationReferenceDataSource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ApplicationName" => ApplicationName,
                    "CurrentApplicationVersionId" => CurrentApplicationVersionId,
                    "ReferenceId" => ReferenceId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_application(application_name)
    describe_application(application_name, params::Dict{String,<:Any})

 This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only
supports SQL applications. Version 2 of the API supports SQL and Java applications. For
more information about version 2, see Amazon Kinesis Data Analytics API V2 Documentation.
Returns information about a specific Amazon Kinesis Analytics application. If you want to
retrieve a list of all applications in your account, use the ListApplications operation.
This operation requires permissions to perform the kinesisanalytics:DescribeApplication
action. You can use DescribeApplication to get the current application versionId, which you
need to call other operations such as Update.

# Arguments
- `application_name`: Name of the application.

"""
function describe_application(
    ApplicationName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kinesis_analytics(
        "DescribeApplication",
        Dict{String,Any}("ApplicationName" => ApplicationName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_application(
    ApplicationName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kinesis_analytics(
        "DescribeApplication",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("ApplicationName" => ApplicationName), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    discover_input_schema()
    discover_input_schema(params::Dict{String,<:Any})

 This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only
supports SQL applications. Version 2 of the API supports SQL and Java applications. For
more information about version 2, see Amazon Kinesis Data Analytics API V2 Documentation.
Infers a schema by evaluating sample records on the specified streaming source (Amazon
Kinesis stream or Amazon Kinesis Firehose delivery stream) or S3 object. In the response,
the operation returns the inferred schema and also the sample records that the operation
used to infer the schema.  You can use the inferred schema when configuring a streaming
source for your application. For conceptual information, see Configuring Application Input.
Note that when you create an application using the Amazon Kinesis Analytics console, the
console uses this operation to infer a schema and show it in the console user interface.
This operation requires permissions to perform the kinesisanalytics:DiscoverInputSchema
action.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"InputProcessingConfiguration"`: The InputProcessingConfiguration to use to preprocess
  the records before discovering the schema of the records.
- `"InputStartingPositionConfiguration"`: Point at which you want Amazon Kinesis Analytics
  to start reading records from the specified streaming source discovery purposes.
- `"ResourceARN"`: Amazon Resource Name (ARN) of the streaming source.
- `"RoleARN"`: ARN of the IAM role that Amazon Kinesis Analytics can assume to access the
  stream on your behalf.
- `"S3Configuration"`: Specify this parameter to discover a schema from data in an Amazon
  S3 object.
"""
function discover_input_schema(; aws_config::AbstractAWSConfig=current_aws_config())
    return kinesis_analytics(
        "DiscoverInputSchema"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function discover_input_schema(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kinesis_analytics(
        "DiscoverInputSchema",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_applications()
    list_applications(params::Dict{String,<:Any})

 This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only
supports SQL applications. Version 2 of the API supports SQL and Java applications. For
more information about version 2, see Amazon Kinesis Data Analytics API V2 Documentation.
Returns a list of Amazon Kinesis Analytics applications in your account. For each
application, the response includes the application name, Amazon Resource Name (ARN), and
status. If the response returns the HasMoreApplications value as true, you can send another
request by adding the ExclusiveStartApplicationName in the request body, and set the value
of this to the last application name from the previous response.  If you want detailed
information about a specific application, use DescribeApplication. This operation requires
permissions to perform the kinesisanalytics:ListApplications action.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ExclusiveStartApplicationName"`: Name of the application to start the list with. When
  using pagination to retrieve the list, you don't need to specify this parameter in the
  first request. However, in subsequent requests, you add the last application name from the
  previous response to get the next page of applications.
- `"Limit"`: Maximum number of applications to list.
"""
function list_applications(; aws_config::AbstractAWSConfig=current_aws_config())
    return kinesis_analytics(
        "ListApplications"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_applications(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kinesis_analytics(
        "ListApplications", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_tags_for_resource(resource_arn)
    list_tags_for_resource(resource_arn, params::Dict{String,<:Any})

Retrieves the list of key-value tags assigned to the application. For more information, see
Using Tagging.

# Arguments
- `resource_arn`: The ARN of the application for which to retrieve tags.

"""
function list_tags_for_resource(
    ResourceARN; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kinesis_analytics(
        "ListTagsForResource",
        Dict{String,Any}("ResourceARN" => ResourceARN);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tags_for_resource(
    ResourceARN,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kinesis_analytics(
        "ListTagsForResource",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ResourceARN" => ResourceARN), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_application(application_name, input_configurations)
    start_application(application_name, input_configurations, params::Dict{String,<:Any})

 This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only
supports SQL applications. Version 2 of the API supports SQL and Java applications. For
more information about version 2, see Amazon Kinesis Data Analytics API V2 Documentation.
Starts the specified Amazon Kinesis Analytics application. After creating an application,
you must exclusively call this operation to start your application. After the application
starts, it begins consuming the input data, processes it, and writes the output to the
configured destination.  The application status must be READY for you to start an
application. You can get the application status in the console or using the
DescribeApplication operation. After you start the application, you can stop the
application from processing the input by calling the StopApplication operation. This
operation requires permissions to perform the kinesisanalytics:StartApplication action.

# Arguments
- `application_name`: Name of the application.
- `input_configurations`: Identifies the specific input, by ID, that the application starts
  consuming. Amazon Kinesis Analytics starts reading the streaming source associated with the
  input. You can also specify where in the streaming source you want Amazon Kinesis Analytics
  to start reading.

"""
function start_application(
    ApplicationName, InputConfigurations; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kinesis_analytics(
        "StartApplication",
        Dict{String,Any}(
            "ApplicationName" => ApplicationName,
            "InputConfigurations" => InputConfigurations,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_application(
    ApplicationName,
    InputConfigurations,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kinesis_analytics(
        "StartApplication",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ApplicationName" => ApplicationName,
                    "InputConfigurations" => InputConfigurations,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    stop_application(application_name)
    stop_application(application_name, params::Dict{String,<:Any})

 This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only
supports SQL applications. Version 2 of the API supports SQL and Java applications. For
more information about version 2, see Amazon Kinesis Data Analytics API V2 Documentation.
Stops the application from processing input data. You can stop an application only if it is
in the running state. You can use the DescribeApplication operation to find the application
state. After the application is stopped, Amazon Kinesis Analytics stops reading data from
the input, the application stops processing data, and there is no output written to the
destination.  This operation requires permissions to perform the
kinesisanalytics:StopApplication action.

# Arguments
- `application_name`: Name of the running application to stop.

"""
function stop_application(
    ApplicationName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kinesis_analytics(
        "StopApplication",
        Dict{String,Any}("ApplicationName" => ApplicationName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function stop_application(
    ApplicationName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kinesis_analytics(
        "StopApplication",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("ApplicationName" => ApplicationName), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_resource(resource_arn, tags)
    tag_resource(resource_arn, tags, params::Dict{String,<:Any})

Adds one or more key-value tags to a Kinesis Analytics application. Note that the maximum
number of application tags includes system tags. The maximum number of user-defined
application tags is 50. For more information, see Using Tagging.

# Arguments
- `resource_arn`: The ARN of the application to assign the tags.
- `tags`: The key-value tags to assign to the application.

"""
function tag_resource(ResourceARN, Tags; aws_config::AbstractAWSConfig=current_aws_config())
    return kinesis_analytics(
        "TagResource",
        Dict{String,Any}("ResourceARN" => ResourceARN, "Tags" => Tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_resource(
    ResourceARN,
    Tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kinesis_analytics(
        "TagResource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ResourceARN" => ResourceARN, "Tags" => Tags),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_resource(resource_arn, tag_keys)
    untag_resource(resource_arn, tag_keys, params::Dict{String,<:Any})

Removes one or more tags from a Kinesis Analytics application. For more information, see
Using Tagging.

# Arguments
- `resource_arn`: The ARN of the Kinesis Analytics application from which to remove the
  tags.
- `tag_keys`: A list of keys of tags to remove from the specified application.

"""
function untag_resource(
    ResourceARN, TagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kinesis_analytics(
        "UntagResource",
        Dict{String,Any}("ResourceARN" => ResourceARN, "TagKeys" => TagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_resource(
    ResourceARN,
    TagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kinesis_analytics(
        "UntagResource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ResourceARN" => ResourceARN, "TagKeys" => TagKeys),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_application(application_name, application_update, current_application_version_id)
    update_application(application_name, application_update, current_application_version_id, params::Dict{String,<:Any})

 This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only
supports SQL applications. Version 2 of the API supports SQL and Java applications. For
more information about version 2, see Amazon Kinesis Data Analytics API V2 Documentation.
Updates an existing Amazon Kinesis Analytics application. Using this API, you can update
application code, input configuration, and output configuration.  Note that Amazon Kinesis
Analytics updates the CurrentApplicationVersionId each time you update your application.
This operation requires permission for the kinesisanalytics:UpdateApplication action.

# Arguments
- `application_name`: Name of the Amazon Kinesis Analytics application to update.
- `application_update`: Describes application updates.
- `current_application_version_id`: The current application version ID. You can use the
  DescribeApplication operation to get this value.

"""
function update_application(
    ApplicationName,
    ApplicationUpdate,
    CurrentApplicationVersionId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kinesis_analytics(
        "UpdateApplication",
        Dict{String,Any}(
            "ApplicationName" => ApplicationName,
            "ApplicationUpdate" => ApplicationUpdate,
            "CurrentApplicationVersionId" => CurrentApplicationVersionId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_application(
    ApplicationName,
    ApplicationUpdate,
    CurrentApplicationVersionId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kinesis_analytics(
        "UpdateApplication",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ApplicationName" => ApplicationName,
                    "ApplicationUpdate" => ApplicationUpdate,
                    "CurrentApplicationVersionId" => CurrentApplicationVersionId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
