# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: lex_runtime_service
using AWS.Compat
using AWS.UUIDs

"""
    delete_session(bot_alias, bot_name, user_id)
    delete_session(bot_alias, bot_name, user_id, params::Dict{String,<:Any})

Removes session information for a specified bot, alias, and user ID.

# Arguments
- `bot_alias`: The alias in use for the bot that contains the session data.
- `bot_name`: The name of the bot that contains the session data.
- `user_id`: The identifier of the user associated with the session data.

"""
function delete_session(
    botAlias, botName, userId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lex_runtime_service(
        "DELETE",
        "/bot/$(botName)/alias/$(botAlias)/user/$(userId)/session";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_session(
    botAlias,
    botName,
    userId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lex_runtime_service(
        "DELETE",
        "/bot/$(botName)/alias/$(botAlias)/user/$(userId)/session",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_session(bot_alias, bot_name, user_id)
    get_session(bot_alias, bot_name, user_id, params::Dict{String,<:Any})

Returns session information for a specified bot, alias, and user ID.

# Arguments
- `bot_alias`: The alias in use for the bot that contains the session data.
- `bot_name`: The name of the bot that contains the session data.
- `user_id`: The ID of the client application user. Amazon Lex uses this to identify a
  user's conversation with your bot.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"checkpointLabelFilter"`: A string used to filter the intents returned in the
  recentIntentSummaryView structure.  When you specify a filter, only intents with their
  checkpointLabel field set to that string are returned.
"""
function get_session(
    botAlias, botName, userId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lex_runtime_service(
        "GET",
        "/bot/$(botName)/alias/$(botAlias)/user/$(userId)/session/";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_session(
    botAlias,
    botName,
    userId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lex_runtime_service(
        "GET",
        "/bot/$(botName)/alias/$(botAlias)/user/$(userId)/session/",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    post_content(content-_type, bot_alias, bot_name, input_stream, user_id)
    post_content(content-_type, bot_alias, bot_name, input_stream, user_id, params::Dict{String,<:Any})

 Sends user input (text or speech) to Amazon Lex. Clients use this API to send text and
audio requests to Amazon Lex at runtime. Amazon Lex interprets the user input using the
machine learning model that it built for the bot.  The PostContent operation supports audio
input at 8kHz and 16kHz. You can use 8kHz audio to achieve higher speech recognition
accuracy in telephone audio applications.   In response, Amazon Lex returns the next
message to convey to the user. Consider the following example messages:     For a user
input \"I would like a pizza,\" Amazon Lex might return a response with a message eliciting
slot data (for example, PizzaSize): \"What size pizza would you like?\".     After the user
provides all of the pizza order information, Amazon Lex might return a response with a
message to get user confirmation: \"Order the pizza?\".     After the user replies \"Yes\"
to the confirmation prompt, Amazon Lex might return a conclusion statement: \"Thank you,
your cheese pizza has been ordered.\".     Not all Amazon Lex messages require a response
from the user. For example, conclusion statements do not require a response. Some messages
require only a yes or no response. In addition to the message, Amazon Lex provides
additional context about the message in the response that you can use to enhance client
behavior, such as displaying the appropriate client user interface. Consider the following
examples:     If the message is to elicit slot data, Amazon Lex returns the following
context information:     x-amz-lex-dialog-state header set to ElicitSlot
x-amz-lex-intent-name header set to the intent name in the current context
x-amz-lex-slot-to-elicit header set to the slot name for which the message is eliciting
information     x-amz-lex-slots header set to a map of slots configured for the intent with
their current values       If the message is a confirmation prompt, the
x-amz-lex-dialog-state header is set to Confirmation and the x-amz-lex-slot-to-elicit
header is omitted.     If the message is a clarification prompt configured for the intent,
indicating that the user intent is not understood, the x-amz-dialog-state header is set to
ElicitIntent and the x-amz-slot-to-elicit header is omitted.     In addition, Amazon Lex
also returns your application-specific sessionAttributes. For more information, see
Managing Conversation Context.

# Arguments
- `content-_type`:  You pass this value as the Content-Type HTTP header.   Indicates the
  audio format or text. The header value must start with one of the following prefixes:
  PCM format, audio data must be in little-endian byte order.   audio/l16; rate=16000;
  channels=1   audio/x-l16; sample-rate=16000; channel-count=1   audio/lpcm;
  sample-rate=8000; sample-size-bits=16; channel-count=1; is-big-endian=false      Opus
  format   audio/x-cbr-opus-with-preamble; preamble-size=0; bit-rate=256000;
  frame-size-milliseconds=4     Text format   text/plain; charset=utf-8
- `bot_alias`: Alias of the Amazon Lex bot.
- `bot_name`: Name of the Amazon Lex bot.
- `input_stream`:  User input in PCM or Opus audio format or text format as described in
  the Content-Type HTTP header.  You can stream audio data to Amazon Lex or you can create a
  local buffer that captures all of the audio data before sending. In general, you get better
  performance if you stream audio data rather than buffering the data locally.
- `user_id`: The ID of the client application user. Amazon Lex uses this to identify a
  user's conversation with your bot. At runtime, each request must contain the userID field.
  To decide the user ID to use for your application, consider the following factors.   The
  userID field must not contain any personally identifiable information of the user, for
  example, name, personal identification numbers, or other end user personal information.
  If you want a user to start a conversation on one device and continue on another device,
  use a user-specific identifier.   If you want the same user to be able to have two
  independent conversations on two different devices, choose a device-specific identifier.
  A user can't have two independent conversations with two different versions of the same
  bot. For example, a user can't have a conversation with the PROD and BETA versions of the
  same bot. If you anticipate that a user will need to have conversation with two different
  versions, for example, while testing, include the bot alias in the user ID to separate the
  two conversations.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Accept"`:  You pass this value as the Accept HTTP header.   The message Amazon Lex
  returns in the response can be either text or speech based on the Accept HTTP header value
  in the request.     If the value is text/plain; charset=utf-8, Amazon Lex returns text in
  the response.     If the value begins with audio/, Amazon Lex returns speech in the
  response. Amazon Lex uses Amazon Polly to generate the speech (using the configuration you
  specified in the Accept header). For example, if you specify audio/mpeg as the value,
  Amazon Lex returns speech in the MPEG format.   If the value is audio/pcm, the speech
  returned is audio/pcm in 16-bit, little endian format.    The following are the accepted
  values:   audio/mpeg   audio/ogg   audio/pcm   text/plain; charset=utf-8   audio/*
  (defaults to mpeg)
- `"x-amz-lex-active-contexts"`: A list of contexts active for the request. A context can
  be activated when a previous intent is fulfilled, or by including the context in the
  request, If you don't specify a list of contexts, Amazon Lex will use the current list of
  contexts for the session. If you specify an empty list, all contexts for the session are
  cleared.
- `"x-amz-lex-request-attributes"`: You pass this value as the x-amz-lex-request-attributes
  HTTP header. Request-specific information passed between Amazon Lex and a client
  application. The value must be a JSON serialized and base64 encoded map with string keys
  and values. The total size of the requestAttributes and sessionAttributes headers is
  limited to 12 KB. The namespace x-amz-lex: is reserved for special attributes. Don't create
  any request attributes with the prefix x-amz-lex:. For more information, see Setting
  Request Attributes.
- `"x-amz-lex-session-attributes"`: You pass this value as the x-amz-lex-session-attributes
  HTTP header. Application-specific information passed between Amazon Lex and a client
  application. The value must be a JSON serialized and base64 encoded map with string keys
  and values. The total size of the sessionAttributes and requestAttributes headers is
  limited to 12 KB. For more information, see Setting Session Attributes.
"""
function post_content(
    Content_Type,
    botAlias,
    botName,
    inputStream,
    userId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lex_runtime_service(
        "POST",
        "/bot/$(botName)/alias/$(botAlias)/user/$(userId)/content",
        Dict{String,Any}(
            "inputStream" => inputStream,
            "headers" => Dict{String,Any}("Content-Type" => Content_Type),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function post_content(
    Content_Type,
    botAlias,
    botName,
    inputStream,
    userId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lex_runtime_service(
        "POST",
        "/bot/$(botName)/alias/$(botAlias)/user/$(userId)/content",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "inputStream" => inputStream,
                    "headers" => Dict{String,Any}("Content-Type" => Content_Type),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    post_text(bot_alias, bot_name, input_text, user_id)
    post_text(bot_alias, bot_name, input_text, user_id, params::Dict{String,<:Any})

Sends user input to Amazon Lex. Client applications can use this API to send requests to
Amazon Lex at runtime. Amazon Lex then interprets the user input using the machine learning
model it built for the bot.   In response, Amazon Lex returns the next message to convey to
the user an optional responseCard to display. Consider the following example messages:
For a user input \"I would like a pizza\", Amazon Lex might return a response with a
message eliciting slot data (for example, PizzaSize): \"What size pizza would you like?\"
  After the user provides all of the pizza order information, Amazon Lex might return a
response with a message to obtain user confirmation \"Proceed with the pizza order?\".
After the user replies to a confirmation prompt with a \"yes\", Amazon Lex might return a
conclusion statement: \"Thank you, your cheese pizza has been ordered.\".     Not all
Amazon Lex messages require a user response. For example, a conclusion statement does not
require a response. Some messages require only a \"yes\" or \"no\" user response. In
addition to the message, Amazon Lex provides additional context about the message in the
response that you might use to enhance client behavior, for example, to display the
appropriate client user interface. These are the slotToElicit, dialogState, intentName, and
slots fields in the response. Consider the following examples:    If the message is to
elicit slot data, Amazon Lex returns the following context information:    dialogState set
to ElicitSlot     intentName set to the intent name in the current context     slotToElicit
set to the slot name for which the message is eliciting information     slots set to a map
of slots, configured for the intent, with currently known values       If the message is a
confirmation prompt, the dialogState is set to ConfirmIntent and SlotToElicit is set to
null.    If the message is a clarification prompt (configured for the intent) that
indicates that user intent is not understood, the dialogState is set to ElicitIntent and
slotToElicit is set to null.     In addition, Amazon Lex also returns your
application-specific sessionAttributes. For more information, see Managing Conversation
Context.

# Arguments
- `bot_alias`: The alias of the Amazon Lex bot.
- `bot_name`: The name of the Amazon Lex bot.
- `input_text`: The text that the user entered (Amazon Lex interprets this text).
- `user_id`: The ID of the client application user. Amazon Lex uses this to identify a
  user's conversation with your bot. At runtime, each request must contain the userID field.
  To decide the user ID to use for your application, consider the following factors.   The
  userID field must not contain any personally identifiable information of the user, for
  example, name, personal identification numbers, or other end user personal information.
  If you want a user to start a conversation on one device and continue on another device,
  use a user-specific identifier.   If you want the same user to be able to have two
  independent conversations on two different devices, choose a device-specific identifier.
  A user can't have two independent conversations with two different versions of the same
  bot. For example, a user can't have a conversation with the PROD and BETA versions of the
  same bot. If you anticipate that a user will need to have conversation with two different
  versions, for example, while testing, include the bot alias in the user ID to separate the
  two conversations.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"activeContexts"`: A list of contexts active for the request. A context can be activated
  when a previous intent is fulfilled, or by including the context in the request, If you
  don't specify a list of contexts, Amazon Lex will use the current list of contexts for the
  session. If you specify an empty list, all contexts for the session are cleared.
- `"requestAttributes"`: Request-specific information passed between Amazon Lex and a
  client application. The namespace x-amz-lex: is reserved for special attributes. Don't
  create any request attributes with the prefix x-amz-lex:. For more information, see Setting
  Request Attributes.
- `"sessionAttributes"`: Application-specific information passed between Amazon Lex and a
  client application. For more information, see Setting Session Attributes.
"""
function post_text(
    botAlias, botName, inputText, userId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lex_runtime_service(
        "POST",
        "/bot/$(botName)/alias/$(botAlias)/user/$(userId)/text",
        Dict{String,Any}("inputText" => inputText);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function post_text(
    botAlias,
    botName,
    inputText,
    userId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lex_runtime_service(
        "POST",
        "/bot/$(botName)/alias/$(botAlias)/user/$(userId)/text",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("inputText" => inputText), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_session(bot_alias, bot_name, user_id)
    put_session(bot_alias, bot_name, user_id, params::Dict{String,<:Any})

Creates a new session or modifies an existing session with an Amazon Lex bot. Use this
operation to enable your application to set the state of the bot. For more information, see
Managing Sessions.

# Arguments
- `bot_alias`: The alias in use for the bot that contains the session data.
- `bot_name`: The name of the bot that contains the session data.
- `user_id`: The ID of the client application user. Amazon Lex uses this to identify a
  user's conversation with your bot.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Accept"`: The message that Amazon Lex returns in the response can be either text or
  speech based depending on the value of this field.   If the value is text/plain;
  charset=utf-8, Amazon Lex returns text in the response.   If the value begins with audio/,
  Amazon Lex returns speech in the response. Amazon Lex uses Amazon Polly to generate the
  speech in the configuration that you specify. For example, if you specify audio/mpeg as the
  value, Amazon Lex returns speech in the MPEG format.   If the value is audio/pcm, the
  speech is returned as audio/pcm in 16-bit, little endian format.   The following are the
  accepted values:    audio/mpeg     audio/ogg     audio/pcm     audio/* (defaults to mpeg)
   text/plain; charset=utf-8
- `"activeContexts"`: A list of contexts active for the request. A context can be activated
  when a previous intent is fulfilled, or by including the context in the request, If you
  don't specify a list of contexts, Amazon Lex will use the current list of contexts for the
  session. If you specify an empty list, all contexts for the session are cleared.
- `"dialogAction"`: Sets the next action that the bot should take to fulfill the
  conversation.
- `"recentIntentSummaryView"`: A summary of the recent intents for the bot. You can use the
  intent summary view to set a checkpoint label on an intent and modify attributes of
  intents. You can also use it to remove or add intent summary objects to the list. An intent
  that you modify or add to the list must make sense for the bot. For example, the intent
  name must be valid for the bot. You must provide valid values for:    intentName    slot
  names    slotToElict    If you send the recentIntentSummaryView parameter in a PutSession
  request, the contents of the new summary view replaces the old summary view. For example,
  if a GetSession request returns three intents in the summary view and you call PutSession
  with one intent in the summary view, the next call to GetSession will only return one
  intent.
- `"sessionAttributes"`: Map of key/value pairs representing the session-specific context
  information. It contains application information passed between Amazon Lex and a client
  application.
"""
function put_session(
    botAlias, botName, userId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lex_runtime_service(
        "POST",
        "/bot/$(botName)/alias/$(botAlias)/user/$(userId)/session";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_session(
    botAlias,
    botName,
    userId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lex_runtime_service(
        "POST",
        "/bot/$(botName)/alias/$(botAlias)/user/$(userId)/session",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
