# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: workdocs
using AWS.Compat
using AWS.UUIDs

"""
    abort_document_version_upload(document_id, version_id)
    abort_document_version_upload(document_id, version_id, params::Dict{String,<:Any})

Aborts the upload of the specified document version that was previously initiated by
InitiateDocumentVersionUpload. The client should make this call only when it no longer
intends to upload the document version, or fails to do so.

# Arguments
- `document_id`: The ID of the document.
- `version_id`: The ID of the version.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Authentication"`: Amazon WorkDocs authentication token. Not required when using Amazon
  Web Services administrator credentials to access the API.
"""
function abort_document_version_upload(
    DocumentId, VersionId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return workdocs(
        "DELETE",
        "/api/v1/documents/$(DocumentId)/versions/$(VersionId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function abort_document_version_upload(
    DocumentId,
    VersionId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workdocs(
        "DELETE",
        "/api/v1/documents/$(DocumentId)/versions/$(VersionId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    activate_user(user_id)
    activate_user(user_id, params::Dict{String,<:Any})

Activates the specified user. Only active users can access Amazon WorkDocs.

# Arguments
- `user_id`: The ID of the user.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Authentication"`: Amazon WorkDocs authentication token. Not required when using Amazon
  Web Services administrator credentials to access the API.
"""
function activate_user(UserId; aws_config::AbstractAWSConfig=current_aws_config())
    return workdocs(
        "POST",
        "/api/v1/users/$(UserId)/activation";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function activate_user(
    UserId, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return workdocs(
        "POST",
        "/api/v1/users/$(UserId)/activation",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    add_resource_permissions(principals, resource_id)
    add_resource_permissions(principals, resource_id, params::Dict{String,<:Any})

Creates a set of permissions for the specified folder or document. The resource permissions
are overwritten if the principals already have different permissions.

# Arguments
- `principals`: The users, groups, or organization being granted permission.
- `resource_id`: The ID of the resource.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Authentication"`: Amazon WorkDocs authentication token. Not required when using Amazon
  Web Services administrator credentials to access the API.
- `"NotificationOptions"`: The notification options.
"""
function add_resource_permissions(
    Principals, ResourceId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return workdocs(
        "POST",
        "/api/v1/resources/$(ResourceId)/permissions",
        Dict{String,Any}("Principals" => Principals);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function add_resource_permissions(
    Principals,
    ResourceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workdocs(
        "POST",
        "/api/v1/resources/$(ResourceId)/permissions",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("Principals" => Principals), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_comment(document_id, text, version_id)
    create_comment(document_id, text, version_id, params::Dict{String,<:Any})

Adds a new comment to the specified document version.

# Arguments
- `document_id`: The ID of the document.
- `text`: The text of the comment.
- `version_id`: The ID of the document version.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Authentication"`: Amazon WorkDocs authentication token. Not required when using Amazon
  Web Services administrator credentials to access the API.
- `"NotifyCollaborators"`: Set this parameter to TRUE to send an email out to the document
  collaborators after the comment is created.
- `"ParentId"`: The ID of the parent comment.
- `"ThreadId"`: The ID of the root comment in the thread.
- `"Visibility"`: The visibility of the comment. Options are either PRIVATE, where the
  comment is visible only to the comment author and document owner and co-owners, or PUBLIC,
  where the comment is visible to document owners, co-owners, and contributors.
"""
function create_comment(
    DocumentId, Text, VersionId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return workdocs(
        "POST",
        "/api/v1/documents/$(DocumentId)/versions/$(VersionId)/comment",
        Dict{String,Any}("Text" => Text);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_comment(
    DocumentId,
    Text,
    VersionId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workdocs(
        "POST",
        "/api/v1/documents/$(DocumentId)/versions/$(VersionId)/comment",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Text" => Text), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_custom_metadata(custom_metadata, resource_id)
    create_custom_metadata(custom_metadata, resource_id, params::Dict{String,<:Any})

Adds one or more custom properties to the specified resource (a folder, document, or
version).

# Arguments
- `custom_metadata`: Custom metadata in the form of name-value pairs.
- `resource_id`: The ID of the resource.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Authentication"`: Amazon WorkDocs authentication token. Not required when using Amazon
  Web Services administrator credentials to access the API.
- `"versionid"`: The ID of the version, if the custom metadata is being added to a document
  version.
"""
function create_custom_metadata(
    CustomMetadata, ResourceId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return workdocs(
        "PUT",
        "/api/v1/resources/$(ResourceId)/customMetadata",
        Dict{String,Any}("CustomMetadata" => CustomMetadata);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_custom_metadata(
    CustomMetadata,
    ResourceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workdocs(
        "PUT",
        "/api/v1/resources/$(ResourceId)/customMetadata",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("CustomMetadata" => CustomMetadata), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_folder(parent_folder_id)
    create_folder(parent_folder_id, params::Dict{String,<:Any})

Creates a folder with the specified name and parent folder.

# Arguments
- `parent_folder_id`: The ID of the parent folder.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Authentication"`: Amazon WorkDocs authentication token. Not required when using Amazon
  Web Services administrator credentials to access the API.
- `"Name"`: The name of the new folder.
"""
function create_folder(ParentFolderId; aws_config::AbstractAWSConfig=current_aws_config())
    return workdocs(
        "POST",
        "/api/v1/folders",
        Dict{String,Any}("ParentFolderId" => ParentFolderId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_folder(
    ParentFolderId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workdocs(
        "POST",
        "/api/v1/folders",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ParentFolderId" => ParentFolderId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_labels(labels, resource_id)
    create_labels(labels, resource_id, params::Dict{String,<:Any})

Adds the specified list of labels to the given resource (a document or folder)

# Arguments
- `labels`: List of labels to add to the resource.
- `resource_id`: The ID of the resource.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Authentication"`: Amazon WorkDocs authentication token. Not required when using Amazon
  Web Services administrator credentials to access the API.
"""
function create_labels(
    Labels, ResourceId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return workdocs(
        "PUT",
        "/api/v1/resources/$(ResourceId)/labels",
        Dict{String,Any}("Labels" => Labels);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_labels(
    Labels,
    ResourceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workdocs(
        "PUT",
        "/api/v1/resources/$(ResourceId)/labels",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Labels" => Labels), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_notification_subscription(endpoint, organization_id, protocol, subscription_type)
    create_notification_subscription(endpoint, organization_id, protocol, subscription_type, params::Dict{String,<:Any})

Configure Amazon WorkDocs to use Amazon SNS notifications. The endpoint receives a
confirmation message, and must confirm the subscription. For more information, see Setting
up notifications for an IAM user or role in the Amazon WorkDocs Developer Guide.

# Arguments
- `endpoint`: The endpoint to receive the notifications. If the protocol is HTTPS, the
  endpoint is a URL that begins with https.
- `organization_id`: The ID of the organization.
- `protocol`: The protocol to use. The supported value is https, which delivers
  JSON-encoded messages using HTTPS POST.
- `subscription_type`: The notification type.

"""
function create_notification_subscription(
    Endpoint,
    OrganizationId,
    Protocol,
    SubscriptionType;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workdocs(
        "POST",
        "/api/v1/organizations/$(OrganizationId)/subscriptions",
        Dict{String,Any}(
            "Endpoint" => Endpoint,
            "Protocol" => Protocol,
            "SubscriptionType" => SubscriptionType,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_notification_subscription(
    Endpoint,
    OrganizationId,
    Protocol,
    SubscriptionType,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workdocs(
        "POST",
        "/api/v1/organizations/$(OrganizationId)/subscriptions",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "Endpoint" => Endpoint,
                    "Protocol" => Protocol,
                    "SubscriptionType" => SubscriptionType,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_user(given_name, password, surname, username)
    create_user(given_name, password, surname, username, params::Dict{String,<:Any})

Creates a user in a Simple AD or Microsoft AD directory. The status of a newly created user
is \"ACTIVE\". New users can access Amazon WorkDocs.

# Arguments
- `given_name`: The given name of the user.
- `password`: The password of the user.
- `surname`: The surname of the user.
- `username`: The login name of the user.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Authentication"`: Amazon WorkDocs authentication token. Not required when using Amazon
  Web Services administrator credentials to access the API.
- `"EmailAddress"`: The email address of the user.
- `"OrganizationId"`: The ID of the organization.
- `"StorageRule"`: The amount of storage for the user.
- `"TimeZoneId"`: The time zone ID of the user.
"""
function create_user(
    GivenName,
    Password,
    Surname,
    Username;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workdocs(
        "POST",
        "/api/v1/users",
        Dict{String,Any}(
            "GivenName" => GivenName,
            "Password" => Password,
            "Surname" => Surname,
            "Username" => Username,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_user(
    GivenName,
    Password,
    Surname,
    Username,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workdocs(
        "POST",
        "/api/v1/users",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "GivenName" => GivenName,
                    "Password" => Password,
                    "Surname" => Surname,
                    "Username" => Username,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    deactivate_user(user_id)
    deactivate_user(user_id, params::Dict{String,<:Any})

Deactivates the specified user, which revokes the user's access to Amazon WorkDocs.

# Arguments
- `user_id`: The ID of the user.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Authentication"`: Amazon WorkDocs authentication token. Not required when using Amazon
  Web Services administrator credentials to access the API.
"""
function deactivate_user(UserId; aws_config::AbstractAWSConfig=current_aws_config())
    return workdocs(
        "DELETE",
        "/api/v1/users/$(UserId)/activation";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function deactivate_user(
    UserId, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return workdocs(
        "DELETE",
        "/api/v1/users/$(UserId)/activation",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_comment(comment_id, document_id, version_id)
    delete_comment(comment_id, document_id, version_id, params::Dict{String,<:Any})

Deletes the specified comment from the document version.

# Arguments
- `comment_id`: The ID of the comment.
- `document_id`: The ID of the document.
- `version_id`: The ID of the document version.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Authentication"`: Amazon WorkDocs authentication token. Not required when using Amazon
  Web Services administrator credentials to access the API.
"""
function delete_comment(
    CommentId, DocumentId, VersionId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return workdocs(
        "DELETE",
        "/api/v1/documents/$(DocumentId)/versions/$(VersionId)/comment/$(CommentId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_comment(
    CommentId,
    DocumentId,
    VersionId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workdocs(
        "DELETE",
        "/api/v1/documents/$(DocumentId)/versions/$(VersionId)/comment/$(CommentId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_custom_metadata(resource_id)
    delete_custom_metadata(resource_id, params::Dict{String,<:Any})

Deletes custom metadata from the specified resource.

# Arguments
- `resource_id`: The ID of the resource, either a document or folder.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Authentication"`: Amazon WorkDocs authentication token. Not required when using Amazon
  Web Services administrator credentials to access the API.
- `"deleteAll"`: Flag to indicate removal of all custom metadata properties from the
  specified resource.
- `"keys"`: List of properties to remove.
- `"versionId"`: The ID of the version, if the custom metadata is being deleted from a
  document version.
"""
function delete_custom_metadata(
    ResourceId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return workdocs(
        "DELETE",
        "/api/v1/resources/$(ResourceId)/customMetadata";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_custom_metadata(
    ResourceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workdocs(
        "DELETE",
        "/api/v1/resources/$(ResourceId)/customMetadata",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_document(document_id)
    delete_document(document_id, params::Dict{String,<:Any})

Permanently deletes the specified document and its associated metadata.

# Arguments
- `document_id`: The ID of the document.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Authentication"`: Amazon WorkDocs authentication token. Not required when using Amazon
  Web Services administrator credentials to access the API.
"""
function delete_document(DocumentId; aws_config::AbstractAWSConfig=current_aws_config())
    return workdocs(
        "DELETE",
        "/api/v1/documents/$(DocumentId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_document(
    DocumentId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workdocs(
        "DELETE",
        "/api/v1/documents/$(DocumentId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_document_version(document_id, version_id, delete_prior_versions)
    delete_document_version(document_id, version_id, delete_prior_versions, params::Dict{String,<:Any})

Deletes a specific version of a document.

# Arguments
- `document_id`: The ID of the document associated with the version being deleted.
- `version_id`: The ID of the version being deleted.
- `delete_prior_versions`: Deletes all versions of a document prior to the current version.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Authentication"`: Amazon WorkDocs authentication token. Not required when using Amazon
  Web Services administrator credentials to access the API.
"""
function delete_document_version(
    DocumentId,
    VersionId,
    deletePriorVersions;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workdocs(
        "DELETE",
        "/api/v1/documentVersions/$(DocumentId)/versions/$(VersionId)",
        Dict{String,Any}("deletePriorVersions" => deletePriorVersions);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_document_version(
    DocumentId,
    VersionId,
    deletePriorVersions,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workdocs(
        "DELETE",
        "/api/v1/documentVersions/$(DocumentId)/versions/$(VersionId)",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("deletePriorVersions" => deletePriorVersions),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_folder(folder_id)
    delete_folder(folder_id, params::Dict{String,<:Any})

Permanently deletes the specified folder and its contents.

# Arguments
- `folder_id`: The ID of the folder.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Authentication"`: Amazon WorkDocs authentication token. Not required when using Amazon
  Web Services administrator credentials to access the API.
"""
function delete_folder(FolderId; aws_config::AbstractAWSConfig=current_aws_config())
    return workdocs(
        "DELETE",
        "/api/v1/folders/$(FolderId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_folder(
    FolderId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workdocs(
        "DELETE",
        "/api/v1/folders/$(FolderId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_folder_contents(folder_id)
    delete_folder_contents(folder_id, params::Dict{String,<:Any})

Deletes the contents of the specified folder.

# Arguments
- `folder_id`: The ID of the folder.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Authentication"`: Amazon WorkDocs authentication token. Not required when using Amazon
  Web Services administrator credentials to access the API.
"""
function delete_folder_contents(
    FolderId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return workdocs(
        "DELETE",
        "/api/v1/folders/$(FolderId)/contents";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_folder_contents(
    FolderId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workdocs(
        "DELETE",
        "/api/v1/folders/$(FolderId)/contents",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_labels(resource_id)
    delete_labels(resource_id, params::Dict{String,<:Any})

Deletes the specified list of labels from a resource.

# Arguments
- `resource_id`: The ID of the resource.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Authentication"`: Amazon WorkDocs authentication token. Not required when using Amazon
  Web Services administrator credentials to access the API.
- `"deleteAll"`: Flag to request removal of all labels from the specified resource.
- `"labels"`: List of labels to delete from the resource.
"""
function delete_labels(ResourceId; aws_config::AbstractAWSConfig=current_aws_config())
    return workdocs(
        "DELETE",
        "/api/v1/resources/$(ResourceId)/labels";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_labels(
    ResourceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workdocs(
        "DELETE",
        "/api/v1/resources/$(ResourceId)/labels",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_notification_subscription(organization_id, subscription_id)
    delete_notification_subscription(organization_id, subscription_id, params::Dict{String,<:Any})

Deletes the specified subscription from the specified organization.

# Arguments
- `organization_id`: The ID of the organization.
- `subscription_id`: The ID of the subscription.

"""
function delete_notification_subscription(
    OrganizationId, SubscriptionId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return workdocs(
        "DELETE",
        "/api/v1/organizations/$(OrganizationId)/subscriptions/$(SubscriptionId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_notification_subscription(
    OrganizationId,
    SubscriptionId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workdocs(
        "DELETE",
        "/api/v1/organizations/$(OrganizationId)/subscriptions/$(SubscriptionId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_user(user_id)
    delete_user(user_id, params::Dict{String,<:Any})

Deletes the specified user from a Simple AD or Microsoft AD directory.  Deleting a user
immediately and permanently deletes all content in that user's folder structure. Site
retention policies do NOT apply to this type of deletion.

# Arguments
- `user_id`: The ID of the user.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Authentication"`: Amazon WorkDocs authentication token. Do not set this field when
  using administrative API actions, as in accessing the API using Amazon Web Services
  credentials.
"""
function delete_user(UserId; aws_config::AbstractAWSConfig=current_aws_config())
    return workdocs(
        "DELETE",
        "/api/v1/users/$(UserId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_user(
    UserId, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return workdocs(
        "DELETE",
        "/api/v1/users/$(UserId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_activities()
    describe_activities(params::Dict{String,<:Any})

Describes the user activities in a specified time period.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Authentication"`: Amazon WorkDocs authentication token. Not required when using Amazon
  Web Services administrator credentials to access the API.
- `"activityTypes"`: Specifies which activity types to include in the response. If this
  field is left empty, all activity types are returned.
- `"endTime"`: The timestamp that determines the end time of the activities. The response
  includes the activities performed before the specified timestamp.
- `"includeIndirectActivities"`: Includes indirect activities. An indirect activity results
  from a direct activity performed on a parent resource. For example, sharing a parent folder
  (the direct activity) shares all of the subfolders and documents within the parent folder
  (the indirect activity).
- `"limit"`: The maximum number of items to return.
- `"marker"`: The marker for the next set of results.
- `"organizationId"`: The ID of the organization. This is a mandatory parameter when using
  administrative API (SigV4) requests.
- `"resourceId"`: The document or folder ID for which to describe activity types.
- `"startTime"`: The timestamp that determines the starting time of the activities. The
  response includes the activities performed after the specified timestamp.
- `"userId"`: The ID of the user who performed the action. The response includes activities
  pertaining to this user. This is an optional parameter and is only applicable for
  administrative API (SigV4) requests.
"""
function describe_activities(; aws_config::AbstractAWSConfig=current_aws_config())
    return workdocs(
        "GET", "/api/v1/activities"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_activities(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return workdocs(
        "GET",
        "/api/v1/activities",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_comments(document_id, version_id)
    describe_comments(document_id, version_id, params::Dict{String,<:Any})

List all the comments for the specified document version.

# Arguments
- `document_id`: The ID of the document.
- `version_id`: The ID of the document version.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Authentication"`: Amazon WorkDocs authentication token. Not required when using Amazon
  Web Services administrator credentials to access the API.
- `"limit"`: The maximum number of items to return.
- `"marker"`: The marker for the next set of results. This marker was received from a
  previous call.
"""
function describe_comments(
    DocumentId, VersionId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return workdocs(
        "GET",
        "/api/v1/documents/$(DocumentId)/versions/$(VersionId)/comments";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_comments(
    DocumentId,
    VersionId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workdocs(
        "GET",
        "/api/v1/documents/$(DocumentId)/versions/$(VersionId)/comments",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_document_versions(document_id)
    describe_document_versions(document_id, params::Dict{String,<:Any})

Retrieves the document versions for the specified document. By default, only active
versions are returned.

# Arguments
- `document_id`: The ID of the document.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Authentication"`: Amazon WorkDocs authentication token. Not required when using Amazon
  Web Services administrator credentials to access the API.
- `"fields"`: Specify \"SOURCE\" to include initialized versions and a URL for the source
  document.
- `"include"`: A comma-separated list of values. Specify \"INITIALIZED\" to include
  incomplete versions.
- `"limit"`: The maximum number of versions to return with this call.
- `"marker"`: The marker for the next set of results. (You received this marker from a
  previous call.)
"""
function describe_document_versions(
    DocumentId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return workdocs(
        "GET",
        "/api/v1/documents/$(DocumentId)/versions";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_document_versions(
    DocumentId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workdocs(
        "GET",
        "/api/v1/documents/$(DocumentId)/versions",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_folder_contents(folder_id)
    describe_folder_contents(folder_id, params::Dict{String,<:Any})

Describes the contents of the specified folder, including its documents and subfolders. By
default, Amazon WorkDocs returns the first 100 active document and folder metadata items.
If there are more results, the response includes a marker that you can use to request the
next set of results. You can also request initialized documents.

# Arguments
- `folder_id`: The ID of the folder.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Authentication"`: Amazon WorkDocs authentication token. Not required when using Amazon
  Web Services administrator credentials to access the API.
- `"include"`: The contents to include. Specify \"INITIALIZED\" to include initialized
  documents.
- `"limit"`: The maximum number of items to return with this call.
- `"marker"`: The marker for the next set of results. This marker was received from a
  previous call.
- `"order"`: The order for the contents of the folder.
- `"sort"`: The sorting criteria.
- `"type"`: The type of items.
"""
function describe_folder_contents(
    FolderId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return workdocs(
        "GET",
        "/api/v1/folders/$(FolderId)/contents";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_folder_contents(
    FolderId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workdocs(
        "GET",
        "/api/v1/folders/$(FolderId)/contents",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_groups(search_query)
    describe_groups(search_query, params::Dict{String,<:Any})

Describes the groups specified by the query. Groups are defined by the underlying Active
Directory.

# Arguments
- `search_query`: A query to describe groups by group name.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Authentication"`: Amazon WorkDocs authentication token. Not required when using Amazon
  Web Services administrator credentials to access the API.
- `"limit"`: The maximum number of items to return with this call.
- `"marker"`: The marker for the next set of results. (You received this marker from a
  previous call.)
- `"organizationId"`: The ID of the organization.
"""
function describe_groups(searchQuery; aws_config::AbstractAWSConfig=current_aws_config())
    return workdocs(
        "GET",
        "/api/v1/groups",
        Dict{String,Any}("searchQuery" => searchQuery);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_groups(
    searchQuery,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workdocs(
        "GET",
        "/api/v1/groups",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("searchQuery" => searchQuery), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_notification_subscriptions(organization_id)
    describe_notification_subscriptions(organization_id, params::Dict{String,<:Any})

Lists the specified notification subscriptions.

# Arguments
- `organization_id`: The ID of the organization.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"limit"`: The maximum number of items to return with this call.
- `"marker"`: The marker for the next set of results. (You received this marker from a
  previous call.)
"""
function describe_notification_subscriptions(
    OrganizationId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return workdocs(
        "GET",
        "/api/v1/organizations/$(OrganizationId)/subscriptions";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_notification_subscriptions(
    OrganizationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workdocs(
        "GET",
        "/api/v1/organizations/$(OrganizationId)/subscriptions",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_resource_permissions(resource_id)
    describe_resource_permissions(resource_id, params::Dict{String,<:Any})

Describes the permissions of a specified resource.

# Arguments
- `resource_id`: The ID of the resource.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Authentication"`: Amazon WorkDocs authentication token. Not required when using Amazon
  Web Services administrator credentials to access the API.
- `"limit"`: The maximum number of items to return with this call.
- `"marker"`: The marker for the next set of results. (You received this marker from a
  previous call)
- `"principalId"`: The ID of the principal to filter permissions by.
"""
function describe_resource_permissions(
    ResourceId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return workdocs(
        "GET",
        "/api/v1/resources/$(ResourceId)/permissions";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_resource_permissions(
    ResourceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workdocs(
        "GET",
        "/api/v1/resources/$(ResourceId)/permissions",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_root_folders(authentication)
    describe_root_folders(authentication, params::Dict{String,<:Any})

Describes the current user's special folders; the RootFolder and the RecycleBin. RootFolder
is the root of user's files and folders and RecycleBin is the root of recycled items. This
is not a valid action for SigV4 (administrative API) clients. This action requires an
authentication token. To get an authentication token, register an application with Amazon
WorkDocs. For more information, see Authentication and Access Control for User Applications
in the Amazon WorkDocs Developer Guide.

# Arguments
- `authentication`: Amazon WorkDocs authentication token.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"limit"`: The maximum number of items to return.
- `"marker"`: The marker for the next set of results. (You received this marker from a
  previous call.)
"""
function describe_root_folders(
    Authentication; aws_config::AbstractAWSConfig=current_aws_config()
)
    return workdocs(
        "GET",
        "/api/v1/me/root",
        Dict{String,Any}("headers" => Dict{String,Any}("Authentication" => Authentication));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_root_folders(
    Authentication,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workdocs(
        "GET",
        "/api/v1/me/root",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "headers" => Dict{String,Any}("Authentication" => Authentication)
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_users()
    describe_users(params::Dict{String,<:Any})

Describes the specified users. You can describe all users or filter the results (for
example, by status or organization). By default, Amazon WorkDocs returns the first 24
active or pending users. If there are more results, the response includes a marker that you
can use to request the next set of results.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Authentication"`: Amazon WorkDocs authentication token. Not required when using Amazon
  Web Services administrator credentials to access the API.
- `"fields"`: A comma-separated list of values. Specify \"STORAGE_METADATA\" to include the
  user storage quota and utilization information.
- `"include"`: The state of the users. Specify \"ALL\" to include inactive users.
- `"limit"`: The maximum number of items to return.
- `"marker"`: The marker for the next set of results. (You received this marker from a
  previous call.)
- `"order"`: The order for the results.
- `"organizationId"`: The ID of the organization.
- `"query"`: A query to filter users by user name. Remember the following about the Userids
  and Query parameters:   If you don't use either parameter, the API returns a paginated list
  of all users on the site.   If you use both parameters, the API ignores the Query
  parameter.   The Userid parameter only returns user names that match a corresponding user
  ID.   The Query parameter runs a \"prefix\" search for users by the GivenName, SurName, or
  UserName fields included in a CreateUser API call. For example, querying on Ma returns
  Márcia Oliveira, María García, and Mateo Jackson. If you use multiple characters, the
  API only returns data that matches all characters. For example, querying on Ma J only
  returns Mateo Jackson.
- `"sort"`: The sorting criteria.
- `"userIds"`: The IDs of the users.
"""
function describe_users(; aws_config::AbstractAWSConfig=current_aws_config())
    return workdocs(
        "GET", "/api/v1/users"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_users(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return workdocs(
        "GET",
        "/api/v1/users",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_current_user(authentication)
    get_current_user(authentication, params::Dict{String,<:Any})

Retrieves details of the current user for whom the authentication token was generated. This
is not a valid action for SigV4 (administrative API) clients. This action requires an
authentication token. To get an authentication token, register an application with Amazon
WorkDocs. For more information, see Authentication and Access Control for User Applications
in the Amazon WorkDocs Developer Guide.

# Arguments
- `authentication`: Amazon WorkDocs authentication token.

"""
function get_current_user(
    Authentication; aws_config::AbstractAWSConfig=current_aws_config()
)
    return workdocs(
        "GET",
        "/api/v1/me",
        Dict{String,Any}("headers" => Dict{String,Any}("Authentication" => Authentication));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_current_user(
    Authentication,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workdocs(
        "GET",
        "/api/v1/me",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "headers" => Dict{String,Any}("Authentication" => Authentication)
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_document(document_id)
    get_document(document_id, params::Dict{String,<:Any})

Retrieves details of a document.

# Arguments
- `document_id`: The ID of the document.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Authentication"`: Amazon WorkDocs authentication token. Not required when using Amazon
  Web Services administrator credentials to access the API.
- `"includeCustomMetadata"`: Set this to TRUE to include custom metadata in the response.
"""
function get_document(DocumentId; aws_config::AbstractAWSConfig=current_aws_config())
    return workdocs(
        "GET",
        "/api/v1/documents/$(DocumentId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_document(
    DocumentId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workdocs(
        "GET",
        "/api/v1/documents/$(DocumentId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_document_path(document_id)
    get_document_path(document_id, params::Dict{String,<:Any})

Retrieves the path information (the hierarchy from the root folder) for the requested
document. By default, Amazon WorkDocs returns a maximum of 100 levels upwards from the
requested document and only includes the IDs of the parent folders in the path. You can
limit the maximum number of levels. You can also request the names of the parent folders.

# Arguments
- `document_id`: The ID of the document.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Authentication"`: Amazon WorkDocs authentication token. Not required when using Amazon
  Web Services administrator credentials to access the API.
- `"fields"`: A comma-separated list of values. Specify NAME to include the names of the
  parent folders.
- `"limit"`: The maximum number of levels in the hierarchy to return.
- `"marker"`: This value is not supported.
"""
function get_document_path(DocumentId; aws_config::AbstractAWSConfig=current_aws_config())
    return workdocs(
        "GET",
        "/api/v1/documents/$(DocumentId)/path";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_document_path(
    DocumentId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workdocs(
        "GET",
        "/api/v1/documents/$(DocumentId)/path",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_document_version(document_id, version_id)
    get_document_version(document_id, version_id, params::Dict{String,<:Any})

Retrieves version metadata for the specified document.

# Arguments
- `document_id`: The ID of the document.
- `version_id`: The version ID of the document.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Authentication"`: Amazon WorkDocs authentication token. Not required when using Amazon
  Web Services administrator credentials to access the API.
- `"fields"`: A comma-separated list of values. Specify \"SOURCE\" to include a URL for the
  source document.
- `"includeCustomMetadata"`: Set this to TRUE to include custom metadata in the response.
"""
function get_document_version(
    DocumentId, VersionId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return workdocs(
        "GET",
        "/api/v1/documents/$(DocumentId)/versions/$(VersionId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_document_version(
    DocumentId,
    VersionId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workdocs(
        "GET",
        "/api/v1/documents/$(DocumentId)/versions/$(VersionId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_folder(folder_id)
    get_folder(folder_id, params::Dict{String,<:Any})

Retrieves the metadata of the specified folder.

# Arguments
- `folder_id`: The ID of the folder.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Authentication"`: Amazon WorkDocs authentication token. Not required when using Amazon
  Web Services administrator credentials to access the API.
- `"includeCustomMetadata"`: Set to TRUE to include custom metadata in the response.
"""
function get_folder(FolderId; aws_config::AbstractAWSConfig=current_aws_config())
    return workdocs(
        "GET",
        "/api/v1/folders/$(FolderId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_folder(
    FolderId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workdocs(
        "GET",
        "/api/v1/folders/$(FolderId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_folder_path(folder_id)
    get_folder_path(folder_id, params::Dict{String,<:Any})

Retrieves the path information (the hierarchy from the root folder) for the specified
folder. By default, Amazon WorkDocs returns a maximum of 100 levels upwards from the
requested folder and only includes the IDs of the parent folders in the path. You can limit
the maximum number of levels. You can also request the parent folder names.

# Arguments
- `folder_id`: The ID of the folder.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Authentication"`: Amazon WorkDocs authentication token. Not required when using Amazon
  Web Services administrator credentials to access the API.
- `"fields"`: A comma-separated list of values. Specify \"NAME\" to include the names of
  the parent folders.
- `"limit"`: The maximum number of levels in the hierarchy to return.
- `"marker"`: This value is not supported.
"""
function get_folder_path(FolderId; aws_config::AbstractAWSConfig=current_aws_config())
    return workdocs(
        "GET",
        "/api/v1/folders/$(FolderId)/path";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_folder_path(
    FolderId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workdocs(
        "GET",
        "/api/v1/folders/$(FolderId)/path",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_resources()
    get_resources(params::Dict{String,<:Any})

Retrieves a collection of resources, including folders and documents. The only
CollectionType supported is SHARED_WITH_ME.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Authentication"`: The Amazon WorkDocs authentication token. Not required when using
  Amazon Web Services administrator credentials to access the API.
- `"collectionType"`: The collection type.
- `"limit"`: The maximum number of resources to return.
- `"marker"`: The marker for the next set of results. This marker was received from a
  previous call.
- `"userId"`: The user ID for the resource collection. This is a required field for
  accessing the API operation using IAM credentials.
"""
function get_resources(; aws_config::AbstractAWSConfig=current_aws_config())
    return workdocs(
        "GET", "/api/v1/resources"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function get_resources(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return workdocs(
        "GET",
        "/api/v1/resources",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    initiate_document_version_upload()
    initiate_document_version_upload(params::Dict{String,<:Any})

Creates a new document object and version object. The client specifies the parent folder ID
and name of the document to upload. The ID is optionally specified when creating a new
version of an existing document. This is the first step to upload a document. Next, upload
the document to the URL returned from the call, and then call UpdateDocumentVersion. To
cancel the document upload, call AbortDocumentVersionUpload.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Authentication"`: Amazon WorkDocs authentication token. Not required when using Amazon
  Web Services administrator credentials to access the API.
- `"ContentCreatedTimestamp"`: The timestamp when the content of the document was
  originally created.
- `"ContentModifiedTimestamp"`: The timestamp when the content of the document was modified.
- `"ContentType"`: The content type of the document.
- `"DocumentSizeInBytes"`: The size of the document, in bytes.
- `"Id"`: The ID of the document.
- `"Name"`: The name of the document.
- `"ParentFolderId"`: The ID of the parent folder.
"""
function initiate_document_version_upload(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return workdocs(
        "POST", "/api/v1/documents"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function initiate_document_version_upload(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return workdocs(
        "POST",
        "/api/v1/documents",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    remove_all_resource_permissions(resource_id)
    remove_all_resource_permissions(resource_id, params::Dict{String,<:Any})

Removes all the permissions from the specified resource.

# Arguments
- `resource_id`: The ID of the resource.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Authentication"`: Amazon WorkDocs authentication token. Not required when using Amazon
  Web Services administrator credentials to access the API.
"""
function remove_all_resource_permissions(
    ResourceId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return workdocs(
        "DELETE",
        "/api/v1/resources/$(ResourceId)/permissions";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function remove_all_resource_permissions(
    ResourceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workdocs(
        "DELETE",
        "/api/v1/resources/$(ResourceId)/permissions",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    remove_resource_permission(principal_id, resource_id)
    remove_resource_permission(principal_id, resource_id, params::Dict{String,<:Any})

Removes the permission for the specified principal from the specified resource.

# Arguments
- `principal_id`: The principal ID of the resource.
- `resource_id`: The ID of the resource.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Authentication"`: Amazon WorkDocs authentication token. Not required when using Amazon
  Web Services administrator credentials to access the API.
- `"type"`: The principal type of the resource.
"""
function remove_resource_permission(
    PrincipalId, ResourceId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return workdocs(
        "DELETE",
        "/api/v1/resources/$(ResourceId)/permissions/$(PrincipalId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function remove_resource_permission(
    PrincipalId,
    ResourceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workdocs(
        "DELETE",
        "/api/v1/resources/$(ResourceId)/permissions/$(PrincipalId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    restore_document_versions(document_id)
    restore_document_versions(document_id, params::Dict{String,<:Any})

Recovers a deleted version of an Amazon WorkDocs document.

# Arguments
- `document_id`: The ID of the document.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Authentication"`: Amazon WorkDocs authentication token. Not required when using Amazon
  Web Services administrator credentials to access the API.
"""
function restore_document_versions(
    DocumentId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return workdocs(
        "POST",
        "/api/v1/documentVersions/restore/$(DocumentId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function restore_document_versions(
    DocumentId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workdocs(
        "POST",
        "/api/v1/documentVersions/restore/$(DocumentId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    search_resources()
    search_resources(params::Dict{String,<:Any})

Searches metadata and the content of folders, documents, document versions, and comments.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AdditionalResponseFields"`: A list of attributes to include in the response. Used to
  request fields that are not normally returned in a standard response.
- `"Authentication"`: Amazon WorkDocs authentication token. Not required when using Amazon
  Web Services administrator credentials to access the API.
- `"Filters"`: Filters results based on entity metadata.
- `"Limit"`: Max results count per page.
- `"Marker"`: The marker for the next set of results.
- `"OrderBy"`: Order by results in one or more categories.
- `"OrganizationId"`: Filters based on the resource owner OrgId. This is a mandatory
  parameter when using Admin SigV4 credentials.
- `"QueryScopes"`: Filter based on the text field type. A Folder has only a name and no
  content. A Comment has only content and no name. A Document or Document Version has a name
  and content
- `"QueryText"`: The String to search for. Searches across different text fields based on
  request parameters. Use double quotes around the query string for exact phrase matches.
"""
function search_resources(; aws_config::AbstractAWSConfig=current_aws_config())
    return workdocs(
        "POST", "/api/v1/search"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function search_resources(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return workdocs(
        "POST",
        "/api/v1/search",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_document(document_id)
    update_document(document_id, params::Dict{String,<:Any})

Updates the specified attributes of a document. The user must have access to both the
document and its parent folder, if applicable.

# Arguments
- `document_id`: The ID of the document.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Authentication"`: Amazon WorkDocs authentication token. Not required when using Amazon
  Web Services administrator credentials to access the API.
- `"Name"`: The name of the document.
- `"ParentFolderId"`: The ID of the parent folder.
- `"ResourceState"`: The resource state of the document. Only ACTIVE and RECYCLED are
  supported.
"""
function update_document(DocumentId; aws_config::AbstractAWSConfig=current_aws_config())
    return workdocs(
        "PATCH",
        "/api/v1/documents/$(DocumentId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_document(
    DocumentId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workdocs(
        "PATCH",
        "/api/v1/documents/$(DocumentId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_document_version(document_id, version_id)
    update_document_version(document_id, version_id, params::Dict{String,<:Any})

Changes the status of the document version to ACTIVE.  Amazon WorkDocs also sets its
document container to ACTIVE. This is the last step in a document upload, after the client
uploads the document to an S3-presigned URL returned by InitiateDocumentVersionUpload.

# Arguments
- `document_id`: The ID of the document.
- `version_id`: The version ID of the document.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Authentication"`: Amazon WorkDocs authentication token. Not required when using Amazon
  Web Services administrator credentials to access the API.
- `"VersionStatus"`: The status of the version.
"""
function update_document_version(
    DocumentId, VersionId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return workdocs(
        "PATCH",
        "/api/v1/documents/$(DocumentId)/versions/$(VersionId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_document_version(
    DocumentId,
    VersionId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workdocs(
        "PATCH",
        "/api/v1/documents/$(DocumentId)/versions/$(VersionId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_folder(folder_id)
    update_folder(folder_id, params::Dict{String,<:Any})

Updates the specified attributes of the specified folder. The user must have access to both
the folder and its parent folder, if applicable.

# Arguments
- `folder_id`: The ID of the folder.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Authentication"`: Amazon WorkDocs authentication token. Not required when using Amazon
  Web Services administrator credentials to access the API.
- `"Name"`: The name of the folder.
- `"ParentFolderId"`: The ID of the parent folder.
- `"ResourceState"`: The resource state of the folder. Only ACTIVE and RECYCLED are
  accepted values from the API.
"""
function update_folder(FolderId; aws_config::AbstractAWSConfig=current_aws_config())
    return workdocs(
        "PATCH",
        "/api/v1/folders/$(FolderId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_folder(
    FolderId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workdocs(
        "PATCH",
        "/api/v1/folders/$(FolderId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_user(user_id)
    update_user(user_id, params::Dict{String,<:Any})

Updates the specified attributes of the specified user, and grants or revokes
administrative privileges to the Amazon WorkDocs site.

# Arguments
- `user_id`: The ID of the user.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Authentication"`: Amazon WorkDocs authentication token. Not required when using Amazon
  Web Services administrator credentials to access the API.
- `"GivenName"`: The given name of the user.
- `"GrantPoweruserPrivileges"`: Boolean value to determine whether the user is granted
  Power user privileges.
- `"Locale"`: The locale of the user.
- `"StorageRule"`: The amount of storage for the user.
- `"Surname"`: The surname of the user.
- `"TimeZoneId"`: The time zone ID of the user.
- `"Type"`: The type of the user.
"""
function update_user(UserId; aws_config::AbstractAWSConfig=current_aws_config())
    return workdocs(
        "PATCH",
        "/api/v1/users/$(UserId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_user(
    UserId, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return workdocs(
        "PATCH",
        "/api/v1/users/$(UserId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
