# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: chime_sdk_meetings
using AWS.Compat
using AWS.UUIDs

"""
    batch_create_attendee(attendees, meeting_id)
    batch_create_attendee(attendees, meeting_id, params::Dict{String,<:Any})

Creates up to 100 attendees for an active Amazon Chime SDK meeting. For more information
about the Amazon Chime SDK, see Using the Amazon Chime SDK in the Amazon Chime Developer
Guide.

# Arguments
- `attendees`: The attendee information, including attendees' IDs and join tokens.
- `meeting_id`: The Amazon Chime SDK ID of the meeting to which you're adding attendees.

"""
function batch_create_attendee(
    Attendees, MeetingId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime_sdk_meetings(
        "POST",
        "/meetings/$(MeetingId)/attendees?operation=batch-create",
        Dict{String,Any}("Attendees" => Attendees);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function batch_create_attendee(
    Attendees,
    MeetingId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_meetings(
        "POST",
        "/meetings/$(MeetingId)/attendees?operation=batch-create",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("Attendees" => Attendees), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    batch_update_attendee_capabilities_except(capabilities, excluded_attendee_ids, meeting_id)
    batch_update_attendee_capabilities_except(capabilities, excluded_attendee_ids, meeting_id, params::Dict{String,<:Any})

Updates AttendeeCapabilities except the capabilities listed in an ExcludedAttendeeIds
table.  You use the capabilities with a set of values that control what the capabilities
can do, such as SendReceive data. For more information about those values, see .  When
using capabilities, be aware of these corner cases:   If you specify
MeetingFeatures:Video:MaxResolution:None when you create a meeting, all API requests that
include SendReceive, Send, or Receive for AttendeeCapabilities:Video will be rejected with
ValidationError 400.   If you specify MeetingFeatures:Content:MaxResolution:None when you
create a meeting, all API requests that include SendReceive, Send, or Receive for
AttendeeCapabilities:Content will be rejected with ValidationError 400.   You can't set
content capabilities to SendReceive or Receive unless you also set video capabilities to
SendReceive or Receive. If you don't set the video capability to receive, the response will
contain an HTTP 400 Bad Request status code. However, you can set your video capability to
receive and you set your content capability to not receive.   When you change an audio
capability from None or Receive to Send or SendReceive , and if the attendee left their
microphone unmuted, audio will flow from the attendee to the other meeting participants.
When you change a video or content capability from None or Receive to Send or SendReceive ,
and if the attendee turned on their video or content streams, remote attendees can receive
those streams, but only after media renegotiation between the client and the Amazon Chime
back-end server.

# Arguments
- `capabilities`: The capabilities (audio, video, or content) that you want to update.
- `excluded_attendee_ids`: The AttendeeIDs that you want to exclude from one or more
  capabilities.
- `meeting_id`: The ID of the meeting associated with the update request.

"""
function batch_update_attendee_capabilities_except(
    Capabilities,
    ExcludedAttendeeIds,
    MeetingId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_meetings(
        "PUT",
        "/meetings/$(MeetingId)/attendees/capabilities?operation=batch-update-except",
        Dict{String,Any}(
            "Capabilities" => Capabilities, "ExcludedAttendeeIds" => ExcludedAttendeeIds
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function batch_update_attendee_capabilities_except(
    Capabilities,
    ExcludedAttendeeIds,
    MeetingId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_meetings(
        "PUT",
        "/meetings/$(MeetingId)/attendees/capabilities?operation=batch-update-except",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "Capabilities" => Capabilities,
                    "ExcludedAttendeeIds" => ExcludedAttendeeIds,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_attendee(external_user_id, meeting_id)
    create_attendee(external_user_id, meeting_id, params::Dict{String,<:Any})

 Creates a new attendee for an active Amazon Chime SDK meeting. For more information about
the Amazon Chime SDK, see Using the Amazon Chime SDK in the Amazon Chime Developer Guide.

# Arguments
- `external_user_id`: The Amazon Chime SDK external user ID. An idempotency token. Links
  the attendee to an identity managed by a builder application. Pattern:
  [-_&amp;@+=,(){}[]/«».:|'\"#a-zA-Z0-9À-ÿs]*  Values that begin with aws: are reserved.
  You can't configure a value that uses this prefix.
- `meeting_id`: The unique ID of the meeting.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Capabilities"`: The capabilities (audio, video, or content) that you want to grant an
  attendee. If you don't specify capabilities, all users have send and receive capabilities
  on all media channels by default.  You use the capabilities with a set of values that
  control what the capabilities can do, such as SendReceive data. For more information about
  those values, see .  When using capabilities, be aware of these corner cases:   If you
  specify MeetingFeatures:Video:MaxResolution:None when you create a meeting, all API
  requests that include SendReceive, Send, or Receive for AttendeeCapabilities:Video will be
  rejected with ValidationError 400.   If you specify
  MeetingFeatures:Content:MaxResolution:None when you create a meeting, all API requests that
  include SendReceive, Send, or Receive for AttendeeCapabilities:Content will be rejected
  with ValidationError 400.   You can't set content capabilities to SendReceive or Receive
  unless you also set video capabilities to SendReceive or Receive. If you don't set the
  video capability to receive, the response will contain an HTTP 400 Bad Request status code.
  However, you can set your video capability to receive and you set your content capability
  to not receive.   When you change an audio capability from None or Receive to Send or
  SendReceive , and if the attendee left their microphone unmuted, audio will flow from the
  attendee to the other meeting participants.   When you change a video or content capability
  from None or Receive to Send or SendReceive , and if the attendee turned on their video or
  content streams, remote attendees can receive those streams, but only after media
  renegotiation between the client and the Amazon Chime back-end server.
"""
function create_attendee(
    ExternalUserId, MeetingId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime_sdk_meetings(
        "POST",
        "/meetings/$(MeetingId)/attendees",
        Dict{String,Any}("ExternalUserId" => ExternalUserId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_attendee(
    ExternalUserId,
    MeetingId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_meetings(
        "POST",
        "/meetings/$(MeetingId)/attendees",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ExternalUserId" => ExternalUserId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_meeting(client_request_token, external_meeting_id, media_region)
    create_meeting(client_request_token, external_meeting_id, media_region, params::Dict{String,<:Any})

Creates a new Amazon Chime SDK meeting in the specified media Region with no initial
attendees. For more information about specifying media Regions, see Amazon Chime SDK Media
Regions in the Amazon Chime Developer Guide. For more information about the Amazon Chime
SDK, see Using the Amazon Chime SDK in the Amazon Chime Developer Guide.

# Arguments
- `client_request_token`: The unique identifier for the client request. Use a different
  token for different meetings.
- `external_meeting_id`: The external meeting ID. Pattern:
  [-_&amp;@+=,(){}[]/«».:|'\"#a-zA-Z0-9À-ÿs]*  Values that begin with aws: are reserved.
  You can't configure a value that uses this prefix. Case insensitive.
- `media_region`: The Region in which to create the meeting.  Available values: af-south-1,
  ap-northeast-1, ap-northeast-2, ap-south-1, ap-southeast-1, ap-southeast-2, ca-central-1,
  eu-central-1, eu-north-1, eu-south-1, eu-west-1, eu-west-2, eu-west-3, sa-east-1,
  us-east-1, us-east-2, us-west-1, us-west-2.  Available values in Amazon Web Services
  GovCloud (US) Regions: us-gov-east-1, us-gov-west-1.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MeetingFeatures"`: Lists the audio and video features enabled for a meeting, such as
  echo reduction.
- `"MeetingHostId"`: Reserved.
- `"NotificationsConfiguration"`: The configuration for resource targets to receive
  notifications when meeting and attendee events occur.
- `"PrimaryMeetingId"`: When specified, replicates the media from the primary meeting to
  the new meeting.
- `"Tags"`: Applies one or more tags to an Amazon Chime SDK meeting. Note the following:
  Not all resources have tags. For a list of services with resources that support tagging
  using this operation, see Services that support the Resource Groups Tagging API. If the
  resource doesn't yet support this operation, the resource's service might support tagging
  using its own API operations. For more information, refer to the documentation for that
  service.   Each resource can have up to 50 tags. For other limits, see Tag Naming and Usage
  Conventions in the AWS General Reference.   You can only tag resources that are located in
  the specified Amazon Web Services Region for the Amazon Web Services account.   To add tags
  to a resource, you need the necessary permissions for the service that the resource belongs
  to as well as permissions for adding tags. For more information, see the documentation for
  each service.    Do not store personally identifiable information (PII) or other
  confidential or sensitive information in tags. We use tags to provide you with billing and
  administration services. Tags are not intended to be used for private or sensitive data.
  Minimum permissions  In addition to the tag:TagResources permission required by this
  operation, you must also have the tagging permission defined by the service that created
  the resource. For example, to tag a ChimeSDKMeetings instance using the TagResources
  operation, you must have both of the following permissions:  tag:TagResources
  ChimeSDKMeetings:CreateTags   Some services might have specific requirements for tagging
  some resources. For example, to tag an Amazon S3 bucket, you must also have the
  s3:GetBucketTagging permission. If the expected minimum permissions don't work, check the
  documentation for that service's tagging APIs for more information.
- `"TenantIds"`: A consistent and opaque identifier, created and maintained by the builder
  to represent a segment of their users.
"""
function create_meeting(
    ClientRequestToken,
    ExternalMeetingId,
    MediaRegion;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_meetings(
        "POST",
        "/meetings",
        Dict{String,Any}(
            "ClientRequestToken" => ClientRequestToken,
            "ExternalMeetingId" => ExternalMeetingId,
            "MediaRegion" => MediaRegion,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_meeting(
    ClientRequestToken,
    ExternalMeetingId,
    MediaRegion,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_meetings(
        "POST",
        "/meetings",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ClientRequestToken" => ClientRequestToken,
                    "ExternalMeetingId" => ExternalMeetingId,
                    "MediaRegion" => MediaRegion,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_meeting_with_attendees(attendees, client_request_token, external_meeting_id, media_region)
    create_meeting_with_attendees(attendees, client_request_token, external_meeting_id, media_region, params::Dict{String,<:Any})

 Creates a new Amazon Chime SDK meeting in the specified media Region, with attendees. For
more information about specifying media Regions, see Amazon Chime SDK Media Regions in the
Amazon Chime Developer Guide. For more information about the Amazon Chime SDK, see Using
the Amazon Chime SDK in the Amazon Chime Developer Guide.

# Arguments
- `attendees`: The attendee information, including attendees' IDs and join tokens.
- `client_request_token`: The unique identifier for the client request. Use a different
  token for different meetings.
- `external_meeting_id`: The external meeting ID. Pattern:
  [-_&amp;@+=,(){}[]/«».:|'\"#a-zA-Z0-9À-ÿs]*  Values that begin with aws: are reserved.
  You can't configure a value that uses this prefix. Case insensitive.
- `media_region`: The Region in which to create the meeting.  Available values: af-south-1,
  ap-northeast-1, ap-northeast-2, ap-south-1, ap-southeast-1, ap-southeast-2, ca-central-1,
  eu-central-1, eu-north-1, eu-south-1, eu-west-1, eu-west-2, eu-west-3, sa-east-1,
  us-east-1, us-east-2, us-west-1, us-west-2.  Available values in Amazon Web Services
  GovCloud (US) Regions: us-gov-east-1, us-gov-west-1.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MeetingFeatures"`: Lists the audio and video features enabled for a meeting, such as
  echo reduction.
- `"MeetingHostId"`: Reserved.
- `"NotificationsConfiguration"`: The configuration for resource targets to receive
  notifications when meeting and attendee events occur.
- `"PrimaryMeetingId"`: When specified, replicates the media from the primary meeting to
  the new meeting.
- `"Tags"`: The tags in the request.
- `"TenantIds"`: A consistent and opaque identifier, created and maintained by the builder
  to represent a segment of their users.
"""
function create_meeting_with_attendees(
    Attendees,
    ClientRequestToken,
    ExternalMeetingId,
    MediaRegion;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_meetings(
        "POST",
        "/meetings?operation=create-attendees",
        Dict{String,Any}(
            "Attendees" => Attendees,
            "ClientRequestToken" => ClientRequestToken,
            "ExternalMeetingId" => ExternalMeetingId,
            "MediaRegion" => MediaRegion,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_meeting_with_attendees(
    Attendees,
    ClientRequestToken,
    ExternalMeetingId,
    MediaRegion,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_meetings(
        "POST",
        "/meetings?operation=create-attendees",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "Attendees" => Attendees,
                    "ClientRequestToken" => ClientRequestToken,
                    "ExternalMeetingId" => ExternalMeetingId,
                    "MediaRegion" => MediaRegion,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_attendee(attendee_id, meeting_id)
    delete_attendee(attendee_id, meeting_id, params::Dict{String,<:Any})

Deletes an attendee from the specified Amazon Chime SDK meeting and deletes their
JoinToken. Attendees are automatically deleted when a Amazon Chime SDK meeting is deleted.
For more information about the Amazon Chime SDK, see Using the Amazon Chime SDK in the
Amazon Chime Developer Guide.

# Arguments
- `attendee_id`: The Amazon Chime SDK attendee ID.
- `meeting_id`: The Amazon Chime SDK meeting ID.

"""
function delete_attendee(
    AttendeeId, MeetingId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime_sdk_meetings(
        "DELETE",
        "/meetings/$(MeetingId)/attendees/$(AttendeeId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_attendee(
    AttendeeId,
    MeetingId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_meetings(
        "DELETE",
        "/meetings/$(MeetingId)/attendees/$(AttendeeId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_meeting(meeting_id)
    delete_meeting(meeting_id, params::Dict{String,<:Any})

Deletes the specified Amazon Chime SDK meeting. The operation deletes all attendees,
disconnects all clients, and prevents new clients from joining the meeting. For more
information about the Amazon Chime SDK, see Using the Amazon Chime SDK in the Amazon Chime
Developer Guide.

# Arguments
- `meeting_id`: The Amazon Chime SDK meeting ID.

"""
function delete_meeting(MeetingId; aws_config::AbstractAWSConfig=current_aws_config())
    return chime_sdk_meetings(
        "DELETE",
        "/meetings/$(MeetingId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_meeting(
    MeetingId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_meetings(
        "DELETE",
        "/meetings/$(MeetingId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_attendee(attendee_id, meeting_id)
    get_attendee(attendee_id, meeting_id, params::Dict{String,<:Any})

 Gets the Amazon Chime SDK attendee details for a specified meeting ID and attendee ID. For
more information about the Amazon Chime SDK, see Using the Amazon Chime SDK in the Amazon
Chime Developer Guide.

# Arguments
- `attendee_id`: The Amazon Chime SDK attendee ID.
- `meeting_id`: The Amazon Chime SDK meeting ID.

"""
function get_attendee(
    AttendeeId, MeetingId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime_sdk_meetings(
        "GET",
        "/meetings/$(MeetingId)/attendees/$(AttendeeId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_attendee(
    AttendeeId,
    MeetingId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_meetings(
        "GET",
        "/meetings/$(MeetingId)/attendees/$(AttendeeId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_meeting(meeting_id)
    get_meeting(meeting_id, params::Dict{String,<:Any})

Gets the Amazon Chime SDK meeting details for the specified meeting ID. For more
information about the Amazon Chime SDK, see Using the Amazon Chime SDK in the Amazon Chime
Developer Guide.

# Arguments
- `meeting_id`: The Amazon Chime SDK meeting ID.

"""
function get_meeting(MeetingId; aws_config::AbstractAWSConfig=current_aws_config())
    return chime_sdk_meetings(
        "GET",
        "/meetings/$(MeetingId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_meeting(
    MeetingId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_meetings(
        "GET",
        "/meetings/$(MeetingId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_attendees(meeting_id)
    list_attendees(meeting_id, params::Dict{String,<:Any})

 Lists the attendees for the specified Amazon Chime SDK meeting. For more information about
the Amazon Chime SDK, see Using the Amazon Chime SDK in the Amazon Chime Developer Guide.

# Arguments
- `meeting_id`: The Amazon Chime SDK meeting ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"max-results"`: The maximum number of results to return in a single call.
- `"next-token"`: The token to use to retrieve the next page of results.
"""
function list_attendees(MeetingId; aws_config::AbstractAWSConfig=current_aws_config())
    return chime_sdk_meetings(
        "GET",
        "/meetings/$(MeetingId)/attendees";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_attendees(
    MeetingId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_meetings(
        "GET",
        "/meetings/$(MeetingId)/attendees",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_tags_for_resource(arn)
    list_tags_for_resource(arn, params::Dict{String,<:Any})

Returns a list of the tags available for the specified resource.

# Arguments
- `arn`: The ARN of the resource.

"""
function list_tags_for_resource(arn; aws_config::AbstractAWSConfig=current_aws_config())
    return chime_sdk_meetings(
        "GET",
        "/tags",
        Dict{String,Any}("arn" => arn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tags_for_resource(
    arn, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime_sdk_meetings(
        "GET",
        "/tags",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("arn" => arn), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_meeting_transcription(meeting_id, transcription_configuration)
    start_meeting_transcription(meeting_id, transcription_configuration, params::Dict{String,<:Any})

Starts transcription for the specified meetingId. For more information, refer to  Using
Amazon Chime SDK live transcription  in the Amazon Chime SDK Developer Guide. If you
specify an invalid configuration, a TranscriptFailed event will be sent with the contents
of the BadRequestException generated by Amazon Transcribe. For more information on each
parameter and which combinations are valid, refer to the StartStreamTranscription API in
the Amazon Transcribe Developer Guide.  By default, Amazon Transcribe may use and store
audio content processed by the service to develop and improve Amazon Web Services AI/ML
services as further described in section 50 of the Amazon Web Services Service Terms. Using
Amazon Transcribe may be subject to federal and state laws or regulations regarding the
recording or interception of electronic communications. It is your and your end users’
responsibility to comply with all applicable laws regarding the recording, including
properly notifying all participants in a recorded session or communication that the session
or communication is being recorded, and obtaining all necessary consents. You can opt out
from Amazon Web Services using audio content to develop and improve AWS AI/ML services by
configuring an AI services opt out policy using Amazon Web Services Organizations.

# Arguments
- `meeting_id`: The unique ID of the meeting being transcribed.
- `transcription_configuration`: The configuration for the current transcription operation.
  Must contain EngineTranscribeSettings or EngineTranscribeMedicalSettings.

"""
function start_meeting_transcription(
    MeetingId,
    TranscriptionConfiguration;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_meetings(
        "POST",
        "/meetings/$(MeetingId)/transcription?operation=start",
        Dict{String,Any}("TranscriptionConfiguration" => TranscriptionConfiguration);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_meeting_transcription(
    MeetingId,
    TranscriptionConfiguration,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_meetings(
        "POST",
        "/meetings/$(MeetingId)/transcription?operation=start",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "TranscriptionConfiguration" => TranscriptionConfiguration
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    stop_meeting_transcription(meeting_id)
    stop_meeting_transcription(meeting_id, params::Dict{String,<:Any})

Stops transcription for the specified meetingId. For more information, refer to  Using
Amazon Chime SDK live transcription  in the Amazon Chime SDK Developer Guide.  By default,
Amazon Transcribe may use and store audio content processed by the service to develop and
improve Amazon Web Services AI/ML services as further described in section 50 of the Amazon
Web Services Service Terms. Using Amazon Transcribe may be subject to federal and state
laws or regulations regarding the recording or interception of electronic communications.
It is your and your end users’ responsibility to comply with all applicable laws
regarding the recording, including properly notifying all participants in a recorded
session or communication that the session or communication is being recorded, and obtaining
all necessary consents. You can opt out from Amazon Web Services using audio content to
develop and improve Amazon Web Services AI/ML services by configuring an AI services opt
out policy using Amazon Web Services Organizations.

# Arguments
- `meeting_id`: The unique ID of the meeting for which you stop transcription.

"""
function stop_meeting_transcription(
    MeetingId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime_sdk_meetings(
        "POST",
        "/meetings/$(MeetingId)/transcription?operation=stop";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function stop_meeting_transcription(
    MeetingId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_meetings(
        "POST",
        "/meetings/$(MeetingId)/transcription?operation=stop",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_resource(resource_arn, tags)
    tag_resource(resource_arn, tags, params::Dict{String,<:Any})

The resource that supports tags.

# Arguments
- `resource_arn`: The ARN of the resource.
- `tags`: Lists the requested tags.

"""
function tag_resource(ResourceARN, Tags; aws_config::AbstractAWSConfig=current_aws_config())
    return chime_sdk_meetings(
        "POST",
        "/tags?operation=tag-resource",
        Dict{String,Any}("ResourceARN" => ResourceARN, "Tags" => Tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_resource(
    ResourceARN,
    Tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_meetings(
        "POST",
        "/tags?operation=tag-resource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ResourceARN" => ResourceARN, "Tags" => Tags),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_resource(resource_arn, tag_keys)
    untag_resource(resource_arn, tag_keys, params::Dict{String,<:Any})

Removes the specified tags from the specified resources. When you specify a tag key, the
action removes both that key and its associated value. The operation succeeds even if you
attempt to remove tags from a resource that were already removed. Note the following:   To
remove tags from a resource, you need the necessary permissions for the service that the
resource belongs to as well as permissions for removing tags. For more information, see the
documentation for the service whose resource you want to untag.   You can only tag
resources that are located in the specified Amazon Web Services Region for the calling
Amazon Web Services account.    Minimum permissions  In addition to the tag:UntagResources
permission required by this operation, you must also have the remove tags permission
defined by the service that created the resource. For example, to remove the tags from an
Amazon EC2 instance using the UntagResources operation, you must have both of the following
permissions:  tag:UntagResource   ChimeSDKMeetings:DeleteTags

# Arguments
- `resource_arn`: The ARN of the resource that you're removing tags from.
- `tag_keys`: The tag keys being removed from the resources.

"""
function untag_resource(
    ResourceARN, TagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime_sdk_meetings(
        "POST",
        "/tags?operation=untag-resource",
        Dict{String,Any}("ResourceARN" => ResourceARN, "TagKeys" => TagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_resource(
    ResourceARN,
    TagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_meetings(
        "POST",
        "/tags?operation=untag-resource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ResourceARN" => ResourceARN, "TagKeys" => TagKeys),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_attendee_capabilities(attendee_id, capabilities, meeting_id)
    update_attendee_capabilities(attendee_id, capabilities, meeting_id, params::Dict{String,<:Any})

The capabilities that you want to update.  You use the capabilities with a set of values
that control what the capabilities can do, such as SendReceive data. For more information
about those values, see .  When using capabilities, be aware of these corner cases:   If
you specify MeetingFeatures:Video:MaxResolution:None when you create a meeting, all API
requests that include SendReceive, Send, or Receive for AttendeeCapabilities:Video will be
rejected with ValidationError 400.   If you specify
MeetingFeatures:Content:MaxResolution:None when you create a meeting, all API requests that
include SendReceive, Send, or Receive for AttendeeCapabilities:Content will be rejected
with ValidationError 400.   You can't set content capabilities to SendReceive or Receive
unless you also set video capabilities to SendReceive or Receive. If you don't set the
video capability to receive, the response will contain an HTTP 400 Bad Request status code.
However, you can set your video capability to receive and you set your content capability
to not receive.   When you change an audio capability from None or Receive to Send or
SendReceive , and if the attendee left their microphone unmuted, audio will flow from the
attendee to the other meeting participants.   When you change a video or content capability
from None or Receive to Send or SendReceive , and if the attendee turned on their video or
content streams, remote attendees can receive those streams, but only after media
renegotiation between the client and the Amazon Chime back-end server.

# Arguments
- `attendee_id`: The ID of the attendee associated with the update request.
- `capabilities`: The capabilities that you want to update.
- `meeting_id`: The ID of the meeting associated with the update request.

"""
function update_attendee_capabilities(
    AttendeeId, Capabilities, MeetingId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime_sdk_meetings(
        "PUT",
        "/meetings/$(MeetingId)/attendees/$(AttendeeId)/capabilities",
        Dict{String,Any}("Capabilities" => Capabilities);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_attendee_capabilities(
    AttendeeId,
    Capabilities,
    MeetingId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_meetings(
        "PUT",
        "/meetings/$(MeetingId)/attendees/$(AttendeeId)/capabilities",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("Capabilities" => Capabilities), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
