# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: pinpoint_sms_voice_v2
using AWS.Compat
using AWS.UUIDs

"""
    associate_origination_identity(iso_country_code, origination_identity, pool_id)
    associate_origination_identity(iso_country_code, origination_identity, pool_id, params::Dict{String,<:Any})

Associates the specified origination identity with a pool. If the origination identity is a
phone number and is already associated with another pool, an error is returned. A sender ID
can be associated with multiple pools. If the origination identity configuration doesn't
match the pool's configuration, an error is returned.

# Arguments
- `iso_country_code`: The new two-character code, in ISO 3166-1 alpha-2 format, for the
  country or region of the origination identity.
- `origination_identity`: The origination identity to use, such as PhoneNumberId,
  PhoneNumberArn, SenderId, or SenderIdArn. You can use DescribePhoneNumbers to find the
  values for PhoneNumberId and PhoneNumberArn, while DescribeSenderIds can be used to get the
  values for SenderId and SenderIdArn.
- `pool_id`: The pool to update with the new Identity. This value can be either the PoolId
  or PoolArn, and you can find these values using DescribePools.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientToken"`: Unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request. If you don't specify a client token, a randomly generated token
  is used for the request to ensure idempotency.
"""
function associate_origination_identity(
    IsoCountryCode,
    OriginationIdentity,
    PoolId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint_sms_voice_v2(
        "AssociateOriginationIdentity",
        Dict{String,Any}(
            "IsoCountryCode" => IsoCountryCode,
            "OriginationIdentity" => OriginationIdentity,
            "PoolId" => PoolId,
            "ClientToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function associate_origination_identity(
    IsoCountryCode,
    OriginationIdentity,
    PoolId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint_sms_voice_v2(
        "AssociateOriginationIdentity",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "IsoCountryCode" => IsoCountryCode,
                    "OriginationIdentity" => OriginationIdentity,
                    "PoolId" => PoolId,
                    "ClientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    associate_protect_configuration(configuration_set_name, protect_configuration_id)
    associate_protect_configuration(configuration_set_name, protect_configuration_id, params::Dict{String,<:Any})

Associate a protect configuration with a configuration set. This replaces the configuration
sets current protect configuration. A configuration set can only be associated with one
protect configuration at a time. A protect configuration can be associated with multiple
configuration sets.

# Arguments
- `configuration_set_name`: The name of the ConfigurationSet.
- `protect_configuration_id`: The unique identifier for the protect configuration.

"""
function associate_protect_configuration(
    ConfigurationSetName,
    ProtectConfigurationId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint_sms_voice_v2(
        "AssociateProtectConfiguration",
        Dict{String,Any}(
            "ConfigurationSetName" => ConfigurationSetName,
            "ProtectConfigurationId" => ProtectConfigurationId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function associate_protect_configuration(
    ConfigurationSetName,
    ProtectConfigurationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint_sms_voice_v2(
        "AssociateProtectConfiguration",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ConfigurationSetName" => ConfigurationSetName,
                    "ProtectConfigurationId" => ProtectConfigurationId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_configuration_set(configuration_set_name)
    create_configuration_set(configuration_set_name, params::Dict{String,<:Any})

Creates a new configuration set. After you create the configuration set, you can add one or
more event destinations to it. A configuration set is a set of rules that you apply to the
SMS and voice messages that you send. When you send a message, you can optionally specify a
single configuration set.

# Arguments
- `configuration_set_name`: The name to use for the new configuration set.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientToken"`: Unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request. If you don't specify a client token, a randomly generated token
  is used for the request to ensure idempotency.
- `"Tags"`: An array of key and value pair tags that's associated with the new
  configuration set.
"""
function create_configuration_set(
    ConfigurationSetName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint_sms_voice_v2(
        "CreateConfigurationSet",
        Dict{String,Any}(
            "ConfigurationSetName" => ConfigurationSetName, "ClientToken" => string(uuid4())
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_configuration_set(
    ConfigurationSetName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint_sms_voice_v2(
        "CreateConfigurationSet",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ConfigurationSetName" => ConfigurationSetName,
                    "ClientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_event_destination(configuration_set_name, event_destination_name, matching_event_types)
    create_event_destination(configuration_set_name, event_destination_name, matching_event_types, params::Dict{String,<:Any})

Creates a new event destination in a configuration set. An event destination is a location
where you send message events. The event options are Amazon CloudWatch, Amazon Kinesis Data
Firehose, or Amazon SNS. For example, when a message is delivered successfully, you can
send information about that event to an event destination, or send notifications to
endpoints that are subscribed to an Amazon SNS topic. Each configuration set can contain
between 0 and 5 event destinations. Each event destination can contain a reference to a
single destination, such as a CloudWatch or Kinesis Data Firehose destination.

# Arguments
- `configuration_set_name`: Either the name of the configuration set or the configuration
  set ARN to apply event logging to. The ConfigurateSetName and ConfigurationSetArn can be
  found using the DescribeConfigurationSets action.
- `event_destination_name`: The name that identifies the event destination.
- `matching_event_types`: An array of event types that determine which events to log. If
  \"ALL\" is used, then Amazon Pinpoint logs every event type.  The TEXT_SENT event type is
  not supported.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientToken"`: Unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request. If you don't specify a client token, a randomly generated token
  is used for the request to ensure idempotency.
- `"CloudWatchLogsDestination"`: An object that contains information about an event
  destination for logging to Amazon CloudWatch Logs.
- `"KinesisFirehoseDestination"`: An object that contains information about an event
  destination for logging to Amazon Kinesis Data Firehose.
- `"SnsDestination"`: An object that contains information about an event destination for
  logging to Amazon SNS.
"""
function create_event_destination(
    ConfigurationSetName,
    EventDestinationName,
    MatchingEventTypes;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint_sms_voice_v2(
        "CreateEventDestination",
        Dict{String,Any}(
            "ConfigurationSetName" => ConfigurationSetName,
            "EventDestinationName" => EventDestinationName,
            "MatchingEventTypes" => MatchingEventTypes,
            "ClientToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_event_destination(
    ConfigurationSetName,
    EventDestinationName,
    MatchingEventTypes,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint_sms_voice_v2(
        "CreateEventDestination",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ConfigurationSetName" => ConfigurationSetName,
                    "EventDestinationName" => EventDestinationName,
                    "MatchingEventTypes" => MatchingEventTypes,
                    "ClientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_opt_out_list(opt_out_list_name)
    create_opt_out_list(opt_out_list_name, params::Dict{String,<:Any})

Creates a new opt-out list. If the opt-out list name already exists, an error is returned.
An opt-out list is a list of phone numbers that are opted out, meaning you can't send SMS
or voice messages to them. If end user replies with the keyword \"STOP,\" an entry for the
phone number is added to the opt-out list. In addition to STOP, your recipients can use any
supported opt-out keyword, such as CANCEL or OPTOUT. For a list of supported opt-out
keywords, see  SMS opt out  in the Amazon Pinpoint User Guide.

# Arguments
- `opt_out_list_name`: The name of the new OptOutList.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientToken"`: Unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request. If you don't specify a client token, a randomly generated token
  is used for the request to ensure idempotency.
- `"Tags"`: An array of tags (key and value pairs) to associate with the new OptOutList.
"""
function create_opt_out_list(
    OptOutListName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint_sms_voice_v2(
        "CreateOptOutList",
        Dict{String,Any}(
            "OptOutListName" => OptOutListName, "ClientToken" => string(uuid4())
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_opt_out_list(
    OptOutListName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint_sms_voice_v2(
        "CreateOptOutList",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "OptOutListName" => OptOutListName, "ClientToken" => string(uuid4())
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_pool(iso_country_code, message_type, origination_identity)
    create_pool(iso_country_code, message_type, origination_identity, params::Dict{String,<:Any})

Creates a new pool and associates the specified origination identity to the pool. A pool
can include one or more phone numbers and SenderIds that are associated with your Amazon
Web Services account. The new pool inherits its configuration from the specified
origination identity. This includes keywords, message type, opt-out list, two-way
configuration, and self-managed opt-out configuration. Deletion protection isn't inherited
from the origination identity and defaults to false. If the origination identity is a phone
number and is already associated with another pool, an error is returned. A sender ID can
be associated with multiple pools.

# Arguments
- `iso_country_code`: The new two-character code, in ISO 3166-1 alpha-2 format, for the
  country or region of the new pool.
- `message_type`: The type of message. Valid values are TRANSACTIONAL for messages that are
  critical or time-sensitive and PROMOTIONAL for messages that aren't critical or
  time-sensitive.
- `origination_identity`: The origination identity to use such as a PhoneNumberId,
  PhoneNumberArn, SenderId or SenderIdArn. You can use DescribePhoneNumbers to find the
  values for PhoneNumberId and PhoneNumberArn while DescribeSenderIds can be used to get the
  values for SenderId and SenderIdArn.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientToken"`: Unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request. If you don't specify a client token, a randomly generated token
  is used for the request to ensure idempotency.
- `"DeletionProtectionEnabled"`: By default this is set to false. When set to true the pool
  can't be deleted. You can change this value using the UpdatePool action.
- `"Tags"`: An array of tags (key and value pairs) associated with the pool.
"""
function create_pool(
    IsoCountryCode,
    MessageType,
    OriginationIdentity;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint_sms_voice_v2(
        "CreatePool",
        Dict{String,Any}(
            "IsoCountryCode" => IsoCountryCode,
            "MessageType" => MessageType,
            "OriginationIdentity" => OriginationIdentity,
            "ClientToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_pool(
    IsoCountryCode,
    MessageType,
    OriginationIdentity,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint_sms_voice_v2(
        "CreatePool",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "IsoCountryCode" => IsoCountryCode,
                    "MessageType" => MessageType,
                    "OriginationIdentity" => OriginationIdentity,
                    "ClientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_protect_configuration()
    create_protect_configuration(params::Dict{String,<:Any})

Create a new protect configuration. By default all country rule sets for each capability
are set to ALLOW. Update the country rule sets using
UpdateProtectConfigurationCountryRuleSet. A protect configurations name is stored as a Tag
with the key set to Name and value as the name of the protect configuration.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientToken"`: Unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request. If you don't specify a client token, a randomly generated token
  is used for the request to ensure idempotency.
- `"DeletionProtectionEnabled"`: When set to true deletion protection is enabled. By
  default this is set to false.
- `"Tags"`: An array of key and value pair tags that are associated with the resource.
"""
function create_protect_configuration(; aws_config::AbstractAWSConfig=current_aws_config())
    return pinpoint_sms_voice_v2(
        "CreateProtectConfiguration",
        Dict{String,Any}("ClientToken" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_protect_configuration(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint_sms_voice_v2(
        "CreateProtectConfiguration",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ClientToken" => string(uuid4())), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_registration(registration_type)
    create_registration(registration_type, params::Dict{String,<:Any})

Creates a new registration based on the RegistrationType field.

# Arguments
- `registration_type`: The type of registration form to create. The list of
  RegistrationTypes can be found using the DescribeRegistrationTypeDefinitions action.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientToken"`: Unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request. If you don't specify a client token, a randomly generated token
  is used for the request to ensure idempotency.
- `"Tags"`: An array of tags (key and value pairs) to associate with the registration.
"""
function create_registration(
    RegistrationType; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint_sms_voice_v2(
        "CreateRegistration",
        Dict{String,Any}(
            "RegistrationType" => RegistrationType, "ClientToken" => string(uuid4())
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_registration(
    RegistrationType,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint_sms_voice_v2(
        "CreateRegistration",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "RegistrationType" => RegistrationType, "ClientToken" => string(uuid4())
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_registration_association(registration_id, resource_id)
    create_registration_association(registration_id, resource_id, params::Dict{String,<:Any})

Associate the registration with an origination identity such as a phone number or sender ID.

# Arguments
- `registration_id`: The unique identifier for the registration.
- `resource_id`: The unique identifier for the origination identity. For example this could
  be a PhoneNumberId or SenderId.

"""
function create_registration_association(
    RegistrationId, ResourceId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint_sms_voice_v2(
        "CreateRegistrationAssociation",
        Dict{String,Any}("RegistrationId" => RegistrationId, "ResourceId" => ResourceId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_registration_association(
    RegistrationId,
    ResourceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint_sms_voice_v2(
        "CreateRegistrationAssociation",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "RegistrationId" => RegistrationId, "ResourceId" => ResourceId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_registration_attachment()
    create_registration_attachment(params::Dict{String,<:Any})

Create a new registration attachment to use for uploading a file or a URL to a file. The
maximum file size is 1MiB and valid file extensions are PDF, JPEG and PNG. For example,
many sender ID registrations require a signed “letter of authorization” (LOA) to be
submitted.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AttachmentBody"`: The registration file to upload. The maximum file size is 1MiB and
  valid file extensions are PDF, JPEG and PNG.
- `"AttachmentUrl"`: A URL to the required registration file. For example, you can provide
  the S3 object URL.
- `"ClientToken"`: Unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request. If you don't specify a client token, a randomly generated token
  is used for the request to ensure idempotency.
- `"Tags"`: An array of tags (key and value pairs) to associate with the registration
  attachment.
"""
function create_registration_attachment(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint_sms_voice_v2(
        "CreateRegistrationAttachment",
        Dict{String,Any}("ClientToken" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_registration_attachment(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint_sms_voice_v2(
        "CreateRegistrationAttachment",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ClientToken" => string(uuid4())), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_registration_version(registration_id)
    create_registration_version(registration_id, params::Dict{String,<:Any})

Create a new version of the registration and increase the VersionNumber. The previous
version of the registration becomes read-only.

# Arguments
- `registration_id`: The unique identifier for the registration.

"""
function create_registration_version(
    RegistrationId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint_sms_voice_v2(
        "CreateRegistrationVersion",
        Dict{String,Any}("RegistrationId" => RegistrationId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_registration_version(
    RegistrationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint_sms_voice_v2(
        "CreateRegistrationVersion",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("RegistrationId" => RegistrationId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_verified_destination_number(destination_phone_number)
    create_verified_destination_number(destination_phone_number, params::Dict{String,<:Any})

You can only send messages to verified destination numbers when your account is in the
sandbox. You can add up to 10 verified destination numbers.

# Arguments
- `destination_phone_number`: The verified destination phone number, in E.164 format.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientToken"`: Unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request. If you don't specify a client token, a randomly generated token
  is used for the request to ensure idempotency.
- `"Tags"`: An array of tags (key and value pairs) to associate with the destination number.
"""
function create_verified_destination_number(
    DestinationPhoneNumber; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint_sms_voice_v2(
        "CreateVerifiedDestinationNumber",
        Dict{String,Any}(
            "DestinationPhoneNumber" => DestinationPhoneNumber,
            "ClientToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_verified_destination_number(
    DestinationPhoneNumber,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint_sms_voice_v2(
        "CreateVerifiedDestinationNumber",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "DestinationPhoneNumber" => DestinationPhoneNumber,
                    "ClientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_account_default_protect_configuration()
    delete_account_default_protect_configuration(params::Dict{String,<:Any})

Removes the current account default protect configuration.

"""
function delete_account_default_protect_configuration(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint_sms_voice_v2(
        "DeleteAccountDefaultProtectConfiguration";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_account_default_protect_configuration(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint_sms_voice_v2(
        "DeleteAccountDefaultProtectConfiguration",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_configuration_set(configuration_set_name)
    delete_configuration_set(configuration_set_name, params::Dict{String,<:Any})

Deletes an existing configuration set. A configuration set is a set of rules that you apply
to voice and SMS messages that you send. In a configuration set, you can specify a
destination for specific types of events related to voice and SMS messages.

# Arguments
- `configuration_set_name`: The name of the configuration set or the configuration set ARN
  that you want to delete. The ConfigurationSetName and ConfigurationSetArn can be found
  using the DescribeConfigurationSets action.

"""
function delete_configuration_set(
    ConfigurationSetName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint_sms_voice_v2(
        "DeleteConfigurationSet",
        Dict{String,Any}("ConfigurationSetName" => ConfigurationSetName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_configuration_set(
    ConfigurationSetName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint_sms_voice_v2(
        "DeleteConfigurationSet",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ConfigurationSetName" => ConfigurationSetName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_default_message_type(configuration_set_name)
    delete_default_message_type(configuration_set_name, params::Dict{String,<:Any})

Deletes an existing default message type on a configuration set.  A message type is a type
of messages that you plan to send. If you send account-related messages or time-sensitive
messages such as one-time passcodes, choose Transactional. If you plan to send messages
that contain marketing material or other promotional content, choose Promotional. This
setting applies to your entire Amazon Web Services account.

# Arguments
- `configuration_set_name`: The name of the configuration set or the configuration set
  Amazon Resource Name (ARN) to delete the default message type from. The
  ConfigurationSetName and ConfigurationSetArn can be found using the
  DescribeConfigurationSets action.

"""
function delete_default_message_type(
    ConfigurationSetName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint_sms_voice_v2(
        "DeleteDefaultMessageType",
        Dict{String,Any}("ConfigurationSetName" => ConfigurationSetName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_default_message_type(
    ConfigurationSetName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint_sms_voice_v2(
        "DeleteDefaultMessageType",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ConfigurationSetName" => ConfigurationSetName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_default_sender_id(configuration_set_name)
    delete_default_sender_id(configuration_set_name, params::Dict{String,<:Any})

Deletes an existing default sender ID on a configuration set. A default sender ID is the
identity that appears on recipients' devices when they receive SMS messages. Support for
sender ID capabilities varies by country or region.

# Arguments
- `configuration_set_name`: The name of the configuration set or the configuration set
  Amazon Resource Name (ARN) to delete the default sender ID from. The ConfigurationSetName
  and ConfigurationSetArn can be found using the DescribeConfigurationSets action.

"""
function delete_default_sender_id(
    ConfigurationSetName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint_sms_voice_v2(
        "DeleteDefaultSenderId",
        Dict{String,Any}("ConfigurationSetName" => ConfigurationSetName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_default_sender_id(
    ConfigurationSetName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint_sms_voice_v2(
        "DeleteDefaultSenderId",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ConfigurationSetName" => ConfigurationSetName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_event_destination(configuration_set_name, event_destination_name)
    delete_event_destination(configuration_set_name, event_destination_name, params::Dict{String,<:Any})

Deletes an existing event destination. An event destination is a location where you send
response information about the messages that you send. For example, when a message is
delivered successfully, you can send information about that event to an Amazon CloudWatch
destination, or send notifications to endpoints that are subscribed to an Amazon SNS topic.

# Arguments
- `configuration_set_name`: The name of the configuration set or the configuration set's
  Amazon Resource Name (ARN) to remove the event destination from. The ConfigurateSetName and
  ConfigurationSetArn can be found using the DescribeConfigurationSets action.
- `event_destination_name`: The name of the event destination to delete.

"""
function delete_event_destination(
    ConfigurationSetName,
    EventDestinationName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint_sms_voice_v2(
        "DeleteEventDestination",
        Dict{String,Any}(
            "ConfigurationSetName" => ConfigurationSetName,
            "EventDestinationName" => EventDestinationName,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_event_destination(
    ConfigurationSetName,
    EventDestinationName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint_sms_voice_v2(
        "DeleteEventDestination",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ConfigurationSetName" => ConfigurationSetName,
                    "EventDestinationName" => EventDestinationName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_keyword(keyword, origination_identity)
    delete_keyword(keyword, origination_identity, params::Dict{String,<:Any})

Deletes an existing keyword from an origination phone number or pool. A keyword is a word
that you can search for on a particular phone number or pool. It is also a specific word or
phrase that an end user can send to your number to elicit a response, such as an
informational message or a special offer. When your number receives a message that begins
with a keyword, Amazon Pinpoint responds with a customizable message. Keywords \"HELP\" and
\"STOP\" can't be deleted or modified.

# Arguments
- `keyword`: The keyword to delete.
- `origination_identity`: The origination identity to use such as a PhoneNumberId,
  PhoneNumberArn, PoolId or PoolArn. You can use DescribePhoneNumbers to find the values for
  PhoneNumberId and PhoneNumberArn and DescribePools to find the values of PoolId and PoolArn.

"""
function delete_keyword(
    Keyword, OriginationIdentity; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint_sms_voice_v2(
        "DeleteKeyword",
        Dict{String,Any}(
            "Keyword" => Keyword, "OriginationIdentity" => OriginationIdentity
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_keyword(
    Keyword,
    OriginationIdentity,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint_sms_voice_v2(
        "DeleteKeyword",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "Keyword" => Keyword, "OriginationIdentity" => OriginationIdentity
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_media_message_spend_limit_override()
    delete_media_message_spend_limit_override(params::Dict{String,<:Any})

Deletes an account-level monthly spending limit override for sending multimedia messages
(MMS). Deleting a spend limit override will set the EnforcedLimit to equal the MaxLimit,
which is controlled by Amazon Web Services. For more information on spend limits (quotas)
see Quotas for Server Migration Service in the Server Migration Service User Guide.

"""
function delete_media_message_spend_limit_override(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint_sms_voice_v2(
        "DeleteMediaMessageSpendLimitOverride";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_media_message_spend_limit_override(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint_sms_voice_v2(
        "DeleteMediaMessageSpendLimitOverride",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_opt_out_list(opt_out_list_name)
    delete_opt_out_list(opt_out_list_name, params::Dict{String,<:Any})

Deletes an existing opt-out list. All opted out phone numbers in the opt-out list are
deleted. If the specified opt-out list name doesn't exist or is in-use by an origination
phone number or pool, an error is returned.

# Arguments
- `opt_out_list_name`: The OptOutListName or OptOutListArn of the OptOutList to delete. You
  can use DescribeOptOutLists to find the values for OptOutListName and OptOutListArn.

"""
function delete_opt_out_list(
    OptOutListName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint_sms_voice_v2(
        "DeleteOptOutList",
        Dict{String,Any}("OptOutListName" => OptOutListName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_opt_out_list(
    OptOutListName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint_sms_voice_v2(
        "DeleteOptOutList",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("OptOutListName" => OptOutListName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_opted_out_number(opt_out_list_name, opted_out_number)
    delete_opted_out_number(opt_out_list_name, opted_out_number, params::Dict{String,<:Any})

Deletes an existing opted out destination phone number from the specified opt-out list.
Each destination phone number can only be deleted once every 30 days. If the specified
destination phone number doesn't exist or if the opt-out list doesn't exist, an error is
returned.

# Arguments
- `opt_out_list_name`: The OptOutListName or OptOutListArn to remove the phone number from.
- `opted_out_number`: The phone number, in E.164 format, to remove from the OptOutList.

"""
function delete_opted_out_number(
    OptOutListName, OptedOutNumber; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint_sms_voice_v2(
        "DeleteOptedOutNumber",
        Dict{String,Any}(
            "OptOutListName" => OptOutListName, "OptedOutNumber" => OptedOutNumber
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_opted_out_number(
    OptOutListName,
    OptedOutNumber,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint_sms_voice_v2(
        "DeleteOptedOutNumber",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "OptOutListName" => OptOutListName, "OptedOutNumber" => OptedOutNumber
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_pool(pool_id)
    delete_pool(pool_id, params::Dict{String,<:Any})

Deletes an existing pool. Deleting a pool disassociates all origination identities from
that pool. If the pool status isn't active or if deletion protection is enabled, an error
is returned. A pool is a collection of phone numbers and SenderIds. A pool can include one
or more phone numbers and SenderIds that are associated with your Amazon Web Services
account.

# Arguments
- `pool_id`: The PoolId or PoolArn of the pool to delete. You can use DescribePools to find
  the values for PoolId and PoolArn .

"""
function delete_pool(PoolId; aws_config::AbstractAWSConfig=current_aws_config())
    return pinpoint_sms_voice_v2(
        "DeletePool",
        Dict{String,Any}("PoolId" => PoolId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_pool(
    PoolId, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint_sms_voice_v2(
        "DeletePool",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("PoolId" => PoolId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_protect_configuration(protect_configuration_id)
    delete_protect_configuration(protect_configuration_id, params::Dict{String,<:Any})

Permanently delete the protect configuration. The protect configuration must have deletion
protection disabled and must not be associated as the account default protect configuration
or associated with a configuration set.

# Arguments
- `protect_configuration_id`: The unique identifier for the protect configuration.

"""
function delete_protect_configuration(
    ProtectConfigurationId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint_sms_voice_v2(
        "DeleteProtectConfiguration",
        Dict{String,Any}("ProtectConfigurationId" => ProtectConfigurationId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_protect_configuration(
    ProtectConfigurationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint_sms_voice_v2(
        "DeleteProtectConfiguration",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ProtectConfigurationId" => ProtectConfigurationId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_registration(registration_id)
    delete_registration(registration_id, params::Dict{String,<:Any})

Permanently delete an existing registration from your account.

# Arguments
- `registration_id`: The unique identifier for the registration.

"""
function delete_registration(
    RegistrationId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint_sms_voice_v2(
        "DeleteRegistration",
        Dict{String,Any}("RegistrationId" => RegistrationId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_registration(
    RegistrationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint_sms_voice_v2(
        "DeleteRegistration",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("RegistrationId" => RegistrationId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_registration_attachment(registration_attachment_id)
    delete_registration_attachment(registration_attachment_id, params::Dict{String,<:Any})

Permanently delete the specified registration attachment.

# Arguments
- `registration_attachment_id`: The unique identifier for the registration attachment.

"""
function delete_registration_attachment(
    RegistrationAttachmentId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint_sms_voice_v2(
        "DeleteRegistrationAttachment",
        Dict{String,Any}("RegistrationAttachmentId" => RegistrationAttachmentId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_registration_attachment(
    RegistrationAttachmentId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint_sms_voice_v2(
        "DeleteRegistrationAttachment",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("RegistrationAttachmentId" => RegistrationAttachmentId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_registration_field_value(field_path, registration_id)
    delete_registration_field_value(field_path, registration_id, params::Dict{String,<:Any})

Delete the value in a registration form field.

# Arguments
- `field_path`: The path to the registration form field. You can use
  DescribeRegistrationFieldDefinitions for a list of FieldPaths.
- `registration_id`: The unique identifier for the registration.

"""
function delete_registration_field_value(
    FieldPath, RegistrationId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint_sms_voice_v2(
        "DeleteRegistrationFieldValue",
        Dict{String,Any}("FieldPath" => FieldPath, "RegistrationId" => RegistrationId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_registration_field_value(
    FieldPath,
    RegistrationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint_sms_voice_v2(
        "DeleteRegistrationFieldValue",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "FieldPath" => FieldPath, "RegistrationId" => RegistrationId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_text_message_spend_limit_override()
    delete_text_message_spend_limit_override(params::Dict{String,<:Any})

Deletes an account-level monthly spending limit override for sending text messages.
Deleting a spend limit override will set the EnforcedLimit to equal the MaxLimit, which is
controlled by Amazon Web Services. For more information on spend limits (quotas) see Amazon
Pinpoint quotas  in the Amazon Pinpoint Developer Guide.

"""
function delete_text_message_spend_limit_override(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint_sms_voice_v2(
        "DeleteTextMessageSpendLimitOverride";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_text_message_spend_limit_override(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint_sms_voice_v2(
        "DeleteTextMessageSpendLimitOverride",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_verified_destination_number(verified_destination_number_id)
    delete_verified_destination_number(verified_destination_number_id, params::Dict{String,<:Any})

Delete a verified destination phone number.

# Arguments
- `verified_destination_number_id`: The unique identifier for the verified destination
  phone number.

"""
function delete_verified_destination_number(
    VerifiedDestinationNumberId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint_sms_voice_v2(
        "DeleteVerifiedDestinationNumber",
        Dict{String,Any}("VerifiedDestinationNumberId" => VerifiedDestinationNumberId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_verified_destination_number(
    VerifiedDestinationNumberId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint_sms_voice_v2(
        "DeleteVerifiedDestinationNumber",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "VerifiedDestinationNumberId" => VerifiedDestinationNumberId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_voice_message_spend_limit_override()
    delete_voice_message_spend_limit_override(params::Dict{String,<:Any})

Deletes an account level monthly spend limit override for sending voice messages. Deleting
a spend limit override sets the EnforcedLimit equal to the MaxLimit, which is controlled by
Amazon Web Services. For more information on spending limits (quotas) see Amazon Pinpoint
quotas in the Amazon Pinpoint Developer Guide.

"""
function delete_voice_message_spend_limit_override(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint_sms_voice_v2(
        "DeleteVoiceMessageSpendLimitOverride";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_voice_message_spend_limit_override(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint_sms_voice_v2(
        "DeleteVoiceMessageSpendLimitOverride",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_account_attributes()
    describe_account_attributes(params::Dict{String,<:Any})

Describes attributes of your Amazon Web Services account. The supported account attributes
include account tier, which indicates whether your account is in the sandbox or production
environment. When you're ready to move your account out of the sandbox, create an Amazon
Web Services Support case for a service limit increase request. New Amazon Pinpoint
accounts are placed into an SMS or voice sandbox. The sandbox protects both Amazon Web
Services end recipients and SMS or voice recipients from fraud and abuse.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of results to return per each request.
- `"NextToken"`: The token to be used for the next set of paginated results. You don't need
  to supply a value for this field in the initial request.
"""
function describe_account_attributes(; aws_config::AbstractAWSConfig=current_aws_config())
    return pinpoint_sms_voice_v2(
        "DescribeAccountAttributes"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_account_attributes(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint_sms_voice_v2(
        "DescribeAccountAttributes",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_account_limits()
    describe_account_limits(params::Dict{String,<:Any})

Describes the current Amazon Pinpoint SMS Voice V2 resource quotas for your account. The
description for a quota includes the quota name, current usage toward that quota, and the
quota's maximum value. When you establish an Amazon Web Services account, the account has
initial quotas on the maximum number of configuration sets, opt-out lists, phone numbers,
and pools that you can create in a given Region. For more information see  Amazon Pinpoint
quotas  in the Amazon Pinpoint Developer Guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of results to return per each request.
- `"NextToken"`: The token to be used for the next set of paginated results. You don't need
  to supply a value for this field in the initial request.
"""
function describe_account_limits(; aws_config::AbstractAWSConfig=current_aws_config())
    return pinpoint_sms_voice_v2(
        "DescribeAccountLimits"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_account_limits(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint_sms_voice_v2(
        "DescribeAccountLimits",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_configuration_sets()
    describe_configuration_sets(params::Dict{String,<:Any})

Describes the specified configuration sets or all in your account. If you specify
configuration set names, the output includes information for only the specified
configuration sets. If you specify filters, the output includes information for only those
configuration sets that meet the filter criteria. If you don't specify configuration set
names or filters, the output includes information for all configuration sets. If you
specify a configuration set name that isn't valid, an error is returned.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ConfigurationSetNames"`: An array of strings. Each element can be either a
  ConfigurationSetName or ConfigurationSetArn.
- `"Filters"`: An array of filters to apply to the results that are returned.
- `"MaxResults"`: The maximum number of results to return per each request.
- `"NextToken"`: The token to be used for the next set of paginated results. You don't need
  to supply a value for this field in the initial request.
"""
function describe_configuration_sets(; aws_config::AbstractAWSConfig=current_aws_config())
    return pinpoint_sms_voice_v2(
        "DescribeConfigurationSets"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_configuration_sets(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint_sms_voice_v2(
        "DescribeConfigurationSets",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_keywords(origination_identity)
    describe_keywords(origination_identity, params::Dict{String,<:Any})

Describes the specified keywords or all keywords on your origination phone number or pool.
A keyword is a word that you can search for on a particular phone number or pool. It is
also a specific word or phrase that an end user can send to your number to elicit a
response, such as an informational message or a special offer. When your number receives a
message that begins with a keyword, Amazon Pinpoint responds with a customizable message.
If you specify a keyword that isn't valid, an error is returned.

# Arguments
- `origination_identity`: The origination identity to use such as a PhoneNumberId,
  PhoneNumberArn, SenderId or SenderIdArn. You can use DescribePhoneNumbers to find the
  values for PhoneNumberId and PhoneNumberArn while DescribeSenderIds can be used to get the
  values for SenderId and SenderIdArn.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filters"`: An array of keyword filters to filter the results.
- `"Keywords"`: An array of keywords to search for.
- `"MaxResults"`: The maximum number of results to return per each request.
- `"NextToken"`: The token to be used for the next set of paginated results. You don't need
  to supply a value for this field in the initial request.
"""
function describe_keywords(
    OriginationIdentity; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint_sms_voice_v2(
        "DescribeKeywords",
        Dict{String,Any}("OriginationIdentity" => OriginationIdentity);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_keywords(
    OriginationIdentity,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint_sms_voice_v2(
        "DescribeKeywords",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("OriginationIdentity" => OriginationIdentity),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_opt_out_lists()
    describe_opt_out_lists(params::Dict{String,<:Any})

Describes the specified opt-out list or all opt-out lists in your account. If you specify
opt-out list names, the output includes information for only the specified opt-out lists.
Opt-out lists include only those that meet the filter criteria. If you don't specify
opt-out list names or filters, the output includes information for all opt-out lists. If
you specify an opt-out list name that isn't valid, an error is returned.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of results to return per each request.
- `"NextToken"`: The token to be used for the next set of paginated results. You don't need
  to supply a value for this field in the initial request.
- `"OptOutListNames"`: The OptOutLists to show the details of. This is an array of strings
  that can be either the OptOutListName or OptOutListArn.
"""
function describe_opt_out_lists(; aws_config::AbstractAWSConfig=current_aws_config())
    return pinpoint_sms_voice_v2(
        "DescribeOptOutLists"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_opt_out_lists(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint_sms_voice_v2(
        "DescribeOptOutLists",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_opted_out_numbers(opt_out_list_name)
    describe_opted_out_numbers(opt_out_list_name, params::Dict{String,<:Any})

Describes the specified opted out destination numbers or all opted out destination numbers
in an opt-out list. If you specify opted out numbers, the output includes information for
only the specified opted out numbers. If you specify filters, the output includes
information for only those opted out numbers that meet the filter criteria. If you don't
specify opted out numbers or filters, the output includes information for all opted out
destination numbers in your opt-out list. If you specify an opted out number that isn't
valid, an error is returned.

# Arguments
- `opt_out_list_name`: The OptOutListName or OptOutListArn of the OptOutList. You can use
  DescribeOptOutLists to find the values for OptOutListName and OptOutListArn.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filters"`: An array of OptedOutFilter objects to filter the results on.
- `"MaxResults"`: The maximum number of results to return per each request.
- `"NextToken"`: The token to be used for the next set of paginated results. You don't need
  to supply a value for this field in the initial request.
- `"OptedOutNumbers"`: An array of phone numbers to search for in the OptOutList.
"""
function describe_opted_out_numbers(
    OptOutListName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint_sms_voice_v2(
        "DescribeOptedOutNumbers",
        Dict{String,Any}("OptOutListName" => OptOutListName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_opted_out_numbers(
    OptOutListName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint_sms_voice_v2(
        "DescribeOptedOutNumbers",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("OptOutListName" => OptOutListName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_phone_numbers()
    describe_phone_numbers(params::Dict{String,<:Any})

Describes the specified origination phone number, or all the phone numbers in your account.
If you specify phone number IDs, the output includes information for only the specified
phone numbers. If you specify filters, the output includes information for only those phone
numbers that meet the filter criteria. If you don't specify phone number IDs or filters,
the output includes information for all phone numbers. If you specify a phone number ID
that isn't valid, an error is returned.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filters"`: An array of PhoneNumberFilter objects to filter the results.
- `"MaxResults"`: The maximum number of results to return per each request.
- `"NextToken"`: The token to be used for the next set of paginated results. You don't need
  to supply a value for this field in the initial request.
- `"PhoneNumberIds"`: The unique identifier of phone numbers to find information about.
  This is an array of strings that can be either the PhoneNumberId or PhoneNumberArn.
"""
function describe_phone_numbers(; aws_config::AbstractAWSConfig=current_aws_config())
    return pinpoint_sms_voice_v2(
        "DescribePhoneNumbers"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_phone_numbers(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint_sms_voice_v2(
        "DescribePhoneNumbers",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_pools()
    describe_pools(params::Dict{String,<:Any})

Retrieves the specified pools or all pools associated with your Amazon Web Services
account. If you specify pool IDs, the output includes information for only the specified
pools. If you specify filters, the output includes information for only those pools that
meet the filter criteria. If you don't specify pool IDs or filters, the output includes
information for all pools. If you specify a pool ID that isn't valid, an error is returned.
A pool is a collection of phone numbers and SenderIds. A pool can include one or more phone
numbers and SenderIds that are associated with your Amazon Web Services account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filters"`: An array of PoolFilter objects to filter the results.
- `"MaxResults"`: The maximum number of results to return per each request.
- `"NextToken"`: The token to be used for the next set of paginated results. You don't need
  to supply a value for this field in the initial request.
- `"PoolIds"`: The unique identifier of pools to find. This is an array of strings that can
  be either the PoolId or PoolArn.
"""
function describe_pools(; aws_config::AbstractAWSConfig=current_aws_config())
    return pinpoint_sms_voice_v2(
        "DescribePools"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_pools(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint_sms_voice_v2(
        "DescribePools", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    describe_protect_configurations()
    describe_protect_configurations(params::Dict{String,<:Any})

Retrieves the protect configurations that match any of filters. If a filter isn’t
provided then all protect configurations are returned.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filters"`: An array of ProtectConfigurationFilter objects to filter the results.
- `"MaxResults"`: The maximum number of results to return per each request.
- `"NextToken"`: The token to be used for the next set of paginated results. You don't need
  to supply a value for this field in the initial request.
- `"ProtectConfigurationIds"`: An array of protect configuration identifiers to search for.
"""
function describe_protect_configurations(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint_sms_voice_v2(
        "DescribeProtectConfigurations";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_protect_configurations(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint_sms_voice_v2(
        "DescribeProtectConfigurations",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_registration_attachments()
    describe_registration_attachments(params::Dict{String,<:Any})

Retrieves the specified registration attachments or all registration attachments associated
with your Amazon Web Services account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filters"`: An array of RegistrationAttachmentFilter objects to filter the results.
- `"MaxResults"`: The maximum number of results to return per each request.
- `"NextToken"`: The token to be used for the next set of paginated results. You don't need
  to supply a value for this field in the initial request.
- `"RegistrationAttachmentIds"`: The unique identifier of registration attachments to find.
  This is an array of RegistrationAttachmentId.
"""
function describe_registration_attachments(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint_sms_voice_v2(
        "DescribeRegistrationAttachments";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_registration_attachments(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint_sms_voice_v2(
        "DescribeRegistrationAttachments",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_registration_field_definitions(registration_type)
    describe_registration_field_definitions(registration_type, params::Dict{String,<:Any})

Retrieves the specified registration type field definitions. You can use
DescribeRegistrationFieldDefinitions to view the requirements for creating, filling out,
and submitting each registration type.

# Arguments
- `registration_type`: The type of registration form. The list of RegistrationTypes can be
  found using the DescribeRegistrationTypeDefinitions action.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"FieldPaths"`: An array of paths to the registration form field.
- `"MaxResults"`: The maximum number of results to return per each request.
- `"NextToken"`: The token to be used for the next set of paginated results. You don't need
  to supply a value for this field in the initial request.
- `"SectionPath"`: The path to the section of the registration.
"""
function describe_registration_field_definitions(
    RegistrationType; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint_sms_voice_v2(
        "DescribeRegistrationFieldDefinitions",
        Dict{String,Any}("RegistrationType" => RegistrationType);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_registration_field_definitions(
    RegistrationType,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint_sms_voice_v2(
        "DescribeRegistrationFieldDefinitions",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("RegistrationType" => RegistrationType), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_registration_field_values(registration_id)
    describe_registration_field_values(registration_id, params::Dict{String,<:Any})

Retrieves the specified registration field values.

# Arguments
- `registration_id`: The unique identifier for the registration.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"FieldPaths"`: An array of paths to the registration form field.
- `"MaxResults"`: The maximum number of results to return per each request.
- `"NextToken"`: The token to be used for the next set of paginated results. You don't need
  to supply a value for this field in the initial request.
- `"SectionPath"`: The path to the section of the registration.
- `"VersionNumber"`: The version number of the registration.
"""
function describe_registration_field_values(
    RegistrationId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint_sms_voice_v2(
        "DescribeRegistrationFieldValues",
        Dict{String,Any}("RegistrationId" => RegistrationId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_registration_field_values(
    RegistrationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint_sms_voice_v2(
        "DescribeRegistrationFieldValues",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("RegistrationId" => RegistrationId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_registration_section_definitions(registration_type)
    describe_registration_section_definitions(registration_type, params::Dict{String,<:Any})

Retrieves the specified registration section definitions. You can use
DescribeRegistrationSectionDefinitions to view the requirements for creating, filling out,
and submitting each registration type.

# Arguments
- `registration_type`: The type of registration form. The list of RegistrationTypes can be
  found using the DescribeRegistrationTypeDefinitions action.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of results to return per each request.
- `"NextToken"`: The token to be used for the next set of paginated results. You don't need
  to supply a value for this field in the initial request.
- `"SectionPaths"`: An array of paths for the registration form section.
"""
function describe_registration_section_definitions(
    RegistrationType; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint_sms_voice_v2(
        "DescribeRegistrationSectionDefinitions",
        Dict{String,Any}("RegistrationType" => RegistrationType);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_registration_section_definitions(
    RegistrationType,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint_sms_voice_v2(
        "DescribeRegistrationSectionDefinitions",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("RegistrationType" => RegistrationType), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_registration_type_definitions()
    describe_registration_type_definitions(params::Dict{String,<:Any})

Retrieves the specified registration type definitions. You can use
DescribeRegistrationTypeDefinitions to view the requirements for creating, filling out, and
submitting each registration type.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filters"`: An array of RegistrationFilter objects to filter the results.
- `"MaxResults"`: The maximum number of results to return per each request.
- `"NextToken"`: The token to be used for the next set of paginated results. You don't need
  to supply a value for this field in the initial request.
- `"RegistrationTypes"`: The type of registration form. The list of RegistrationTypes can
  be found using the DescribeRegistrationTypeDefinitions action.
"""
function describe_registration_type_definitions(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint_sms_voice_v2(
        "DescribeRegistrationTypeDefinitions";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_registration_type_definitions(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint_sms_voice_v2(
        "DescribeRegistrationTypeDefinitions",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_registration_versions(registration_id)
    describe_registration_versions(registration_id, params::Dict{String,<:Any})

Retrieves the specified registration version.

# Arguments
- `registration_id`: The unique identifier for the registration.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filters"`: An array of RegistrationVersionFilter objects to filter the results.
- `"MaxResults"`: The maximum number of results to return per each request.
- `"NextToken"`: The token to be used for the next set of paginated results. You don't need
  to supply a value for this field in the initial request.
- `"VersionNumbers"`: An array of registration version numbers.
"""
function describe_registration_versions(
    RegistrationId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint_sms_voice_v2(
        "DescribeRegistrationVersions",
        Dict{String,Any}("RegistrationId" => RegistrationId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_registration_versions(
    RegistrationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint_sms_voice_v2(
        "DescribeRegistrationVersions",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("RegistrationId" => RegistrationId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_registrations()
    describe_registrations(params::Dict{String,<:Any})

Retrieves the specified registrations.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filters"`: An array of RegistrationFilter objects to filter the results.
- `"MaxResults"`: The maximum number of results to return per each request.
- `"NextToken"`: The token to be used for the next set of paginated results. You don't need
  to supply a value for this field in the initial request.
- `"RegistrationIds"`: An array of unique identifiers for each registration.
"""
function describe_registrations(; aws_config::AbstractAWSConfig=current_aws_config())
    return pinpoint_sms_voice_v2(
        "DescribeRegistrations"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_registrations(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint_sms_voice_v2(
        "DescribeRegistrations",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_sender_ids()
    describe_sender_ids(params::Dict{String,<:Any})

Describes the specified SenderIds or all SenderIds associated with your Amazon Web Services
account. If you specify SenderIds, the output includes information for only the specified
SenderIds. If you specify filters, the output includes information for only those SenderIds
that meet the filter criteria. If you don't specify SenderIds or filters, the output
includes information for all SenderIds. f you specify a sender ID that isn't valid, an
error is returned.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filters"`: An array of SenderIdFilter objects to filter the results.
- `"MaxResults"`: The maximum number of results to return per each request.
- `"NextToken"`: The token to be used for the next set of paginated results. You don't need
  to supply a value for this field in the initial request.
- `"SenderIds"`: An array of SenderIdAndCountry objects to search for.
"""
function describe_sender_ids(; aws_config::AbstractAWSConfig=current_aws_config())
    return pinpoint_sms_voice_v2(
        "DescribeSenderIds"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_sender_ids(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint_sms_voice_v2(
        "DescribeSenderIds", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    describe_spend_limits()
    describe_spend_limits(params::Dict{String,<:Any})

Describes the current Amazon Pinpoint monthly spend limits for sending voice and text
messages. When you establish an Amazon Web Services account, the account has initial
monthly spend limit in a given Region. For more information on increasing your monthly
spend limit, see  Requesting increases to your monthly SMS spending quota for Amazon
Pinpoint  in the Amazon Pinpoint User Guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of results to return per each request.
- `"NextToken"`: The token to be used for the next set of paginated results. You don't need
  to supply a value for this field in the initial request.
"""
function describe_spend_limits(; aws_config::AbstractAWSConfig=current_aws_config())
    return pinpoint_sms_voice_v2(
        "DescribeSpendLimits"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_spend_limits(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint_sms_voice_v2(
        "DescribeSpendLimits",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_verified_destination_numbers()
    describe_verified_destination_numbers(params::Dict{String,<:Any})

Retrieves the specified verified destiona numbers.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DestinationPhoneNumbers"`: An array of verified destination phone number, in E.164
  format.
- `"Filters"`: An array of VerifiedDestinationNumberFilter objects to filter the results.
- `"MaxResults"`: The maximum number of results to return per each request.
- `"NextToken"`: The token to be used for the next set of paginated results. You don't need
  to supply a value for this field in the initial request.
- `"VerifiedDestinationNumberIds"`: An array of VerifiedDestinationNumberid to retreive.
"""
function describe_verified_destination_numbers(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint_sms_voice_v2(
        "DescribeVerifiedDestinationNumbers";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_verified_destination_numbers(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint_sms_voice_v2(
        "DescribeVerifiedDestinationNumbers",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disassociate_origination_identity(iso_country_code, origination_identity, pool_id)
    disassociate_origination_identity(iso_country_code, origination_identity, pool_id, params::Dict{String,<:Any})

Removes the specified origination identity from an existing pool. If the origination
identity isn't associated with the specified pool, an error is returned.

# Arguments
- `iso_country_code`: The two-character code, in ISO 3166-1 alpha-2 format, for the country
  or region.
- `origination_identity`: The origination identity to use such as a PhoneNumberId,
  PhoneNumberArn, SenderId or SenderIdArn. You can use DescribePhoneNumbers find the values
  for PhoneNumberId and PhoneNumberArn, or use DescribeSenderIds to get the values for
  SenderId and SenderIdArn.
- `pool_id`: The unique identifier for the pool to disassociate with the origination
  identity. This value can be either the PoolId or PoolArn.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientToken"`: Unique, case-sensitive identifier you provide to ensure the idempotency
  of the request. If you don't specify a client token, a randomly generated token is used for
  the request to ensure idempotency.
"""
function disassociate_origination_identity(
    IsoCountryCode,
    OriginationIdentity,
    PoolId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint_sms_voice_v2(
        "DisassociateOriginationIdentity",
        Dict{String,Any}(
            "IsoCountryCode" => IsoCountryCode,
            "OriginationIdentity" => OriginationIdentity,
            "PoolId" => PoolId,
            "ClientToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disassociate_origination_identity(
    IsoCountryCode,
    OriginationIdentity,
    PoolId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint_sms_voice_v2(
        "DisassociateOriginationIdentity",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "IsoCountryCode" => IsoCountryCode,
                    "OriginationIdentity" => OriginationIdentity,
                    "PoolId" => PoolId,
                    "ClientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disassociate_protect_configuration(configuration_set_name, protect_configuration_id)
    disassociate_protect_configuration(configuration_set_name, protect_configuration_id, params::Dict{String,<:Any})

Disassociate a protect configuration from a configuration set.

# Arguments
- `configuration_set_name`: The name of the ConfigurationSet.
- `protect_configuration_id`: The unique identifier for the protect configuration.

"""
function disassociate_protect_configuration(
    ConfigurationSetName,
    ProtectConfigurationId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint_sms_voice_v2(
        "DisassociateProtectConfiguration",
        Dict{String,Any}(
            "ConfigurationSetName" => ConfigurationSetName,
            "ProtectConfigurationId" => ProtectConfigurationId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disassociate_protect_configuration(
    ConfigurationSetName,
    ProtectConfigurationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint_sms_voice_v2(
        "DisassociateProtectConfiguration",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ConfigurationSetName" => ConfigurationSetName,
                    "ProtectConfigurationId" => ProtectConfigurationId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    discard_registration_version(registration_id)
    discard_registration_version(registration_id, params::Dict{String,<:Any})

Discard the current version of the registration.

# Arguments
- `registration_id`: The unique identifier for the registration.

"""
function discard_registration_version(
    RegistrationId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint_sms_voice_v2(
        "DiscardRegistrationVersion",
        Dict{String,Any}("RegistrationId" => RegistrationId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function discard_registration_version(
    RegistrationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint_sms_voice_v2(
        "DiscardRegistrationVersion",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("RegistrationId" => RegistrationId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_protect_configuration_country_rule_set(number_capability, protect_configuration_id)
    get_protect_configuration_country_rule_set(number_capability, protect_configuration_id, params::Dict{String,<:Any})

Retrieve the CountryRuleSet for the specified NumberCapability from a protect configuration.

# Arguments
- `number_capability`: The capability type to return the CountryRuleSet for. Valid values
  are SMS, VOICE, or MMS.
- `protect_configuration_id`: The unique identifier for the protect configuration.

"""
function get_protect_configuration_country_rule_set(
    NumberCapability,
    ProtectConfigurationId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint_sms_voice_v2(
        "GetProtectConfigurationCountryRuleSet",
        Dict{String,Any}(
            "NumberCapability" => NumberCapability,
            "ProtectConfigurationId" => ProtectConfigurationId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_protect_configuration_country_rule_set(
    NumberCapability,
    ProtectConfigurationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint_sms_voice_v2(
        "GetProtectConfigurationCountryRuleSet",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "NumberCapability" => NumberCapability,
                    "ProtectConfigurationId" => ProtectConfigurationId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_pool_origination_identities(pool_id)
    list_pool_origination_identities(pool_id, params::Dict{String,<:Any})

Lists all associated origination identities in your pool. If you specify filters, the
output includes information for only those origination identities that meet the filter
criteria.

# Arguments
- `pool_id`: The unique identifier for the pool. This value can be either the PoolId or
  PoolArn.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filters"`: An array of PoolOriginationIdentitiesFilter objects to filter the results..
- `"MaxResults"`: The maximum number of results to return per each request.
- `"NextToken"`: The token to be used for the next set of paginated results. You don't need
  to supply a value for this field in the initial request.
"""
function list_pool_origination_identities(
    PoolId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint_sms_voice_v2(
        "ListPoolOriginationIdentities",
        Dict{String,Any}("PoolId" => PoolId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_pool_origination_identities(
    PoolId, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint_sms_voice_v2(
        "ListPoolOriginationIdentities",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("PoolId" => PoolId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_registration_associations(registration_id)
    list_registration_associations(registration_id, params::Dict{String,<:Any})

Retreive all of the origination identies that are associated with a registration.

# Arguments
- `registration_id`: The unique identifier for the registration.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filters"`: An array of RegistrationAssociationFilter to apply to the results that are
  returned.
- `"MaxResults"`: The maximum number of results to return per each request.
- `"NextToken"`: The token to be used for the next set of paginated results. You don't need
  to supply a value for this field in the initial request.
"""
function list_registration_associations(
    RegistrationId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint_sms_voice_v2(
        "ListRegistrationAssociations",
        Dict{String,Any}("RegistrationId" => RegistrationId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_registration_associations(
    RegistrationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint_sms_voice_v2(
        "ListRegistrationAssociations",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("RegistrationId" => RegistrationId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_tags_for_resource(resource_arn)
    list_tags_for_resource(resource_arn, params::Dict{String,<:Any})

List all tags associated with a resource.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the resource to query for.

"""
function list_tags_for_resource(
    ResourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint_sms_voice_v2(
        "ListTagsForResource",
        Dict{String,Any}("ResourceArn" => ResourceArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tags_for_resource(
    ResourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint_sms_voice_v2(
        "ListTagsForResource",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ResourceArn" => ResourceArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_keyword(keyword, keyword_message, origination_identity)
    put_keyword(keyword, keyword_message, origination_identity, params::Dict{String,<:Any})

Creates or updates a keyword configuration on an origination phone number or pool.  A
keyword is a word that you can search for on a particular phone number or pool. It is also
a specific word or phrase that an end user can send to your number to elicit a response,
such as an informational message or a special offer. When your number receives a message
that begins with a keyword, Amazon Pinpoint responds with a customizable message. If you
specify a keyword that isn't valid, an error is returned.

# Arguments
- `keyword`: The new keyword to add.
- `keyword_message`: The message associated with the keyword.
- `origination_identity`: The origination identity to use such as a PhoneNumberId,
  PhoneNumberArn, SenderId or SenderIdArn. You can use DescribePhoneNumbers get the values
  for PhoneNumberId and PhoneNumberArn while DescribeSenderIds can be used to get the values
  for SenderId and SenderIdArn.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"KeywordAction"`: The action to perform for the new keyword when it is received.
  AUTOMATIC_RESPONSE: A message is sent to the recipient.   OPT_OUT: Keeps the recipient from
  receiving future messages.   OPT_IN: The recipient wants to receive future messages.
"""
function put_keyword(
    Keyword,
    KeywordMessage,
    OriginationIdentity;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint_sms_voice_v2(
        "PutKeyword",
        Dict{String,Any}(
            "Keyword" => Keyword,
            "KeywordMessage" => KeywordMessage,
            "OriginationIdentity" => OriginationIdentity,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_keyword(
    Keyword,
    KeywordMessage,
    OriginationIdentity,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint_sms_voice_v2(
        "PutKeyword",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "Keyword" => Keyword,
                    "KeywordMessage" => KeywordMessage,
                    "OriginationIdentity" => OriginationIdentity,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_opted_out_number(opt_out_list_name, opted_out_number)
    put_opted_out_number(opt_out_list_name, opted_out_number, params::Dict{String,<:Any})

Creates an opted out destination phone number in the opt-out list. If the destination phone
number isn't valid or if the specified opt-out list doesn't exist, an error is returned.

# Arguments
- `opt_out_list_name`: The OptOutListName or OptOutListArn to add the phone number to.
- `opted_out_number`: The phone number to add to the OptOutList in E.164 format.

"""
function put_opted_out_number(
    OptOutListName, OptedOutNumber; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint_sms_voice_v2(
        "PutOptedOutNumber",
        Dict{String,Any}(
            "OptOutListName" => OptOutListName, "OptedOutNumber" => OptedOutNumber
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_opted_out_number(
    OptOutListName,
    OptedOutNumber,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint_sms_voice_v2(
        "PutOptedOutNumber",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "OptOutListName" => OptOutListName, "OptedOutNumber" => OptedOutNumber
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_registration_field_value(field_path, registration_id)
    put_registration_field_value(field_path, registration_id, params::Dict{String,<:Any})

Creates or updates a field value for a registration.

# Arguments
- `field_path`: The path to the registration form field. You can use
  DescribeRegistrationFieldDefinitions for a list of FieldPaths.
- `registration_id`: The unique identifier for the registration.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"RegistrationAttachmentId"`: The unique identifier for the registration attachment.
- `"SelectChoices"`: An array of values for the form field.
- `"TextValue"`: The text data for a free form field.
"""
function put_registration_field_value(
    FieldPath, RegistrationId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint_sms_voice_v2(
        "PutRegistrationFieldValue",
        Dict{String,Any}("FieldPath" => FieldPath, "RegistrationId" => RegistrationId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_registration_field_value(
    FieldPath,
    RegistrationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint_sms_voice_v2(
        "PutRegistrationFieldValue",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "FieldPath" => FieldPath, "RegistrationId" => RegistrationId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    release_phone_number(phone_number_id)
    release_phone_number(phone_number_id, params::Dict{String,<:Any})

Releases an existing origination phone number in your account. Once released, a phone
number is no longer available for sending messages. If the origination phone number has
deletion protection enabled or is associated with a pool, an error is returned.

# Arguments
- `phone_number_id`: The PhoneNumberId or PhoneNumberArn of the phone number to release.
  You can use DescribePhoneNumbers to get the values for PhoneNumberId and PhoneNumberArn.

"""
function release_phone_number(
    PhoneNumberId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint_sms_voice_v2(
        "ReleasePhoneNumber",
        Dict{String,Any}("PhoneNumberId" => PhoneNumberId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function release_phone_number(
    PhoneNumberId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint_sms_voice_v2(
        "ReleasePhoneNumber",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("PhoneNumberId" => PhoneNumberId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    release_sender_id(iso_country_code, sender_id)
    release_sender_id(iso_country_code, sender_id, params::Dict{String,<:Any})

Releases an existing sender ID in your account.

# Arguments
- `iso_country_code`: The two-character code, in ISO 3166-1 alpha-2 format, for the country
  or region.
- `sender_id`: The sender ID to release.

"""
function release_sender_id(
    IsoCountryCode, SenderId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint_sms_voice_v2(
        "ReleaseSenderId",
        Dict{String,Any}("IsoCountryCode" => IsoCountryCode, "SenderId" => SenderId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function release_sender_id(
    IsoCountryCode,
    SenderId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint_sms_voice_v2(
        "ReleaseSenderId",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "IsoCountryCode" => IsoCountryCode, "SenderId" => SenderId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    request_phone_number(iso_country_code, message_type, number_capabilities, number_type)
    request_phone_number(iso_country_code, message_type, number_capabilities, number_type, params::Dict{String,<:Any})

Request an origination phone number for use in your account. For more information on phone
number request see  Requesting a number  in the Amazon Pinpoint User Guide.

# Arguments
- `iso_country_code`: The two-character code, in ISO 3166-1 alpha-2 format, for the country
  or region.
- `message_type`: The type of message. Valid values are TRANSACTIONAL for messages that are
  critical or time-sensitive and PROMOTIONAL for messages that aren't critical or
  time-sensitive.
- `number_capabilities`: Indicates if the phone number will be used for text messages,
  voice messages, or both.
- `number_type`: The type of phone number to request.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientToken"`: Unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request. If you don't specify a client token, a randomly generated token
  is used for the request to ensure idempotency.
- `"DeletionProtectionEnabled"`: By default this is set to false. When set to true the
  phone number can't be deleted.
- `"OptOutListName"`: The name of the OptOutList to associate with the phone number. You
  can use the OptOutListName or OptOutListArn.
- `"PoolId"`: The pool to associated with the phone number. You can use the PoolId or
  PoolArn.
- `"RegistrationId"`: Use this field to attach your phone number for an external
  registration process.
- `"Tags"`: An array of tags (key and value pairs) associate with the requested phone
  number.
"""
function request_phone_number(
    IsoCountryCode,
    MessageType,
    NumberCapabilities,
    NumberType;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint_sms_voice_v2(
        "RequestPhoneNumber",
        Dict{String,Any}(
            "IsoCountryCode" => IsoCountryCode,
            "MessageType" => MessageType,
            "NumberCapabilities" => NumberCapabilities,
            "NumberType" => NumberType,
            "ClientToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function request_phone_number(
    IsoCountryCode,
    MessageType,
    NumberCapabilities,
    NumberType,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint_sms_voice_v2(
        "RequestPhoneNumber",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "IsoCountryCode" => IsoCountryCode,
                    "MessageType" => MessageType,
                    "NumberCapabilities" => NumberCapabilities,
                    "NumberType" => NumberType,
                    "ClientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    request_sender_id(iso_country_code, sender_id)
    request_sender_id(iso_country_code, sender_id, params::Dict{String,<:Any})

Request a new sender ID that doesn't require registration.

# Arguments
- `iso_country_code`: The two-character code, in ISO 3166-1 alpha-2 format, for the country
  or region.
- `sender_id`: The sender ID string to request.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientToken"`: Unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request. If you don't specify a client token, a randomly generated token
  is used for the request to ensure idempotency.
- `"DeletionProtectionEnabled"`: By default this is set to false. When set to true the
  sender ID can't be deleted.
- `"MessageTypes"`: The type of message. Valid values are TRANSACTIONAL for messages that
  are critical or time-sensitive and PROMOTIONAL for messages that aren't critical or
  time-sensitive.
- `"Tags"`: An array of tags (key and value pairs) to associate with the sender ID.
"""
function request_sender_id(
    IsoCountryCode, SenderId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint_sms_voice_v2(
        "RequestSenderId",
        Dict{String,Any}(
            "IsoCountryCode" => IsoCountryCode,
            "SenderId" => SenderId,
            "ClientToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function request_sender_id(
    IsoCountryCode,
    SenderId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint_sms_voice_v2(
        "RequestSenderId",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "IsoCountryCode" => IsoCountryCode,
                    "SenderId" => SenderId,
                    "ClientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    send_destination_number_verification_code(verification_channel, verified_destination_number_id)
    send_destination_number_verification_code(verification_channel, verified_destination_number_id, params::Dict{String,<:Any})

Before you can send test messages to a verified destination phone number you need to opt-in
the verified destination phone number. Creates a new text message with a verification code
and send it to a verified destination phone number. Once you have the verification code use
VerifyDestinationNumber to opt-in the verified destination phone number to receive messages.

# Arguments
- `verification_channel`: Choose to send the verification code as an SMS or voice message.
- `verified_destination_number_id`: The unique identifier for the verified destination
  phone number.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ConfigurationSetName"`: The name of the configuration set to use. This can be either
  the ConfigurationSetName or ConfigurationSetArn.
- `"Context"`: You can specify custom data in this field. If you do, that data is logged to
  the event destination.
- `"DestinationCountryParameters"`: This field is used for any country-specific
  registration requirements. Currently, this setting is only used when you send messages to
  recipients in India using a sender ID. For more information see Special requirements for
  sending SMS messages to recipients in India.
- `"LanguageCode"`: Choose the language to use for the message.
- `"OriginationIdentity"`: The origination identity of the message. This can be either the
  PhoneNumber, PhoneNumberId, PhoneNumberArn, SenderId, SenderIdArn, PoolId, or PoolArn.
"""
function send_destination_number_verification_code(
    VerificationChannel,
    VerifiedDestinationNumberId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint_sms_voice_v2(
        "SendDestinationNumberVerificationCode",
        Dict{String,Any}(
            "VerificationChannel" => VerificationChannel,
            "VerifiedDestinationNumberId" => VerifiedDestinationNumberId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function send_destination_number_verification_code(
    VerificationChannel,
    VerifiedDestinationNumberId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint_sms_voice_v2(
        "SendDestinationNumberVerificationCode",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "VerificationChannel" => VerificationChannel,
                    "VerifiedDestinationNumberId" => VerifiedDestinationNumberId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    send_media_message(destination_phone_number, origination_identity)
    send_media_message(destination_phone_number, origination_identity, params::Dict{String,<:Any})

Creates a new multimedia message (MMS) and sends it to a recipient's phone number.

# Arguments
- `destination_phone_number`: The destination phone number in E.164 format.
- `origination_identity`: The origination identity of the message. This can be either the
  PhoneNumber, PhoneNumberId, PhoneNumberArn, SenderId, SenderIdArn, PoolId, or PoolArn.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ConfigurationSetName"`: The name of the configuration set to use. This can be either
  the ConfigurationSetName or ConfigurationSetArn.
- `"Context"`: You can specify custom data in this field. If you do, that data is logged to
  the event destination.
- `"DryRun"`: When set to true, the message is checked and validated, but isn't sent to the
  end recipient.
- `"MaxPrice"`: The maximum amount that you want to spend, in US dollars, per each MMS
  message.
- `"MediaUrls"`: An array of URLs to each media file to send.  The media files have to be
  stored in a publicly available S3 bucket. Supported media file formats are listed in MMS
  file types, size and character limits. For more information on creating an S3 bucket and
  managing objects, see Creating a bucket and Uploading objects in the S3 user guide.
- `"MessageBody"`: The text body of the message.
- `"ProtectConfigurationId"`: The unique identifier of the protect configuration to use.
- `"TimeToLive"`: How long the text message is valid for. By default this is 72 hours.
"""
function send_media_message(
    DestinationPhoneNumber,
    OriginationIdentity;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint_sms_voice_v2(
        "SendMediaMessage",
        Dict{String,Any}(
            "DestinationPhoneNumber" => DestinationPhoneNumber,
            "OriginationIdentity" => OriginationIdentity,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function send_media_message(
    DestinationPhoneNumber,
    OriginationIdentity,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint_sms_voice_v2(
        "SendMediaMessage",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "DestinationPhoneNumber" => DestinationPhoneNumber,
                    "OriginationIdentity" => OriginationIdentity,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    send_text_message(destination_phone_number)
    send_text_message(destination_phone_number, params::Dict{String,<:Any})

Creates a new text message and sends it to a recipient's phone number. SMS throughput
limits are measured in Message Parts per Second (MPS). Your MPS limit depends on the
destination country of your messages, as well as the type of phone number (origination
number) that you use to send the message. For more information, see Message Parts per
Second (MPS) limits in the Amazon Pinpoint User Guide.

# Arguments
- `destination_phone_number`: The destination phone number in E.164 format.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ConfigurationSetName"`: The name of the configuration set to use. This can be either
  the ConfigurationSetName or ConfigurationSetArn.
- `"Context"`: You can specify custom data in this field. If you do, that data is logged to
  the event destination.
- `"DestinationCountryParameters"`: This field is used for any country-specific
  registration requirements. Currently, this setting is only used when you send messages to
  recipients in India using a sender ID. For more information see Special requirements for
  sending SMS messages to recipients in India.
- `"DryRun"`: When set to true, the message is checked and validated, but isn't sent to the
  end recipient.
- `"Keyword"`: When you register a short code in the US, you must specify a program name.
  If you don’t have a US short code, omit this attribute.
- `"MaxPrice"`: The maximum amount that you want to spend, in US dollars, per each text
  message part. A text message can contain multiple parts.
- `"MessageBody"`: The body of the text message.
- `"MessageType"`: The type of message. Valid values are for messages that are critical or
  time-sensitive and PROMOTIONAL for messages that aren't critical or time-sensitive.
- `"OriginationIdentity"`: The origination identity of the message. This can be either the
  PhoneNumber, PhoneNumberId, PhoneNumberArn, SenderId, SenderIdArn, PoolId, or PoolArn.
- `"ProtectConfigurationId"`: The unique identifier for the protect configuration.
- `"TimeToLive"`: How long the text message is valid for. By default this is 72 hours.
"""
function send_text_message(
    DestinationPhoneNumber; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint_sms_voice_v2(
        "SendTextMessage",
        Dict{String,Any}("DestinationPhoneNumber" => DestinationPhoneNumber);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function send_text_message(
    DestinationPhoneNumber,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint_sms_voice_v2(
        "SendTextMessage",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("DestinationPhoneNumber" => DestinationPhoneNumber),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    send_voice_message(destination_phone_number, origination_identity)
    send_voice_message(destination_phone_number, origination_identity, params::Dict{String,<:Any})

Allows you to send a request that sends a voice message through Amazon Pinpoint. This
operation uses Amazon Polly to convert a text script into a voice message.

# Arguments
- `destination_phone_number`: The destination phone number in E.164 format.
- `origination_identity`: The origination identity to use for the voice call. This can be
  the PhoneNumber, PhoneNumberId, PhoneNumberArn, PoolId, or PoolArn.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ConfigurationSetName"`: The name of the configuration set to use. This can be either
  the ConfigurationSetName or ConfigurationSetArn.
- `"Context"`: You can specify custom data in this field. If you do, that data is logged to
  the event destination.
- `"DryRun"`: When set to true, the message is checked and validated, but isn't sent to the
  end recipient.
- `"MaxPricePerMinute"`: The maximum amount to spend per voice message, in US dollars.
- `"MessageBody"`: The text to convert to a voice message.
- `"MessageBodyTextType"`: Specifies if the MessageBody field contains text or speech
  synthesis markup language (SSML).   TEXT: This is the default value. When used the maximum
  character limit is 3000.   SSML: When used the maximum character limit is 6000 including
  SSML tagging.
- `"ProtectConfigurationId"`: The unique identifier for the protect configuration.
- `"TimeToLive"`: How long the voice message is valid for. By default this is 72 hours.
- `"VoiceId"`: The voice for the Amazon Polly service to use. By default this is set to
  \"MATTHEW\".
"""
function send_voice_message(
    DestinationPhoneNumber,
    OriginationIdentity;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint_sms_voice_v2(
        "SendVoiceMessage",
        Dict{String,Any}(
            "DestinationPhoneNumber" => DestinationPhoneNumber,
            "OriginationIdentity" => OriginationIdentity,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function send_voice_message(
    DestinationPhoneNumber,
    OriginationIdentity,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint_sms_voice_v2(
        "SendVoiceMessage",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "DestinationPhoneNumber" => DestinationPhoneNumber,
                    "OriginationIdentity" => OriginationIdentity,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    set_account_default_protect_configuration(protect_configuration_id)
    set_account_default_protect_configuration(protect_configuration_id, params::Dict{String,<:Any})

Set a protect configuration as your account default. You can only have one account default
protect configuration at a time. The current account default protect configuration is
replaced with the provided protect configuration.

# Arguments
- `protect_configuration_id`: The unique identifier for the protect configuration.

"""
function set_account_default_protect_configuration(
    ProtectConfigurationId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint_sms_voice_v2(
        "SetAccountDefaultProtectConfiguration",
        Dict{String,Any}("ProtectConfigurationId" => ProtectConfigurationId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function set_account_default_protect_configuration(
    ProtectConfigurationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint_sms_voice_v2(
        "SetAccountDefaultProtectConfiguration",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ProtectConfigurationId" => ProtectConfigurationId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    set_default_message_type(configuration_set_name, message_type)
    set_default_message_type(configuration_set_name, message_type, params::Dict{String,<:Any})

Sets the default message type on a configuration set. Choose the category of SMS messages
that you plan to send from this account. If you send account-related messages or
time-sensitive messages such as one-time passcodes, choose Transactional. If you plan to
send messages that contain marketing material or other promotional content, choose
Promotional. This setting applies to your entire Amazon Web Services account.

# Arguments
- `configuration_set_name`: The configuration set to update with a new default message
  type. This field can be the ConsigurationSetName or ConfigurationSetArn.
- `message_type`: The type of message. Valid values are TRANSACTIONAL for messages that are
  critical or time-sensitive and PROMOTIONAL for messages that aren't critical or
  time-sensitive.

"""
function set_default_message_type(
    ConfigurationSetName, MessageType; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint_sms_voice_v2(
        "SetDefaultMessageType",
        Dict{String,Any}(
            "ConfigurationSetName" => ConfigurationSetName, "MessageType" => MessageType
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function set_default_message_type(
    ConfigurationSetName,
    MessageType,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint_sms_voice_v2(
        "SetDefaultMessageType",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ConfigurationSetName" => ConfigurationSetName,
                    "MessageType" => MessageType,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    set_default_sender_id(configuration_set_name, sender_id)
    set_default_sender_id(configuration_set_name, sender_id, params::Dict{String,<:Any})

Sets default sender ID on a configuration set. When sending a text message to a destination
country that supports sender IDs, the default sender ID on the configuration set specified
will be used if no dedicated origination phone numbers or registered sender IDs are
available in your account.

# Arguments
- `configuration_set_name`: The configuration set to updated with a new default SenderId.
  This field can be the ConsigurationSetName or ConfigurationSetArn.
- `sender_id`: The current sender ID for the configuration set. When sending a text message
  to a destination country which supports SenderIds, the default sender ID on the
  configuration set specified on SendTextMessage will be used if no dedicated origination
  phone numbers or registered SenderIds are available in your account, instead of a generic
  sender ID, such as 'NOTICE'.

"""
function set_default_sender_id(
    ConfigurationSetName, SenderId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint_sms_voice_v2(
        "SetDefaultSenderId",
        Dict{String,Any}(
            "ConfigurationSetName" => ConfigurationSetName, "SenderId" => SenderId
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function set_default_sender_id(
    ConfigurationSetName,
    SenderId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint_sms_voice_v2(
        "SetDefaultSenderId",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ConfigurationSetName" => ConfigurationSetName, "SenderId" => SenderId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    set_media_message_spend_limit_override(monthly_limit)
    set_media_message_spend_limit_override(monthly_limit, params::Dict{String,<:Any})

Sets an account level monthly spend limit override for sending MMS messages. The requested
spend limit must be less than or equal to the MaxLimit, which is set by Amazon Web
Services.

# Arguments
- `monthly_limit`: The new monthly limit to enforce on text messages.

"""
function set_media_message_spend_limit_override(
    MonthlyLimit; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint_sms_voice_v2(
        "SetMediaMessageSpendLimitOverride",
        Dict{String,Any}("MonthlyLimit" => MonthlyLimit);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function set_media_message_spend_limit_override(
    MonthlyLimit,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint_sms_voice_v2(
        "SetMediaMessageSpendLimitOverride",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("MonthlyLimit" => MonthlyLimit), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    set_text_message_spend_limit_override(monthly_limit)
    set_text_message_spend_limit_override(monthly_limit, params::Dict{String,<:Any})

Sets an account level monthly spend limit override for sending text messages. The requested
spend limit must be less than or equal to the MaxLimit, which is set by Amazon Web
Services.

# Arguments
- `monthly_limit`: The new monthly limit to enforce on text messages.

"""
function set_text_message_spend_limit_override(
    MonthlyLimit; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint_sms_voice_v2(
        "SetTextMessageSpendLimitOverride",
        Dict{String,Any}("MonthlyLimit" => MonthlyLimit);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function set_text_message_spend_limit_override(
    MonthlyLimit,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint_sms_voice_v2(
        "SetTextMessageSpendLimitOverride",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("MonthlyLimit" => MonthlyLimit), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    set_voice_message_spend_limit_override(monthly_limit)
    set_voice_message_spend_limit_override(monthly_limit, params::Dict{String,<:Any})

Sets an account level monthly spend limit override for sending voice messages. The
requested spend limit must be less than or equal to the MaxLimit, which is set by Amazon
Web Services.

# Arguments
- `monthly_limit`: The new monthly limit to enforce on voice messages.

"""
function set_voice_message_spend_limit_override(
    MonthlyLimit; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint_sms_voice_v2(
        "SetVoiceMessageSpendLimitOverride",
        Dict{String,Any}("MonthlyLimit" => MonthlyLimit);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function set_voice_message_spend_limit_override(
    MonthlyLimit,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint_sms_voice_v2(
        "SetVoiceMessageSpendLimitOverride",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("MonthlyLimit" => MonthlyLimit), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    submit_registration_version(registration_id)
    submit_registration_version(registration_id, params::Dict{String,<:Any})

Submit the specified registration for review and approval.

# Arguments
- `registration_id`: The unique identifier for the registration.

"""
function submit_registration_version(
    RegistrationId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint_sms_voice_v2(
        "SubmitRegistrationVersion",
        Dict{String,Any}("RegistrationId" => RegistrationId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function submit_registration_version(
    RegistrationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint_sms_voice_v2(
        "SubmitRegistrationVersion",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("RegistrationId" => RegistrationId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_resource(resource_arn, tags)
    tag_resource(resource_arn, tags, params::Dict{String,<:Any})

Adds or overwrites only the specified tags for the specified Amazon Pinpoint SMS Voice,
version 2 resource. When you specify an existing tag key, the value is overwritten with the
new value. Each resource can have a maximum of 50 tags. Each tag consists of a key and an
optional value. Tag keys must be unique per resource. For more information about tags, see
Tagging Amazon Pinpoint resources in the Amazon Pinpoint Developer Guide.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the resource.
- `tags`: An array of key and value pair tags that are associated with the resource.

"""
function tag_resource(ResourceArn, Tags; aws_config::AbstractAWSConfig=current_aws_config())
    return pinpoint_sms_voice_v2(
        "TagResource",
        Dict{String,Any}("ResourceArn" => ResourceArn, "Tags" => Tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_resource(
    ResourceArn,
    Tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint_sms_voice_v2(
        "TagResource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ResourceArn" => ResourceArn, "Tags" => Tags),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_resource(resource_arn, tag_keys)
    untag_resource(resource_arn, tag_keys, params::Dict{String,<:Any})

Removes the association of the specified tags from an Amazon Pinpoint SMS Voice V2
resource. For more information on tags see  Tagging Amazon Pinpoint resources in the Amazon
Pinpoint Developer Guide.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the resource.
- `tag_keys`: An array of tag key values to unassociate with the resource.

"""
function untag_resource(
    ResourceArn, TagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint_sms_voice_v2(
        "UntagResource",
        Dict{String,Any}("ResourceArn" => ResourceArn, "TagKeys" => TagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_resource(
    ResourceArn,
    TagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint_sms_voice_v2(
        "UntagResource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ResourceArn" => ResourceArn, "TagKeys" => TagKeys),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_event_destination(configuration_set_name, event_destination_name)
    update_event_destination(configuration_set_name, event_destination_name, params::Dict{String,<:Any})

Updates an existing event destination in a configuration set. You can update the IAM role
ARN for CloudWatch Logs and Kinesis Data Firehose. You can also enable or disable the event
destination. You may want to update an event destination to change its matching event types
or updating the destination resource ARN. You can't change an event destination's type
between CloudWatch Logs, Kinesis Data Firehose, and Amazon SNS.

# Arguments
- `configuration_set_name`: The configuration set to update with the new event destination.
  Valid values for this can be the ConfigurationSetName or ConfigurationSetArn.
- `event_destination_name`: The name to use for the event destination.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CloudWatchLogsDestination"`: An object that contains information about an event
  destination that sends data to CloudWatch Logs.
- `"Enabled"`: When set to true logging is enabled.
- `"KinesisFirehoseDestination"`: An object that contains information about an event
  destination for logging to Kinesis Data Firehose.
- `"MatchingEventTypes"`: An array of event types that determine which events to log.  The
  TEXT_SENT event type is not supported.
- `"SnsDestination"`: An object that contains information about an event destination that
  sends data to Amazon SNS.
"""
function update_event_destination(
    ConfigurationSetName,
    EventDestinationName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint_sms_voice_v2(
        "UpdateEventDestination",
        Dict{String,Any}(
            "ConfigurationSetName" => ConfigurationSetName,
            "EventDestinationName" => EventDestinationName,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_event_destination(
    ConfigurationSetName,
    EventDestinationName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint_sms_voice_v2(
        "UpdateEventDestination",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ConfigurationSetName" => ConfigurationSetName,
                    "EventDestinationName" => EventDestinationName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_phone_number(phone_number_id)
    update_phone_number(phone_number_id, params::Dict{String,<:Any})

Updates the configuration of an existing origination phone number. You can update the
opt-out list, enable or disable two-way messaging, change the TwoWayChannelArn, enable or
disable self-managed opt-outs, and enable or disable deletion protection. If the
origination phone number is associated with a pool, an error is returned.

# Arguments
- `phone_number_id`: The unique identifier of the phone number. Valid values for this field
  can be either the PhoneNumberId or PhoneNumberArn.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DeletionProtectionEnabled"`: By default this is set to false. When set to true the
  phone number can't be deleted.
- `"OptOutListName"`: The OptOutList to add the phone number to. Valid values for this
  field can be either the OutOutListName or OutOutListArn.
- `"SelfManagedOptOutsEnabled"`: By default this is set to false. When an end recipient
  sends a message that begins with HELP or STOP to one of your dedicated numbers, Amazon
  Pinpoint automatically replies with a customizable message and adds the end recipient to
  the OptOutList. When set to true you're responsible for responding to HELP and STOP
  requests. You're also responsible for tracking and honoring opt-out requests.
- `"TwoWayChannelArn"`: The Amazon Resource Name (ARN) of the two way channel.
- `"TwoWayChannelRole"`: An optional IAM Role Arn for a service to assume, to be able to
  post inbound SMS messages.
- `"TwoWayEnabled"`: By default this is set to false. When set to true you can receive
  incoming text messages from your end recipients.
"""
function update_phone_number(
    PhoneNumberId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint_sms_voice_v2(
        "UpdatePhoneNumber",
        Dict{String,Any}("PhoneNumberId" => PhoneNumberId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_phone_number(
    PhoneNumberId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint_sms_voice_v2(
        "UpdatePhoneNumber",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("PhoneNumberId" => PhoneNumberId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_pool(pool_id)
    update_pool(pool_id, params::Dict{String,<:Any})

Updates the configuration of an existing pool. You can update the opt-out list, enable or
disable two-way messaging, change the TwoWayChannelArn, enable or disable self-managed
opt-outs, enable or disable deletion protection, and enable or disable shared routes.

# Arguments
- `pool_id`: The unique identifier of the pool to update. Valid values are either the
  PoolId or PoolArn.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DeletionProtectionEnabled"`: When set to true the pool can't be deleted.
- `"OptOutListName"`: The OptOutList to associate with the pool. Valid values are either
  OptOutListName or OptOutListArn.
- `"SelfManagedOptOutsEnabled"`: By default this is set to false. When an end recipient
  sends a message that begins with HELP or STOP to one of your dedicated numbers, Amazon
  Pinpoint automatically replies with a customizable message and adds the end recipient to
  the OptOutList. When set to true you're responsible for responding to HELP and STOP
  requests. You're also responsible for tracking and honoring opt-out requests.
- `"SharedRoutesEnabled"`: Indicates whether shared routes are enabled for the pool.
- `"TwoWayChannelArn"`: The Amazon Resource Name (ARN) of the two way channel.
- `"TwoWayChannelRole"`: An optional IAM Role Arn for a service to assume, to be able to
  post inbound SMS messages.
- `"TwoWayEnabled"`: By default this is set to false. When set to true you can receive
  incoming text messages from your end recipients.
"""
function update_pool(PoolId; aws_config::AbstractAWSConfig=current_aws_config())
    return pinpoint_sms_voice_v2(
        "UpdatePool",
        Dict{String,Any}("PoolId" => PoolId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_pool(
    PoolId, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint_sms_voice_v2(
        "UpdatePool",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("PoolId" => PoolId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_protect_configuration(protect_configuration_id)
    update_protect_configuration(protect_configuration_id, params::Dict{String,<:Any})

Update the setting for an existing protect configuration.

# Arguments
- `protect_configuration_id`: The unique identifier for the protect configuration.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DeletionProtectionEnabled"`: When set to true deletion protection is enabled. By
  default this is set to false.
"""
function update_protect_configuration(
    ProtectConfigurationId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint_sms_voice_v2(
        "UpdateProtectConfiguration",
        Dict{String,Any}("ProtectConfigurationId" => ProtectConfigurationId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_protect_configuration(
    ProtectConfigurationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint_sms_voice_v2(
        "UpdateProtectConfiguration",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ProtectConfigurationId" => ProtectConfigurationId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_protect_configuration_country_rule_set(country_rule_set_updates, number_capability, protect_configuration_id)
    update_protect_configuration_country_rule_set(country_rule_set_updates, number_capability, protect_configuration_id, params::Dict{String,<:Any})

Update a country rule set to ALLOW or BLOCK messages to be sent to the specified
destination counties. You can update one or multiple countries at a time. The updates are
only applied to the specified NumberCapability type.

# Arguments
- `country_rule_set_updates`: A map of ProtectConfigurationCountryRuleSetInformation
  objects that contain the details for the requested NumberCapability. The Key is the
  two-letter ISO country code. For a list of supported ISO country codes, see Supported
  countries and regions (SMS channel) in the Amazon Pinpoint SMS user guide.
- `number_capability`: The number capability to apply the CountryRuleSetUpdates updates to.
- `protect_configuration_id`: The unique identifier for the protect configuration.

"""
function update_protect_configuration_country_rule_set(
    CountryRuleSetUpdates,
    NumberCapability,
    ProtectConfigurationId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint_sms_voice_v2(
        "UpdateProtectConfigurationCountryRuleSet",
        Dict{String,Any}(
            "CountryRuleSetUpdates" => CountryRuleSetUpdates,
            "NumberCapability" => NumberCapability,
            "ProtectConfigurationId" => ProtectConfigurationId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_protect_configuration_country_rule_set(
    CountryRuleSetUpdates,
    NumberCapability,
    ProtectConfigurationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint_sms_voice_v2(
        "UpdateProtectConfigurationCountryRuleSet",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "CountryRuleSetUpdates" => CountryRuleSetUpdates,
                    "NumberCapability" => NumberCapability,
                    "ProtectConfigurationId" => ProtectConfigurationId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_sender_id(iso_country_code, sender_id)
    update_sender_id(iso_country_code, sender_id, params::Dict{String,<:Any})

Updates the configuration of an existing sender ID.

# Arguments
- `iso_country_code`: The two-character code, in ISO 3166-1 alpha-2 format, for the country
  or region.
- `sender_id`: The sender ID to update.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DeletionProtectionEnabled"`: By default this is set to false. When set to true the
  sender ID can't be deleted.
"""
function update_sender_id(
    IsoCountryCode, SenderId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint_sms_voice_v2(
        "UpdateSenderId",
        Dict{String,Any}("IsoCountryCode" => IsoCountryCode, "SenderId" => SenderId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_sender_id(
    IsoCountryCode,
    SenderId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint_sms_voice_v2(
        "UpdateSenderId",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "IsoCountryCode" => IsoCountryCode, "SenderId" => SenderId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    verify_destination_number(verification_code, verified_destination_number_id)
    verify_destination_number(verification_code, verified_destination_number_id, params::Dict{String,<:Any})

Use the verification code that was received by the verified destination phone number to
opt-in the verified destination phone number to receive more messages.

# Arguments
- `verification_code`: The verification code that was received by the verified destination
  phone number.
- `verified_destination_number_id`: The unique identifier for the verififed destination
  phone number.

"""
function verify_destination_number(
    VerificationCode,
    VerifiedDestinationNumberId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint_sms_voice_v2(
        "VerifyDestinationNumber",
        Dict{String,Any}(
            "VerificationCode" => VerificationCode,
            "VerifiedDestinationNumberId" => VerifiedDestinationNumberId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function verify_destination_number(
    VerificationCode,
    VerifiedDestinationNumberId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint_sms_voice_v2(
        "VerifyDestinationNumber",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "VerificationCode" => VerificationCode,
                    "VerifiedDestinationNumberId" => VerifiedDestinationNumberId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
