# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: ses
using AWS.Compat
using AWS.UUIDs

"""
    clone_receipt_rule_set(original_rule_set_name, rule_set_name)
    clone_receipt_rule_set(original_rule_set_name, rule_set_name, params::Dict{String,<:Any})

Creates a receipt rule set by cloning an existing one. All receipt rules and configurations
are copied to the new receipt rule set and are completely independent of the source rule
set. For information about setting up rule sets, see the Amazon SES Developer Guide. You
can execute this operation no more than once per second.

# Arguments
- `original_rule_set_name`: The name of the rule set to clone.
- `rule_set_name`: The name of the rule set to create. The name must meet the following
  requirements:   Contain only ASCII letters (a-z, A-Z), numbers (0-9), underscores (_), or
  dashes (-).   Start and end with a letter or number.   Contain 64 characters or fewer.

"""
function clone_receipt_rule_set(
    OriginalRuleSetName, RuleSetName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ses(
        "CloneReceiptRuleSet",
        Dict{String,Any}(
            "OriginalRuleSetName" => OriginalRuleSetName, "RuleSetName" => RuleSetName
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function clone_receipt_rule_set(
    OriginalRuleSetName,
    RuleSetName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ses(
        "CloneReceiptRuleSet",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "OriginalRuleSetName" => OriginalRuleSetName,
                    "RuleSetName" => RuleSetName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_configuration_set(configuration_set)
    create_configuration_set(configuration_set, params::Dict{String,<:Any})

Creates a configuration set. Configuration sets enable you to publish email sending events.
For information about using configuration sets, see the Amazon SES Developer Guide. You can
execute this operation no more than once per second.

# Arguments
- `configuration_set`: A data structure that contains the name of the configuration set.

"""
function create_configuration_set(
    ConfigurationSet; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ses(
        "CreateConfigurationSet",
        Dict{String,Any}("ConfigurationSet" => ConfigurationSet);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_configuration_set(
    ConfigurationSet,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ses(
        "CreateConfigurationSet",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("ConfigurationSet" => ConfigurationSet), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_configuration_set_event_destination(configuration_set_name, event_destination)
    create_configuration_set_event_destination(configuration_set_name, event_destination, params::Dict{String,<:Any})

Creates a configuration set event destination.  When you create or update an event
destination, you must provide one, and only one, destination. The destination can be
CloudWatch, Amazon Kinesis Firehose, or Amazon Simple Notification Service (Amazon SNS).
An event destination is the Amazon Web Services service to which Amazon SES publishes the
email sending events associated with a configuration set. For information about using
configuration sets, see the Amazon SES Developer Guide. You can execute this operation no
more than once per second.

# Arguments
- `configuration_set_name`: The name of the configuration set that the event destination
  should be associated with.
- `event_destination`: An object that describes the Amazon Web Services service that email
  sending event where information is published.

"""
function create_configuration_set_event_destination(
    ConfigurationSetName,
    EventDestination;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ses(
        "CreateConfigurationSetEventDestination",
        Dict{String,Any}(
            "ConfigurationSetName" => ConfigurationSetName,
            "EventDestination" => EventDestination,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_configuration_set_event_destination(
    ConfigurationSetName,
    EventDestination,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ses(
        "CreateConfigurationSetEventDestination",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ConfigurationSetName" => ConfigurationSetName,
                    "EventDestination" => EventDestination,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_configuration_set_tracking_options(configuration_set_name, tracking_options)
    create_configuration_set_tracking_options(configuration_set_name, tracking_options, params::Dict{String,<:Any})

Creates an association between a configuration set and a custom domain for open and click
event tracking.  By default, images and links used for tracking open and click events are
hosted on domains operated by Amazon SES. You can configure a subdomain of your own to
handle these events. For information about using custom domains, see the Amazon SES
Developer Guide.

# Arguments
- `configuration_set_name`: The name of the configuration set that the tracking options
  should be associated with.
- `tracking_options`:

"""
function create_configuration_set_tracking_options(
    ConfigurationSetName,
    TrackingOptions;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ses(
        "CreateConfigurationSetTrackingOptions",
        Dict{String,Any}(
            "ConfigurationSetName" => ConfigurationSetName,
            "TrackingOptions" => TrackingOptions,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_configuration_set_tracking_options(
    ConfigurationSetName,
    TrackingOptions,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ses(
        "CreateConfigurationSetTrackingOptions",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ConfigurationSetName" => ConfigurationSetName,
                    "TrackingOptions" => TrackingOptions,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_custom_verification_email_template(failure_redirection_url, from_email_address, success_redirection_url, template_content, template_name, template_subject)
    create_custom_verification_email_template(failure_redirection_url, from_email_address, success_redirection_url, template_content, template_name, template_subject, params::Dict{String,<:Any})

Creates a new custom verification email template. For more information about custom
verification email templates, see Using Custom Verification Email Templates in the Amazon
SES Developer Guide. You can execute this operation no more than once per second.

# Arguments
- `failure_redirection_url`: The URL that the recipient of the verification email is sent
  to if his or her address is not successfully verified.
- `from_email_address`: The email address that the custom verification email is sent from.
- `success_redirection_url`: The URL that the recipient of the verification email is sent
  to if his or her address is successfully verified.
- `template_content`: The content of the custom verification email. The total size of the
  email must be less than 10 MB. The message body may contain HTML, with some limitations.
  For more information, see Custom Verification Email Frequently Asked Questions in the
  Amazon SES Developer Guide.
- `template_name`: The name of the custom verification email template.
- `template_subject`: The subject line of the custom verification email.

"""
function create_custom_verification_email_template(
    FailureRedirectionURL,
    FromEmailAddress,
    SuccessRedirectionURL,
    TemplateContent,
    TemplateName,
    TemplateSubject;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ses(
        "CreateCustomVerificationEmailTemplate",
        Dict{String,Any}(
            "FailureRedirectionURL" => FailureRedirectionURL,
            "FromEmailAddress" => FromEmailAddress,
            "SuccessRedirectionURL" => SuccessRedirectionURL,
            "TemplateContent" => TemplateContent,
            "TemplateName" => TemplateName,
            "TemplateSubject" => TemplateSubject,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_custom_verification_email_template(
    FailureRedirectionURL,
    FromEmailAddress,
    SuccessRedirectionURL,
    TemplateContent,
    TemplateName,
    TemplateSubject,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ses(
        "CreateCustomVerificationEmailTemplate",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "FailureRedirectionURL" => FailureRedirectionURL,
                    "FromEmailAddress" => FromEmailAddress,
                    "SuccessRedirectionURL" => SuccessRedirectionURL,
                    "TemplateContent" => TemplateContent,
                    "TemplateName" => TemplateName,
                    "TemplateSubject" => TemplateSubject,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_receipt_filter(filter)
    create_receipt_filter(filter, params::Dict{String,<:Any})

Creates a new IP address filter. For information about setting up IP address filters, see
the Amazon SES Developer Guide. You can execute this operation no more than once per second.

# Arguments
- `filter`: A data structure that describes the IP address filter to create, which consists
  of a name, an IP address range, and whether to allow or block mail from it.

"""
function create_receipt_filter(Filter; aws_config::AbstractAWSConfig=current_aws_config())
    return ses(
        "CreateReceiptFilter",
        Dict{String,Any}("Filter" => Filter);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_receipt_filter(
    Filter, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ses(
        "CreateReceiptFilter",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Filter" => Filter), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_receipt_rule(rule, rule_set_name)
    create_receipt_rule(rule, rule_set_name, params::Dict{String,<:Any})

Creates a receipt rule. For information about setting up receipt rules, see the Amazon SES
Developer Guide. You can execute this operation no more than once per second.

# Arguments
- `rule`: A data structure that contains the specified rule's name, actions, recipients,
  domains, enabled status, scan status, and TLS policy.
- `rule_set_name`: The name of the rule set where the receipt rule is added.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"After"`: The name of an existing rule after which the new rule is placed. If this
  parameter is null, the new rule is inserted at the beginning of the rule list.
"""
function create_receipt_rule(
    Rule, RuleSetName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ses(
        "CreateReceiptRule",
        Dict{String,Any}("Rule" => Rule, "RuleSetName" => RuleSetName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_receipt_rule(
    Rule,
    RuleSetName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ses(
        "CreateReceiptRule",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("Rule" => Rule, "RuleSetName" => RuleSetName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_receipt_rule_set(rule_set_name)
    create_receipt_rule_set(rule_set_name, params::Dict{String,<:Any})

Creates an empty receipt rule set. For information about setting up receipt rule sets, see
the Amazon SES Developer Guide. You can execute this operation no more than once per second.

# Arguments
- `rule_set_name`: The name of the rule set to create. The name must meet the following
  requirements:   Contain only ASCII letters (a-z, A-Z), numbers (0-9), underscores (_), or
  dashes (-).   Start and end with a letter or number.   Contain 64 characters or fewer.

"""
function create_receipt_rule_set(
    RuleSetName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ses(
        "CreateReceiptRuleSet",
        Dict{String,Any}("RuleSetName" => RuleSetName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_receipt_rule_set(
    RuleSetName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ses(
        "CreateReceiptRuleSet",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("RuleSetName" => RuleSetName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_template(template)
    create_template(template, params::Dict{String,<:Any})

Creates an email template. Email templates enable you to send personalized email to one or
more destinations in a single operation. For more information, see the Amazon SES Developer
Guide. You can execute this operation no more than once per second.

# Arguments
- `template`: The content of the email, composed of a subject line and either an HTML part
  or a text-only part.

"""
function create_template(Template; aws_config::AbstractAWSConfig=current_aws_config())
    return ses(
        "CreateTemplate",
        Dict{String,Any}("Template" => Template);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_template(
    Template,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ses(
        "CreateTemplate",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("Template" => Template), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_configuration_set(configuration_set_name)
    delete_configuration_set(configuration_set_name, params::Dict{String,<:Any})

Deletes a configuration set. Configuration sets enable you to publish email sending events.
For information about using configuration sets, see the Amazon SES Developer Guide. You can
execute this operation no more than once per second.

# Arguments
- `configuration_set_name`: The name of the configuration set to delete.

"""
function delete_configuration_set(
    ConfigurationSetName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ses(
        "DeleteConfigurationSet",
        Dict{String,Any}("ConfigurationSetName" => ConfigurationSetName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_configuration_set(
    ConfigurationSetName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ses(
        "DeleteConfigurationSet",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ConfigurationSetName" => ConfigurationSetName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_configuration_set_event_destination(configuration_set_name, event_destination_name)
    delete_configuration_set_event_destination(configuration_set_name, event_destination_name, params::Dict{String,<:Any})

Deletes a configuration set event destination. Configuration set event destinations are
associated with configuration sets, which enable you to publish email sending events. For
information about using configuration sets, see the Amazon SES Developer Guide. You can
execute this operation no more than once per second.

# Arguments
- `configuration_set_name`: The name of the configuration set from which to delete the
  event destination.
- `event_destination_name`: The name of the event destination to delete.

"""
function delete_configuration_set_event_destination(
    ConfigurationSetName,
    EventDestinationName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ses(
        "DeleteConfigurationSetEventDestination",
        Dict{String,Any}(
            "ConfigurationSetName" => ConfigurationSetName,
            "EventDestinationName" => EventDestinationName,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_configuration_set_event_destination(
    ConfigurationSetName,
    EventDestinationName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ses(
        "DeleteConfigurationSetEventDestination",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ConfigurationSetName" => ConfigurationSetName,
                    "EventDestinationName" => EventDestinationName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_configuration_set_tracking_options(configuration_set_name)
    delete_configuration_set_tracking_options(configuration_set_name, params::Dict{String,<:Any})

Deletes an association between a configuration set and a custom domain for open and click
event tracking. By default, images and links used for tracking open and click events are
hosted on domains operated by Amazon SES. You can configure a subdomain of your own to
handle these events. For information about using custom domains, see the Amazon SES
Developer Guide.  Deleting this kind of association results in emails sent using the
specified configuration set to capture open and click events using the standard, Amazon
SES-operated domains.

# Arguments
- `configuration_set_name`: The name of the configuration set.

"""
function delete_configuration_set_tracking_options(
    ConfigurationSetName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ses(
        "DeleteConfigurationSetTrackingOptions",
        Dict{String,Any}("ConfigurationSetName" => ConfigurationSetName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_configuration_set_tracking_options(
    ConfigurationSetName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ses(
        "DeleteConfigurationSetTrackingOptions",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ConfigurationSetName" => ConfigurationSetName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_custom_verification_email_template(template_name)
    delete_custom_verification_email_template(template_name, params::Dict{String,<:Any})

Deletes an existing custom verification email template.  For more information about custom
verification email templates, see Using Custom Verification Email Templates in the Amazon
SES Developer Guide. You can execute this operation no more than once per second.

# Arguments
- `template_name`: The name of the custom verification email template to delete.

"""
function delete_custom_verification_email_template(
    TemplateName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ses(
        "DeleteCustomVerificationEmailTemplate",
        Dict{String,Any}("TemplateName" => TemplateName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_custom_verification_email_template(
    TemplateName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ses(
        "DeleteCustomVerificationEmailTemplate",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("TemplateName" => TemplateName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_identity(identity)
    delete_identity(identity, params::Dict{String,<:Any})

Deletes the specified identity (an email address or a domain) from the list of verified
identities. You can execute this operation no more than once per second.

# Arguments
- `identity`: The identity to be removed from the list of identities for the Amazon Web
  Services account.

"""
function delete_identity(Identity; aws_config::AbstractAWSConfig=current_aws_config())
    return ses(
        "DeleteIdentity",
        Dict{String,Any}("Identity" => Identity);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_identity(
    Identity,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ses(
        "DeleteIdentity",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("Identity" => Identity), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_identity_policy(identity, policy_name)
    delete_identity_policy(identity, policy_name, params::Dict{String,<:Any})

Deletes the specified sending authorization policy for the given identity (an email address
or a domain). This operation returns successfully even if a policy with the specified name
does not exist.  This operation is for the identity owner only. If you have not verified
the identity, it returns an error.  Sending authorization is a feature that enables an
identity owner to authorize other senders to use its identities. For information about
using sending authorization, see the Amazon SES Developer Guide. You can execute this
operation no more than once per second.

# Arguments
- `identity`: The identity that is associated with the policy to delete. You can specify
  the identity by using its name or by using its Amazon Resource Name (ARN). Examples:
  user@example.com, example.com, arn:aws:ses:us-east-1:123456789012:identity/example.com. To
  successfully call this operation, you must own the identity.
- `policy_name`: The name of the policy to be deleted.

"""
function delete_identity_policy(
    Identity, PolicyName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ses(
        "DeleteIdentityPolicy",
        Dict{String,Any}("Identity" => Identity, "PolicyName" => PolicyName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_identity_policy(
    Identity,
    PolicyName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ses(
        "DeleteIdentityPolicy",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("Identity" => Identity, "PolicyName" => PolicyName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_receipt_filter(filter_name)
    delete_receipt_filter(filter_name, params::Dict{String,<:Any})

Deletes the specified IP address filter. For information about managing IP address filters,
see the Amazon SES Developer Guide. You can execute this operation no more than once per
second.

# Arguments
- `filter_name`: The name of the IP address filter to delete.

"""
function delete_receipt_filter(
    FilterName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ses(
        "DeleteReceiptFilter",
        Dict{String,Any}("FilterName" => FilterName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_receipt_filter(
    FilterName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ses(
        "DeleteReceiptFilter",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("FilterName" => FilterName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_receipt_rule(rule_name, rule_set_name)
    delete_receipt_rule(rule_name, rule_set_name, params::Dict{String,<:Any})

Deletes the specified receipt rule. For information about managing receipt rules, see the
Amazon SES Developer Guide. You can execute this operation no more than once per second.

# Arguments
- `rule_name`: The name of the receipt rule to delete.
- `rule_set_name`: The name of the receipt rule set that contains the receipt rule to
  delete.

"""
function delete_receipt_rule(
    RuleName, RuleSetName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ses(
        "DeleteReceiptRule",
        Dict{String,Any}("RuleName" => RuleName, "RuleSetName" => RuleSetName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_receipt_rule(
    RuleName,
    RuleSetName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ses(
        "DeleteReceiptRule",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("RuleName" => RuleName, "RuleSetName" => RuleSetName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_receipt_rule_set(rule_set_name)
    delete_receipt_rule_set(rule_set_name, params::Dict{String,<:Any})

Deletes the specified receipt rule set and all of the receipt rules it contains.  The
currently active rule set cannot be deleted.  For information about managing receipt rule
sets, see the Amazon SES Developer Guide. You can execute this operation no more than once
per second.

# Arguments
- `rule_set_name`: The name of the receipt rule set to delete.

"""
function delete_receipt_rule_set(
    RuleSetName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ses(
        "DeleteReceiptRuleSet",
        Dict{String,Any}("RuleSetName" => RuleSetName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_receipt_rule_set(
    RuleSetName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ses(
        "DeleteReceiptRuleSet",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("RuleSetName" => RuleSetName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_template(template_name)
    delete_template(template_name, params::Dict{String,<:Any})

Deletes an email template. You can execute this operation no more than once per second.

# Arguments
- `template_name`: The name of the template to be deleted.

"""
function delete_template(TemplateName; aws_config::AbstractAWSConfig=current_aws_config())
    return ses(
        "DeleteTemplate",
        Dict{String,Any}("TemplateName" => TemplateName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_template(
    TemplateName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ses(
        "DeleteTemplate",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("TemplateName" => TemplateName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_verified_email_address(email_address)
    delete_verified_email_address(email_address, params::Dict{String,<:Any})

Deprecated. Use the DeleteIdentity operation to delete email addresses and domains.

# Arguments
- `email_address`: An email address to be removed from the list of verified addresses.

"""
function delete_verified_email_address(
    EmailAddress; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ses(
        "DeleteVerifiedEmailAddress",
        Dict{String,Any}("EmailAddress" => EmailAddress);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_verified_email_address(
    EmailAddress,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ses(
        "DeleteVerifiedEmailAddress",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("EmailAddress" => EmailAddress), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_active_receipt_rule_set()
    describe_active_receipt_rule_set(params::Dict{String,<:Any})

Returns the metadata and receipt rules for the receipt rule set that is currently active.
For information about setting up receipt rule sets, see the Amazon SES Developer Guide. You
can execute this operation no more than once per second.

"""
function describe_active_receipt_rule_set(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return ses(
        "DescribeActiveReceiptRuleSet";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_active_receipt_rule_set(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ses(
        "DescribeActiveReceiptRuleSet",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_configuration_set(configuration_set_name)
    describe_configuration_set(configuration_set_name, params::Dict{String,<:Any})

Returns the details of the specified configuration set. For information about using
configuration sets, see the Amazon SES Developer Guide. You can execute this operation no
more than once per second.

# Arguments
- `configuration_set_name`: The name of the configuration set to describe.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ConfigurationSetAttributeNames"`: A list of configuration set attributes to return.
"""
function describe_configuration_set(
    ConfigurationSetName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ses(
        "DescribeConfigurationSet",
        Dict{String,Any}("ConfigurationSetName" => ConfigurationSetName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_configuration_set(
    ConfigurationSetName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ses(
        "DescribeConfigurationSet",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ConfigurationSetName" => ConfigurationSetName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_receipt_rule(rule_name, rule_set_name)
    describe_receipt_rule(rule_name, rule_set_name, params::Dict{String,<:Any})

Returns the details of the specified receipt rule. For information about setting up receipt
rules, see the Amazon SES Developer Guide. You can execute this operation no more than once
per second.

# Arguments
- `rule_name`: The name of the receipt rule.
- `rule_set_name`: The name of the receipt rule set that the receipt rule belongs to.

"""
function describe_receipt_rule(
    RuleName, RuleSetName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ses(
        "DescribeReceiptRule",
        Dict{String,Any}("RuleName" => RuleName, "RuleSetName" => RuleSetName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_receipt_rule(
    RuleName,
    RuleSetName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ses(
        "DescribeReceiptRule",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("RuleName" => RuleName, "RuleSetName" => RuleSetName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_receipt_rule_set(rule_set_name)
    describe_receipt_rule_set(rule_set_name, params::Dict{String,<:Any})

Returns the details of the specified receipt rule set. For information about managing
receipt rule sets, see the Amazon SES Developer Guide. You can execute this operation no
more than once per second.

# Arguments
- `rule_set_name`: The name of the receipt rule set to describe.

"""
function describe_receipt_rule_set(
    RuleSetName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ses(
        "DescribeReceiptRuleSet",
        Dict{String,Any}("RuleSetName" => RuleSetName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_receipt_rule_set(
    RuleSetName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ses(
        "DescribeReceiptRuleSet",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("RuleSetName" => RuleSetName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_account_sending_enabled()
    get_account_sending_enabled(params::Dict{String,<:Any})

Returns the email sending status of the Amazon SES account for the current Region. You can
execute this operation no more than once per second.

"""
function get_account_sending_enabled(; aws_config::AbstractAWSConfig=current_aws_config())
    return ses(
        "GetAccountSendingEnabled"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function get_account_sending_enabled(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ses(
        "GetAccountSendingEnabled",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_custom_verification_email_template(template_name)
    get_custom_verification_email_template(template_name, params::Dict{String,<:Any})

Returns the custom email verification template for the template name you specify. For more
information about custom verification email templates, see Using Custom Verification Email
Templates in the Amazon SES Developer Guide. You can execute this operation no more than
once per second.

# Arguments
- `template_name`: The name of the custom verification email template to retrieve.

"""
function get_custom_verification_email_template(
    TemplateName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ses(
        "GetCustomVerificationEmailTemplate",
        Dict{String,Any}("TemplateName" => TemplateName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_custom_verification_email_template(
    TemplateName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ses(
        "GetCustomVerificationEmailTemplate",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("TemplateName" => TemplateName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_identity_dkim_attributes(identities)
    get_identity_dkim_attributes(identities, params::Dict{String,<:Any})

Returns the current status of Easy DKIM signing for an entity. For domain name identities,
this operation also returns the DKIM tokens that are required for Easy DKIM signing, and
whether Amazon SES has successfully verified that these tokens have been published. This
operation takes a list of identities as input and returns the following information for
each:   Whether Easy DKIM signing is enabled or disabled.   A set of DKIM tokens that
represent the identity. If the identity is an email address, the tokens represent the
domain of that address.   Whether Amazon SES has successfully verified the DKIM tokens
published in the domain's DNS. This information is only returned for domain name
identities, not for email addresses.   This operation is throttled at one request per
second and can only get DKIM attributes for up to 100 identities at a time. For more
information about creating DNS records using DKIM tokens, go to the Amazon SES Developer
Guide.

# Arguments
- `identities`: A list of one or more verified identities - email addresses, domains, or
  both.

"""
function get_identity_dkim_attributes(
    Identities; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ses(
        "GetIdentityDkimAttributes",
        Dict{String,Any}("Identities" => Identities);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_identity_dkim_attributes(
    Identities,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ses(
        "GetIdentityDkimAttributes",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("Identities" => Identities), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_identity_mail_from_domain_attributes(identities)
    get_identity_mail_from_domain_attributes(identities, params::Dict{String,<:Any})

Returns the custom MAIL FROM attributes for a list of identities (email addresses :
domains). This operation is throttled at one request per second and can only get custom
MAIL FROM attributes for up to 100 identities at a time.

# Arguments
- `identities`: A list of one or more identities.

"""
function get_identity_mail_from_domain_attributes(
    Identities; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ses(
        "GetIdentityMailFromDomainAttributes",
        Dict{String,Any}("Identities" => Identities);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_identity_mail_from_domain_attributes(
    Identities,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ses(
        "GetIdentityMailFromDomainAttributes",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("Identities" => Identities), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_identity_notification_attributes(identities)
    get_identity_notification_attributes(identities, params::Dict{String,<:Any})

Given a list of verified identities (email addresses and/or domains), returns a structure
describing identity notification attributes. This operation is throttled at one request per
second and can only get notification attributes for up to 100 identities at a time. For
more information about using notifications with Amazon SES, see the Amazon SES Developer
Guide.

# Arguments
- `identities`: A list of one or more identities. You can specify an identity by using its
  name or by using its Amazon Resource Name (ARN). Examples: user@example.com, example.com,
  arn:aws:ses:us-east-1:123456789012:identity/example.com.

"""
function get_identity_notification_attributes(
    Identities; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ses(
        "GetIdentityNotificationAttributes",
        Dict{String,Any}("Identities" => Identities);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_identity_notification_attributes(
    Identities,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ses(
        "GetIdentityNotificationAttributes",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("Identities" => Identities), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_identity_policies(identity, policy_names)
    get_identity_policies(identity, policy_names, params::Dict{String,<:Any})

Returns the requested sending authorization policies for the given identity (an email
address or a domain). The policies are returned as a map of policy names to policy
contents. You can retrieve a maximum of 20 policies at a time.  This operation is for the
identity owner only. If you have not verified the identity, it returns an error.  Sending
authorization is a feature that enables an identity owner to authorize other senders to use
its identities. For information about using sending authorization, see the Amazon SES
Developer Guide. You can execute this operation no more than once per second.

# Arguments
- `identity`: The identity for which the policies are retrieved. You can specify an
  identity by using its name or by using its Amazon Resource Name (ARN). Examples:
  user@example.com, example.com, arn:aws:ses:us-east-1:123456789012:identity/example.com. To
  successfully call this operation, you must own the identity.
- `policy_names`: A list of the names of policies to be retrieved. You can retrieve a
  maximum of 20 policies at a time. If you do not know the names of the policies that are
  attached to the identity, you can use ListIdentityPolicies.

"""
function get_identity_policies(
    Identity, PolicyNames; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ses(
        "GetIdentityPolicies",
        Dict{String,Any}("Identity" => Identity, "PolicyNames" => PolicyNames);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_identity_policies(
    Identity,
    PolicyNames,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ses(
        "GetIdentityPolicies",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("Identity" => Identity, "PolicyNames" => PolicyNames),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_identity_verification_attributes(identities)
    get_identity_verification_attributes(identities, params::Dict{String,<:Any})

Given a list of identities (email addresses and/or domains), returns the verification
status and (for domain identities) the verification token for each identity. The
verification status of an email address is \"Pending\" until the email address owner clicks
the link within the verification email that Amazon SES sent to that address. If the email
address owner clicks the link within 24 hours, the verification status of the email address
changes to \"Success\". If the link is not clicked within 24 hours, the verification status
changes to \"Failed.\" In that case, to verify the email address, you must restart the
verification process from the beginning. For domain identities, the domain's verification
status is \"Pending\" as Amazon SES searches for the required TXT record in the DNS
settings of the domain. When Amazon SES detects the record, the domain's verification
status changes to \"Success\". If Amazon SES is unable to detect the record within 72
hours, the domain's verification status changes to \"Failed.\" In that case, to verify the
domain, you must restart the verification process from the beginning. This operation is
throttled at one request per second and can only get verification attributes for up to 100
identities at a time.

# Arguments
- `identities`: A list of identities.

"""
function get_identity_verification_attributes(
    Identities; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ses(
        "GetIdentityVerificationAttributes",
        Dict{String,Any}("Identities" => Identities);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_identity_verification_attributes(
    Identities,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ses(
        "GetIdentityVerificationAttributes",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("Identities" => Identities), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_send_quota()
    get_send_quota(params::Dict{String,<:Any})

Provides the sending limits for the Amazon SES account.  You can execute this operation no
more than once per second.

"""
function get_send_quota(; aws_config::AbstractAWSConfig=current_aws_config())
    return ses("GetSendQuota"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function get_send_quota(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ses(
        "GetSendQuota", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    get_send_statistics()
    get_send_statistics(params::Dict{String,<:Any})

Provides sending statistics for the current Amazon Web Services Region. The result is a
list of data points, representing the last two weeks of sending activity. Each data point
in the list contains statistics for a 15-minute period of time. You can execute this
operation no more than once per second.

"""
function get_send_statistics(; aws_config::AbstractAWSConfig=current_aws_config())
    return ses("GetSendStatistics"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function get_send_statistics(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ses(
        "GetSendStatistics", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    get_template(template_name)
    get_template(template_name, params::Dict{String,<:Any})

Displays the template object (which includes the Subject line, HTML part and text part) for
the template you specify. You can execute this operation no more than once per second.

# Arguments
- `template_name`: The name of the template to retrieve.

"""
function get_template(TemplateName; aws_config::AbstractAWSConfig=current_aws_config())
    return ses(
        "GetTemplate",
        Dict{String,Any}("TemplateName" => TemplateName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_template(
    TemplateName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ses(
        "GetTemplate",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("TemplateName" => TemplateName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_configuration_sets()
    list_configuration_sets(params::Dict{String,<:Any})

Provides a list of the configuration sets associated with your Amazon SES account in the
current Amazon Web Services Region. For information about using configuration sets, see
Monitoring Your Amazon SES Sending Activity in the Amazon SES Developer Guide.  You can
execute this operation no more than once per second. This operation returns up to 1,000
configuration sets each time it is run. If your Amazon SES account has more than 1,000
configuration sets, this operation also returns NextToken. You can then execute the
ListConfigurationSets operation again, passing the NextToken parameter and the value of the
NextToken element to retrieve additional results.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxItems"`: The number of configuration sets to return.
- `"NextToken"`: A token returned from a previous call to ListConfigurationSets to indicate
  the position of the configuration set in the configuration set list.
"""
function list_configuration_sets(; aws_config::AbstractAWSConfig=current_aws_config())
    return ses(
        "ListConfigurationSets"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_configuration_sets(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ses(
        "ListConfigurationSets",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_custom_verification_email_templates()
    list_custom_verification_email_templates(params::Dict{String,<:Any})

Lists the existing custom verification email templates for your account in the current
Amazon Web Services Region. For more information about custom verification email templates,
see Using Custom Verification Email Templates in the Amazon SES Developer Guide. You can
execute this operation no more than once per second.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of custom verification email templates to return. This
  value must be at least 1 and less than or equal to 50. If you do not specify a value, or if
  you specify a value less than 1 or greater than 50, the operation returns up to 50 results.
- `"NextToken"`: An array the contains the name and creation time stamp for each template
  in your Amazon SES account.
"""
function list_custom_verification_email_templates(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return ses(
        "ListCustomVerificationEmailTemplates";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_custom_verification_email_templates(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ses(
        "ListCustomVerificationEmailTemplates",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_identities()
    list_identities(params::Dict{String,<:Any})

Returns a list containing all of the identities (email addresses and domains) for your
Amazon Web Services account in the current Amazon Web Services Region, regardless of
verification status. You can execute this operation no more than once per second.  It's
recommended that for successive pagination calls of this API, you continue to the use the
same parameter/value pairs as used in the original call, e.g., if you used
IdentityType=Domain in the the original call and received a NextToken in the response, you
should continue providing the IdentityType=Domain parameter for further NextToken calls;
however, if you didn't provide the IdentityType parameter in the original call, then
continue to not provide it for successive pagination calls. Using this protocol will ensure
consistent results.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"IdentityType"`: The type of the identities to list. Possible values are
  \"EmailAddress\" and \"Domain\". If this parameter is omitted, then all identities are
  listed.
- `"MaxItems"`: The maximum number of identities per page. Possible values are 1-1000
  inclusive.
- `"NextToken"`: The token to use for pagination.
"""
function list_identities(; aws_config::AbstractAWSConfig=current_aws_config())
    return ses("ListIdentities"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function list_identities(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ses(
        "ListIdentities", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_identity_policies(identity)
    list_identity_policies(identity, params::Dict{String,<:Any})

Returns a list of sending authorization policies that are attached to the given identity
(an email address or a domain). This operation returns only a list. To get the actual
policy content, use GetIdentityPolicies.  This operation is for the identity owner only. If
you have not verified the identity, it returns an error.  Sending authorization is a
feature that enables an identity owner to authorize other senders to use its identities.
For information about using sending authorization, see the Amazon SES Developer Guide. You
can execute this operation no more than once per second.

# Arguments
- `identity`: The identity that is associated with the policy for which the policies are
  listed. You can specify an identity by using its name or by using its Amazon Resource Name
  (ARN). Examples: user@example.com, example.com,
  arn:aws:ses:us-east-1:123456789012:identity/example.com. To successfully call this
  operation, you must own the identity.

"""
function list_identity_policies(
    Identity; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ses(
        "ListIdentityPolicies",
        Dict{String,Any}("Identity" => Identity);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_identity_policies(
    Identity,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ses(
        "ListIdentityPolicies",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("Identity" => Identity), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_receipt_filters()
    list_receipt_filters(params::Dict{String,<:Any})

Lists the IP address filters associated with your Amazon Web Services account in the
current Amazon Web Services Region. For information about managing IP address filters, see
the Amazon SES Developer Guide. You can execute this operation no more than once per second.

"""
function list_receipt_filters(; aws_config::AbstractAWSConfig=current_aws_config())
    return ses("ListReceiptFilters"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function list_receipt_filters(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ses(
        "ListReceiptFilters", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_receipt_rule_sets()
    list_receipt_rule_sets(params::Dict{String,<:Any})

Lists the receipt rule sets that exist under your Amazon Web Services account in the
current Amazon Web Services Region. If there are additional receipt rule sets to be
retrieved, you receive a NextToken that you can provide to the next call to
ListReceiptRuleSets to retrieve the additional entries. For information about managing
receipt rule sets, see the Amazon SES Developer Guide. You can execute this operation no
more than once per second.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"NextToken"`: A token returned from a previous call to ListReceiptRuleSets to indicate
  the position in the receipt rule set list.
"""
function list_receipt_rule_sets(; aws_config::AbstractAWSConfig=current_aws_config())
    return ses(
        "ListReceiptRuleSets"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_receipt_rule_sets(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ses(
        "ListReceiptRuleSets",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_templates()
    list_templates(params::Dict{String,<:Any})

Lists the email templates present in your Amazon SES account in the current Amazon Web
Services Region. You can execute this operation no more than once per second.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxItems"`: The maximum number of templates to return. This value must be at least 1
  and less than or equal to 100. If more than 100 items are requested, the page size will
  automatically set to 100. If you do not specify a value, 10 is the default page size.
- `"NextToken"`: A token returned from a previous call to ListTemplates to indicate the
  position in the list of email templates.
"""
function list_templates(; aws_config::AbstractAWSConfig=current_aws_config())
    return ses("ListTemplates"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function list_templates(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ses(
        "ListTemplates", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_verified_email_addresses()
    list_verified_email_addresses(params::Dict{String,<:Any})

Deprecated. Use the ListIdentities operation to list the email addresses and domains
associated with your account.

"""
function list_verified_email_addresses(; aws_config::AbstractAWSConfig=current_aws_config())
    return ses(
        "ListVerifiedEmailAddresses"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_verified_email_addresses(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ses(
        "ListVerifiedEmailAddresses",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_configuration_set_delivery_options(configuration_set_name)
    put_configuration_set_delivery_options(configuration_set_name, params::Dict{String,<:Any})

Adds or updates the delivery options for a configuration set.

# Arguments
- `configuration_set_name`: The name of the configuration set.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DeliveryOptions"`: Specifies whether messages that use the configuration set are
  required to use Transport Layer Security (TLS).
"""
function put_configuration_set_delivery_options(
    ConfigurationSetName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ses(
        "PutConfigurationSetDeliveryOptions",
        Dict{String,Any}("ConfigurationSetName" => ConfigurationSetName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_configuration_set_delivery_options(
    ConfigurationSetName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ses(
        "PutConfigurationSetDeliveryOptions",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ConfigurationSetName" => ConfigurationSetName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_identity_policy(identity, policy, policy_name)
    put_identity_policy(identity, policy, policy_name, params::Dict{String,<:Any})

Adds or updates a sending authorization policy for the specified identity (an email address
or a domain).  This operation is for the identity owner only. If you have not verified the
identity, it returns an error.  Sending authorization is a feature that enables an identity
owner to authorize other senders to use its identities. For information about using sending
authorization, see the Amazon SES Developer Guide. You can execute this operation no more
than once per second.

# Arguments
- `identity`: The identity to which that the policy applies. You can specify an identity by
  using its name or by using its Amazon Resource Name (ARN). Examples: user@example.com,
  example.com, arn:aws:ses:us-east-1:123456789012:identity/example.com. To successfully call
  this operation, you must own the identity.
- `policy`: The text of the policy in JSON format. The policy cannot exceed 4 KB. For
  information about the syntax of sending authorization policies, see the Amazon SES
  Developer Guide.
- `policy_name`: The name of the policy. The policy name cannot exceed 64 characters and
  can only include alphanumeric characters, dashes, and underscores.

"""
function put_identity_policy(
    Identity, Policy, PolicyName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ses(
        "PutIdentityPolicy",
        Dict{String,Any}(
            "Identity" => Identity, "Policy" => Policy, "PolicyName" => PolicyName
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_identity_policy(
    Identity,
    Policy,
    PolicyName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ses(
        "PutIdentityPolicy",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "Identity" => Identity, "Policy" => Policy, "PolicyName" => PolicyName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    reorder_receipt_rule_set(rule_names, rule_set_name)
    reorder_receipt_rule_set(rule_names, rule_set_name, params::Dict{String,<:Any})

Reorders the receipt rules within a receipt rule set.  All of the rules in the rule set
must be represented in this request. That is, it is error if the reorder request doesn't
explicitly position all of the rules.  For information about managing receipt rule sets,
see the Amazon SES Developer Guide. You can execute this operation no more than once per
second.

# Arguments
- `rule_names`: The specified receipt rule set's receipt rules, in order.
- `rule_set_name`: The name of the receipt rule set to reorder.

"""
function reorder_receipt_rule_set(
    RuleNames, RuleSetName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ses(
        "ReorderReceiptRuleSet",
        Dict{String,Any}("RuleNames" => RuleNames, "RuleSetName" => RuleSetName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function reorder_receipt_rule_set(
    RuleNames,
    RuleSetName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ses(
        "ReorderReceiptRuleSet",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("RuleNames" => RuleNames, "RuleSetName" => RuleSetName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    send_bounce(bounce_sender, bounced_recipient_info_list, original_message_id)
    send_bounce(bounce_sender, bounced_recipient_info_list, original_message_id, params::Dict{String,<:Any})

Generates and sends a bounce message to the sender of an email you received through Amazon
SES. You can only use this operation on an email up to 24 hours after you receive it.  You
cannot use this operation to send generic bounces for mail that was not received by Amazon
SES.  For information about receiving email through Amazon SES, see the Amazon SES
Developer Guide. You can execute this operation no more than once per second.

# Arguments
- `bounce_sender`: The address to use in the \"From\" header of the bounce message. This
  must be an identity that you have verified with Amazon SES.
- `bounced_recipient_info_list`: A list of recipients of the bounced message, including the
  information required to create the Delivery Status Notifications (DSNs) for the recipients.
  You must specify at least one BouncedRecipientInfo in the list.
- `original_message_id`: The message ID of the message to be bounced.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"BounceSenderArn"`: This parameter is used only for sending authorization. It is the ARN
  of the identity that is associated with the sending authorization policy that permits you
  to use the address in the \"From\" header of the bounce. For more information about sending
  authorization, see the Amazon SES Developer Guide.
- `"Explanation"`: Human-readable text for the bounce message to explain the failure. If
  not specified, the text is auto-generated based on the bounced recipient information.
- `"MessageDsn"`: Message-related DSN fields. If not specified, Amazon SES chooses the
  values.
"""
function send_bounce(
    BounceSender,
    BouncedRecipientInfoList,
    OriginalMessageId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ses(
        "SendBounce",
        Dict{String,Any}(
            "BounceSender" => BounceSender,
            "BouncedRecipientInfoList" => BouncedRecipientInfoList,
            "OriginalMessageId" => OriginalMessageId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function send_bounce(
    BounceSender,
    BouncedRecipientInfoList,
    OriginalMessageId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ses(
        "SendBounce",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "BounceSender" => BounceSender,
                    "BouncedRecipientInfoList" => BouncedRecipientInfoList,
                    "OriginalMessageId" => OriginalMessageId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    send_bulk_templated_email(destinations, source, template)
    send_bulk_templated_email(destinations, source, template, params::Dict{String,<:Any})

Composes an email message to multiple destinations. The message body is created using an
email template. To send email using this operation, your call must meet the following
requirements:   The call must refer to an existing email template. You can create email
templates using CreateTemplate.   The message must be sent from a verified email address or
domain.   If your account is still in the Amazon SES sandbox, you may send only to verified
addresses or domains, or to email addresses associated with the Amazon SES Mailbox
Simulator. For more information, see Verifying Email Addresses and Domains in the Amazon
SES Developer Guide.    The maximum message size is 10 MB.   Each Destination parameter
must include at least one recipient email address. The recipient address can be a To:
address, a CC: address, or a BCC: address. If a recipient email address is invalid (that
is, it is not in the format UserName@[SubDomain.]Domain.TopLevelDomain), the entire message
is rejected, even if the message contains other recipients that are valid.   The message
may not include more than 50 recipients, across the To:, CC: and BCC: fields. If you need
to send an email message to a larger audience, you can divide your recipient list into
groups of 50 or fewer, and then call the SendBulkTemplatedEmail operation several times to
send the message to each group.   The number of destinations you can contact in a single
call can be limited by your account's maximum sending rate.

# Arguments
- `destinations`: One or more Destination objects. All of the recipients in a Destination
  receive the same version of the email. You can specify up to 50 Destination objects within
  a Destinations array.
- `source`: The email address that is sending the email. This email address must be either
  individually verified with Amazon SES, or from a domain that has been verified with Amazon
  SES. For information about verifying identities, see the Amazon SES Developer Guide. If you
  are sending on behalf of another user and have been permitted to do so by a sending
  authorization policy, then you must also specify the SourceArn parameter. For more
  information about sending authorization, see the Amazon SES Developer Guide.  Amazon SES
  does not support the SMTPUTF8 extension, as described in RFC6531. For this reason, the
  email address string must be 7-bit ASCII. If you want to send to or from email addresses
  that contain Unicode characters in the domain part of an address, you must encode the
  domain using Punycode. Punycode is not permitted in the local part of the email address
  (the part before the @ sign) nor in the \"friendly from\" name. If you want to use Unicode
  characters in the \"friendly from\" name, you must encode the \"friendly from\" name using
  MIME encoded-word syntax, as described in Sending raw email using the Amazon SES API. For
  more information about Punycode, see RFC 3492.
- `template`: The template to use when sending this email.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ConfigurationSetName"`: The name of the configuration set to use when you send an email
  using SendBulkTemplatedEmail.
- `"DefaultTags"`: A list of tags, in the form of name/value pairs, to apply to an email
  that you send to a destination using SendBulkTemplatedEmail.
- `"DefaultTemplateData"`: A list of replacement values to apply to the template when
  replacement data is not specified in a Destination object. These values act as a default or
  fallback option when no other data is available. The template data is a JSON object,
  typically consisting of key-value pairs in which the keys correspond to replacement tags in
  the email template.
- `"ReplyToAddresses"`: The reply-to email address(es) for the message. If the recipient
  replies to the message, each reply-to address receives the reply.
- `"ReturnPath"`: The email address that bounces and complaints are forwarded to when
  feedback forwarding is enabled. If the message cannot be delivered to the recipient, then
  an error message is returned from the recipient's ISP; this message is forwarded to the
  email address specified by the ReturnPath parameter. The ReturnPath parameter is never
  overwritten. This email address must be either individually verified with Amazon SES, or
  from a domain that has been verified with Amazon SES.
- `"ReturnPathArn"`: This parameter is used only for sending authorization. It is the ARN
  of the identity that is associated with the sending authorization policy that permits you
  to use the email address specified in the ReturnPath parameter. For example, if the owner
  of example.com (which has ARN arn:aws:ses:us-east-1:123456789012:identity/example.com)
  attaches a policy to it that authorizes you to use feedback@example.com, then you would
  specify the ReturnPathArn to be arn:aws:ses:us-east-1:123456789012:identity/example.com,
  and the ReturnPath to be feedback@example.com. For more information about sending
  authorization, see the Amazon SES Developer Guide.
- `"SourceArn"`: This parameter is used only for sending authorization. It is the ARN of
  the identity that is associated with the sending authorization policy that permits you to
  send for the email address specified in the Source parameter. For example, if the owner of
  example.com (which has ARN arn:aws:ses:us-east-1:123456789012:identity/example.com)
  attaches a policy to it that authorizes you to send from user@example.com, then you would
  specify the SourceArn to be arn:aws:ses:us-east-1:123456789012:identity/example.com, and
  the Source to be user@example.com. For more information about sending authorization, see
  the Amazon SES Developer Guide.
- `"TemplateArn"`: The ARN of the template to use when sending this email.
"""
function send_bulk_templated_email(
    Destinations, Source, Template; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ses(
        "SendBulkTemplatedEmail",
        Dict{String,Any}(
            "Destinations" => Destinations, "Source" => Source, "Template" => Template
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function send_bulk_templated_email(
    Destinations,
    Source,
    Template,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ses(
        "SendBulkTemplatedEmail",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "Destinations" => Destinations,
                    "Source" => Source,
                    "Template" => Template,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    send_custom_verification_email(email_address, template_name)
    send_custom_verification_email(email_address, template_name, params::Dict{String,<:Any})

Adds an email address to the list of identities for your Amazon SES account in the current
Amazon Web Services Region and attempts to verify it. As a result of executing this
operation, a customized verification email is sent to the specified address. To use this
operation, you must first create a custom verification email template. For more information
about creating and using custom verification email templates, see Using Custom Verification
Email Templates in the Amazon SES Developer Guide. You can execute this operation no more
than once per second.

# Arguments
- `email_address`: The email address to verify.
- `template_name`: The name of the custom verification email template to use when sending
  the verification email.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ConfigurationSetName"`: Name of a configuration set to use when sending the
  verification email.
"""
function send_custom_verification_email(
    EmailAddress, TemplateName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ses(
        "SendCustomVerificationEmail",
        Dict{String,Any}("EmailAddress" => EmailAddress, "TemplateName" => TemplateName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function send_custom_verification_email(
    EmailAddress,
    TemplateName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ses(
        "SendCustomVerificationEmail",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "EmailAddress" => EmailAddress, "TemplateName" => TemplateName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    send_email(destination, message, source)
    send_email(destination, message, source, params::Dict{String,<:Any})

Composes an email message and immediately queues it for sending. To send email using this
operation, your message must meet the following requirements:   The message must be sent
from a verified email address or domain. If you attempt to send email using a non-verified
address or domain, the operation results in an \"Email address not verified\" error.    If
your account is still in the Amazon SES sandbox, you may only send to verified addresses or
domains, or to email addresses associated with the Amazon SES Mailbox Simulator. For more
information, see Verifying Email Addresses and Domains in the Amazon SES Developer Guide.
 The maximum message size is 10 MB.   The message must include at least one recipient email
address. The recipient address can be a To: address, a CC: address, or a BCC: address. If a
recipient email address is invalid (that is, it is not in the format
UserName@[SubDomain.]Domain.TopLevelDomain), the entire message is rejected, even if the
message contains other recipients that are valid.   The message may not include more than
50 recipients, across the To:, CC: and BCC: fields. If you need to send an email message to
a larger audience, you can divide your recipient list into groups of 50 or fewer, and then
call the SendEmail operation several times to send the message to each group.    For every
message that you send, the total number of recipients (including each recipient in the To:,
CC: and BCC: fields) is counted against the maximum number of emails you can send in a
24-hour period (your sending quota). For more information about sending quotas in Amazon
SES, see Managing Your Amazon SES Sending Limits in the Amazon SES Developer Guide.

# Arguments
- `destination`: The destination for this email, composed of To:, CC:, and BCC: fields.
- `message`: The message to be sent.
- `source`: The email address that is sending the email. This email address must be either
  individually verified with Amazon SES, or from a domain that has been verified with Amazon
  SES. For information about verifying identities, see the Amazon SES Developer Guide. If you
  are sending on behalf of another user and have been permitted to do so by a sending
  authorization policy, then you must also specify the SourceArn parameter. For more
  information about sending authorization, see the Amazon SES Developer Guide.  Amazon SES
  does not support the SMTPUTF8 extension, as described in RFC6531. For this reason, the
  email address string must be 7-bit ASCII. If you want to send to or from email addresses
  that contain Unicode characters in the domain part of an address, you must encode the
  domain using Punycode. Punycode is not permitted in the local part of the email address
  (the part before the @ sign) nor in the \"friendly from\" name. If you want to use Unicode
  characters in the \"friendly from\" name, you must encode the \"friendly from\" name using
  MIME encoded-word syntax, as described in Sending raw email using the Amazon SES API. For
  more information about Punycode, see RFC 3492.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ConfigurationSetName"`: The name of the configuration set to use when you send an email
  using SendEmail.
- `"ReplyToAddresses"`: The reply-to email address(es) for the message. If the recipient
  replies to the message, each reply-to address receives the reply.
- `"ReturnPath"`: The email address that bounces and complaints are forwarded to when
  feedback forwarding is enabled. If the message cannot be delivered to the recipient, then
  an error message is returned from the recipient's ISP; this message is forwarded to the
  email address specified by the ReturnPath parameter. The ReturnPath parameter is never
  overwritten. This email address must be either individually verified with Amazon SES, or
  from a domain that has been verified with Amazon SES.
- `"ReturnPathArn"`: This parameter is used only for sending authorization. It is the ARN
  of the identity that is associated with the sending authorization policy that permits you
  to use the email address specified in the ReturnPath parameter. For example, if the owner
  of example.com (which has ARN arn:aws:ses:us-east-1:123456789012:identity/example.com)
  attaches a policy to it that authorizes you to use feedback@example.com, then you would
  specify the ReturnPathArn to be arn:aws:ses:us-east-1:123456789012:identity/example.com,
  and the ReturnPath to be feedback@example.com. For more information about sending
  authorization, see the Amazon SES Developer Guide.
- `"SourceArn"`: This parameter is used only for sending authorization. It is the ARN of
  the identity that is associated with the sending authorization policy that permits you to
  send for the email address specified in the Source parameter. For example, if the owner of
  example.com (which has ARN arn:aws:ses:us-east-1:123456789012:identity/example.com)
  attaches a policy to it that authorizes you to send from user@example.com, then you would
  specify the SourceArn to be arn:aws:ses:us-east-1:123456789012:identity/example.com, and
  the Source to be user@example.com. For more information about sending authorization, see
  the Amazon SES Developer Guide.
- `"Tags"`: A list of tags, in the form of name/value pairs, to apply to an email that you
  send using SendEmail. Tags correspond to characteristics of the email that you define, so
  that you can publish email sending events.
"""
function send_email(
    Destination, Message, Source; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ses(
        "SendEmail",
        Dict{String,Any}(
            "Destination" => Destination, "Message" => Message, "Source" => Source
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function send_email(
    Destination,
    Message,
    Source,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ses(
        "SendEmail",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "Destination" => Destination, "Message" => Message, "Source" => Source
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    send_raw_email(raw_message)
    send_raw_email(raw_message, params::Dict{String,<:Any})

Composes an email message and immediately queues it for sending. This operation is more
flexible than the SendEmail operation. When you use the SendRawEmail operation, you can
specify the headers of the message as well as its content. This flexibility is useful, for
example, when you need to send a multipart MIME email (such a message that contains both a
text and an HTML version). You can also use this operation to send messages that include
attachments. The SendRawEmail operation has the following requirements:   You can only send
email from verified email addresses or domains. If you try to send email from an address
that isn't verified, the operation results in an \"Email address not verified\" error.   If
your account is still in the Amazon SES sandbox, you can only send email to other verified
addresses in your account, or to addresses that are associated with the Amazon SES mailbox
simulator.   The maximum message size, including attachments, is 10 MB.   Each message has
to include at least one recipient address. A recipient address includes any address on the
To:, CC:, or BCC: lines.   If you send a single message to more than one recipient address,
and one of the recipient addresses isn't in a valid format (that is, it's not in the format
UserName@[SubDomain.]Domain.TopLevelDomain), Amazon SES rejects the entire message, even if
the other addresses are valid.   Each message can include up to 50 recipient addresses
across the To:, CC:, or BCC: lines. If you need to send a single message to more than 50
recipients, you have to split the list of recipient addresses into groups of less than 50
recipients, and send separate messages to each group.   Amazon SES allows you to specify
8-bit Content-Transfer-Encoding for MIME message parts. However, if Amazon SES has to
modify the contents of your message (for example, if you use open and click tracking),
8-bit content isn't preserved. For this reason, we highly recommend that you encode all
content that isn't 7-bit ASCII. For more information, see MIME Encoding in the Amazon SES
Developer Guide.   Additionally, keep the following considerations in mind when using the
SendRawEmail operation:   Although you can customize the message headers when using the
SendRawEmail operation, Amazon SES automatically applies its own Message-ID and Date
headers; if you passed these headers when creating the message, they are overwritten by the
values that Amazon SES provides.   If you are using sending authorization to send on behalf
of another user, SendRawEmail enables you to specify the cross-account identity for the
email's Source, From, and Return-Path parameters in one of two ways: you can pass optional
parameters SourceArn, FromArn, and/or ReturnPathArn, or you can include the following
X-headers in the header of your raw email:    X-SES-SOURCE-ARN     X-SES-FROM-ARN
X-SES-RETURN-PATH-ARN     Don't include these X-headers in the DKIM signature. Amazon SES
removes these before it sends the email.  If you only specify the SourceIdentityArn
parameter, Amazon SES sets the From and Return-Path addresses to the same identity that you
specified. For more information about sending authorization, see the Using Sending
Authorization with Amazon SES in the Amazon SES Developer Guide.    For every message that
you send, the total number of recipients (including each recipient in the To:, CC: and BCC:
fields) is counted against the maximum number of emails you can send in a 24-hour period
(your sending quota). For more information about sending quotas in Amazon SES, see Managing
Your Amazon SES Sending Limits in the Amazon SES Developer Guide.

# Arguments
- `raw_message`: The raw email message itself. The message has to meet the following
  criteria:   The message has to contain a header and a body, separated by a blank line.
  All of the required header fields must be present in the message.   Each part of a
  multipart MIME message must be formatted properly.   Attachments must be of a content type
  that Amazon SES supports. For a list on unsupported content types, see Unsupported
  Attachment Types in the Amazon SES Developer Guide.   The entire message must be
  base64-encoded.   If any of the MIME parts in your message contain content that is outside
  of the 7-bit ASCII character range, we highly recommend that you encode that content. For
  more information, see Sending Raw Email in the Amazon SES Developer Guide.   Per RFC 5321,
  the maximum length of each line of text, including the &lt;CRLF&gt;, must not exceed 1,000
  characters.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ConfigurationSetName"`: The name of the configuration set to use when you send an email
  using SendRawEmail.
- `"Destinations"`: A list of destinations for the message, consisting of To:, CC:, and
  BCC: addresses.
- `"FromArn"`: This parameter is used only for sending authorization. It is the ARN of the
  identity that is associated with the sending authorization policy that permits you to
  specify a particular \"From\" address in the header of the raw email. Instead of using this
  parameter, you can use the X-header X-SES-FROM-ARN in the raw message of the email. If you
  use both the FromArn parameter and the corresponding X-header, Amazon SES uses the value of
  the FromArn parameter.  For information about when to use this parameter, see the
  description of SendRawEmail in this guide, or see the Amazon SES Developer Guide.
- `"ReturnPathArn"`: This parameter is used only for sending authorization. It is the ARN
  of the identity that is associated with the sending authorization policy that permits you
  to use the email address specified in the ReturnPath parameter. For example, if the owner
  of example.com (which has ARN arn:aws:ses:us-east-1:123456789012:identity/example.com)
  attaches a policy to it that authorizes you to use feedback@example.com, then you would
  specify the ReturnPathArn to be arn:aws:ses:us-east-1:123456789012:identity/example.com,
  and the ReturnPath to be feedback@example.com. Instead of using this parameter, you can use
  the X-header X-SES-RETURN-PATH-ARN in the raw message of the email. If you use both the
  ReturnPathArn parameter and the corresponding X-header, Amazon SES uses the value of the
  ReturnPathArn parameter.  For information about when to use this parameter, see the
  description of SendRawEmail in this guide, or see the Amazon SES Developer Guide.
- `"Source"`: The identity's email address. If you do not provide a value for this
  parameter, you must specify a \"From\" address in the raw text of the message. (You can
  also specify both.)  Amazon SES does not support the SMTPUTF8 extension, as described
  inRFC6531. For this reason, the email address string must be 7-bit ASCII. If you want to
  send to or from email addresses that contain Unicode characters in the domain part of an
  address, you must encode the domain using Punycode. Punycode is not permitted in the local
  part of the email address (the part before the @ sign) nor in the \"friendly from\" name.
  If you want to use Unicode characters in the \"friendly from\" name, you must encode the
  \"friendly from\" name using MIME encoded-word syntax, as described in Sending raw email
  using the Amazon SES API. For more information about Punycode, see RFC 3492.  If you
  specify the Source parameter and have feedback forwarding enabled, then bounces and
  complaints are sent to this email address. This takes precedence over any Return-Path
  header that you might include in the raw text of the message.
- `"SourceArn"`: This parameter is used only for sending authorization. It is the ARN of
  the identity that is associated with the sending authorization policy that permits you to
  send for the email address specified in the Source parameter. For example, if the owner of
  example.com (which has ARN arn:aws:ses:us-east-1:123456789012:identity/example.com)
  attaches a policy to it that authorizes you to send from user@example.com, then you would
  specify the SourceArn to be arn:aws:ses:us-east-1:123456789012:identity/example.com, and
  the Source to be user@example.com. Instead of using this parameter, you can use the
  X-header X-SES-SOURCE-ARN in the raw message of the email. If you use both the SourceArn
  parameter and the corresponding X-header, Amazon SES uses the value of the SourceArn
  parameter.  For information about when to use this parameter, see the description of
  SendRawEmail in this guide, or see the Amazon SES Developer Guide.
- `"Tags"`: A list of tags, in the form of name/value pairs, to apply to an email that you
  send using SendRawEmail. Tags correspond to characteristics of the email that you define,
  so that you can publish email sending events.
"""
function send_raw_email(RawMessage; aws_config::AbstractAWSConfig=current_aws_config())
    return ses(
        "SendRawEmail",
        Dict{String,Any}("RawMessage" => RawMessage);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function send_raw_email(
    RawMessage,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ses(
        "SendRawEmail",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("RawMessage" => RawMessage), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    send_templated_email(destination, source, template, template_data)
    send_templated_email(destination, source, template, template_data, params::Dict{String,<:Any})

Composes an email message using an email template and immediately queues it for sending. To
send email using this operation, your call must meet the following requirements:   The call
must refer to an existing email template. You can create email templates using the
CreateTemplate operation.   The message must be sent from a verified email address or
domain.   If your account is still in the Amazon SES sandbox, you may only send to verified
addresses or domains, or to email addresses associated with the Amazon SES Mailbox
Simulator. For more information, see Verifying Email Addresses and Domains in the Amazon
SES Developer Guide.    The maximum message size is 10 MB.   Calls to the
SendTemplatedEmail operation may only include one Destination parameter. A destination is a
set of recipients that receives the same version of the email. The Destination parameter
can include up to 50 recipients, across the To:, CC: and BCC: fields.   The Destination
parameter must include at least one recipient email address. The recipient address can be a
To: address, a CC: address, or a BCC: address. If a recipient email address is invalid
(that is, it is not in the format UserName@[SubDomain.]Domain.TopLevelDomain), the entire
message is rejected, even if the message contains other recipients that are valid.    If
your call to the SendTemplatedEmail operation includes all of the required parameters,
Amazon SES accepts it and returns a Message ID. However, if Amazon SES can't render the
email because the template contains errors, it doesn't send the email. Additionally,
because it already accepted the message, Amazon SES doesn't return a message stating that
it was unable to send the email. For these reasons, we highly recommend that you set up
Amazon SES to send you notifications when Rendering Failure events occur. For more
information, see Sending Personalized Email Using the Amazon SES API in the Amazon Simple
Email Service Developer Guide.

# Arguments
- `destination`: The destination for this email, composed of To:, CC:, and BCC: fields. A
  Destination can include up to 50 recipients across these three fields.
- `source`: The email address that is sending the email. This email address must be either
  individually verified with Amazon SES, or from a domain that has been verified with Amazon
  SES. For information about verifying identities, see the Amazon SES Developer Guide. If you
  are sending on behalf of another user and have been permitted to do so by a sending
  authorization policy, then you must also specify the SourceArn parameter. For more
  information about sending authorization, see the Amazon SES Developer Guide.  Amazon SES
  does not support the SMTPUTF8 extension, as described in RFC6531. for this reason, The
  email address string must be 7-bit ASCII. If you want to send to or from email addresses
  that contain Unicode characters in the domain part of an address, you must encode the
  domain using Punycode. Punycode is not permitted in the local part of the email address
  (the part before the @ sign) nor in the \"friendly from\" name. If you want to use Unicode
  characters in the \"friendly from\" name, you must encode the \"friendly from\" name using
  MIME encoded-word syntax, as described in Sending raw email using the Amazon SES API. For
  more information about Punycode, see RFC 3492.
- `template`: The template to use when sending this email.
- `template_data`: A list of replacement values to apply to the template. This parameter is
  a JSON object, typically consisting of key-value pairs in which the keys correspond to
  replacement tags in the email template.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ConfigurationSetName"`: The name of the configuration set to use when you send an email
  using SendTemplatedEmail.
- `"ReplyToAddresses"`: The reply-to email address(es) for the message. If the recipient
  replies to the message, each reply-to address receives the reply.
- `"ReturnPath"`: The email address that bounces and complaints are forwarded to when
  feedback forwarding is enabled. If the message cannot be delivered to the recipient, then
  an error message is returned from the recipient's ISP; this message is forwarded to the
  email address specified by the ReturnPath parameter. The ReturnPath parameter is never
  overwritten. This email address must be either individually verified with Amazon SES, or
  from a domain that has been verified with Amazon SES.
- `"ReturnPathArn"`: This parameter is used only for sending authorization. It is the ARN
  of the identity that is associated with the sending authorization policy that permits you
  to use the email address specified in the ReturnPath parameter. For example, if the owner
  of example.com (which has ARN arn:aws:ses:us-east-1:123456789012:identity/example.com)
  attaches a policy to it that authorizes you to use feedback@example.com, then you would
  specify the ReturnPathArn to be arn:aws:ses:us-east-1:123456789012:identity/example.com,
  and the ReturnPath to be feedback@example.com. For more information about sending
  authorization, see the Amazon SES Developer Guide.
- `"SourceArn"`: This parameter is used only for sending authorization. It is the ARN of
  the identity that is associated with the sending authorization policy that permits you to
  send for the email address specified in the Source parameter. For example, if the owner of
  example.com (which has ARN arn:aws:ses:us-east-1:123456789012:identity/example.com)
  attaches a policy to it that authorizes you to send from user@example.com, then you would
  specify the SourceArn to be arn:aws:ses:us-east-1:123456789012:identity/example.com, and
  the Source to be user@example.com. For more information about sending authorization, see
  the Amazon SES Developer Guide.
- `"Tags"`: A list of tags, in the form of name/value pairs, to apply to an email that you
  send using SendTemplatedEmail. Tags correspond to characteristics of the email that you
  define, so that you can publish email sending events.
- `"TemplateArn"`: The ARN of the template to use when sending this email.
"""
function send_templated_email(
    Destination,
    Source,
    Template,
    TemplateData;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ses(
        "SendTemplatedEmail",
        Dict{String,Any}(
            "Destination" => Destination,
            "Source" => Source,
            "Template" => Template,
            "TemplateData" => TemplateData,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function send_templated_email(
    Destination,
    Source,
    Template,
    TemplateData,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ses(
        "SendTemplatedEmail",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "Destination" => Destination,
                    "Source" => Source,
                    "Template" => Template,
                    "TemplateData" => TemplateData,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    set_active_receipt_rule_set()
    set_active_receipt_rule_set(params::Dict{String,<:Any})

Sets the specified receipt rule set as the active receipt rule set.  To disable your
email-receiving through Amazon SES completely, you can call this operation with RuleSetName
set to null.  For information about managing receipt rule sets, see the Amazon SES
Developer Guide. You can execute this operation no more than once per second.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"RuleSetName"`: The name of the receipt rule set to make active. Setting this value to
  null disables all email receiving.
"""
function set_active_receipt_rule_set(; aws_config::AbstractAWSConfig=current_aws_config())
    return ses(
        "SetActiveReceiptRuleSet"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function set_active_receipt_rule_set(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ses(
        "SetActiveReceiptRuleSet",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    set_identity_dkim_enabled(dkim_enabled, identity)
    set_identity_dkim_enabled(dkim_enabled, identity, params::Dict{String,<:Any})

Enables or disables Easy DKIM signing of email sent from an identity. If Easy DKIM signing
is enabled for a domain, then Amazon SES uses DKIM to sign all email that it sends from
addresses on that domain. If Easy DKIM signing is enabled for an email address, then Amazon
SES uses DKIM to sign all email it sends from that address.  For email addresses (for
example, user@example.com), you can only enable DKIM signing if the corresponding domain
(in this case, example.com) has been set up to use Easy DKIM.  You can enable DKIM signing
for an identity at any time after you start the verification process for the identity, even
if the verification process isn't complete.  You can execute this operation no more than
once per second. For more information about Easy DKIM signing, go to the Amazon SES
Developer Guide.

# Arguments
- `dkim_enabled`: Sets whether DKIM signing is enabled for an identity. Set to true to
  enable DKIM signing for this identity; false to disable it.
- `identity`: The identity for which DKIM signing should be enabled or disabled.

"""
function set_identity_dkim_enabled(
    DkimEnabled, Identity; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ses(
        "SetIdentityDkimEnabled",
        Dict{String,Any}("DkimEnabled" => DkimEnabled, "Identity" => Identity);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function set_identity_dkim_enabled(
    DkimEnabled,
    Identity,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ses(
        "SetIdentityDkimEnabled",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("DkimEnabled" => DkimEnabled, "Identity" => Identity),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    set_identity_feedback_forwarding_enabled(forwarding_enabled, identity)
    set_identity_feedback_forwarding_enabled(forwarding_enabled, identity, params::Dict{String,<:Any})

Given an identity (an email address or a domain), enables or disables whether Amazon SES
forwards bounce and complaint notifications as email. Feedback forwarding can only be
disabled when Amazon Simple Notification Service (Amazon SNS) topics are specified for both
bounces and complaints.  Feedback forwarding does not apply to delivery notifications.
Delivery notifications are only available through Amazon SNS.  You can execute this
operation no more than once per second. For more information about using notifications with
Amazon SES, see the Amazon SES Developer Guide.

# Arguments
- `forwarding_enabled`: Sets whether Amazon SES forwards bounce and complaint notifications
  as email. true specifies that Amazon SES forwards bounce and complaint notifications as
  email, in addition to any Amazon SNS topic publishing otherwise specified. false specifies
  that Amazon SES publishes bounce and complaint notifications only through Amazon SNS. This
  value can only be set to false when Amazon SNS topics are set for both Bounce and Complaint
  notification types.
- `identity`: The identity for which to set bounce and complaint notification forwarding.
  Examples: user@example.com, example.com.

"""
function set_identity_feedback_forwarding_enabled(
    ForwardingEnabled, Identity; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ses(
        "SetIdentityFeedbackForwardingEnabled",
        Dict{String,Any}("ForwardingEnabled" => ForwardingEnabled, "Identity" => Identity);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function set_identity_feedback_forwarding_enabled(
    ForwardingEnabled,
    Identity,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ses(
        "SetIdentityFeedbackForwardingEnabled",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ForwardingEnabled" => ForwardingEnabled, "Identity" => Identity
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    set_identity_headers_in_notifications_enabled(enabled, identity, notification_type)
    set_identity_headers_in_notifications_enabled(enabled, identity, notification_type, params::Dict{String,<:Any})

Given an identity (an email address or a domain), sets whether Amazon SES includes the
original email headers in the Amazon Simple Notification Service (Amazon SNS) notifications
of a specified type. You can execute this operation no more than once per second. For more
information about using notifications with Amazon SES, see the Amazon SES Developer Guide.

# Arguments
- `enabled`: Sets whether Amazon SES includes the original email headers in Amazon SNS
  notifications of the specified notification type. A value of true specifies that Amazon SES
  includes headers in notifications, and a value of false specifies that Amazon SES does not
  include headers in notifications. This value can only be set when NotificationType is
  already set to use a particular Amazon SNS topic.
- `identity`: The identity for which to enable or disable headers in notifications.
  Examples: user@example.com, example.com.
- `notification_type`: The notification type for which to enable or disable headers in
  notifications.

"""
function set_identity_headers_in_notifications_enabled(
    Enabled, Identity, NotificationType; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ses(
        "SetIdentityHeadersInNotificationsEnabled",
        Dict{String,Any}(
            "Enabled" => Enabled,
            "Identity" => Identity,
            "NotificationType" => NotificationType,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function set_identity_headers_in_notifications_enabled(
    Enabled,
    Identity,
    NotificationType,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ses(
        "SetIdentityHeadersInNotificationsEnabled",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "Enabled" => Enabled,
                    "Identity" => Identity,
                    "NotificationType" => NotificationType,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    set_identity_mail_from_domain(identity)
    set_identity_mail_from_domain(identity, params::Dict{String,<:Any})

Enables or disables the custom MAIL FROM domain setup for a verified identity (an email
address or a domain).  To send emails using the specified MAIL FROM domain, you must add an
MX record to your MAIL FROM domain's DNS settings. To ensure that your emails pass Sender
Policy Framework (SPF) checks, you must also add or update an SPF record. For more
information, see the Amazon SES Developer Guide.  You can execute this operation no more
than once per second.

# Arguments
- `identity`: The verified identity.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"BehaviorOnMXFailure"`: The action for Amazon SES to take if it cannot successfully read
  the required MX record when you send an email. If you choose UseDefaultValue, Amazon SES
  uses amazonses.com (or a subdomain of that) as the MAIL FROM domain. If you choose
  RejectMessage, Amazon SES returns a MailFromDomainNotVerified error and not send the email.
  The action specified in BehaviorOnMXFailure is taken when the custom MAIL FROM domain setup
  is in the Pending, Failed, and TemporaryFailure states.
- `"MailFromDomain"`: The custom MAIL FROM domain for the verified identity to use. The
  MAIL FROM domain must 1) be a subdomain of the verified identity, 2) not be used in a
  \"From\" address if the MAIL FROM domain is the destination of email feedback forwarding
  (for more information, see the Amazon SES Developer Guide), and 3) not be used to receive
  emails. A value of null disables the custom MAIL FROM setting for the identity.
"""
function set_identity_mail_from_domain(
    Identity; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ses(
        "SetIdentityMailFromDomain",
        Dict{String,Any}("Identity" => Identity);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function set_identity_mail_from_domain(
    Identity,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ses(
        "SetIdentityMailFromDomain",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("Identity" => Identity), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    set_identity_notification_topic(identity, notification_type)
    set_identity_notification_topic(identity, notification_type, params::Dict{String,<:Any})

Sets an Amazon Simple Notification Service (Amazon SNS) topic to use when delivering
notifications. When you use this operation, you specify a verified identity, such as an
email address or domain. When you send an email that uses the chosen identity in the Source
field, Amazon SES sends notifications to the topic you specified. You can send bounce,
complaint, or delivery notifications (or any combination of the three) to the Amazon SNS
topic that you specify. You can execute this operation no more than once per second. For
more information about feedback notification, see the Amazon SES Developer Guide.

# Arguments
- `identity`: The identity (email address or domain) for the Amazon SNS topic.  You can
  only specify a verified identity for this parameter.  You can specify an identity by using
  its name or by using its Amazon Resource Name (ARN). The following examples are all valid
  identities: sender@example.com, example.com,
  arn:aws:ses:us-east-1:123456789012:identity/example.com.
- `notification_type`: The type of notifications that are published to the specified Amazon
  SNS topic.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"SnsTopic"`: The Amazon Resource Name (ARN) of the Amazon SNS topic. If the parameter is
  omitted from the request or a null value is passed, SnsTopic is cleared and publishing is
  disabled.
"""
function set_identity_notification_topic(
    Identity, NotificationType; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ses(
        "SetIdentityNotificationTopic",
        Dict{String,Any}("Identity" => Identity, "NotificationType" => NotificationType);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function set_identity_notification_topic(
    Identity,
    NotificationType,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ses(
        "SetIdentityNotificationTopic",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "Identity" => Identity, "NotificationType" => NotificationType
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    set_receipt_rule_position(rule_name, rule_set_name)
    set_receipt_rule_position(rule_name, rule_set_name, params::Dict{String,<:Any})

Sets the position of the specified receipt rule in the receipt rule set. For information
about managing receipt rules, see the Amazon SES Developer Guide. You can execute this
operation no more than once per second.

# Arguments
- `rule_name`: The name of the receipt rule to reposition.
- `rule_set_name`: The name of the receipt rule set that contains the receipt rule to
  reposition.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"After"`: The name of the receipt rule after which to place the specified receipt rule.
"""
function set_receipt_rule_position(
    RuleName, RuleSetName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ses(
        "SetReceiptRulePosition",
        Dict{String,Any}("RuleName" => RuleName, "RuleSetName" => RuleSetName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function set_receipt_rule_position(
    RuleName,
    RuleSetName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ses(
        "SetReceiptRulePosition",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("RuleName" => RuleName, "RuleSetName" => RuleSetName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    test_render_template(template_data, template_name)
    test_render_template(template_data, template_name, params::Dict{String,<:Any})

Creates a preview of the MIME content of an email when provided with a template and a set
of replacement data. You can execute this operation no more than once per second.

# Arguments
- `template_data`: A list of replacement values to apply to the template. This parameter is
  a JSON object, typically consisting of key-value pairs in which the keys correspond to
  replacement tags in the email template.
- `template_name`: The name of the template to render.

"""
function test_render_template(
    TemplateData, TemplateName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ses(
        "TestRenderTemplate",
        Dict{String,Any}("TemplateData" => TemplateData, "TemplateName" => TemplateName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function test_render_template(
    TemplateData,
    TemplateName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ses(
        "TestRenderTemplate",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "TemplateData" => TemplateData, "TemplateName" => TemplateName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_account_sending_enabled()
    update_account_sending_enabled(params::Dict{String,<:Any})

Enables or disables email sending across your entire Amazon SES account in the current
Amazon Web Services Region. You can use this operation in conjunction with Amazon
CloudWatch alarms to temporarily pause email sending across your Amazon SES account in a
given Amazon Web Services Region when reputation metrics (such as your bounce or complaint
rates) reach certain thresholds. You can execute this operation no more than once per
second.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Enabled"`: Describes whether email sending is enabled or disabled for your Amazon SES
  account in the current Amazon Web Services Region.
"""
function update_account_sending_enabled(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return ses(
        "UpdateAccountSendingEnabled";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_account_sending_enabled(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ses(
        "UpdateAccountSendingEnabled",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_configuration_set_event_destination(configuration_set_name, event_destination)
    update_configuration_set_event_destination(configuration_set_name, event_destination, params::Dict{String,<:Any})

Updates the event destination of a configuration set. Event destinations are associated
with configuration sets, which enable you to publish email sending events to Amazon
CloudWatch, Amazon Kinesis Firehose, or Amazon Simple Notification Service (Amazon SNS).
For information about using configuration sets, see Monitoring Your Amazon SES Sending
Activity in the Amazon SES Developer Guide.   When you create or update an event
destination, you must provide one, and only one, destination. The destination can be Amazon
CloudWatch, Amazon Kinesis Firehose, or Amazon Simple Notification Service (Amazon SNS).
You can execute this operation no more than once per second.

# Arguments
- `configuration_set_name`: The name of the configuration set that contains the event
  destination.
- `event_destination`: The event destination object.

"""
function update_configuration_set_event_destination(
    ConfigurationSetName,
    EventDestination;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ses(
        "UpdateConfigurationSetEventDestination",
        Dict{String,Any}(
            "ConfigurationSetName" => ConfigurationSetName,
            "EventDestination" => EventDestination,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_configuration_set_event_destination(
    ConfigurationSetName,
    EventDestination,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ses(
        "UpdateConfigurationSetEventDestination",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ConfigurationSetName" => ConfigurationSetName,
                    "EventDestination" => EventDestination,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_configuration_set_reputation_metrics_enabled(configuration_set_name, enabled)
    update_configuration_set_reputation_metrics_enabled(configuration_set_name, enabled, params::Dict{String,<:Any})

Enables or disables the publishing of reputation metrics for emails sent using a specific
configuration set in a given Amazon Web Services Region. Reputation metrics include bounce
and complaint rates. These metrics are published to Amazon CloudWatch. By using CloudWatch,
you can create alarms when bounce or complaint rates exceed certain thresholds. You can
execute this operation no more than once per second.

# Arguments
- `configuration_set_name`: The name of the configuration set to update.
- `enabled`: Describes whether or not Amazon SES publishes reputation metrics for the
  configuration set, such as bounce and complaint rates, to Amazon CloudWatch.

"""
function update_configuration_set_reputation_metrics_enabled(
    ConfigurationSetName, Enabled; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ses(
        "UpdateConfigurationSetReputationMetricsEnabled",
        Dict{String,Any}(
            "ConfigurationSetName" => ConfigurationSetName, "Enabled" => Enabled
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_configuration_set_reputation_metrics_enabled(
    ConfigurationSetName,
    Enabled,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ses(
        "UpdateConfigurationSetReputationMetricsEnabled",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ConfigurationSetName" => ConfigurationSetName, "Enabled" => Enabled
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_configuration_set_sending_enabled(configuration_set_name, enabled)
    update_configuration_set_sending_enabled(configuration_set_name, enabled, params::Dict{String,<:Any})

Enables or disables email sending for messages sent using a specific configuration set in a
given Amazon Web Services Region. You can use this operation in conjunction with Amazon
CloudWatch alarms to temporarily pause email sending for a configuration set when the
reputation metrics for that configuration set (such as your bounce on complaint rate)
exceed certain thresholds. You can execute this operation no more than once per second.

# Arguments
- `configuration_set_name`: The name of the configuration set to update.
- `enabled`: Describes whether email sending is enabled or disabled for the configuration
  set.

"""
function update_configuration_set_sending_enabled(
    ConfigurationSetName, Enabled; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ses(
        "UpdateConfigurationSetSendingEnabled",
        Dict{String,Any}(
            "ConfigurationSetName" => ConfigurationSetName, "Enabled" => Enabled
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_configuration_set_sending_enabled(
    ConfigurationSetName,
    Enabled,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ses(
        "UpdateConfigurationSetSendingEnabled",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ConfigurationSetName" => ConfigurationSetName, "Enabled" => Enabled
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_configuration_set_tracking_options(configuration_set_name, tracking_options)
    update_configuration_set_tracking_options(configuration_set_name, tracking_options, params::Dict{String,<:Any})

Modifies an association between a configuration set and a custom domain for open and click
event tracking.  By default, images and links used for tracking open and click events are
hosted on domains operated by Amazon SES. You can configure a subdomain of your own to
handle these events. For information about using custom domains, see the Amazon SES
Developer Guide.

# Arguments
- `configuration_set_name`: The name of the configuration set.
- `tracking_options`:

"""
function update_configuration_set_tracking_options(
    ConfigurationSetName,
    TrackingOptions;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ses(
        "UpdateConfigurationSetTrackingOptions",
        Dict{String,Any}(
            "ConfigurationSetName" => ConfigurationSetName,
            "TrackingOptions" => TrackingOptions,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_configuration_set_tracking_options(
    ConfigurationSetName,
    TrackingOptions,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ses(
        "UpdateConfigurationSetTrackingOptions",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ConfigurationSetName" => ConfigurationSetName,
                    "TrackingOptions" => TrackingOptions,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_custom_verification_email_template(template_name)
    update_custom_verification_email_template(template_name, params::Dict{String,<:Any})

Updates an existing custom verification email template. For more information about custom
verification email templates, see Using Custom Verification Email Templates in the Amazon
SES Developer Guide. You can execute this operation no more than once per second.

# Arguments
- `template_name`: The name of the custom verification email template to update.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"FailureRedirectionURL"`: The URL that the recipient of the verification email is sent
  to if his or her address is not successfully verified.
- `"FromEmailAddress"`: The email address that the custom verification email is sent from.
- `"SuccessRedirectionURL"`: The URL that the recipient of the verification email is sent
  to if his or her address is successfully verified.
- `"TemplateContent"`: The content of the custom verification email. The total size of the
  email must be less than 10 MB. The message body may contain HTML, with some limitations.
  For more information, see Custom Verification Email Frequently Asked Questions in the
  Amazon SES Developer Guide.
- `"TemplateSubject"`: The subject line of the custom verification email.
"""
function update_custom_verification_email_template(
    TemplateName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ses(
        "UpdateCustomVerificationEmailTemplate",
        Dict{String,Any}("TemplateName" => TemplateName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_custom_verification_email_template(
    TemplateName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ses(
        "UpdateCustomVerificationEmailTemplate",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("TemplateName" => TemplateName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_receipt_rule(rule, rule_set_name)
    update_receipt_rule(rule, rule_set_name, params::Dict{String,<:Any})

Updates a receipt rule. For information about managing receipt rules, see the Amazon SES
Developer Guide. You can execute this operation no more than once per second.

# Arguments
- `rule`: A data structure that contains the updated receipt rule information.
- `rule_set_name`: The name of the receipt rule set that the receipt rule belongs to.

"""
function update_receipt_rule(
    Rule, RuleSetName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ses(
        "UpdateReceiptRule",
        Dict{String,Any}("Rule" => Rule, "RuleSetName" => RuleSetName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_receipt_rule(
    Rule,
    RuleSetName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ses(
        "UpdateReceiptRule",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("Rule" => Rule, "RuleSetName" => RuleSetName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_template(template)
    update_template(template, params::Dict{String,<:Any})

Updates an email template. Email templates enable you to send personalized email to one or
more destinations in a single operation. For more information, see the Amazon SES Developer
Guide. You can execute this operation no more than once per second.

# Arguments
- `template`:

"""
function update_template(Template; aws_config::AbstractAWSConfig=current_aws_config())
    return ses(
        "UpdateTemplate",
        Dict{String,Any}("Template" => Template);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_template(
    Template,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ses(
        "UpdateTemplate",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("Template" => Template), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    verify_domain_dkim(domain)
    verify_domain_dkim(domain, params::Dict{String,<:Any})

Returns a set of DKIM tokens for a domain identity.  When you execute the VerifyDomainDkim
operation, the domain that you specify is added to the list of identities that are
associated with your account. This is true even if you haven't already associated the
domain with your account by using the VerifyDomainIdentity operation. However, you can't
send email from the domain until you either successfully verify it or you successfully set
up DKIM for it.  You use the tokens that are generated by this operation to create CNAME
records. When Amazon SES detects that you've added these records to the DNS configuration
for a domain, you can start sending email from that domain. You can start sending email
even if you haven't added the TXT record provided by the VerifyDomainIdentity operation to
the DNS configuration for your domain. All email that you send from the domain is
authenticated using DKIM. To create the CNAME records for DKIM authentication, use the
following values:    Name: token._domainkey.example.com     Type: CNAME    Value:
token.dkim.amazonses.com   In the preceding example, replace token with one of the tokens
that are generated when you execute this operation. Replace example.com with your domain.
Repeat this process for each token that's generated by this operation. You can execute this
operation no more than once per second.

# Arguments
- `domain`: The name of the domain to be verified for Easy DKIM signing.

"""
function verify_domain_dkim(Domain; aws_config::AbstractAWSConfig=current_aws_config())
    return ses(
        "VerifyDomainDkim",
        Dict{String,Any}("Domain" => Domain);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function verify_domain_dkim(
    Domain, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ses(
        "VerifyDomainDkim",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Domain" => Domain), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    verify_domain_identity(domain)
    verify_domain_identity(domain, params::Dict{String,<:Any})

Adds a domain to the list of identities for your Amazon SES account in the current Amazon
Web Services Region and attempts to verify it. For more information about verifying
domains, see Verifying Email Addresses and Domains in the Amazon SES Developer Guide.  You
can execute this operation no more than once per second.

# Arguments
- `domain`: The domain to be verified.

"""
function verify_domain_identity(Domain; aws_config::AbstractAWSConfig=current_aws_config())
    return ses(
        "VerifyDomainIdentity",
        Dict{String,Any}("Domain" => Domain);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function verify_domain_identity(
    Domain, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ses(
        "VerifyDomainIdentity",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Domain" => Domain), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    verify_email_address(email_address)
    verify_email_address(email_address, params::Dict{String,<:Any})

Deprecated. Use the VerifyEmailIdentity operation to verify a new email address.

# Arguments
- `email_address`: The email address to be verified.

"""
function verify_email_address(
    EmailAddress; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ses(
        "VerifyEmailAddress",
        Dict{String,Any}("EmailAddress" => EmailAddress);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function verify_email_address(
    EmailAddress,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ses(
        "VerifyEmailAddress",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("EmailAddress" => EmailAddress), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    verify_email_identity(email_address)
    verify_email_identity(email_address, params::Dict{String,<:Any})

Adds an email address to the list of identities for your Amazon SES account in the current
Amazon Web Services Region and attempts to verify it. As a result of executing this
operation, a verification email is sent to the specified address. You can execute this
operation no more than once per second.

# Arguments
- `email_address`: The email address to be verified.

"""
function verify_email_identity(
    EmailAddress; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ses(
        "VerifyEmailIdentity",
        Dict{String,Any}("EmailAddress" => EmailAddress);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function verify_email_identity(
    EmailAddress,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ses(
        "VerifyEmailIdentity",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("EmailAddress" => EmailAddress), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
