# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: sfn
using AWS.Compat
using AWS.UUIDs

"""
    create_activity(name)
    create_activity(name, params::Dict{String,<:Any})

Creates an activity. An activity is a task that you write in any programming language and
host on any machine that has access to Step Functions. Activities must poll Step Functions
using the GetActivityTask API action and respond using SendTask* API actions. This function
lets Step Functions know the existence of your activity and returns an identifier for use
in a state machine and when polling from the activity.  This operation is eventually
consistent. The results are best effort and may not reflect very recent updates and
changes.    CreateActivity is an idempotent API. Subsequent requests won’t create a
duplicate resource if it was already created. CreateActivity's idempotency check is based
on the activity name. If a following request has different tags values, Step Functions will
ignore these differences and treat it as an idempotent request of the previous. In this
case, tags will not be updated, even if they are different.

# Arguments
- `name`: The name of the activity to create. This name must be unique for your Amazon Web
  Services account and region for 90 days. For more information, see  Limits Related to State
  Machine Executions in the Step Functions Developer Guide. A name must not contain:   white
  space   brackets &lt; &gt; { } [ ]    wildcard characters ? *    special characters \" # %
  ^ | ~ `  &amp; , ; : /    control characters (U+0000-001F, U+007F-009F)   To enable logging
  with CloudWatch Logs, the name should only contain 0-9, A-Z, a-z, - and _.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"tags"`: The list of tags to add to a resource. An array of key-value pairs. For more
  information, see Using Cost Allocation Tags in the Amazon Web Services Billing and Cost
  Management User Guide, and Controlling Access Using IAM Tags. Tags may only contain Unicode
  letters, digits, white space, or these symbols: _ . : / = + - @.
"""
function create_activity(name; aws_config::AbstractAWSConfig=current_aws_config())
    return sfn(
        "CreateActivity",
        Dict{String,Any}("name" => name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_activity(
    name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sfn(
        "CreateActivity",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("name" => name), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_state_machine(definition, name, role_arn)
    create_state_machine(definition, name, role_arn, params::Dict{String,<:Any})

Creates a state machine. A state machine consists of a collection of states that can do
work (Task states), determine to which states to transition next (Choice states), stop an
execution with an error (Fail states), and so on. State machines are specified using a
JSON-based, structured language. For more information, see Amazon States Language in the
Step Functions User Guide. If you set the publish parameter of this API action to true, it
publishes version 1 as the first revision of the state machine.  This operation is
eventually consistent. The results are best effort and may not reflect very recent updates
and changes.    CreateStateMachine is an idempotent API. Subsequent requests won’t create
a duplicate resource if it was already created. CreateStateMachine's idempotency check is
based on the state machine name, definition, type, LoggingConfiguration, and
TracingConfiguration. The check is also based on the publish and versionDescription
parameters. If a following request has a different roleArn or tags, Step Functions will
ignore these differences and treat it as an idempotent request of the previous. In this
case, roleArn and tags will not be updated, even if they are different.

# Arguments
- `definition`: The Amazon States Language definition of the state machine. See Amazon
  States Language.
- `name`: The name of the state machine.  A name must not contain:   white space   brackets
  &lt; &gt; { } [ ]    wildcard characters ? *    special characters \" # %  ^ | ~ `  &amp; ,
  ; : /    control characters (U+0000-001F, U+007F-009F)   To enable logging with CloudWatch
  Logs, the name should only contain 0-9, A-Z, a-z, - and _.
- `role_arn`: The Amazon Resource Name (ARN) of the IAM role to use for this state machine.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"loggingConfiguration"`: Defines what execution history events are logged and where they
  are logged.  By default, the level is set to OFF. For more information see Log Levels in
  the Step Functions User Guide.
- `"publish"`: Set to true to publish the first version of the state machine during
  creation. The default is false.
- `"tags"`: Tags to be added when creating a state machine. An array of key-value pairs.
  For more information, see Using Cost Allocation Tags in the Amazon Web Services Billing and
  Cost Management User Guide, and Controlling Access Using IAM Tags. Tags may only contain
  Unicode letters, digits, white space, or these symbols: _ . : / = + - @.
- `"tracingConfiguration"`: Selects whether X-Ray tracing is enabled.
- `"type"`: Determines whether a Standard or Express state machine is created. The default
  is STANDARD. You cannot update the type of a state machine once it has been created.
- `"versionDescription"`: Sets description about the state machine version. You can only
  set the description if the publish parameter is set to true. Otherwise, if you set
  versionDescription, but publish to false, this API action throws ValidationException.
"""
function create_state_machine(
    definition, name, roleArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sfn(
        "CreateStateMachine",
        Dict{String,Any}("definition" => definition, "name" => name, "roleArn" => roleArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_state_machine(
    definition,
    name,
    roleArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sfn(
        "CreateStateMachine",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "definition" => definition, "name" => name, "roleArn" => roleArn
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_state_machine_alias(name, routing_configuration)
    create_state_machine_alias(name, routing_configuration, params::Dict{String,<:Any})

Creates an alias for a state machine that points to one or two versions of the same state
machine. You can set your application to call StartExecution with an alias and update the
version the alias uses without changing the client's code. You can also map an alias to
split StartExecution requests between two versions of a state machine. To do this, add a
second RoutingConfig object in the routingConfiguration parameter. You must also specify
the percentage of execution run requests each version should receive in both RoutingConfig
objects. Step Functions randomly chooses which version runs a given execution based on the
percentage you specify. To create an alias that points to a single version, specify a
single RoutingConfig object with a weight set to 100. You can create up to 100 aliases for
each state machine. You must delete unused aliases using the DeleteStateMachineAlias API
action.  CreateStateMachineAlias is an idempotent API. Step Functions bases the idempotency
check on the stateMachineArn, description, name, and routingConfiguration parameters.
Requests that contain the same values for these parameters return a successful idempotent
response without creating a duplicate resource.  Related operations:
DescribeStateMachineAlias     ListStateMachineAliases     UpdateStateMachineAlias
DeleteStateMachineAlias

# Arguments
- `name`: The name of the state machine alias. To avoid conflict with version ARNs, don't
  use an integer in the name of the alias.
- `routing_configuration`: The routing configuration of a state machine alias. The routing
  configuration shifts execution traffic between two state machine versions.
  routingConfiguration contains an array of RoutingConfig objects that specify up to two
  state machine versions. Step Functions then randomly choses which version to run an
  execution with based on the weight assigned to each RoutingConfig.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"description"`: A description for the state machine alias.
"""
function create_state_machine_alias(
    name, routingConfiguration; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sfn(
        "CreateStateMachineAlias",
        Dict{String,Any}("name" => name, "routingConfiguration" => routingConfiguration);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_state_machine_alias(
    name,
    routingConfiguration,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sfn(
        "CreateStateMachineAlias",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "name" => name, "routingConfiguration" => routingConfiguration
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_activity(activity_arn)
    delete_activity(activity_arn, params::Dict{String,<:Any})

Deletes an activity.

# Arguments
- `activity_arn`: The Amazon Resource Name (ARN) of the activity to delete.

"""
function delete_activity(activityArn; aws_config::AbstractAWSConfig=current_aws_config())
    return sfn(
        "DeleteActivity",
        Dict{String,Any}("activityArn" => activityArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_activity(
    activityArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sfn(
        "DeleteActivity",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("activityArn" => activityArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_state_machine(state_machine_arn)
    delete_state_machine(state_machine_arn, params::Dict{String,<:Any})

Deletes a state machine. This is an asynchronous operation. It sets the state machine's
status to DELETING and begins the deletion process. A state machine is deleted only when
all its executions are completed. On the next state transition, the state machine's
executions are terminated. A qualified state machine ARN can either refer to a Distributed
Map state defined within a state machine, a version ARN, or an alias ARN. The following are
some examples of qualified and unqualified state machine ARNs:   The following qualified
state machine ARN refers to a Distributed Map state with a label mapStateLabel in a state
machine named myStateMachine.
arn:partition:states:region:account-id:stateMachine:myStateMachine/mapStateLabel   If you
provide a qualified state machine ARN that refers to a Distributed Map state, the request
fails with ValidationException.    The following unqualified state machine ARN refers to a
state machine named myStateMachine.
arn:partition:states:region:account-id:stateMachine:myStateMachine    This API action also
deletes all versions and aliases associated with a state machine.  For EXPRESS state
machines, the deletion happens eventually (usually in less than a minute). Running
executions may emit logs after DeleteStateMachine API is called.

# Arguments
- `state_machine_arn`: The Amazon Resource Name (ARN) of the state machine to delete.

"""
function delete_state_machine(
    stateMachineArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sfn(
        "DeleteStateMachine",
        Dict{String,Any}("stateMachineArn" => stateMachineArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_state_machine(
    stateMachineArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sfn(
        "DeleteStateMachine",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("stateMachineArn" => stateMachineArn), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_state_machine_alias(state_machine_alias_arn)
    delete_state_machine_alias(state_machine_alias_arn, params::Dict{String,<:Any})

Deletes a state machine alias. After you delete a state machine alias, you can't use it to
start executions. When you delete a state machine alias, Step Functions doesn't delete the
state machine versions that alias references.  Related operations:
CreateStateMachineAlias     DescribeStateMachineAlias     ListStateMachineAliases
UpdateStateMachineAlias

# Arguments
- `state_machine_alias_arn`: The Amazon Resource Name (ARN) of the state machine alias to
  delete.

"""
function delete_state_machine_alias(
    stateMachineAliasArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sfn(
        "DeleteStateMachineAlias",
        Dict{String,Any}("stateMachineAliasArn" => stateMachineAliasArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_state_machine_alias(
    stateMachineAliasArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sfn(
        "DeleteStateMachineAlias",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("stateMachineAliasArn" => stateMachineAliasArn),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_state_machine_version(state_machine_version_arn)
    delete_state_machine_version(state_machine_version_arn, params::Dict{String,<:Any})

Deletes a state machine version. After you delete a version, you can't call StartExecution
using that version's ARN or use the version with a state machine alias.  Deleting a state
machine version won't terminate its in-progress executions.   You can't delete a state
machine version currently referenced by one or more aliases. Before you delete a version,
you must either delete the aliases or update them to point to another state machine
version.   Related operations:     PublishStateMachineVersion     ListStateMachineVersions


# Arguments
- `state_machine_version_arn`: The Amazon Resource Name (ARN) of the state machine version
  to delete.

"""
function delete_state_machine_version(
    stateMachineVersionArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sfn(
        "DeleteStateMachineVersion",
        Dict{String,Any}("stateMachineVersionArn" => stateMachineVersionArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_state_machine_version(
    stateMachineVersionArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sfn(
        "DeleteStateMachineVersion",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("stateMachineVersionArn" => stateMachineVersionArn),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_activity(activity_arn)
    describe_activity(activity_arn, params::Dict{String,<:Any})

Describes an activity.  This operation is eventually consistent. The results are best
effort and may not reflect very recent updates and changes.

# Arguments
- `activity_arn`: The Amazon Resource Name (ARN) of the activity to describe.

"""
function describe_activity(activityArn; aws_config::AbstractAWSConfig=current_aws_config())
    return sfn(
        "DescribeActivity",
        Dict{String,Any}("activityArn" => activityArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_activity(
    activityArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sfn(
        "DescribeActivity",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("activityArn" => activityArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_execution(execution_arn)
    describe_execution(execution_arn, params::Dict{String,<:Any})

Provides information about a state machine execution, such as the state machine associated
with the execution, the execution input and output, and relevant execution metadata. If
you've redriven an execution, you can use this API action to return information about the
redrives of that execution. In addition, you can use this API action to return the Map Run
Amazon Resource Name (ARN) if the execution was dispatched by a Map Run. If you specify a
version or alias ARN when you call the StartExecution API action, DescribeExecution returns
that ARN.  This operation is eventually consistent. The results are best effort and may not
reflect very recent updates and changes.  Executions of an EXPRESS state machine aren't
supported by DescribeExecution unless a Map Run dispatched them.

# Arguments
- `execution_arn`: The Amazon Resource Name (ARN) of the execution to describe.

"""
function describe_execution(
    executionArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sfn(
        "DescribeExecution",
        Dict{String,Any}("executionArn" => executionArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_execution(
    executionArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sfn(
        "DescribeExecution",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("executionArn" => executionArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_map_run(map_run_arn)
    describe_map_run(map_run_arn, params::Dict{String,<:Any})

Provides information about a Map Run's configuration, progress, and results. If you've
redriven a Map Run, this API action also returns information about the redrives of that Map
Run. For more information, see Examining Map Run in the Step Functions Developer Guide.

# Arguments
- `map_run_arn`: The Amazon Resource Name (ARN) that identifies a Map Run.

"""
function describe_map_run(mapRunArn; aws_config::AbstractAWSConfig=current_aws_config())
    return sfn(
        "DescribeMapRun",
        Dict{String,Any}("mapRunArn" => mapRunArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_map_run(
    mapRunArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sfn(
        "DescribeMapRun",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("mapRunArn" => mapRunArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_state_machine(state_machine_arn)
    describe_state_machine(state_machine_arn, params::Dict{String,<:Any})

Provides information about a state machine's definition, its IAM role Amazon Resource Name
(ARN), and configuration. A qualified state machine ARN can either refer to a Distributed
Map state defined within a state machine, a version ARN, or an alias ARN. The following are
some examples of qualified and unqualified state machine ARNs:   The following qualified
state machine ARN refers to a Distributed Map state with a label mapStateLabel in a state
machine named myStateMachine.
arn:partition:states:region:account-id:stateMachine:myStateMachine/mapStateLabel   If you
provide a qualified state machine ARN that refers to a Distributed Map state, the request
fails with ValidationException.    The following qualified state machine ARN refers to an
alias named PROD.
arn:&lt;partition&gt;:states:&lt;region&gt;:&lt;account-id&gt;:stateMachine:&lt;myStateMachi
ne:PROD&gt;   If you provide a qualified state machine ARN that refers to a version ARN or
an alias ARN, the request starts execution for that version or alias.    The following
unqualified state machine ARN refers to a state machine named myStateMachine.
arn:&lt;partition&gt;:states:&lt;region&gt;:&lt;account-id&gt;:stateMachine:&lt;myStateMachi
ne&gt;    This API action returns the details for a state machine version if the
stateMachineArn you specify is a state machine version ARN.  This operation is eventually
consistent. The results are best effort and may not reflect very recent updates and
changes.

# Arguments
- `state_machine_arn`: The Amazon Resource Name (ARN) of the state machine for which you
  want the information. If you specify a state machine version ARN, this API returns details
  about that version. The version ARN is a combination of state machine ARN and the version
  number separated by a colon (:). For example, stateMachineARN:1.

"""
function describe_state_machine(
    stateMachineArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sfn(
        "DescribeStateMachine",
        Dict{String,Any}("stateMachineArn" => stateMachineArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_state_machine(
    stateMachineArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sfn(
        "DescribeStateMachine",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("stateMachineArn" => stateMachineArn), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_state_machine_alias(state_machine_alias_arn)
    describe_state_machine_alias(state_machine_alias_arn, params::Dict{String,<:Any})

Returns details about a state machine alias.  Related operations:
CreateStateMachineAlias     ListStateMachineAliases     UpdateStateMachineAlias
DeleteStateMachineAlias

# Arguments
- `state_machine_alias_arn`: The Amazon Resource Name (ARN) of the state machine alias.

"""
function describe_state_machine_alias(
    stateMachineAliasArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sfn(
        "DescribeStateMachineAlias",
        Dict{String,Any}("stateMachineAliasArn" => stateMachineAliasArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_state_machine_alias(
    stateMachineAliasArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sfn(
        "DescribeStateMachineAlias",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("stateMachineAliasArn" => stateMachineAliasArn),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_state_machine_for_execution(execution_arn)
    describe_state_machine_for_execution(execution_arn, params::Dict{String,<:Any})

Provides information about a state machine's definition, its execution role ARN, and
configuration. If a Map Run dispatched the execution, this action returns the Map Run
Amazon Resource Name (ARN) in the response. The state machine returned is the state machine
associated with the Map Run.  This operation is eventually consistent. The results are best
effort and may not reflect very recent updates and changes.  This API action is not
supported by EXPRESS state machines.

# Arguments
- `execution_arn`: The Amazon Resource Name (ARN) of the execution you want state machine
  information for.

"""
function describe_state_machine_for_execution(
    executionArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sfn(
        "DescribeStateMachineForExecution",
        Dict{String,Any}("executionArn" => executionArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_state_machine_for_execution(
    executionArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sfn(
        "DescribeStateMachineForExecution",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("executionArn" => executionArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_activity_task(activity_arn)
    get_activity_task(activity_arn, params::Dict{String,<:Any})

Used by workers to retrieve a task (with the specified activity ARN) which has been
scheduled for execution by a running state machine. This initiates a long poll, where the
service holds the HTTP connection open and responds as soon as a task becomes available
(i.e. an execution of a task of this type is needed.) The maximum time the service holds on
to the request before responding is 60 seconds. If no task is available within 60 seconds,
the poll returns a taskToken with a null string.  This API action isn't logged in
CloudTrail.   Workers should set their client side socket timeout to at least 65 seconds (5
seconds higher than the maximum time the service may hold the poll request). Polling with
GetActivityTask can cause latency in some implementations. See Avoid Latency When Polling
for Activity Tasks in the Step Functions Developer Guide.

# Arguments
- `activity_arn`: The Amazon Resource Name (ARN) of the activity to retrieve tasks from
  (assigned when you create the task using CreateActivity.)

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"workerName"`: You can provide an arbitrary name in order to identify the worker that
  the task is assigned to. This name is used when it is logged in the execution history.
"""
function get_activity_task(activityArn; aws_config::AbstractAWSConfig=current_aws_config())
    return sfn(
        "GetActivityTask",
        Dict{String,Any}("activityArn" => activityArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_activity_task(
    activityArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sfn(
        "GetActivityTask",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("activityArn" => activityArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_execution_history(execution_arn)
    get_execution_history(execution_arn, params::Dict{String,<:Any})

Returns the history of the specified execution as a list of events. By default, the results
are returned in ascending order of the timeStamp of the events. Use the reverseOrder
parameter to get the latest events first. If nextToken is returned, there are more results
available. The value of nextToken is a unique pagination token for each page. Make the call
again using the returned token to retrieve the next page. Keep all other arguments
unchanged. Each pagination token expires after 24 hours. Using an expired pagination token
will return an HTTP 400 InvalidToken error. This API action is not supported by EXPRESS
state machines.

# Arguments
- `execution_arn`: The Amazon Resource Name (ARN) of the execution.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"includeExecutionData"`: You can select whether execution data (input or output of a
  history event) is returned. The default is true.
- `"maxResults"`: The maximum number of results that are returned per call. You can use
  nextToken to obtain further pages of results. The default is 100 and the maximum allowed
  page size is 1000. A value of 0 uses the default. This is only an upper limit. The actual
  number of results returned per call might be fewer than the specified maximum.
- `"nextToken"`: If nextToken is returned, there are more results available. The value of
  nextToken is a unique pagination token for each page. Make the call again using the
  returned token to retrieve the next page. Keep all other arguments unchanged. Each
  pagination token expires after 24 hours. Using an expired pagination token will return an
  HTTP 400 InvalidToken error.
- `"reverseOrder"`: Lists events in descending order of their timeStamp.
"""
function get_execution_history(
    executionArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sfn(
        "GetExecutionHistory",
        Dict{String,Any}("executionArn" => executionArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_execution_history(
    executionArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sfn(
        "GetExecutionHistory",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("executionArn" => executionArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_activities()
    list_activities(params::Dict{String,<:Any})

Lists the existing activities. If nextToken is returned, there are more results available.
The value of nextToken is a unique pagination token for each page. Make the call again
using the returned token to retrieve the next page. Keep all other arguments unchanged.
Each pagination token expires after 24 hours. Using an expired pagination token will return
an HTTP 400 InvalidToken error.  This operation is eventually consistent. The results are
best effort and may not reflect very recent updates and changes.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results that are returned per call. You can use
  nextToken to obtain further pages of results. The default is 100 and the maximum allowed
  page size is 1000. A value of 0 uses the default. This is only an upper limit. The actual
  number of results returned per call might be fewer than the specified maximum.
- `"nextToken"`: If nextToken is returned, there are more results available. The value of
  nextToken is a unique pagination token for each page. Make the call again using the
  returned token to retrieve the next page. Keep all other arguments unchanged. Each
  pagination token expires after 24 hours. Using an expired pagination token will return an
  HTTP 400 InvalidToken error.
"""
function list_activities(; aws_config::AbstractAWSConfig=current_aws_config())
    return sfn("ListActivities"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function list_activities(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sfn(
        "ListActivities", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_executions()
    list_executions(params::Dict{String,<:Any})

Lists all executions of a state machine or a Map Run. You can list all executions related
to a state machine by specifying a state machine Amazon Resource Name (ARN), or those
related to a Map Run by specifying a Map Run ARN. Using this API action, you can also list
all redriven executions. You can also provide a state machine alias ARN or version ARN to
list the executions associated with a specific alias or version. Results are sorted by
time, with the most recent execution first. If nextToken is returned, there are more
results available. The value of nextToken is a unique pagination token for each page. Make
the call again using the returned token to retrieve the next page. Keep all other arguments
unchanged. Each pagination token expires after 24 hours. Using an expired pagination token
will return an HTTP 400 InvalidToken error.  This operation is eventually consistent. The
results are best effort and may not reflect very recent updates and changes.  This API
action is not supported by EXPRESS state machines.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"mapRunArn"`: The Amazon Resource Name (ARN) of the Map Run that started the child
  workflow executions. If the mapRunArn field is specified, a list of all of the child
  workflow executions started by a Map Run is returned. For more information, see Examining
  Map Run in the Step Functions Developer Guide. You can specify either a mapRunArn or a
  stateMachineArn, but not both.
- `"maxResults"`: The maximum number of results that are returned per call. You can use
  nextToken to obtain further pages of results. The default is 100 and the maximum allowed
  page size is 1000. A value of 0 uses the default. This is only an upper limit. The actual
  number of results returned per call might be fewer than the specified maximum.
- `"nextToken"`: If nextToken is returned, there are more results available. The value of
  nextToken is a unique pagination token for each page. Make the call again using the
  returned token to retrieve the next page. Keep all other arguments unchanged. Each
  pagination token expires after 24 hours. Using an expired pagination token will return an
  HTTP 400 InvalidToken error.
- `"redriveFilter"`: Sets a filter to list executions based on whether or not they have
  been redriven. For a Distributed Map, redriveFilter sets a filter to list child workflow
  executions based on whether or not they have been redriven. If you do not provide a
  redriveFilter, Step Functions returns a list of both redriven and non-redriven executions.
  If you provide a state machine ARN in redriveFilter, the API returns a validation exception.
- `"stateMachineArn"`: The Amazon Resource Name (ARN) of the state machine whose executions
  is listed. You can specify either a mapRunArn or a stateMachineArn, but not both. You can
  also return a list of executions associated with a specific alias or version, by specifying
  an alias ARN or a version ARN in the stateMachineArn parameter.
- `"statusFilter"`: If specified, only list the executions whose current execution status
  matches the given filter.
"""
function list_executions(; aws_config::AbstractAWSConfig=current_aws_config())
    return sfn("ListExecutions"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function list_executions(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sfn(
        "ListExecutions", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_map_runs(execution_arn)
    list_map_runs(execution_arn, params::Dict{String,<:Any})

Lists all Map Runs that were started by a given state machine execution. Use this API
action to obtain Map Run ARNs, and then call DescribeMapRun to obtain more information, if
needed.

# Arguments
- `execution_arn`: The Amazon Resource Name (ARN) of the execution for which the Map Runs
  must be listed.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results that are returned per call. You can use
  nextToken to obtain further pages of results. The default is 100 and the maximum allowed
  page size is 1000. A value of 0 uses the default. This is only an upper limit. The actual
  number of results returned per call might be fewer than the specified maximum.
- `"nextToken"`: If nextToken is returned, there are more results available. The value of
  nextToken is a unique pagination token for each page. Make the call again using the
  returned token to retrieve the next page. Keep all other arguments unchanged. Each
  pagination token expires after 24 hours. Using an expired pagination token will return an
  HTTP 400 InvalidToken error.
"""
function list_map_runs(executionArn; aws_config::AbstractAWSConfig=current_aws_config())
    return sfn(
        "ListMapRuns",
        Dict{String,Any}("executionArn" => executionArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_map_runs(
    executionArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sfn(
        "ListMapRuns",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("executionArn" => executionArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_state_machine_aliases(state_machine_arn)
    list_state_machine_aliases(state_machine_arn, params::Dict{String,<:Any})

Lists aliases for a specified state machine ARN. Results are sorted by time, with the most
recently created aliases listed first.  To list aliases that reference a state machine
version, you can specify the version ARN in the stateMachineArn parameter. If nextToken is
returned, there are more results available. The value of nextToken is a unique pagination
token for each page. Make the call again using the returned token to retrieve the next
page. Keep all other arguments unchanged. Each pagination token expires after 24 hours.
Using an expired pagination token will return an HTTP 400 InvalidToken error.  Related
operations:     CreateStateMachineAlias     DescribeStateMachineAlias
UpdateStateMachineAlias     DeleteStateMachineAlias

# Arguments
- `state_machine_arn`: The Amazon Resource Name (ARN) of the state machine for which you
  want to list aliases. If you specify a state machine version ARN, this API returns a list
  of aliases for that version.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results that are returned per call. You can use
  nextToken to obtain further pages of results. The default is 100 and the maximum allowed
  page size is 1000. A value of 0 uses the default. This is only an upper limit. The actual
  number of results returned per call might be fewer than the specified maximum.
- `"nextToken"`: If nextToken is returned, there are more results available. The value of
  nextToken is a unique pagination token for each page. Make the call again using the
  returned token to retrieve the next page. Keep all other arguments unchanged. Each
  pagination token expires after 24 hours. Using an expired pagination token will return an
  HTTP 400 InvalidToken error.
"""
function list_state_machine_aliases(
    stateMachineArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sfn(
        "ListStateMachineAliases",
        Dict{String,Any}("stateMachineArn" => stateMachineArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_state_machine_aliases(
    stateMachineArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sfn(
        "ListStateMachineAliases",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("stateMachineArn" => stateMachineArn), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_state_machine_versions(state_machine_arn)
    list_state_machine_versions(state_machine_arn, params::Dict{String,<:Any})

Lists versions for the specified state machine Amazon Resource Name (ARN). The results are
sorted in descending order of the version creation time. If nextToken is returned, there
are more results available. The value of nextToken is a unique pagination token for each
page. Make the call again using the returned token to retrieve the next page. Keep all
other arguments unchanged. Each pagination token expires after 24 hours. Using an expired
pagination token will return an HTTP 400 InvalidToken error.  Related operations:
PublishStateMachineVersion     DeleteStateMachineVersion

# Arguments
- `state_machine_arn`: The Amazon Resource Name (ARN) of the state machine.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results that are returned per call. You can use
  nextToken to obtain further pages of results. The default is 100 and the maximum allowed
  page size is 1000. A value of 0 uses the default. This is only an upper limit. The actual
  number of results returned per call might be fewer than the specified maximum.
- `"nextToken"`: If nextToken is returned, there are more results available. The value of
  nextToken is a unique pagination token for each page. Make the call again using the
  returned token to retrieve the next page. Keep all other arguments unchanged. Each
  pagination token expires after 24 hours. Using an expired pagination token will return an
  HTTP 400 InvalidToken error.
"""
function list_state_machine_versions(
    stateMachineArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sfn(
        "ListStateMachineVersions",
        Dict{String,Any}("stateMachineArn" => stateMachineArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_state_machine_versions(
    stateMachineArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sfn(
        "ListStateMachineVersions",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("stateMachineArn" => stateMachineArn), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_state_machines()
    list_state_machines(params::Dict{String,<:Any})

Lists the existing state machines. If nextToken is returned, there are more results
available. The value of nextToken is a unique pagination token for each page. Make the call
again using the returned token to retrieve the next page. Keep all other arguments
unchanged. Each pagination token expires after 24 hours. Using an expired pagination token
will return an HTTP 400 InvalidToken error.  This operation is eventually consistent. The
results are best effort and may not reflect very recent updates and changes.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results that are returned per call. You can use
  nextToken to obtain further pages of results. The default is 100 and the maximum allowed
  page size is 1000. A value of 0 uses the default. This is only an upper limit. The actual
  number of results returned per call might be fewer than the specified maximum.
- `"nextToken"`: If nextToken is returned, there are more results available. The value of
  nextToken is a unique pagination token for each page. Make the call again using the
  returned token to retrieve the next page. Keep all other arguments unchanged. Each
  pagination token expires after 24 hours. Using an expired pagination token will return an
  HTTP 400 InvalidToken error.
"""
function list_state_machines(; aws_config::AbstractAWSConfig=current_aws_config())
    return sfn("ListStateMachines"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function list_state_machines(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sfn(
        "ListStateMachines", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_tags_for_resource(resource_arn)
    list_tags_for_resource(resource_arn, params::Dict{String,<:Any})

List tags for a given resource. Tags may only contain Unicode letters, digits, white space,
or these symbols: _ . : / = + - @.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) for the Step Functions state machine or
  activity.

"""
function list_tags_for_resource(
    resourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sfn(
        "ListTagsForResource",
        Dict{String,Any}("resourceArn" => resourceArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tags_for_resource(
    resourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sfn(
        "ListTagsForResource",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("resourceArn" => resourceArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    publish_state_machine_version(state_machine_arn)
    publish_state_machine_version(state_machine_arn, params::Dict{String,<:Any})

Creates a version from the current revision of a state machine. Use versions to create
immutable snapshots of your state machine. You can start executions from versions either
directly or with an alias. To create an alias, use CreateStateMachineAlias. You can publish
up to 1000 versions for each state machine. You must manually delete unused versions using
the DeleteStateMachineVersion API action.  PublishStateMachineVersion is an idempotent API.
It doesn't create a duplicate state machine version if it already exists for the current
revision. Step Functions bases PublishStateMachineVersion's idempotency check on the
stateMachineArn, name, and revisionId parameters. Requests with the same parameters return
a successful idempotent response. If you don't specify a revisionId, Step Functions checks
for a previously published version of the state machine's current revision.  Related
operations:     DeleteStateMachineVersion     ListStateMachineVersions

# Arguments
- `state_machine_arn`: The Amazon Resource Name (ARN) of the state machine.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"description"`: An optional description of the state machine version.
- `"revisionId"`: Only publish the state machine version if the current state machine's
  revision ID matches the specified ID. Use this option to avoid publishing a version if the
  state machine changed since you last updated it. If the specified revision ID doesn't match
  the state machine's current revision ID, the API returns ConflictException.  To specify an
  initial revision ID for a state machine with no revision ID assigned, specify the string
  INITIAL for the revisionId parameter. For example, you can specify a revisionID of INITIAL
  when you create a state machine using the CreateStateMachine API action.
"""
function publish_state_machine_version(
    stateMachineArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sfn(
        "PublishStateMachineVersion",
        Dict{String,Any}("stateMachineArn" => stateMachineArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function publish_state_machine_version(
    stateMachineArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sfn(
        "PublishStateMachineVersion",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("stateMachineArn" => stateMachineArn), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    redrive_execution(execution_arn)
    redrive_execution(execution_arn, params::Dict{String,<:Any})

Restarts unsuccessful executions of Standard workflows that didn't complete successfully in
the last 14 days. These include failed, aborted, or timed out executions. When you redrive
an execution, it continues the failed execution from the unsuccessful step and uses the
same input. Step Functions preserves the results and execution history of the successful
steps, and doesn't rerun these steps when you redrive an execution. Redriven executions use
the same state machine definition and execution ARN as the original execution attempt. For
workflows that include an Inline Map or Parallel state, RedriveExecution API action
reschedules and redrives only the iterations and branches that failed or aborted. To
redrive a workflow that includes a Distributed Map state whose Map Run failed, you must
redrive the parent workflow. The parent workflow redrives all the unsuccessful states,
including a failed Map Run. If a Map Run was not started in the original execution attempt,
the redriven parent workflow starts the Map Run.  This API action is not supported by
EXPRESS state machines. However, you can restart the unsuccessful executions of Express
child workflows in a Distributed Map by redriving its Map Run. When you redrive a Map Run,
the Express child workflows are rerun using the StartExecution API action. For more
information, see Redriving Map Runs.  You can redrive executions if your original execution
meets the following conditions:   The execution status isn't SUCCEEDED.   Your workflow
execution has not exceeded the redrivable period of 14 days. Redrivable period refers to
the time during which you can redrive a given execution. This period starts from the day a
state machine completes its execution.   The workflow execution has not exceeded the
maximum open time of one year. For more information about state machine quotas, see Quotas
related to state machine executions.   The execution event history count is less than
24,999. Redriven executions append their event history to the existing event history. Make
sure your workflow execution contains less than 24,999 events to accommodate the
ExecutionRedriven history event and at least one other history event.

# Arguments
- `execution_arn`: The Amazon Resource Name (ARN) of the execution to be redriven.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientToken"`: A unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request. If you don’t specify a client token, the Amazon Web Services
  SDK automatically generates a client token and uses it for the request to ensure
  idempotency. The API will return idempotent responses for the last 10 client tokens used to
  successfully redrive the execution. These client tokens are valid for up to 15 minutes
  after they are first used.
"""
function redrive_execution(executionArn; aws_config::AbstractAWSConfig=current_aws_config())
    return sfn(
        "RedriveExecution",
        Dict{String,Any}("executionArn" => executionArn, "clientToken" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function redrive_execution(
    executionArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sfn(
        "RedriveExecution",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "executionArn" => executionArn, "clientToken" => string(uuid4())
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    send_task_failure(task_token)
    send_task_failure(task_token, params::Dict{String,<:Any})

Used by activity workers, Task states using the callback pattern, and optionally Task
states using the job run pattern to report that the task identified by the taskToken failed.

# Arguments
- `task_token`: The token that represents this task. Task tokens are generated by Step
  Functions when tasks are assigned to a worker, or in the context object when a workflow
  enters a task state. See GetActivityTaskOutputtaskToken.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"cause"`: A more detailed explanation of the cause of the failure.
- `"error"`: The error code of the failure.
"""
function send_task_failure(taskToken; aws_config::AbstractAWSConfig=current_aws_config())
    return sfn(
        "SendTaskFailure",
        Dict{String,Any}("taskToken" => taskToken);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function send_task_failure(
    taskToken,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sfn(
        "SendTaskFailure",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("taskToken" => taskToken), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    send_task_heartbeat(task_token)
    send_task_heartbeat(task_token, params::Dict{String,<:Any})

Used by activity workers and Task states using the callback pattern, and optionally Task
states using the job run pattern to report to Step Functions that the task represented by
the specified taskToken is still making progress. This action resets the Heartbeat clock.
The Heartbeat threshold is specified in the state machine's Amazon States Language
definition (HeartbeatSeconds). This action does not in itself create an event in the
execution history. However, if the task times out, the execution history contains an
ActivityTimedOut entry for activities, or a TaskTimedOut entry for tasks using the job run
or callback pattern.  The Timeout of a task, defined in the state machine's Amazon States
Language definition, is its maximum allowed duration, regardless of the number of
SendTaskHeartbeat requests received. Use HeartbeatSeconds to configure the timeout interval
for heartbeats.

# Arguments
- `task_token`: The token that represents this task. Task tokens are generated by Step
  Functions when tasks are assigned to a worker, or in the context object when a workflow
  enters a task state. See GetActivityTaskOutputtaskToken.

"""
function send_task_heartbeat(taskToken; aws_config::AbstractAWSConfig=current_aws_config())
    return sfn(
        "SendTaskHeartbeat",
        Dict{String,Any}("taskToken" => taskToken);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function send_task_heartbeat(
    taskToken,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sfn(
        "SendTaskHeartbeat",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("taskToken" => taskToken), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    send_task_success(output, task_token)
    send_task_success(output, task_token, params::Dict{String,<:Any})

Used by activity workers, Task states using the callback pattern, and optionally Task
states using the job run pattern to report that the task identified by the taskToken
completed successfully.

# Arguments
- `output`: The JSON output of the task. Length constraints apply to the payload size, and
  are expressed as bytes in UTF-8 encoding.
- `task_token`: The token that represents this task. Task tokens are generated by Step
  Functions when tasks are assigned to a worker, or in the context object when a workflow
  enters a task state. See GetActivityTaskOutputtaskToken.

"""
function send_task_success(
    output, taskToken; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sfn(
        "SendTaskSuccess",
        Dict{String,Any}("output" => output, "taskToken" => taskToken);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function send_task_success(
    output,
    taskToken,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sfn(
        "SendTaskSuccess",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("output" => output, "taskToken" => taskToken),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_execution(state_machine_arn)
    start_execution(state_machine_arn, params::Dict{String,<:Any})

Starts a state machine execution. A qualified state machine ARN can either refer to a
Distributed Map state defined within a state machine, a version ARN, or an alias ARN. The
following are some examples of qualified and unqualified state machine ARNs:   The
following qualified state machine ARN refers to a Distributed Map state with a label
mapStateLabel in a state machine named myStateMachine.
arn:partition:states:region:account-id:stateMachine:myStateMachine/mapStateLabel   If you
provide a qualified state machine ARN that refers to a Distributed Map state, the request
fails with ValidationException.    The following qualified state machine ARN refers to an
alias named PROD.
arn:&lt;partition&gt;:states:&lt;region&gt;:&lt;account-id&gt;:stateMachine:&lt;myStateMachi
ne:PROD&gt;   If you provide a qualified state machine ARN that refers to a version ARN or
an alias ARN, the request starts execution for that version or alias.    The following
unqualified state machine ARN refers to a state machine named myStateMachine.
arn:&lt;partition&gt;:states:&lt;region&gt;:&lt;account-id&gt;:stateMachine:&lt;myStateMachi
ne&gt;    If you start an execution with an unqualified state machine ARN, Step Functions
uses the latest revision of the state machine for the execution. To start executions of a
state machine version, call StartExecution and provide the version ARN or the ARN of an
alias that points to the version.   StartExecution is idempotent for STANDARD workflows.
For a STANDARD workflow, if you call StartExecution with the same name and input as a
running execution, the call succeeds and return the same response as the original request.
If the execution is closed or if the input is different, it returns a 400
ExecutionAlreadyExists error. You can reuse names after 90 days.   StartExecution isn't
idempotent for EXPRESS workflows.

# Arguments
- `state_machine_arn`: The Amazon Resource Name (ARN) of the state machine to execute. The
  stateMachineArn parameter accepts one of the following inputs:    An unqualified state
  machine ARN – Refers to a state machine ARN that isn't qualified with a version or alias
  ARN. The following is an example of an unqualified state machine ARN.
  arn:&lt;partition&gt;:states:&lt;region&gt;:&lt;account-id&gt;:stateMachine:&lt;myStateMachi
  ne&gt;  Step Functions doesn't associate state machine executions that you start with an
  unqualified ARN with a version. This is true even if that version uses the same revision
  that the execution used.    A state machine version ARN – Refers to a version ARN, which
  is a combination of state machine ARN and the version number separated by a colon (:). The
  following is an example of the ARN for version 10.
  arn:&lt;partition&gt;:states:&lt;region&gt;:&lt;account-id&gt;:stateMachine:&lt;myStateMachi
  ne&gt;:10  Step Functions doesn't associate executions that you start with a version ARN
  with any aliases that point to that version.    A state machine alias ARN – Refers to an
  alias ARN, which is a combination of state machine ARN and the alias name separated by a
  colon (:). The following is an example of the ARN for an alias named PROD.
  arn:&lt;partition&gt;:states:&lt;region&gt;:&lt;account-id&gt;:stateMachine:&lt;myStateMachi
  ne:PROD&gt;  Step Functions associates executions that you start with an alias ARN with
  that alias and the state machine version used for that execution.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"input"`: The string that contains the JSON input data for the execution, for example:
  \"input\": \"{\"first_name\" : \"test\"}\"   If you don't include any JSON input data, you
  still must include the two braces, for example: \"input\": \"{}\"   Length constraints
  apply to the payload size, and are expressed as bytes in UTF-8 encoding.
- `"name"`: Optional name of the execution. This name must be unique for your Amazon Web
  Services account, Region, and state machine for 90 days. For more information, see  Limits
  Related to State Machine Executions in the Step Functions Developer Guide. If you don't
  provide a name for the execution, Step Functions automatically generates a universally
  unique identifier (UUID) as the execution name. A name must not contain:   white space
  brackets &lt; &gt; { } [ ]    wildcard characters ? *    special characters \" # %  ^ | ~ `
   &amp; , ; : /    control characters (U+0000-001F, U+007F-009F)   To enable logging with
  CloudWatch Logs, the name should only contain 0-9, A-Z, a-z, - and _.
- `"traceHeader"`: Passes the X-Ray trace header. The trace header can also be passed in
  the request payload.
"""
function start_execution(
    stateMachineArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sfn(
        "StartExecution",
        Dict{String,Any}("stateMachineArn" => stateMachineArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_execution(
    stateMachineArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sfn(
        "StartExecution",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("stateMachineArn" => stateMachineArn), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_sync_execution(state_machine_arn)
    start_sync_execution(state_machine_arn, params::Dict{String,<:Any})

Starts a Synchronous Express state machine execution. StartSyncExecution is not available
for STANDARD workflows.   StartSyncExecution will return a 200 OK response, even if your
execution fails, because the status code in the API response doesn't reflect function
errors. Error codes are reserved for errors that prevent your execution from running, such
as permissions errors, limit errors, or issues with your state machine code and
configuration.    This API action isn't logged in CloudTrail.

# Arguments
- `state_machine_arn`: The Amazon Resource Name (ARN) of the state machine to execute.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"input"`: The string that contains the JSON input data for the execution, for example:
  \"input\": \"{\"first_name\" : \"test\"}\"   If you don't include any JSON input data, you
  still must include the two braces, for example: \"input\": \"{}\"   Length constraints
  apply to the payload size, and are expressed as bytes in UTF-8 encoding.
- `"name"`: The name of the execution.
- `"traceHeader"`: Passes the X-Ray trace header. The trace header can also be passed in
  the request payload.
"""
function start_sync_execution(
    stateMachineArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sfn(
        "StartSyncExecution",
        Dict{String,Any}("stateMachineArn" => stateMachineArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_sync_execution(
    stateMachineArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sfn(
        "StartSyncExecution",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("stateMachineArn" => stateMachineArn), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    stop_execution(execution_arn)
    stop_execution(execution_arn, params::Dict{String,<:Any})

Stops an execution. This API action is not supported by EXPRESS state machines.

# Arguments
- `execution_arn`: The Amazon Resource Name (ARN) of the execution to stop.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"cause"`: A more detailed explanation of the cause of the failure.
- `"error"`: The error code of the failure.
"""
function stop_execution(executionArn; aws_config::AbstractAWSConfig=current_aws_config())
    return sfn(
        "StopExecution",
        Dict{String,Any}("executionArn" => executionArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function stop_execution(
    executionArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sfn(
        "StopExecution",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("executionArn" => executionArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_resource(resource_arn, tags)
    tag_resource(resource_arn, tags, params::Dict{String,<:Any})

Add a tag to a Step Functions resource. An array of key-value pairs. For more information,
see Using Cost Allocation Tags in the Amazon Web Services Billing and Cost Management User
Guide, and Controlling Access Using IAM Tags. Tags may only contain Unicode letters,
digits, white space, or these symbols: _ . : / = + - @.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) for the Step Functions state machine or
  activity.
- `tags`: The list of tags to add to a resource. Tags may only contain Unicode letters,
  digits, white space, or these symbols: _ . : / = + - @.

"""
function tag_resource(resourceArn, tags; aws_config::AbstractAWSConfig=current_aws_config())
    return sfn(
        "TagResource",
        Dict{String,Any}("resourceArn" => resourceArn, "tags" => tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_resource(
    resourceArn,
    tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sfn(
        "TagResource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("resourceArn" => resourceArn, "tags" => tags),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    test_state(definition, role_arn)
    test_state(definition, role_arn, params::Dict{String,<:Any})

Accepts the definition of a single state and executes it. You can test a state without
creating a state machine or updating an existing state machine. Using this API, you can
test the following:   A state's input and output processing data flow   An Amazon Web
Services service integration request and response   An HTTP Task request and response   You
can call this API on only one state at a time. The states that you can test include the
following:    All Task types except Activity     Pass     Wait     Choice     Succeed
Fail    The TestState API assumes an IAM role which must contain the required IAM
permissions for the resources your state is accessing. For information about the
permissions a state might need, see IAM permissions to test a state. The TestState API can
run for up to five minutes. If the execution of a state exceeds this duration, it fails
with the States.Timeout error.  TestState doesn't support Activity tasks, .sync or
.waitForTaskToken service integration patterns, Parallel, or Map states.

# Arguments
- `definition`: The Amazon States Language (ASL) definition of the state.
- `role_arn`: The Amazon Resource Name (ARN) of the execution role with the required IAM
  permissions for the state.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"input"`: A string that contains the JSON input data for the state.
- `"inspectionLevel"`: Determines the values to return when a state is tested. You can
  specify one of the following types:    INFO: Shows the final state output. By default, Step
  Functions sets inspectionLevel to INFO if you don't specify a level.    DEBUG: Shows the
  final state output along with the input and output data processing result.    TRACE: Shows
  the HTTP request and response for an HTTP Task. This level also shows the final state
  output along with the input and output data processing result.   Each of these levels also
  provide information about the status of the state execution and the next state to
  transition to.
- `"revealSecrets"`: Specifies whether or not to include secret information in the test
  result. For HTTP Tasks, a secret includes the data that an EventBridge connection adds to
  modify the HTTP request headers, query parameters, and body. Step Functions doesn't omit
  any information included in the state definition or the HTTP response. If you set
  revealSecrets to true, you must make sure that the IAM user that calls the TestState API
  has permission for the states:RevealSecrets action. For an example of IAM policy that sets
  the states:RevealSecrets permission, see IAM permissions to test a state. Without this
  permission, Step Functions throws an access denied error. By default, revealSecrets is set
  to false.
"""
function test_state(definition, roleArn; aws_config::AbstractAWSConfig=current_aws_config())
    return sfn(
        "TestState",
        Dict{String,Any}("definition" => definition, "roleArn" => roleArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function test_state(
    definition,
    roleArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sfn(
        "TestState",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("definition" => definition, "roleArn" => roleArn),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_resource(resource_arn, tag_keys)
    untag_resource(resource_arn, tag_keys, params::Dict{String,<:Any})

Remove a tag from a Step Functions resource

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) for the Step Functions state machine or
  activity.
- `tag_keys`: The list of tags to remove from the resource.

"""
function untag_resource(
    resourceArn, tagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sfn(
        "UntagResource",
        Dict{String,Any}("resourceArn" => resourceArn, "tagKeys" => tagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_resource(
    resourceArn,
    tagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sfn(
        "UntagResource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("resourceArn" => resourceArn, "tagKeys" => tagKeys),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_map_run(map_run_arn)
    update_map_run(map_run_arn, params::Dict{String,<:Any})

Updates an in-progress Map Run's configuration to include changes to the settings that
control maximum concurrency and Map Run failure.

# Arguments
- `map_run_arn`: The Amazon Resource Name (ARN) of a Map Run.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxConcurrency"`: The maximum number of child workflow executions that can be specified
  to run in parallel for the Map Run at the same time.
- `"toleratedFailureCount"`: The maximum number of failed items before the Map Run fails.
- `"toleratedFailurePercentage"`: The maximum percentage of failed items before the Map Run
  fails.
"""
function update_map_run(mapRunArn; aws_config::AbstractAWSConfig=current_aws_config())
    return sfn(
        "UpdateMapRun",
        Dict{String,Any}("mapRunArn" => mapRunArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_map_run(
    mapRunArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sfn(
        "UpdateMapRun",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("mapRunArn" => mapRunArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_state_machine(state_machine_arn)
    update_state_machine(state_machine_arn, params::Dict{String,<:Any})

Updates an existing state machine by modifying its definition, roleArn, or
loggingConfiguration. Running executions will continue to use the previous definition and
roleArn. You must include at least one of definition or roleArn or you will receive a
MissingRequiredParameter error. A qualified state machine ARN refers to a Distributed Map
state defined within a state machine. For example, the qualified state machine ARN
arn:partition:states:region:account-id:stateMachine:stateMachineName/mapStateLabel refers
to a Distributed Map state with a label mapStateLabel in the state machine named
stateMachineName. A qualified state machine ARN can either refer to a Distributed Map state
defined within a state machine, a version ARN, or an alias ARN. The following are some
examples of qualified and unqualified state machine ARNs:   The following qualified state
machine ARN refers to a Distributed Map state with a label mapStateLabel in a state machine
named myStateMachine.
arn:partition:states:region:account-id:stateMachine:myStateMachine/mapStateLabel   If you
provide a qualified state machine ARN that refers to a Distributed Map state, the request
fails with ValidationException.    The following qualified state machine ARN refers to an
alias named PROD.
arn:&lt;partition&gt;:states:&lt;region&gt;:&lt;account-id&gt;:stateMachine:&lt;myStateMachi
ne:PROD&gt;   If you provide a qualified state machine ARN that refers to a version ARN or
an alias ARN, the request starts execution for that version or alias.    The following
unqualified state machine ARN refers to a state machine named myStateMachine.
arn:&lt;partition&gt;:states:&lt;region&gt;:&lt;account-id&gt;:stateMachine:&lt;myStateMachi
ne&gt;    After you update your state machine, you can set the publish parameter to true in
the same action to publish a new version. This way, you can opt-in to strict versioning of
your state machine.  Step Functions assigns monotonically increasing integers for state
machine versions, starting at version number 1.   All StartExecution calls within a few
seconds use the updated definition and roleArn. Executions started immediately after you
call UpdateStateMachine may use the previous state machine definition and roleArn.

# Arguments
- `state_machine_arn`: The Amazon Resource Name (ARN) of the state machine.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"definition"`: The Amazon States Language definition of the state machine. See Amazon
  States Language.
- `"loggingConfiguration"`: Use the LoggingConfiguration data type to set CloudWatch Logs
  options.
- `"publish"`: Specifies whether the state machine version is published. The default is
  false. To publish a version after updating the state machine, set publish to true.
- `"roleArn"`: The Amazon Resource Name (ARN) of the IAM role of the state machine.
- `"tracingConfiguration"`: Selects whether X-Ray tracing is enabled.
- `"versionDescription"`: An optional description of the state machine version to publish.
  You can only specify the versionDescription parameter if you've set publish to true.
"""
function update_state_machine(
    stateMachineArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sfn(
        "UpdateStateMachine",
        Dict{String,Any}("stateMachineArn" => stateMachineArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_state_machine(
    stateMachineArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sfn(
        "UpdateStateMachine",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("stateMachineArn" => stateMachineArn), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_state_machine_alias(state_machine_alias_arn)
    update_state_machine_alias(state_machine_alias_arn, params::Dict{String,<:Any})

Updates the configuration of an existing state machine alias by modifying its description
or routingConfiguration. You must specify at least one of the description or
routingConfiguration parameters to update a state machine alias.   UpdateStateMachineAlias
is an idempotent API. Step Functions bases the idempotency check on the
stateMachineAliasArn, description, and routingConfiguration parameters. Requests with the
same parameters return an idempotent response.   This operation is eventually consistent.
All StartExecution requests made within a few seconds use the latest alias configuration.
Executions started immediately after calling UpdateStateMachineAlias may use the previous
routing configuration.   Related operations:     CreateStateMachineAlias
DescribeStateMachineAlias     ListStateMachineAliases     DeleteStateMachineAlias

# Arguments
- `state_machine_alias_arn`: The Amazon Resource Name (ARN) of the state machine alias.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"description"`: A description of the state machine alias.
- `"routingConfiguration"`: The routing configuration of the state machine alias. An array
  of RoutingConfig objects that specifies up to two state machine versions that the alias
  starts executions for.
"""
function update_state_machine_alias(
    stateMachineAliasArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sfn(
        "UpdateStateMachineAlias",
        Dict{String,Any}("stateMachineAliasArn" => stateMachineAliasArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_state_machine_alias(
    stateMachineAliasArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sfn(
        "UpdateStateMachineAlias",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("stateMachineAliasArn" => stateMachineAliasArn),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    validate_state_machine_definition(definition)
    validate_state_machine_definition(definition, params::Dict{String,<:Any})

Validates the syntax of a state machine definition. You can validate that a state machine
definition is correct without creating a state machine resource. Step Functions will
implicitly perform the same syntax check when you invoke CreateStateMachine and
UpdateStateMachine. State machine definitions are specified using a JSON-based, structured
language. For more information on Amazon States Language see Amazon States Language (ASL).
Suggested uses for ValidateStateMachineDefinition:   Integrate automated checks into your
code review or Continuous Integration (CI) process to validate state machine definitions
before starting deployments.   Run the validation from a Git pre-commit hook to check your
state machine definitions before committing them to your source repository.    Errors found
in the state machine definition will be returned in the response as a list of diagnostic
elements, rather than raise an exception.

# Arguments
- `definition`: The Amazon States Language definition of the state machine. For more
  information, see Amazon States Language (ASL).

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"type"`: The target type of state machine for this definition. The default is STANDARD.
"""
function validate_state_machine_definition(
    definition; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sfn(
        "ValidateStateMachineDefinition",
        Dict{String,Any}("definition" => definition);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function validate_state_machine_definition(
    definition,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sfn(
        "ValidateStateMachineDefinition",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("definition" => definition), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
