# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: ssm_incidents
using AWS.Compat
using AWS.UUIDs

"""
    batch_get_incident_findings(finding_ids, incident_record_arn)
    batch_get_incident_findings(finding_ids, incident_record_arn, params::Dict{String,<:Any})

Retrieves details about all specified findings for an incident, including descriptive
details about each finding. A finding represents a recent application environment change
made by an CodeDeploy deployment or an CloudFormation stack creation or update that can be
investigated as a potential cause of the incident.

# Arguments
- `finding_ids`: A list of IDs of findings for which you want to view details.
- `incident_record_arn`: The Amazon Resource Name (ARN) of the incident for which you want
  to view finding details.

"""
function batch_get_incident_findings(
    findingIds, incidentRecordArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm_incidents(
        "POST",
        "/batchGetIncidentFindings",
        Dict{String,Any}(
            "findingIds" => findingIds, "incidentRecordArn" => incidentRecordArn
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function batch_get_incident_findings(
    findingIds,
    incidentRecordArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm_incidents(
        "POST",
        "/batchGetIncidentFindings",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "findingIds" => findingIds, "incidentRecordArn" => incidentRecordArn
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_replication_set(regions)
    create_replication_set(regions, params::Dict{String,<:Any})

A replication set replicates and encrypts your data to the provided Regions with the
provided KMS key.

# Arguments
- `regions`: The Regions that Incident Manager replicates your data to. You can have up to
  three Regions in your replication set.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientToken"`: A token that ensures that the operation is called only once with the
  specified details.
- `"tags"`: A list of tags to add to the replication set.
"""
function create_replication_set(regions; aws_config::AbstractAWSConfig=current_aws_config())
    return ssm_incidents(
        "POST",
        "/createReplicationSet",
        Dict{String,Any}("regions" => regions, "clientToken" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_replication_set(
    regions,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm_incidents(
        "POST",
        "/createReplicationSet",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("regions" => regions, "clientToken" => string(uuid4())),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_response_plan(incident_template, name)
    create_response_plan(incident_template, name, params::Dict{String,<:Any})

Creates a response plan that automates the initial response to incidents. A response plan
engages contacts, starts chat channel collaboration, and initiates runbooks at the
beginning of an incident.

# Arguments
- `incident_template`: Details used to create an incident when using this response plan.
- `name`: The short format name of the response plan. Can't include spaces.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"actions"`: The actions that the response plan starts at the beginning of an incident.
- `"chatChannel"`: The Chatbot chat channel used for collaboration during an incident.
- `"clientToken"`: A token ensuring that the operation is called only once with the
  specified details.
- `"displayName"`: The long format of the response plan name. This field can contain spaces.
- `"engagements"`: The Amazon Resource Name (ARN) for the contacts and escalation plans
  that the response plan engages during an incident.
- `"integrations"`: Information about third-party services integrated into the response
  plan.
- `"tags"`: A list of tags that you are adding to the response plan.
"""
function create_response_plan(
    incidentTemplate, name; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm_incidents(
        "POST",
        "/createResponsePlan",
        Dict{String,Any}(
            "incidentTemplate" => incidentTemplate,
            "name" => name,
            "clientToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_response_plan(
    incidentTemplate,
    name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm_incidents(
        "POST",
        "/createResponsePlan",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "incidentTemplate" => incidentTemplate,
                    "name" => name,
                    "clientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_timeline_event(event_data, event_time, event_type, incident_record_arn)
    create_timeline_event(event_data, event_time, event_type, incident_record_arn, params::Dict{String,<:Any})

Creates a custom timeline event on the incident details page of an incident record.
Incident Manager automatically creates timeline events that mark key moments during an
incident. You can create custom timeline events to mark important events that Incident
Manager can detect automatically.

# Arguments
- `event_data`: A short description of the event.
- `event_time`: The timestamp for when the event occurred.
- `event_type`: The type of event. You can create timeline events of type Custom Event and
  Note. To make a Note-type event appear on the Incident notes panel in the console, specify
  eventType as Noteand enter the Amazon Resource Name (ARN) of the incident as the value for
  eventReference.
- `incident_record_arn`: The Amazon Resource Name (ARN) of the incident record that the
  action adds the incident to.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientToken"`: A token that ensures that a client calls the action only once with the
  specified details.
- `"eventReferences"`: Adds one or more references to the TimelineEvent. A reference is an
  Amazon Web Services resource involved or associated with the incident. To specify a
  reference, enter its Amazon Resource Name (ARN). You can also specify a related item
  associated with a resource. For example, to specify an Amazon DynamoDB (DynamoDB) table as
  a resource, use the table's ARN. You can also specify an Amazon CloudWatch metric
  associated with the DynamoDB table as a related item.
"""
function create_timeline_event(
    eventData,
    eventTime,
    eventType,
    incidentRecordArn;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm_incidents(
        "POST",
        "/createTimelineEvent",
        Dict{String,Any}(
            "eventData" => eventData,
            "eventTime" => eventTime,
            "eventType" => eventType,
            "incidentRecordArn" => incidentRecordArn,
            "clientToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_timeline_event(
    eventData,
    eventTime,
    eventType,
    incidentRecordArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm_incidents(
        "POST",
        "/createTimelineEvent",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "eventData" => eventData,
                    "eventTime" => eventTime,
                    "eventType" => eventType,
                    "incidentRecordArn" => incidentRecordArn,
                    "clientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_incident_record(arn)
    delete_incident_record(arn, params::Dict{String,<:Any})

Delete an incident record from Incident Manager.

# Arguments
- `arn`: The Amazon Resource Name (ARN) of the incident record you are deleting.

"""
function delete_incident_record(arn; aws_config::AbstractAWSConfig=current_aws_config())
    return ssm_incidents(
        "POST",
        "/deleteIncidentRecord",
        Dict{String,Any}("arn" => arn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_incident_record(
    arn, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm_incidents(
        "POST",
        "/deleteIncidentRecord",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("arn" => arn), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_replication_set(arn)
    delete_replication_set(arn, params::Dict{String,<:Any})

Deletes all Regions in your replication set. Deleting the replication set deletes all
Incident Manager data.

# Arguments
- `arn`: The Amazon Resource Name (ARN) of the replication set you're deleting.

"""
function delete_replication_set(arn; aws_config::AbstractAWSConfig=current_aws_config())
    return ssm_incidents(
        "POST",
        "/deleteReplicationSet",
        Dict{String,Any}("arn" => arn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_replication_set(
    arn, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm_incidents(
        "POST",
        "/deleteReplicationSet",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("arn" => arn), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_resource_policy(policy_id, resource_arn)
    delete_resource_policy(policy_id, resource_arn, params::Dict{String,<:Any})

Deletes the resource policy that Resource Access Manager uses to share your Incident
Manager resource.

# Arguments
- `policy_id`: The ID of the resource policy you're deleting.
- `resource_arn`: The Amazon Resource Name (ARN) of the resource you're deleting the policy
  from.

"""
function delete_resource_policy(
    policyId, resourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm_incidents(
        "POST",
        "/deleteResourcePolicy",
        Dict{String,Any}("policyId" => policyId, "resourceArn" => resourceArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_resource_policy(
    policyId,
    resourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm_incidents(
        "POST",
        "/deleteResourcePolicy",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("policyId" => policyId, "resourceArn" => resourceArn),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_response_plan(arn)
    delete_response_plan(arn, params::Dict{String,<:Any})

Deletes the specified response plan. Deleting a response plan stops all linked CloudWatch
alarms and EventBridge events from creating an incident with this response plan.

# Arguments
- `arn`: The Amazon Resource Name (ARN) of the response plan.

"""
function delete_response_plan(arn; aws_config::AbstractAWSConfig=current_aws_config())
    return ssm_incidents(
        "POST",
        "/deleteResponsePlan",
        Dict{String,Any}("arn" => arn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_response_plan(
    arn, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm_incidents(
        "POST",
        "/deleteResponsePlan",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("arn" => arn), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_timeline_event(event_id, incident_record_arn)
    delete_timeline_event(event_id, incident_record_arn, params::Dict{String,<:Any})

Deletes a timeline event from an incident.

# Arguments
- `event_id`: The ID of the event to update. You can use ListTimelineEvents to find an
  event's ID.
- `incident_record_arn`: The Amazon Resource Name (ARN) of the incident that includes the
  timeline event.

"""
function delete_timeline_event(
    eventId, incidentRecordArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm_incidents(
        "POST",
        "/deleteTimelineEvent",
        Dict{String,Any}("eventId" => eventId, "incidentRecordArn" => incidentRecordArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_timeline_event(
    eventId,
    incidentRecordArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm_incidents(
        "POST",
        "/deleteTimelineEvent",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "eventId" => eventId, "incidentRecordArn" => incidentRecordArn
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_incident_record(arn)
    get_incident_record(arn, params::Dict{String,<:Any})

Returns the details for the specified incident record.

# Arguments
- `arn`: The Amazon Resource Name (ARN) of the incident record.

"""
function get_incident_record(arn; aws_config::AbstractAWSConfig=current_aws_config())
    return ssm_incidents(
        "GET",
        "/getIncidentRecord",
        Dict{String,Any}("arn" => arn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_incident_record(
    arn, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm_incidents(
        "GET",
        "/getIncidentRecord",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("arn" => arn), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_replication_set(arn)
    get_replication_set(arn, params::Dict{String,<:Any})

Retrieve your Incident Manager replication set.

# Arguments
- `arn`: The Amazon Resource Name (ARN) of the replication set you want to retrieve.

"""
function get_replication_set(arn; aws_config::AbstractAWSConfig=current_aws_config())
    return ssm_incidents(
        "GET",
        "/getReplicationSet",
        Dict{String,Any}("arn" => arn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_replication_set(
    arn, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm_incidents(
        "GET",
        "/getReplicationSet",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("arn" => arn), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_resource_policies(resource_arn)
    get_resource_policies(resource_arn, params::Dict{String,<:Any})

Retrieves the resource policies attached to the specified response plan.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the response plan with the attached
  resource policy.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of resource policies to display for each page of
  results.
- `"nextToken"`: The pagination token for the next set of items to return. (You received
  this token from a previous call.)
"""
function get_resource_policies(
    resourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm_incidents(
        "POST",
        "/getResourcePolicies",
        Dict{String,Any}("resourceArn" => resourceArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_resource_policies(
    resourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm_incidents(
        "POST",
        "/getResourcePolicies",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("resourceArn" => resourceArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_response_plan(arn)
    get_response_plan(arn, params::Dict{String,<:Any})

Retrieves the details of the specified response plan.

# Arguments
- `arn`: The Amazon Resource Name (ARN) of the response plan.

"""
function get_response_plan(arn; aws_config::AbstractAWSConfig=current_aws_config())
    return ssm_incidents(
        "GET",
        "/getResponsePlan",
        Dict{String,Any}("arn" => arn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_response_plan(
    arn, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm_incidents(
        "GET",
        "/getResponsePlan",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("arn" => arn), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_timeline_event(event_id, incident_record_arn)
    get_timeline_event(event_id, incident_record_arn, params::Dict{String,<:Any})

Retrieves a timeline event based on its ID and incident record.

# Arguments
- `event_id`: The ID of the event. You can get an event's ID when you create it, or by
  using ListTimelineEvents.
- `incident_record_arn`: The Amazon Resource Name (ARN) of the incident that includes the
  timeline event.

"""
function get_timeline_event(
    eventId, incidentRecordArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm_incidents(
        "GET",
        "/getTimelineEvent",
        Dict{String,Any}("eventId" => eventId, "incidentRecordArn" => incidentRecordArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_timeline_event(
    eventId,
    incidentRecordArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm_incidents(
        "GET",
        "/getTimelineEvent",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "eventId" => eventId, "incidentRecordArn" => incidentRecordArn
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_incident_findings(incident_record_arn)
    list_incident_findings(incident_record_arn, params::Dict{String,<:Any})

Retrieves a list of the IDs of findings, plus their last modified times, that have been
identified for a specified incident. A finding represents a recent application environment
change made by an CloudFormation stack creation or update or an CodeDeploy deployment that
can be investigated as a potential cause of the incident.

# Arguments
- `incident_record_arn`: The Amazon Resource Name (ARN) of the incident for which you want
  to view associated findings.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of findings to retrieve per call.
- `"nextToken"`: The pagination token for the next set of items to return. (You received
  this token from a previous call.)
"""
function list_incident_findings(
    incidentRecordArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm_incidents(
        "POST",
        "/listIncidentFindings",
        Dict{String,Any}("incidentRecordArn" => incidentRecordArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_incident_findings(
    incidentRecordArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm_incidents(
        "POST",
        "/listIncidentFindings",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("incidentRecordArn" => incidentRecordArn), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_incident_records()
    list_incident_records(params::Dict{String,<:Any})

Lists all incident records in your account. Use this command to retrieve the Amazon
Resource Name (ARN) of the incident record you want to update.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"filters"`: Filters the list of incident records you want to search through. You can
  filter on the following keys:    creationTime     impact     status     createdBy    Note
  the following when when you use Filters:   If you don't specify a Filter, the response
  includes all incident records.   If you specify more than one filter in a single request,
  the response returns incident records that match all filters.   If you specify a filter
  with more than one value, the response returns incident records that match any of the
  values provided.
- `"maxResults"`: The maximum number of results per page.
- `"nextToken"`: The pagination token for the next set of items to return. (You received
  this token from a previous call.)
"""
function list_incident_records(; aws_config::AbstractAWSConfig=current_aws_config())
    return ssm_incidents(
        "POST",
        "/listIncidentRecords";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_incident_records(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm_incidents(
        "POST",
        "/listIncidentRecords",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_related_items(incident_record_arn)
    list_related_items(incident_record_arn, params::Dict{String,<:Any})

List all related items for an incident record.

# Arguments
- `incident_record_arn`: The Amazon Resource Name (ARN) of the incident record containing
  the listed related items.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of related items per page.
- `"nextToken"`: The pagination token for the next set of items to return. (You received
  this token from a previous call.)
"""
function list_related_items(
    incidentRecordArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm_incidents(
        "POST",
        "/listRelatedItems",
        Dict{String,Any}("incidentRecordArn" => incidentRecordArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_related_items(
    incidentRecordArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm_incidents(
        "POST",
        "/listRelatedItems",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("incidentRecordArn" => incidentRecordArn), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_replication_sets()
    list_replication_sets(params::Dict{String,<:Any})

Lists details about the replication set configured in your account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results per page.
- `"nextToken"`: The pagination token for the next set of items to return. (You received
  this token from a previous call.)
"""
function list_replication_sets(; aws_config::AbstractAWSConfig=current_aws_config())
    return ssm_incidents(
        "POST",
        "/listReplicationSets";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_replication_sets(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm_incidents(
        "POST",
        "/listReplicationSets",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_response_plans()
    list_response_plans(params::Dict{String,<:Any})

Lists all response plans in your account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of response plans per page.
- `"nextToken"`: The pagination token for the next set of items to return. (You received
  this token from a previous call.)
"""
function list_response_plans(; aws_config::AbstractAWSConfig=current_aws_config())
    return ssm_incidents(
        "POST", "/listResponsePlans"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_response_plans(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm_incidents(
        "POST",
        "/listResponsePlans",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_tags_for_resource(resource_arn)
    list_tags_for_resource(resource_arn, params::Dict{String,<:Any})

Lists the tags that are attached to the specified response plan or incident.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the response plan or incident.

"""
function list_tags_for_resource(
    resourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm_incidents(
        "GET",
        "/tags/$(resourceArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tags_for_resource(
    resourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm_incidents(
        "GET",
        "/tags/$(resourceArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_timeline_events(incident_record_arn)
    list_timeline_events(incident_record_arn, params::Dict{String,<:Any})

Lists timeline events for the specified incident record.

# Arguments
- `incident_record_arn`: The Amazon Resource Name (ARN) of the incident that includes the
  timeline event.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"filters"`: Filters the timeline events based on the provided conditional values. You
  can filter timeline events with the following keys:    eventReference     eventTime
  eventType    Note the following when deciding how to use Filters:   If you don't specify a
  Filter, the response includes all timeline events.   If you specify more than one filter in
  a single request, the response returns timeline events that match all filters.   If you
  specify a filter with more than one value, the response returns timeline events that match
  any of the values provided.
- `"maxResults"`: The maximum number of results per page.
- `"nextToken"`: The pagination token for the next set of items to return. (You received
  this token from a previous call.)
- `"sortBy"`: Sort timeline events by the specified key value pair.
- `"sortOrder"`: Sorts the order of timeline events by the value specified in the sortBy
  field.
"""
function list_timeline_events(
    incidentRecordArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm_incidents(
        "POST",
        "/listTimelineEvents",
        Dict{String,Any}("incidentRecordArn" => incidentRecordArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_timeline_events(
    incidentRecordArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm_incidents(
        "POST",
        "/listTimelineEvents",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("incidentRecordArn" => incidentRecordArn), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_resource_policy(policy, resource_arn)
    put_resource_policy(policy, resource_arn, params::Dict{String,<:Any})

Adds a resource policy to the specified response plan. The resource policy is used to share
the response plan using Resource Access Manager (RAM). For more information about
cross-account sharing, see Cross-Region and cross-account incident management.

# Arguments
- `policy`: Details of the resource policy.
- `resource_arn`: The Amazon Resource Name (ARN) of the response plan to add the resource
  policy to.

"""
function put_resource_policy(
    policy, resourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm_incidents(
        "POST",
        "/putResourcePolicy",
        Dict{String,Any}("policy" => policy, "resourceArn" => resourceArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_resource_policy(
    policy,
    resourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm_incidents(
        "POST",
        "/putResourcePolicy",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("policy" => policy, "resourceArn" => resourceArn),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_incident(response_plan_arn)
    start_incident(response_plan_arn, params::Dict{String,<:Any})

Used to start an incident from CloudWatch alarms, EventBridge events, or manually.

# Arguments
- `response_plan_arn`: The Amazon Resource Name (ARN) of the response plan that pre-defines
  summary, chat channels, Amazon SNS topics, runbooks, title, and impact of the incident.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientToken"`: A token ensuring that the operation is called only once with the
  specified details.
- `"impact"`: Defines the impact to the customers. Providing an impact overwrites the
  impact provided by a response plan.  Supported impact codes     1 - Critical    2 - High
  3 - Medium    4 - Low    5 - No Impact
- `"relatedItems"`: Add related items to the incident for other responders to use. Related
  items are Amazon Web Services resources, external links, or files uploaded to an Amazon S3
  bucket.
- `"title"`: Provide a title for the incident. Providing a title overwrites the title
  provided by the response plan.
- `"triggerDetails"`: Details of what created the incident record in Incident Manager.
"""
function start_incident(responsePlanArn; aws_config::AbstractAWSConfig=current_aws_config())
    return ssm_incidents(
        "POST",
        "/startIncident",
        Dict{String,Any}(
            "responsePlanArn" => responsePlanArn, "clientToken" => string(uuid4())
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_incident(
    responsePlanArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm_incidents(
        "POST",
        "/startIncident",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "responsePlanArn" => responsePlanArn, "clientToken" => string(uuid4())
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_resource(resource_arn, tags)
    tag_resource(resource_arn, tags, params::Dict{String,<:Any})

Adds a tag to a response plan.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the response plan you're adding the
  tags to.
- `tags`: A list of tags to add to the response plan.

"""
function tag_resource(resourceArn, tags; aws_config::AbstractAWSConfig=current_aws_config())
    return ssm_incidents(
        "POST",
        "/tags/$(resourceArn)",
        Dict{String,Any}("tags" => tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_resource(
    resourceArn,
    tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm_incidents(
        "POST",
        "/tags/$(resourceArn)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("tags" => tags), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_resource(resource_arn, tag_keys)
    untag_resource(resource_arn, tag_keys, params::Dict{String,<:Any})

Removes a tag from a resource.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the response plan you're removing a tag
  from.
- `tag_keys`: The name of the tag to remove from the response plan.

"""
function untag_resource(
    resourceArn, tagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm_incidents(
        "DELETE",
        "/tags/$(resourceArn)",
        Dict{String,Any}("tagKeys" => tagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_resource(
    resourceArn,
    tagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm_incidents(
        "DELETE",
        "/tags/$(resourceArn)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("tagKeys" => tagKeys), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_deletion_protection(arn, deletion_protected)
    update_deletion_protection(arn, deletion_protected, params::Dict{String,<:Any})

Update deletion protection to either allow or deny deletion of the final Region in a
replication set.

# Arguments
- `arn`: The Amazon Resource Name (ARN) of the replication set to update.
- `deletion_protected`: Specifies if deletion protection is turned on or off in your
  account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientToken"`: A token that ensures that the operation is called only once with the
  specified details.
"""
function update_deletion_protection(
    arn, deletionProtected; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm_incidents(
        "POST",
        "/updateDeletionProtection",
        Dict{String,Any}(
            "arn" => arn,
            "deletionProtected" => deletionProtected,
            "clientToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_deletion_protection(
    arn,
    deletionProtected,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm_incidents(
        "POST",
        "/updateDeletionProtection",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "arn" => arn,
                    "deletionProtected" => deletionProtected,
                    "clientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_incident_record(arn)
    update_incident_record(arn, params::Dict{String,<:Any})

Update the details of an incident record. You can use this operation to update an incident
record from the defined chat channel. For more information about using actions in chat
channels, see Interacting through chat.

# Arguments
- `arn`: The Amazon Resource Name (ARN) of the incident record you are updating.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"chatChannel"`: The Chatbot chat channel where responders can collaborate.
- `"clientToken"`: A token that ensures that a client calls the operation only once with
  the specified details.
- `"impact"`: Defines the impact of the incident to customers and applications. If you
  provide an impact for an incident, it overwrites the impact provided by the response plan.
  Supported impact codes     1 - Critical    2 - High    3 - Medium    4 - Low    5 - No
  Impact
- `"notificationTargets"`: The Amazon SNS targets that Incident Manager notifies when a
  client updates an incident. Using multiple SNS topics creates redundancy in the event that
  a Region is down during the incident.
- `"status"`: The status of the incident. Possible statuses are Open or Resolved.
- `"summary"`: A longer description of what occurred during the incident.
- `"title"`: A brief description of the incident.
"""
function update_incident_record(arn; aws_config::AbstractAWSConfig=current_aws_config())
    return ssm_incidents(
        "POST",
        "/updateIncidentRecord",
        Dict{String,Any}("arn" => arn, "clientToken" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_incident_record(
    arn, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm_incidents(
        "POST",
        "/updateIncidentRecord",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("arn" => arn, "clientToken" => string(uuid4())),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_related_items(incident_record_arn, related_items_update)
    update_related_items(incident_record_arn, related_items_update, params::Dict{String,<:Any})

Add or remove related items from the related items tab of an incident record.

# Arguments
- `incident_record_arn`: The Amazon Resource Name (ARN) of the incident record that
  contains the related items that you update.
- `related_items_update`: Details about the item that you are add to, or delete from, an
  incident.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientToken"`: A token that ensures that a client calls the operation only once with
  the specified details.
"""
function update_related_items(
    incidentRecordArn,
    relatedItemsUpdate;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm_incidents(
        "POST",
        "/updateRelatedItems",
        Dict{String,Any}(
            "incidentRecordArn" => incidentRecordArn,
            "relatedItemsUpdate" => relatedItemsUpdate,
            "clientToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_related_items(
    incidentRecordArn,
    relatedItemsUpdate,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm_incidents(
        "POST",
        "/updateRelatedItems",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "incidentRecordArn" => incidentRecordArn,
                    "relatedItemsUpdate" => relatedItemsUpdate,
                    "clientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_replication_set(actions, arn)
    update_replication_set(actions, arn, params::Dict{String,<:Any})

Add or delete Regions from your replication set.

# Arguments
- `actions`: An action to add or delete a Region.
- `arn`: The Amazon Resource Name (ARN) of the replication set you're updating.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientToken"`: A token that ensures that the operation is called only once with the
  specified details.
"""
function update_replication_set(
    actions, arn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm_incidents(
        "POST",
        "/updateReplicationSet",
        Dict{String,Any}(
            "actions" => actions, "arn" => arn, "clientToken" => string(uuid4())
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_replication_set(
    actions,
    arn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm_incidents(
        "POST",
        "/updateReplicationSet",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "actions" => actions, "arn" => arn, "clientToken" => string(uuid4())
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_response_plan(arn)
    update_response_plan(arn, params::Dict{String,<:Any})

Updates the specified response plan.

# Arguments
- `arn`: The Amazon Resource Name (ARN) of the response plan.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"actions"`: The actions that this response plan takes at the beginning of an incident.
- `"chatChannel"`: The Chatbot chat channel used for collaboration during an incident. Use
  the empty structure to remove the chat channel from the response plan.
- `"clientToken"`: A token ensuring that the operation is called only once with the
  specified details.
- `"displayName"`: The long format name of the response plan. The display name can't
  contain spaces.
- `"engagements"`: The Amazon Resource Name (ARN) for the contacts and escalation plans
  that the response plan engages during an incident.
- `"incidentTemplateDedupeString"`: The string Incident Manager uses to prevent duplicate
  incidents from being created by the same incident in the same account.
- `"incidentTemplateImpact"`: Defines the impact to the customers. Providing an impact
  overwrites the impact provided by a response plan.  Supported impact codes     1 - Critical
     2 - High    3 - Medium    4 - Low    5 - No Impact
- `"incidentTemplateNotificationTargets"`: The Amazon SNS targets that are notified when
  updates are made to an incident.
- `"incidentTemplateSummary"`: A brief summary of the incident. This typically contains
  what has happened, what's currently happening, and next steps.
- `"incidentTemplateTags"`: Tags to assign to the template. When the StartIncident API
  action is called, Incident Manager assigns the tags specified in the template to the
  incident. To call this action, you must also have permission to call the TagResource API
  action for the incident record resource.
- `"incidentTemplateTitle"`: The short format name of the incident. The title can't contain
  spaces.
- `"integrations"`: Information about third-party services integrated into the response
  plan.
"""
function update_response_plan(arn; aws_config::AbstractAWSConfig=current_aws_config())
    return ssm_incidents(
        "POST",
        "/updateResponsePlan",
        Dict{String,Any}("arn" => arn, "clientToken" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_response_plan(
    arn, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm_incidents(
        "POST",
        "/updateResponsePlan",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("arn" => arn, "clientToken" => string(uuid4())),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_timeline_event(event_id, incident_record_arn)
    update_timeline_event(event_id, incident_record_arn, params::Dict{String,<:Any})

Updates a timeline event. You can update events of type Custom Event.

# Arguments
- `event_id`: The ID of the event to update. You can use ListTimelineEvents to find an
  event's ID.
- `incident_record_arn`: The Amazon Resource Name (ARN) of the incident that includes the
  timeline event.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientToken"`: A token that ensures that a client calls the operation only once with
  the specified details.
- `"eventData"`: A short description of the event.
- `"eventReferences"`: Updates all existing references in a TimelineEvent. A reference is
  an Amazon Web Services resource involved or associated with the incident. To specify a
  reference, enter its Amazon Resource Name (ARN). You can also specify a related item
  associated with that resource. For example, to specify an Amazon DynamoDB (DynamoDB) table
  as a resource, use its ARN. You can also specify an Amazon CloudWatch metric associated
  with the DynamoDB table as a related item.  This update action overrides all existing
  references. If you want to keep existing references, you must specify them in the call. If
  you don't, this action removes any existing references and enters only new references.
- `"eventTime"`: The timestamp for when the event occurred.
- `"eventType"`: The type of event. You can update events of type Custom Event and Note.
"""
function update_timeline_event(
    eventId, incidentRecordArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm_incidents(
        "POST",
        "/updateTimelineEvent",
        Dict{String,Any}(
            "eventId" => eventId,
            "incidentRecordArn" => incidentRecordArn,
            "clientToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_timeline_event(
    eventId,
    incidentRecordArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm_incidents(
        "POST",
        "/updateTimelineEvent",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "eventId" => eventId,
                    "incidentRecordArn" => incidentRecordArn,
                    "clientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
