using Test, Colors

@testset "Colormaps" begin
    @testset "distinguishable_colors" begin
        cols = distinguishable_colors(10)
        @test isconcretetype(eltype(cols))

        mindiff = Inf
        for i = 1:10, j = i+1:10
            mindiff = min(mindiff, colordiff(cols[i], cols[j]))
        end
        @test mindiff > 8

        seed = distinguishable_colors(1)
        @test colordiff(distinguishable_colors(1, seed)[1], seed[1]) == 0.0
        @test colordiff(distinguishable_colors(1, seed; dropseed=true)[1], seed[1]) > 50

        cols_i = distinguishable_colors(4, LCHab(60, 50, 40), transform=identity,
                                        lchoices=[40, 60], cchoices=[50], hchoices=[40, 140])
        cols_p = distinguishable_colors(4, LCHab(60, 50, 40), transform=protanopic,
                                        lchoices=[40, 60], cchoices=[50], hchoices=[40, 140])
        @test cols_i[2] ≈ LCHab(40, 50, 140) atol=1f-3 # green
        @test cols_p[2] ≈ LCHab(40, 50,  40) atol=1f-3 # red
    end

    @test length(colormap("RdBu", 100)) == 100

    @test isconcretetype(eltype(colormap("Grays")))

    @test_throws ArgumentError colormap("Grays", N=10) # optional arguments, not keyword

    # not return values to check here, just checking that keywords can be used
    # Sequential
    default_blues = colormap("Blues", 10)
    @test_throws ArgumentError colormap("Blues", 10; mid=0.9) # `mid` is for diverging colormaps only (issue #300)
    @test colormap("Blues", 10; logscale=true) != default_blues
    @test colormap("Blues", 10; h=0.5) != default_blues
    @test colormap("Blues", 10; w=0.5) != default_blues
    @test colormap("Blues", 10; d=0.5) != default_blues
    @test colormap("Blues", 10; c=0.5) != default_blues
    @test colormap("Blues", 10; s=0.5) != default_blues
    @test colormap("Blues", 10; b=0.5) != default_blues
    @test colormap("Blues", 10; wcolor=colorant"white") != default_blues
    @test colormap("Blues", 10; dcolor=colorant"black") != default_blues
    @test_throws ArgumentError colormap("Blues", 10; h1=0.5)

    # Diverging
    default_rdbu = colormap("RdBu", 10)
    @test colormap("RdBu", 10; mid=0.9) != default_rdbu
    @test colormap("RdBu", 10; logscale=true) != default_rdbu
    @test colormap("RdBu", 10; h1=0.5) != default_rdbu
    @test colormap("RdBu", 10; h2=0.5) != default_rdbu
    @test colormap("RdBu", 10; w=0.5) != default_rdbu
    @test colormap("RdBu", 10; d1=0.5) != default_rdbu
    @test colormap("RdBu", 10; d2=0.5) != default_rdbu
    @test colormap("RdBu", 10; c=0.5) != default_rdbu
    @test colormap("RdBu", 10; s=0.5) != default_rdbu
    @test colormap("RdBu", 10; b=0.5) != default_rdbu
    @test colormap("RdBu", 10; wcolor=colorant"white") != default_rdbu
    @test colormap("RdBu", 10; dcolor1=colorant"black") != default_rdbu
    # `dcolor2` is disabled by the default `d2`(=0)
    @test colormap("RdBu", 10; dcolor2=colorant"black", d2=1) != default_rdbu
    @test_throws ArgumentError colormap("RdBu", 10; h=0.5)

    # The outputs of `colormap()` were slightly affected by the bug fix of
    # `MSC(h)` (issue #349).
    # The following were generated by `colormap()` in Colors.jl v0.9.6.
    blues_old   = (0xF4FDFF, 0xB3E3F4, 0x65B9E7, 0x2978BE, 0x0B2857)
    greens_old  = (0xFAFFF7, 0xB6EEA0, 0x75C769, 0x308B40, 0x00391A)
    grays_old   = (0xFFFFFF, 0xDCDCDC, 0xA9A9A9, 0x626262, 0x000000)
    oranges_old = (0xFFFBF6, 0xFFD6B4, 0xFF9D5F, 0xE2500D, 0x732108)
    purples_old = (0xFBFBFB, 0xDBD7F6, 0xAFA7E6, 0x7666BF, 0x3C0468)
    reds_old    = (0xFFF1EE, 0xFFC4B9, 0xFF8576, 0xE72823, 0x6D0B0C)
    rdbu_old    = (0x610102, 0xFF8D7B, 0xF9F8F9, 0x76B4E8, 0x092C58)

    to_rgb(s) = reinterpret(RGB24, s)
    max_colordiff(a1, a2) = maximum(colordiff.(a1, a2))
    @test max_colordiff(colormap("Blues", 5), to_rgb.(blues_old)) < 1
    @test max_colordiff(colormap("Greens", 5), to_rgb.(greens_old)) < 1
    @test max_colordiff(colormap("Grays", 5), to_rgb.(grays_old)) < 1
    @test max_colordiff(colormap("Oranges", 5), to_rgb.(oranges_old)) < 1
    @test max_colordiff(colormap("Purples", 5), to_rgb.(purples_old)) < 1
    @test max_colordiff(colormap("Reds", 5), to_rgb.(reds_old)) < 1
    @test max_colordiff(colormap("RdBu", 5), to_rgb.(rdbu_old)) < 1

    cyans = sequential_palette(192, w=1.0, d=1.0, wcolor=RGB(1,1,1), dcolor=RGB(0,0,0))
    @test all(c -> isapprox(green(c), blue(c), atol=1e-3), cyans)

    ryr = diverging_palette(0.0, 359.999, 45, w=0.9, c=0.7, dcolor1=RGB(0,0,1))
    @test all(c -> isapprox(c[1], c[2], atol=1e-3), zip(ryr, reverse(ryr)))
end
