# colors chosen by according to http://seaborn.pydata.org/tutorial/color_palettes.html
# https://github.com/mwaskom/seaborn/blob/master/seaborn/palettes.py
# as proposed in https://github.com/JuliaPlots/Plots.jl/issues/2510

loadcolorscheme(:seaborn_bright, [
RGB{Float64}(0.00784313725490196,0.24313725490196078,1.0),
RGB{Float64}(1.0,0.48627450980392156,0.0),
RGB{Float64}(0.10196078431372549,0.788235294117647,0.2196078431372549),
RGB{Float64}(0.9098039215686274,0.0,0.043137254901960784),
RGB{Float64}(0.5450980392156862,0.16862745098039217,0.8862745098039215),
RGB{Float64}(0.6235294117647059,0.2823529411764706,0.0),
RGB{Float64}(0.9450980392156862,0.2980392156862745,0.7568627450980392),
RGB{Float64}(0.6392156862745098,0.6392156862745098,0.6392156862745098),
RGB{Float64}(1.0,0.7686274509803922,0.0),
RGB{Float64}(0.0,0.8431372549019608,1.0),
], "seaborn", "sequential")

loadcolorscheme(:seaborn_bright6, [
RGB{Float64}(0.00784313725490196,0.24313725490196078,1.0),
RGB{Float64}(0.10196078431372549,0.788235294117647,0.2196078431372549),
RGB{Float64}(0.9098039215686274,0.0,0.043137254901960784),
RGB{Float64}(0.5450980392156862,0.16862745098039217,0.8862745098039215),
RGB{Float64}(1.0,0.7686274509803922,0.0),
RGB{Float64}(0.0,0.8431372549019608,1.0),
], "seaborn", "sequential")

loadcolorscheme(:seaborn_deep, [
   RGB{Float64}(0.2980392156862745,0.4470588235294118,0.6901960784313725),
   RGB{Float64}(0.8666666666666667,0.5176470588235295,0.3215686274509804),
   RGB{Float64}(0.3333333333333333,0.6588235294117647,0.40784313725490196),
   RGB{Float64}(0.7686274509803922,0.3058823529411765,0.3215686274509804),
   RGB{Float64}(0.5058823529411764,0.4470588235294118,0.7019607843137254),
   RGB{Float64}(0.5764705882352941,0.47058823529411764,0.3764705882352941),
   RGB{Float64}(0.8549019607843137,0.5450980392156862,0.7647058823529411),
   RGB{Float64}(0.5490196078431373,0.5490196078431373,0.5490196078431373),
   RGB{Float64}(0.8,0.7254901960784313,0.4549019607843137),
   RGB{Float64}(0.39215686274509803,0.7098039215686275,0.803921568627451),
  ], "seaborn", "sequential")

loadcolorscheme(:seaborn_deep6, [
   RGB{Float64}(0.2980392156862745,0.4470588235294118,0.6901960784313725),
   RGB{Float64}(0.3333333333333333,0.6588235294117647,0.40784313725490196),
   RGB{Float64}(0.7686274509803922,0.3058823529411765,0.3215686274509804),
   RGB{Float64}(0.5058823529411764,0.4470588235294118,0.7019607843137254),
   RGB{Float64}(0.8,0.7254901960784313,0.4549019607843137),
   RGB{Float64}(0.39215686274509803,0.7098039215686275,0.803921568627451),
  ], "seaborn", "sequential")

loadcolorscheme(:seaborn_dark, [
RGB{Float64}(0.0,0.10980392156862745,0.4980392156862745),
RGB{Float64}(0.6941176470588235,0.25098039215686274,0.050980392156862744),
RGB{Float64}(0.07058823529411765,0.44313725490196076,0.10980392156862745),
RGB{Float64}(0.5490196078431373,0.03137254901960784,0.0),
RGB{Float64}(0.34901960784313724,0.11764705882352941,0.44313725490196076),
RGB{Float64}(0.34901960784313724,0.1843137254901961,0.050980392156862744),
RGB{Float64}(0.6352941176470588,0.20784313725490197,0.5098039215686274),
RGB{Float64}(0.23529411764705882,0.23529411764705882,0.23529411764705882),
RGB{Float64}(0.7215686274509804,0.5215686274509804,0.0392156862745098),
RGB{Float64}(0.0,0.38823529411764707,0.4549019607843137),
], "seaborn", "sequential")

loadcolorscheme(:seaborn_dark6, [
RGB{Float64}(0.0,0.10980392156862745,0.4980392156862745),
RGB{Float64}(0.07058823529411765,0.44313725490196076,0.10980392156862745),
RGB{Float64}(0.5490196078431373,0.03137254901960784,0.0),
RGB{Float64}(0.34901960784313724,0.11764705882352941,0.44313725490196076),
RGB{Float64}(0.7215686274509804,0.5215686274509804,0.0392156862745098),
RGB{Float64}(0.0,0.38823529411764707,0.4549019607843137),
], "seaborn", "sequential")

loadcolorscheme(:seaborn_colorblind, [
RGB{Float64}(0.00392156862745098,0.45098039215686275,0.6980392156862745),
RGB{Float64}(0.8705882352941177,0.5607843137254902,0.0196078431372549),
RGB{Float64}(0.00784313725490196,0.6196078431372549,0.45098039215686275),
RGB{Float64}(0.8352941176470589,0.3686274509803922,0.0),
RGB{Float64}(0.8,0.47058823529411764,0.7372549019607844),
RGB{Float64}(0.792156862745098,0.5686274509803921,0.3803921568627451),
RGB{Float64}(0.984313725490196,0.6862745098039216,0.8941176470588236),
RGB{Float64}(0.5803921568627451,0.5803921568627451,0.5803921568627451),
RGB{Float64}(0.9254901960784314,0.8823529411764706,0.2),
RGB{Float64}(0.33725490196078434,0.7058823529411765,0.9137254901960784),
], "seaborn", "sequential, cvd friendly color blind friendly")

loadcolorscheme(:seaborn_colorblind6, [
RGB{Float64}(0.00392156862745098,0.45098039215686275,0.6980392156862745),
RGB{Float64}(0.00784313725490196,0.6196078431372549,0.45098039215686275),
RGB{Float64}(0.8352941176470589,0.3686274509803922,0.0),
RGB{Float64}(0.8,0.47058823529411764,0.7372549019607844),
RGB{Float64}(0.9254901960784314,0.8823529411764706,0.2),
RGB{Float64}(0.33725490196078434,0.7058823529411765,0.9137254901960784),
], "seaborn", "sequential, cvd friendly color blind friendly")

loadcolorscheme(:seaborn_muted, [
   RGB{Float64}(0.2823529411764706,0.47058823529411764,0.8156862745098039),
   RGB{Float64}(0.9333333333333333,0.5215686274509804,0.2901960784313726),
   RGB{Float64}(0.41568627450980394,0.8,0.39215686274509803),
   RGB{Float64}(0.8392156862745098,0.37254901960784315,0.37254901960784315),
   RGB{Float64}(0.5843137254901961,0.4235294117647059,0.7058823529411765),
   RGB{Float64}(0.5490196078431373,0.3803921568627451,0.23529411764705882),
   RGB{Float64}(0.8627450980392157,0.49411764705882355,0.7529411764705882),
   RGB{Float64}(0.4745098039215686,0.4745098039215686,0.4745098039215686),
   RGB{Float64}(0.8352941176470589,0.7333333333333333,0.403921568627451),
   RGB{Float64}(0.5098039215686274,0.7764705882352941,0.8862745098039215),
  ], "seaborn", "sequential")

loadcolorscheme(:seaborn_muted6, [
   RGB{Float64}(0.2823529411764706,0.47058823529411764,0.8156862745098039),
   RGB{Float64}(0.41568627450980394,0.8,0.39215686274509803),
   RGB{Float64}(0.8392156862745098,0.37254901960784315,0.37254901960784315),
   RGB{Float64}(0.5843137254901961,0.4235294117647059,0.7058823529411765),
   RGB{Float64}(0.8352941176470589,0.7333333333333333,0.403921568627451),
   RGB{Float64}(0.5098039215686274,0.7764705882352941,0.8862745098039215),
  ], "seaborn", "sequential")

loadcolorscheme(:seaborn_pastel, [
   RGB{Float64}(0.6313725490196078,0.788235294117647,0.9568627450980393),
   RGB{Float64}(1.0,0.7058823529411765,0.5098039215686274),
   RGB{Float64}(0.5529411764705883,0.8980392156862745,0.6313725490196078),
   RGB{Float64}(1.0,0.6235294117647059,0.6078431372549019),
   RGB{Float64}(0.8156862745098039,0.7333333333333333,1.0),
   RGB{Float64}(0.8705882352941177,0.7333333333333333,0.6078431372549019),
   RGB{Float64}(0.9803921568627451,0.6901960784313725,0.8941176470588236),
   RGB{Float64}(0.8117647058823529,0.8117647058823529,0.8117647058823529),
   RGB{Float64}(1.0,0.996078431372549,0.6392156862745098),
   RGB{Float64}(0.7254901960784313,0.9490196078431372,0.9411764705882353),
  ], "seaborn", "sequential")

loadcolorscheme(:seaborn_pastel6, [
   RGB{Float64}(0.6313725490196078,0.788235294117647,0.9568627450980393),
   RGB{Float64}(0.5529411764705883,0.8980392156862745,0.6313725490196078),
   RGB{Float64}(1.0,0.6235294117647059,0.6078431372549019),
   RGB{Float64}(0.8156862745098039,0.7333333333333333,1.0),
   RGB{Float64}(1.0,0.996078431372549,0.6392156862745098),
   RGB{Float64}(0.7254901960784313,0.9490196078431372,0.9411764705882353),
  ], "seaborn", "sequential")

loadcolorscheme(:seaborn_rocket_gradient, [
      RGB{Float64}(0.01060815, 0.01808215, 0.10018654),
                                   RGB{Float64}(0.01428972, 0.02048237, 0.10374486),
                                   RGB{Float64}(0.01831941, 0.0229766, 0.10738511),
                                   RGB{Float64}(0.02275049, 0.02554464, 0.11108639),
                                   RGB{Float64}(0.02759119, 0.02818316, 0.11483751),
                                   RGB{Float64}(0.03285175, 0.03088792, 0.11863035),
                                   RGB{Float64}(0.03853466, 0.03365771, 0.12245873),
                                   RGB{Float64}(0.04447016, 0.03648425, 0.12631831),
                                   RGB{Float64}(0.05032105, 0.03936808, 0.13020508),
                                   RGB{Float64}(0.05611171, 0.04224835, 0.13411624),
                                   RGB{Float64}(0.0618531, 0.04504866, 0.13804929),
                                   RGB{Float64}(0.06755457, 0.04778179, 0.14200206),
                                   RGB{Float64}(0.0732236, 0.05045047, 0.14597263),
                                   RGB{Float64}(0.0788708, 0.05305461, 0.14995981),
                                   RGB{Float64}(0.08450105, 0.05559631, 0.15396203),
                                   RGB{Float64}(0.09011319, 0.05808059, 0.15797687),
                                   RGB{Float64}(0.09572396, 0.06050127, 0.16200507),
                                   RGB{Float64}(0.10132312, 0.06286782, 0.16604287),
                                   RGB{Float64}(0.10692823, 0.06517224, 0.17009175),
                                   RGB{Float64}(0.1125315, 0.06742194, 0.17414848),
                                   RGB{Float64}(0.11813947, 0.06961499, 0.17821272),
                                   RGB{Float64}(0.12375803, 0.07174938, 0.18228425),
                                   RGB{Float64}(0.12938228, 0.07383015, 0.18636053),
                                   RGB{Float64}(0.13501631, 0.07585609, 0.19044109),
                                   RGB{Float64}(0.14066867, 0.0778224, 0.19452676),
                                   RGB{Float64}(0.14633406, 0.07973393, 0.1986151),
                                   RGB{Float64}(0.15201338, 0.08159108, 0.20270523),
                                   RGB{Float64}(0.15770877, 0.08339312, 0.20679668),
                                   RGB{Float64}(0.16342174, 0.0851396, 0.21088893),
                                   RGB{Float64}(0.16915387, 0.08682996, 0.21498104),
                                   RGB{Float64}(0.17489524, 0.08848235, 0.2190294),
                                   RGB{Float64}(0.18065495, 0.09009031, 0.22303512),
                                   RGB{Float64}(0.18643324, 0.09165431, 0.22699705),
                                   RGB{Float64}(0.19223028, 0.09317479, 0.23091409),
                                   RGB{Float64}(0.19804623, 0.09465217, 0.23478512),
                                   RGB{Float64}(0.20388117, 0.09608689, 0.23860907),
                                   RGB{Float64}(0.20973515, 0.09747934, 0.24238489),
                                   RGB{Float64}(0.21560818, 0.09882993, 0.24611154),
                                   RGB{Float64}(0.22150014, 0.10013944, 0.2497868),
                                   RGB{Float64}(0.22741085, 0.10140876, 0.25340813),
                                   RGB{Float64}(0.23334047, 0.10263737, 0.25697736),
                                   RGB{Float64}(0.23928891, 0.10382562, 0.2604936),
                                   RGB{Float64}(0.24525608, 0.10497384, 0.26395596),
                                   RGB{Float64}(0.25124182, 0.10608236, 0.26736359),
                                   RGB{Float64}(0.25724602, 0.10715148, 0.27071569),
                                   RGB{Float64}(0.26326851, 0.1081815, 0.27401148),
                                   RGB{Float64}(0.26930915, 0.1091727, 0.2772502),
                                   RGB{Float64}(0.27536766, 0.11012568, 0.28043021),
                                   RGB{Float64}(0.28144375, 0.11104133, 0.2835489),
                                   RGB{Float64}(0.2875374, 0.11191896, 0.28660853),
                                   RGB{Float64}(0.29364846, 0.11275876, 0.2896085),
                                   RGB{Float64}(0.29977678, 0.11356089, 0.29254823),
                                   RGB{Float64}(0.30592213, 0.11432553, 0.29542718),
                                   RGB{Float64}(0.31208435, 0.11505284, 0.29824485),
                                   RGB{Float64}(0.31826327, 0.1157429, 0.30100076),
                                   RGB{Float64}(0.32445869, 0.11639585, 0.30369448),
                                   RGB{Float64}(0.33067031, 0.11701189, 0.30632563),
                                   RGB{Float64}(0.33689808, 0.11759095, 0.3088938),
                                   RGB{Float64}(0.34314168, 0.11813362, 0.31139721),
                                   RGB{Float64}(0.34940101, 0.11863987, 0.3138355),
                                   RGB{Float64}(0.355676, 0.11910909, 0.31620996),
                                   RGB{Float64}(0.36196644, 0.1195413, 0.31852037),
                                   RGB{Float64}(0.36827206, 0.11993653, 0.32076656),
                                   RGB{Float64}(0.37459292, 0.12029443, 0.32294825),
                                   RGB{Float64}(0.38092887, 0.12061482, 0.32506528),
                                   RGB{Float64}(0.38727975, 0.12089756, 0.3271175),
                                   RGB{Float64}(0.39364518, 0.12114272, 0.32910494),
                                   RGB{Float64}(0.40002537, 0.12134964, 0.33102734),
                                   RGB{Float64}(0.40642019, 0.12151801, 0.33288464),
                                   RGB{Float64}(0.41282936, 0.12164769, 0.33467689),
                                   RGB{Float64}(0.41925278, 0.12173833, 0.33640407),
                                   RGB{Float64}(0.42569057, 0.12178916, 0.33806605),
                                   RGB{Float64}(0.43214263, 0.12179973, 0.33966284),
                                   RGB{Float64}(0.43860848, 0.12177004, 0.34119475),
                                   RGB{Float64}(0.44508855, 0.12169883, 0.34266151),
                                   RGB{Float64}(0.45158266, 0.12158557, 0.34406324),
                                   RGB{Float64}(0.45809049, 0.12142996, 0.34540024),
                                   RGB{Float64}(0.46461238, 0.12123063, 0.34667231),
                                   RGB{Float64}(0.47114798, 0.12098721, 0.34787978),
                                   RGB{Float64}(0.47769736, 0.12069864, 0.34902273),
                                   RGB{Float64}(0.48426077, 0.12036349, 0.35010104),
                                   RGB{Float64}(0.49083761, 0.11998161, 0.35111537),
                                   RGB{Float64}(0.49742847, 0.11955087, 0.35206533),
                                   RGB{Float64}(0.50403286, 0.11907081, 0.35295152),
                                   RGB{Float64}(0.51065109, 0.11853959, 0.35377385),
                                   RGB{Float64}(0.51728314, 0.1179558, 0.35453252),
                                   RGB{Float64}(0.52392883, 0.11731817, 0.35522789),
                                   RGB{Float64}(0.53058853, 0.11662445, 0.35585982),
                                   RGB{Float64}(0.53726173, 0.11587369, 0.35642903),
                                   RGB{Float64}(0.54394898, 0.11506307, 0.35693521),
                                   RGB{Float64}(0.5506426, 0.11420757, 0.35737863),
                                   RGB{Float64}(0.55734473, 0.11330456, 0.35775059),
                                   RGB{Float64}(0.56405586, 0.11235265, 0.35804813),
                                   RGB{Float64}(0.57077365, 0.11135597, 0.35827146),
                                   RGB{Float64}(0.5774991, 0.11031233, 0.35841679),
                                   RGB{Float64}(0.58422945, 0.10922707, 0.35848469),
                                   RGB{Float64}(0.59096382, 0.10810205, 0.35847347),
                                   RGB{Float64}(0.59770215, 0.10693774, 0.35838029),
                                   RGB{Float64}(0.60444226, 0.10573912, 0.35820487),
                                   RGB{Float64}(0.61118304, 0.10450943, 0.35794557),
                                   RGB{Float64}(0.61792306, 0.10325288, 0.35760108),
                                   RGB{Float64}(0.62466162, 0.10197244, 0.35716891),
                                   RGB{Float64}(0.63139686, 0.10067417, 0.35664819),
                                   RGB{Float64}(0.63812122, 0.09938212, 0.35603757),
                                   RGB{Float64}(0.64483795, 0.0980891, 0.35533555),
                                   RGB{Float64}(0.65154562, 0.09680192, 0.35454107),
                                   RGB{Float64}(0.65824241, 0.09552918, 0.3536529),
                                   RGB{Float64}(0.66492652, 0.09428017, 0.3526697),
                                   RGB{Float64}(0.67159578, 0.09306598, 0.35159077),
                                   RGB{Float64}(0.67824099, 0.09192342, 0.3504148),
                                   RGB{Float64}(0.684863, 0.09085633, 0.34914061),
                                   RGB{Float64}(0.69146268, 0.0898675, 0.34776864),
                                   RGB{Float64}(0.69803757, 0.08897226, 0.3462986),
                                   RGB{Float64}(0.70457834, 0.0882129, 0.34473046),
                                   RGB{Float64}(0.71108138, 0.08761223, 0.3430635),
                                   RGB{Float64}(0.7175507, 0.08716212, 0.34129974),
                                   RGB{Float64}(0.72398193, 0.08688725, 0.33943958),
                                   RGB{Float64}(0.73035829, 0.0868623, 0.33748452),
                                   RGB{Float64}(0.73669146, 0.08704683, 0.33543669),
                                   RGB{Float64}(0.74297501, 0.08747196, 0.33329799),
                                   RGB{Float64}(0.74919318, 0.08820542, 0.33107204),
                                   RGB{Float64}(0.75535825, 0.08919792, 0.32876184),
                                   RGB{Float64}(0.76145589, 0.09050716, 0.32637117),
                                   RGB{Float64}(0.76748424, 0.09213602, 0.32390525),
                                   RGB{Float64}(0.77344838, 0.09405684, 0.32136808),
                                   RGB{Float64}(0.77932641, 0.09634794, 0.31876642),
                                   RGB{Float64}(0.78513609, 0.09892473, 0.31610488),
                                   RGB{Float64}(0.79085854, 0.10184672, 0.313391),
                                   RGB{Float64}(0.7965014, 0.10506637, 0.31063031),
                                   RGB{Float64}(0.80205987, 0.10858333, 0.30783),
                                   RGB{Float64}(0.80752799, 0.11239964, 0.30499738),
                                   RGB{Float64}(0.81291606, 0.11645784, 0.30213802),
                                   RGB{Float64}(0.81820481, 0.12080606, 0.29926105),
                                   RGB{Float64}(0.82341472, 0.12535343, 0.2963705),
                                   RGB{Float64}(0.82852822, 0.13014118, 0.29347474),
                                   RGB{Float64}(0.83355779, 0.13511035, 0.29057852),
                                   RGB{Float64}(0.83850183, 0.14025098, 0.2876878),
                                   RGB{Float64}(0.84335441, 0.14556683, 0.28480819),
                                   RGB{Float64}(0.84813096, 0.15099892, 0.281943),
                                   RGB{Float64}(0.85281737, 0.15657772, 0.27909826),
                                   RGB{Float64}(0.85742602, 0.1622583, 0.27627462),
                                   RGB{Float64}(0.86196552, 0.16801239, 0.27346473),
                                   RGB{Float64}(0.86641628, 0.17387796, 0.27070818),
                                   RGB{Float64}(0.87079129, 0.17982114, 0.26797378),
                                   RGB{Float64}(0.87507281, 0.18587368, 0.26529697),
                                   RGB{Float64}(0.87925878, 0.19203259, 0.26268136),
                                   RGB{Float64}(0.8833417, 0.19830556, 0.26014181),
                                   RGB{Float64}(0.88731387, 0.20469941, 0.25769539),
                                   RGB{Float64}(0.89116859, 0.21121788, 0.2553592),
                                   RGB{Float64}(0.89490337, 0.21785614, 0.25314362),
                                   RGB{Float64}(0.8985026, 0.22463251, 0.25108745),
                                   RGB{Float64}(0.90197527, 0.23152063, 0.24918223),
                                   RGB{Float64}(0.90530097, 0.23854541, 0.24748098),
                                   RGB{Float64}(0.90848638, 0.24568473, 0.24598324),
                                   RGB{Float64}(0.911533, 0.25292623, 0.24470258),
                                   RGB{Float64}(0.9144225, 0.26028902, 0.24369359),
                                   RGB{Float64}(0.91717106, 0.26773821, 0.24294137),
                                   RGB{Float64}(0.91978131, 0.27526191, 0.24245973),
                                   RGB{Float64}(0.92223947, 0.28287251, 0.24229568),
                                   RGB{Float64}(0.92456587, 0.29053388, 0.24242622),
                                   RGB{Float64}(0.92676657, 0.29823282, 0.24285536),
                                   RGB{Float64}(0.92882964, 0.30598085, 0.24362274),
                                   RGB{Float64}(0.93078135, 0.31373977, 0.24468803),
                                   RGB{Float64}(0.93262051, 0.3215093, 0.24606461),
                                   RGB{Float64}(0.93435067, 0.32928362, 0.24775328),
                                   RGB{Float64}(0.93599076, 0.33703942, 0.24972157),
                                   RGB{Float64}(0.93752831, 0.34479177, 0.25199928),
                                   RGB{Float64}(0.93899289, 0.35250734, 0.25452808),
                                   RGB{Float64}(0.94036561, 0.36020899, 0.25734661),
                                   RGB{Float64}(0.94167588, 0.36786594, 0.2603949),
                                   RGB{Float64}(0.94291042, 0.37549479, 0.26369821),
                                   RGB{Float64}(0.94408513, 0.3830811, 0.26722004),
                                   RGB{Float64}(0.94520419, 0.39062329, 0.27094924),
                                   RGB{Float64}(0.94625977, 0.39813168, 0.27489742),
                                   RGB{Float64}(0.94727016, 0.4055909, 0.27902322),
                                   RGB{Float64}(0.94823505, 0.41300424, 0.28332283),
                                   RGB{Float64}(0.94914549, 0.42038251, 0.28780969),
                                   RGB{Float64}(0.95001704, 0.42771398, 0.29244728),
                                   RGB{Float64}(0.95085121, 0.43500005, 0.29722817),
                                   RGB{Float64}(0.95165009, 0.44224144, 0.30214494),
                                   RGB{Float64}(0.9524044, 0.44944853, 0.3072105),
                                   RGB{Float64}(0.95312556, 0.45661389, 0.31239776),
                                   RGB{Float64}(0.95381595, 0.46373781, 0.31769923),
                                   RGB{Float64}(0.95447591, 0.47082238, 0.32310953),
                                   RGB{Float64}(0.95510255, 0.47787236, 0.32862553),
                                   RGB{Float64}(0.95569679, 0.48489115, 0.33421404),
                                   RGB{Float64}(0.95626788, 0.49187351, 0.33985601),
                                   RGB{Float64}(0.95681685, 0.49882008, 0.34555431),
                                   RGB{Float64}(0.9573439, 0.50573243, 0.35130912),
                                   RGB{Float64}(0.95784842, 0.51261283, 0.35711942),
                                   RGB{Float64}(0.95833051, 0.51946267, 0.36298589),
                                   RGB{Float64}(0.95879054, 0.52628305, 0.36890904),
                                   RGB{Float64}(0.95922872, 0.53307513, 0.3748895),
                                   RGB{Float64}(0.95964538, 0.53983991, 0.38092784),
                                   RGB{Float64}(0.96004345, 0.54657593, 0.3870292),
                                   RGB{Float64}(0.96042097, 0.55328624, 0.39319057),
                                   RGB{Float64}(0.96077819, 0.55997184, 0.39941173),
                                   RGB{Float64}(0.9611152, 0.5666337, 0.40569343),
                                   RGB{Float64}(0.96143273, 0.57327231, 0.41203603),
                                   RGB{Float64}(0.96173392, 0.57988594, 0.41844491),
                                   RGB{Float64}(0.96201757, 0.58647675, 0.42491751),
                                   RGB{Float64}(0.96228344, 0.59304598, 0.43145271),
                                   RGB{Float64}(0.96253168, 0.5995944, 0.43805131),
                                   RGB{Float64}(0.96276513, 0.60612062, 0.44471698),
                                   RGB{Float64}(0.96298491, 0.6126247, 0.45145074),
                                   RGB{Float64}(0.96318967, 0.61910879, 0.45824902),
                                   RGB{Float64}(0.96337949, 0.6255736, 0.46511271),
                                   RGB{Float64}(0.96355923, 0.63201624, 0.47204746),
                                   RGB{Float64}(0.96372785, 0.63843852, 0.47905028),
                                   RGB{Float64}(0.96388426, 0.64484214, 0.4861196),
                                   RGB{Float64}(0.96403203, 0.65122535, 0.4932578),
                                   RGB{Float64}(0.96417332, 0.65758729, 0.50046894),
                                   RGB{Float64}(0.9643063, 0.66393045, 0.5077467),
                                   RGB{Float64}(0.96443322, 0.67025402, 0.51509334),
                                   RGB{Float64}(0.96455845, 0.67655564, 0.52251447),
                                   RGB{Float64}(0.96467922, 0.68283846, 0.53000231),
                                   RGB{Float64}(0.96479861, 0.68910113, 0.53756026),
                                   RGB{Float64}(0.96492035, 0.69534192, 0.5451917),
                                   RGB{Float64}(0.96504223, 0.7015636, 0.5528892),
                                   RGB{Float64}(0.96516917, 0.70776351, 0.5606593),
                                   RGB{Float64}(0.96530224, 0.71394212, 0.56849894),
                                   RGB{Float64}(0.96544032, 0.72010124, 0.57640375),
                                   RGB{Float64}(0.96559206, 0.72623592, 0.58438387),
                                   RGB{Float64}(0.96575293, 0.73235058, 0.59242739),
                                   RGB{Float64}(0.96592829, 0.73844258, 0.60053991),
                                   RGB{Float64}(0.96612013, 0.74451182, 0.60871954),
                                   RGB{Float64}(0.96632832, 0.75055966, 0.61696136),
                                   RGB{Float64}(0.96656022, 0.75658231, 0.62527295),
                                   RGB{Float64}(0.96681185, 0.76258381, 0.63364277),
                                   RGB{Float64}(0.96709183, 0.76855969, 0.64207921),
                                   RGB{Float64}(0.96739773, 0.77451297, 0.65057302),
                                   RGB{Float64}(0.96773482, 0.78044149, 0.65912731),
                                   RGB{Float64}(0.96810471, 0.78634563, 0.66773889),
                                   RGB{Float64}(0.96850919, 0.79222565, 0.6764046),
                                   RGB{Float64}(0.96893132, 0.79809112, 0.68512266),
                                   RGB{Float64}(0.96935926, 0.80395415, 0.69383201),
                                   RGB{Float64}(0.9698028, 0.80981139, 0.70252255),
                                   RGB{Float64}(0.97025511, 0.81566605, 0.71120296),
                                   RGB{Float64}(0.97071849, 0.82151775, 0.71987163),
                                   RGB{Float64}(0.97120159, 0.82736371, 0.72851999),
                                   RGB{Float64}(0.97169389, 0.83320847, 0.73716071),
                                   RGB{Float64}(0.97220061, 0.83905052, 0.74578903),
                                   RGB{Float64}(0.97272597, 0.84488881, 0.75440141),
                                   RGB{Float64}(0.97327085, 0.85072354, 0.76299805),
                                   RGB{Float64}(0.97383206, 0.85655639, 0.77158353),
                                   RGB{Float64}(0.97441222, 0.86238689, 0.78015619),
                                   RGB{Float64}(0.97501782, 0.86821321, 0.78871034),
                                   RGB{Float64}(0.97564391, 0.87403763, 0.79725261),
                                   RGB{Float64}(0.97628674, 0.87986189, 0.8057883),
                                   RGB{Float64}(0.97696114, 0.88568129, 0.81430324),
                                   RGB{Float64}(0.97765722, 0.89149971, 0.82280948),
                                   RGB{Float64}(0.97837585, 0.89731727, 0.83130786),
                                   RGB{Float64}(0.97912374, 0.90313207, 0.83979337),
                                   RGB{Float64}(0.979891, 0.90894778, 0.84827858),
                                   RGB{Float64}(0.98067764, 0.91476465, 0.85676611),
                                   RGB{Float64}(0.98137749, 0.92061729, 0.86536915)]
                                   , "seaborn", "sequential, rocket")

loadcolorscheme(
	:seaborn_mako_gradient,
	[
		RGB{Float64}(0.04503935, 0.01482344, 0.02092227),
		RGB{Float64}(0.04933018, 0.01709292, 0.02535719),
		RGB{Float64}(0.05356262, 0.01950702, 0.03018802),
		RGB{Float64}(0.05774337, 0.02205989, 0.03545515),
		RGB{Float64}(0.06188095, 0.02474764, 0.04115287),
		RGB{Float64}(0.06598247, 0.0275665, 0.04691409),
		RGB{Float64}(0.07005374, 0.03051278, 0.05264306),
		RGB{Float64}(0.07409947, 0.03358324, 0.05834631),
		RGB{Float64}(0.07812339, 0.03677446, 0.06403249),
		RGB{Float64}(0.08212852, 0.0400833, 0.06970862),
		RGB{Float64}(0.08611731, 0.04339148, 0.07538208),
		RGB{Float64}(0.09009161, 0.04664706, 0.08105568),
		RGB{Float64}(0.09405308, 0.04985685, 0.08673591),
		RGB{Float64}(0.09800301, 0.05302279, 0.09242646),
		RGB{Float64}(0.10194255, 0.05614641, 0.09813162),
		RGB{Float64}(0.10587261, 0.05922941, 0.103854),
		RGB{Float64}(0.1097942, 0.06227277, 0.10959847),
		RGB{Float64}(0.11370826, 0.06527747, 0.11536893),
		RGB{Float64}(0.11761516, 0.06824548, 0.12116393),
		RGB{Float64}(0.12151575, 0.07117741, 0.12698763),
		RGB{Float64}(0.12541095, 0.07407363, 0.1328442),
		RGB{Float64}(0.12930083, 0.07693611, 0.13873064),
		RGB{Float64}(0.13317849, 0.07976988, 0.14465095),
		RGB{Float64}(0.13701138, 0.08259683, 0.15060265),
		RGB{Float64}(0.14079223, 0.08542126, 0.15659379),
		RGB{Float64}(0.14452486, 0.08824175, 0.16262484),
		RGB{Float64}(0.14820351, 0.09106304, 0.16869476),
		RGB{Float64}(0.15183185, 0.09388372, 0.17480366),
		RGB{Float64}(0.15540398, 0.09670855, 0.18094993),
		RGB{Float64}(0.15892417, 0.09953561, 0.18713384),
		RGB{Float64}(0.16238588, 0.10236998, 0.19335329),
		RGB{Float64}(0.16579435, 0.10520905, 0.19960847),
		RGB{Float64}(0.16914226, 0.10805832, 0.20589698),
		RGB{Float64}(0.17243586, 0.11091443, 0.21221911),
		RGB{Float64}(0.17566717, 0.11378321, 0.21857219),
		RGB{Float64}(0.17884322, 0.11666074, 0.2249565),
		RGB{Float64}(0.18195582, 0.11955283, 0.23136943),
		RGB{Float64}(0.18501213, 0.12245547, 0.23781116),
		RGB{Float64}(0.18800459, 0.12537395, 0.24427914),
		RGB{Float64}(0.19093944, 0.1283047, 0.25077369),
		RGB{Float64}(0.19381092, 0.13125179, 0.25729255),
		RGB{Float64}(0.19662307, 0.13421303, 0.26383543),
		RGB{Float64}(0.19937337, 0.13719028, 0.27040111),
		RGB{Float64}(0.20206187, 0.14018372, 0.27698891),
		RGB{Float64}(0.20469116, 0.14319196, 0.28359861),
		RGB{Float64}(0.20725547, 0.14621882, 0.29022775),
		RGB{Float64}(0.20976258, 0.14925954, 0.29687795),
		RGB{Float64}(0.21220409, 0.15231929, 0.30354703),
		RGB{Float64}(0.21458611, 0.15539445, 0.31023563),
		RGB{Float64}(0.21690827, 0.15848519, 0.31694355),
		RGB{Float64}(0.21916481, 0.16159489, 0.32366939),
		RGB{Float64}(0.2213631, 0.16471913, 0.33041431),
		RGB{Float64}(0.22349947, 0.1678599, 0.33717781),
		RGB{Float64}(0.2255714, 0.1710185, 0.34395925),
		RGB{Float64}(0.22758415, 0.17419169, 0.35075983),
		RGB{Float64}(0.22953569, 0.17738041, 0.35757941),
		RGB{Float64}(0.23142077, 0.18058733, 0.3644173),
		RGB{Float64}(0.2332454, 0.18380872, 0.37127514),
		RGB{Float64}(0.2350092, 0.18704459, 0.3781528),
		RGB{Float64}(0.23670785, 0.190297, 0.38504973),
		RGB{Float64}(0.23834119, 0.19356547, 0.39196711),
		RGB{Float64}(0.23991189, 0.19684817, 0.39890581),
		RGB{Float64}(0.24141903, 0.20014508, 0.4058667),
		RGB{Float64}(0.24286214, 0.20345642, 0.4128484),
		RGB{Float64}(0.24423453, 0.20678459, 0.41985299),
		RGB{Float64}(0.24554109, 0.21012669, 0.42688124),
		RGB{Float64}(0.2467815, 0.21348266, 0.43393244),
		RGB{Float64}(0.24795393, 0.21685249, 0.4410088),
		RGB{Float64}(0.24905614, 0.22023618, 0.448113),
		RGB{Float64}(0.25007383, 0.22365053, 0.45519562),
		RGB{Float64}(0.25098926, 0.22710664, 0.46223892),
		RGB{Float64}(0.25179696, 0.23060342, 0.46925447),
		RGB{Float64}(0.25249346, 0.23414353, 0.47623196),
		RGB{Float64}(0.25307401, 0.23772973, 0.48316271),
		RGB{Float64}(0.25353152, 0.24136961, 0.49001976),
		RGB{Float64}(0.25386167, 0.24506548, 0.49679407),
		RGB{Float64}(0.25406082, 0.2488164, 0.50348932),
		RGB{Float64}(0.25412435, 0.25262843, 0.51007843),
		RGB{Float64}(0.25404842, 0.25650743, 0.51653282),
		RGB{Float64}(0.25383134, 0.26044852, 0.52286845),
		RGB{Float64}(0.2534705, 0.26446165, 0.52903422),
		RGB{Float64}(0.25296722, 0.2685428, 0.53503572),
		RGB{Float64}(0.2523226, 0.27269346, 0.54085315),
		RGB{Float64}(0.25153974, 0.27691629, 0.54645752),
		RGB{Float64}(0.25062402, 0.28120467, 0.55185939),
		RGB{Float64}(0.24958205, 0.28556371, 0.55701246),
		RGB{Float64}(0.24842386, 0.28998148, 0.56194601),
		RGB{Float64}(0.24715928, 0.29446327, 0.56660884),
		RGB{Float64}(0.24580099, 0.29899398, 0.57104399),
		RGB{Float64}(0.24436202, 0.30357852, 0.57519929),
		RGB{Float64}(0.24285591, 0.30819938, 0.57913247),
		RGB{Float64}(0.24129828, 0.31286235, 0.58278615),
		RGB{Float64}(0.23970131, 0.3175495, 0.5862272),
		RGB{Float64}(0.23807973, 0.32226344, 0.58941872),
		RGB{Float64}(0.23644557, 0.32699241, 0.59240198),
		RGB{Float64}(0.2348113, 0.33173196, 0.59518282),
		RGB{Float64}(0.23318874, 0.33648036, 0.59775543),
		RGB{Float64}(0.2315855, 0.34122763, 0.60016456),
		RGB{Float64}(0.23001121, 0.34597357, 0.60240251),
		RGB{Float64}(0.2284748, 0.35071512, 0.6044784),
		RGB{Float64}(0.22698081, 0.35544612, 0.60642528),
		RGB{Float64}(0.22553305, 0.36016515, 0.60825252),
		RGB{Float64}(0.22413977, 0.36487341, 0.60994938),
		RGB{Float64}(0.22280246, 0.36956728, 0.61154118),
		RGB{Float64}(0.22152555, 0.37424409, 0.61304472),
		RGB{Float64}(0.22030752, 0.37890437, 0.61446646),
		RGB{Float64}(0.2191538, 0.38354668, 0.61581561),
		RGB{Float64}(0.21806257, 0.38817169, 0.61709794),
		RGB{Float64}(0.21703799, 0.39277882, 0.61831922),
		RGB{Float64}(0.21607792, 0.39736958, 0.61948028),
		RGB{Float64}(0.21518463, 0.40194196, 0.62059763),
		RGB{Float64}(0.21435467, 0.40649717, 0.62167507),
		RGB{Float64}(0.21358663, 0.41103579, 0.62271724),
		RGB{Float64}(0.21288172, 0.41555771, 0.62373011),
		RGB{Float64}(0.21223835, 0.42006355, 0.62471794),
		RGB{Float64}(0.21165312, 0.42455441, 0.62568371),
		RGB{Float64}(0.21112526, 0.42903064, 0.6266318),
		RGB{Float64}(0.21065161, 0.43349321, 0.62756504),
		RGB{Float64}(0.21023306, 0.43794288, 0.62848279),
		RGB{Float64}(0.20985996, 0.44238227, 0.62938329),
		RGB{Float64}(0.20951045, 0.44680966, 0.63030696),
		RGB{Float64}(0.20916709, 0.45122981, 0.63124483),
		RGB{Float64}(0.20882976, 0.45564335, 0.63219599),
		RGB{Float64}(0.20849798, 0.46005094, 0.63315928),
		RGB{Float64}(0.20817199, 0.46445309, 0.63413391),
		RGB{Float64}(0.20785149, 0.46885041, 0.63511876),
		RGB{Float64}(0.20753716, 0.47324327, 0.63611321),
		RGB{Float64}(0.20722876, 0.47763224, 0.63711608),
		RGB{Float64}(0.20692679, 0.48201774, 0.63812656),
		RGB{Float64}(0.20663156, 0.48640018, 0.63914367),
		RGB{Float64}(0.20634336, 0.49078002, 0.64016638),
		RGB{Float64}(0.20606303, 0.49515755, 0.6411939),
		RGB{Float64}(0.20578999, 0.49953341, 0.64222457),
		RGB{Float64}(0.20552612, 0.50390766, 0.64325811),
		RGB{Float64}(0.20527189, 0.50828072, 0.64429331),
		RGB{Float64}(0.20502868, 0.51265277, 0.64532947),
		RGB{Float64}(0.20479718, 0.51702417, 0.64636539),
		RGB{Float64}(0.20457804, 0.52139527, 0.64739979),
		RGB{Float64}(0.20437304, 0.52576622, 0.64843198),
		RGB{Float64}(0.20418396, 0.53013715, 0.64946117),
		RGB{Float64}(0.20401238, 0.53450825, 0.65048638),
		RGB{Float64}(0.20385896, 0.53887991, 0.65150606),
		RGB{Float64}(0.20372653, 0.54325208, 0.65251978),
		RGB{Float64}(0.20361709, 0.5476249, 0.6535266),
		RGB{Float64}(0.20353258, 0.55199854, 0.65452542),
		RGB{Float64}(0.20347472, 0.55637318, 0.655515),
		RGB{Float64}(0.20344718, 0.56074869, 0.65649508),
		RGB{Float64}(0.20345161, 0.56512531, 0.65746419),
		RGB{Float64}(0.20349089, 0.56950304, 0.65842151),
		RGB{Float64}(0.20356842, 0.57388184, 0.65936642),
		RGB{Float64}(0.20368663, 0.57826181, 0.66029768),
		RGB{Float64}(0.20384884, 0.58264293, 0.6612145),
		RGB{Float64}(0.20405904, 0.58702506, 0.66211645),
		RGB{Float64}(0.20431921, 0.59140842, 0.66300179),
		RGB{Float64}(0.20463464, 0.59579264, 0.66387079),
		RGB{Float64}(0.20500731, 0.60017798, 0.66472159),
		RGB{Float64}(0.20544449, 0.60456387, 0.66555409),
		RGB{Float64}(0.20596097, 0.60894927, 0.66636568),
		RGB{Float64}(0.20654832, 0.61333521, 0.66715744),
		RGB{Float64}(0.20721003, 0.61772167, 0.66792838),
		RGB{Float64}(0.20795035, 0.62210845, 0.66867802),
		RGB{Float64}(0.20877302, 0.62649546, 0.66940555),
		RGB{Float64}(0.20968223, 0.63088252, 0.6701105),
		RGB{Float64}(0.21068163, 0.63526951, 0.67079211),
		RGB{Float64}(0.21177544, 0.63965621, 0.67145005),
		RGB{Float64}(0.21298582, 0.64404072, 0.67208182),
		RGB{Float64}(0.21430361, 0.64842404, 0.67268861),
		RGB{Float64}(0.21572716, 0.65280655, 0.67326978),
		RGB{Float64}(0.21726052, 0.65718791, 0.6738255),
		RGB{Float64}(0.21890636, 0.66156803, 0.67435491),
		RGB{Float64}(0.220668, 0.66594665, 0.67485792),
		RGB{Float64}(0.22255447, 0.67032297, 0.67533374),
		RGB{Float64}(0.22458372, 0.67469531, 0.67578061),
		RGB{Float64}(0.22673713, 0.67906542, 0.67620044),
		RGB{Float64}(0.22901625, 0.6834332, 0.67659251),
		RGB{Float64}(0.23142316, 0.68779836, 0.67695703),
		RGB{Float64}(0.23395924, 0.69216072, 0.67729378),
		RGB{Float64}(0.23663857, 0.69651881, 0.67760151),
		RGB{Float64}(0.23946645, 0.70087194, 0.67788018),
		RGB{Float64}(0.24242624, 0.70522162, 0.67813088),
		RGB{Float64}(0.24549008, 0.70957083, 0.67835215),
		RGB{Float64}(0.24863372, 0.71392166, 0.67854868),
		RGB{Float64}(0.25187832, 0.71827158, 0.67872193),
		RGB{Float64}(0.25524083, 0.72261873, 0.67887024),
		RGB{Float64}(0.25870947, 0.72696469, 0.67898912),
		RGB{Float64}(0.26229238, 0.73130855, 0.67907645),
		RGB{Float64}(0.26604085, 0.73564353, 0.67914062),
		RGB{Float64}(0.26993099, 0.73997282, 0.67917264),
		RGB{Float64}(0.27397488, 0.74429484, 0.67917096),
		RGB{Float64}(0.27822463, 0.74860229, 0.67914468),
		RGB{Float64}(0.28264201, 0.75290034, 0.67907959),
		RGB{Float64}(0.2873016, 0.75717817, 0.67899164),
		RGB{Float64}(0.29215894, 0.76144162, 0.67886578),
		RGB{Float64}(0.29729823, 0.76567816, 0.67871894),
		RGB{Float64}(0.30268199, 0.76989232, 0.67853896),
		RGB{Float64}(0.30835665, 0.77407636, 0.67833512),
		RGB{Float64}(0.31435139, 0.77822478, 0.67811118),
		RGB{Float64}(0.3206671, 0.78233575, 0.67786729),
		RGB{Float64}(0.32733158, 0.78640315, 0.67761027),
		RGB{Float64}(0.33437168, 0.79042043, 0.67734882),
		RGB{Float64}(0.34182112, 0.79437948, 0.67709394),
		RGB{Float64}(0.34968889, 0.79827511, 0.67685638),
		RGB{Float64}(0.35799244, 0.80210037, 0.67664969),
		RGB{Float64}(0.36675371, 0.80584651, 0.67649539),
		RGB{Float64}(0.3759816, 0.80950627, 0.67641393),
		RGB{Float64}(0.38566792, 0.81307432, 0.67642947),
		RGB{Float64}(0.39579804, 0.81654592, 0.67656899),
		RGB{Float64}(0.40634556, 0.81991799, 0.67686215),
		RGB{Float64}(0.41730243, 0.82318339, 0.67735255),
		RGB{Float64}(0.4285828, 0.82635051, 0.6780564),
		RGB{Float64}(0.44012728, 0.82942353, 0.67900049),
		RGB{Float64}(0.45189421, 0.83240398, 0.68021733),
		RGB{Float64}(0.46378379, 0.83530763, 0.6817062),
		RGB{Float64}(0.47573199, 0.83814472, 0.68347352),
		RGB{Float64}(0.48769865, 0.84092197, 0.68552698),
		RGB{Float64}(0.49962354, 0.84365379, 0.68783929),
		RGB{Float64}(0.5114027, 0.8463718, 0.69029789),
		RGB{Float64}(0.52301693, 0.84908401, 0.69288545),
		RGB{Float64}(0.53447549, 0.85179048, 0.69561066),
		RGB{Float64}(0.54578602, 0.8544913, 0.69848331),
		RGB{Float64}(0.55695565, 0.85718723, 0.70150427),
		RGB{Float64}(0.56798832, 0.85987893, 0.70468261),
		RGB{Float64}(0.57888639, 0.86256715, 0.70802931),
		RGB{Float64}(0.5896541, 0.8652532, 0.71154204),
		RGB{Float64}(0.60028928, 0.86793835, 0.71523675),
		RGB{Float64}(0.61079441, 0.87062438, 0.71910895),
		RGB{Float64}(0.62116633, 0.87331311, 0.72317003),
		RGB{Float64}(0.63140509, 0.87600675, 0.72741689),
		RGB{Float64}(0.64150735, 0.87870746, 0.73185717),
		RGB{Float64}(0.65147219, 0.8814179, 0.73648495),
		RGB{Float64}(0.66129632, 0.8841403, 0.74130658),
		RGB{Float64}(0.67097934, 0.88687758, 0.74631123),
		RGB{Float64}(0.68051833, 0.88963189, 0.75150483),
		RGB{Float64}(0.68991419, 0.89240612, 0.75687187),
		RGB{Float64}(0.69916533, 0.89520211, 0.76241714),
		RGB{Float64}(0.70827373, 0.89802257, 0.76812286),
		RGB{Float64}(0.71723995, 0.90086891, 0.77399039),
		RGB{Float64}(0.72606665, 0.90374337, 0.7800041),
		RGB{Float64}(0.73475675, 0.90664718, 0.78615802),
		RGB{Float64}(0.74331358, 0.90958151, 0.79244474),
		RGB{Float64}(0.75174143, 0.91254787, 0.79884925),
		RGB{Float64}(0.76004473, 0.91554656, 0.80536823),
		RGB{Float64}(0.76827704, 0.91856549, 0.81196513),
		RGB{Float64}(0.77647029, 0.921603, 0.81855729),
		RGB{Float64}(0.78462009, 0.92466151, 0.82514119),
		RGB{Float64}(0.79273542, 0.92773848, 0.83172131),
		RGB{Float64}(0.8008109, 0.93083672, 0.83829355),
		RGB{Float64}(0.80885107, 0.93395528, 0.84485982),
		RGB{Float64}(0.81685878, 0.9370938, 0.85142101),
		RGB{Float64}(0.82483206, 0.94025378, 0.8579751),
		RGB{Float64}(0.83277661, 0.94343371, 0.86452477),
		RGB{Float64}(0.84069127, 0.94663473, 0.87106853),
		RGB{Float64}(0.84857662, 0.9498573, 0.8776059),
		RGB{Float64}(0.8564431, 0.95309792, 0.88414253),
		RGB{Float64}(0.86429066, 0.95635719, 0.89067759),
		RGB{Float64}(0.87218969, 0.95960708, 0.89725384),
	],
	"seaborn",
	"sequential, gradient, mako",
)

loadcolorscheme(:seaborn_icefire_gradient, [
     RGB{Float64}(0.73936227, 0.90443867, 0.85757238),
                                    RGB{Float64}(0.72888063, 0.89639109, 0.85488394),
                                    RGB{Float64}(0.71834255, 0.88842162, 0.8521605),
                                    RGB{Float64}(0.70773866, 0.88052939, 0.849422),
                                    RGB{Float64}(0.69706215, 0.87271313, 0.84668315),
                                    RGB{Float64}(0.68629021, 0.86497329, 0.84398721),
                                    RGB{Float64}(0.67543654, 0.85730617, 0.84130969),
                                    RGB{Float64}(0.66448539, 0.84971123, 0.83868005),
                                    RGB{Float64}(0.65342679, 0.84218728, 0.83611512),
                                    RGB{Float64}(0.64231804, 0.83471867, 0.83358584),
                                    RGB{Float64}(0.63117745, 0.827294, 0.83113431),
                                    RGB{Float64}(0.62000484, 0.81991069, 0.82876741),
                                    RGB{Float64}(0.60879435, 0.81256797, 0.82648905),
                                    RGB{Float64}(0.59754118, 0.80526458, 0.82430414),
                                    RGB{Float64}(0.58624247, 0.79799884, 0.82221573),
                                    RGB{Float64}(0.57489525, 0.7907688, 0.82022901),
                                    RGB{Float64}(0.56349779, 0.78357215, 0.81834861),
                                    RGB{Float64}(0.55204294, 0.77640827, 0.81657563),
                                    RGB{Float64}(0.54052516, 0.76927562, 0.81491462),
                                    RGB{Float64}(0.52894085, 0.76217215, 0.81336913),
                                    RGB{Float64}(0.51728854, 0.75509528, 0.81194156),
                                    RGB{Float64}(0.50555676, 0.74804469, 0.81063503),
                                    RGB{Float64}(0.49373871, 0.7410187, 0.80945242),
                                    RGB{Float64}(0.48183174, 0.73401449, 0.80839675),
                                    RGB{Float64}(0.46982587, 0.72703075, 0.80747097),
                                    RGB{Float64}(0.45770893, 0.72006648, 0.80667756),
                                    RGB{Float64}(0.44547249, 0.71311941, 0.80601991),
                                    RGB{Float64}(0.43318643, 0.70617126, 0.80549278),
                                    RGB{Float64}(0.42110294, 0.69916972, 0.80506683),
                                    RGB{Float64}(0.40925101, 0.69211059, 0.80473246),
                                    RGB{Float64}(0.3976693, 0.68498786, 0.80448272),
                                    RGB{Float64}(0.38632002, 0.67781125, 0.80431024),
                                    RGB{Float64}(0.37523981, 0.67057537, 0.80420832),
                                    RGB{Float64}(0.36442578, 0.66328229, 0.80417474),
                                    RGB{Float64}(0.35385939, 0.65593699, 0.80420591),
                                    RGB{Float64}(0.34358916, 0.64853177, 0.8043),
                                    RGB{Float64}(0.33355526, 0.64107876, 0.80445484),
                                    RGB{Float64}(0.32383062, 0.63356578, 0.80467091),
                                    RGB{Float64}(0.31434372, 0.62600624, 0.8049475),
                                    RGB{Float64}(0.30516161, 0.618389, 0.80528692),
                                    RGB{Float64}(0.29623491, 0.61072284, 0.80569021),
                                    RGB{Float64}(0.28759072, 0.60300319, 0.80616055),
                                    RGB{Float64}(0.27923924, 0.59522877, 0.80669803),
                                    RGB{Float64}(0.27114651, 0.5874047, 0.80730545),
                                    RGB{Float64}(0.26337153, 0.57952055, 0.80799113),
                                    RGB{Float64}(0.25588696, 0.57157984, 0.80875922),
                                    RGB{Float64}(0.248686, 0.56358255, 0.80961366),
                                    RGB{Float64}(0.24180668, 0.55552289, 0.81055123),
                                    RGB{Float64}(0.23526251, 0.54739477, 0.8115939),
                                    RGB{Float64}(0.22921445, 0.53918506, 0.81267292),
                                    RGB{Float64}(0.22397687, 0.53086094, 0.8137141),
                                    RGB{Float64}(0.21977058, 0.52241482, 0.81457651),
                                    RGB{Float64}(0.21658989, 0.51384321, 0.81528511),
                                    RGB{Float64}(0.21452772, 0.50514155, 0.81577278),
                                    RGB{Float64}(0.21372783, 0.49630865, 0.81589566),
                                    RGB{Float64}(0.21409503, 0.48734861, 0.81566163),
                                    RGB{Float64}(0.2157176, 0.47827123, 0.81487615),
                                    RGB{Float64}(0.21842857, 0.46909168, 0.81351614),
                                    RGB{Float64}(0.22211705, 0.45983212, 0.81146983),
                                    RGB{Float64}(0.22665681, 0.45052233, 0.80860217),
                                    RGB{Float64}(0.23176013, 0.44119137, 0.80494325),
                                    RGB{Float64}(0.23727775, 0.43187704, 0.80038017),
                                    RGB{Float64}(0.24298285, 0.42261123, 0.79493267),
                                    RGB{Float64}(0.24865068, 0.41341842, 0.78869164),
                                    RGB{Float64}(0.25423116, 0.40433127, 0.78155831),
                                    RGB{Float64}(0.25950239, 0.39535521, 0.77376848),
                                    RGB{Float64}(0.2644736, 0.38651212, 0.76524809),
                                    RGB{Float64}(0.26901584, 0.37779582, 0.75621942),
                                    RGB{Float64}(0.27318141, 0.36922056, 0.746605),
                                    RGB{Float64}(0.27690355, 0.3607736, 0.73659374),
                                    RGB{Float64}(0.28023585, 0.35244234, 0.72622103),
                                    RGB{Float64}(0.28306009, 0.34438449, 0.71500731),
                                    RGB{Float64}(0.28535896, 0.33660243, 0.70303975),
                                    RGB{Float64}(0.28708711, 0.32912157, 0.69034504),
                                    RGB{Float64}(0.28816354, 0.32200604, 0.67684067),
                                    RGB{Float64}(0.28862749, 0.31519824, 0.66278813),
                                    RGB{Float64}(0.28847904, 0.30869064, 0.6482815),
                                    RGB{Float64}(0.28770912, 0.30250126, 0.63331265),
                                    RGB{Float64}(0.28640325, 0.29655509, 0.61811374),
                                    RGB{Float64}(0.28458943, 0.29082155, 0.60280913),
                                    RGB{Float64}(0.28233561, 0.28527482, 0.58742866),
                                    RGB{Float64}(0.27967038, 0.2798938, 0.57204225),
                                    RGB{Float64}(0.27665361, 0.27465357, 0.55667809),
                                    RGB{Float64}(0.27332564, 0.2695165, 0.54145387),
                                    RGB{Float64}(0.26973851, 0.26447054, 0.52634916),
                                    RGB{Float64}(0.2659204, 0.25949691, 0.511417),
                                    RGB{Float64}(0.26190145, 0.25458123, 0.49668768),
                                    RGB{Float64}(0.2577151, 0.24971691, 0.48214874),
                                    RGB{Float64}(0.25337618, 0.24490494, 0.46778758),
                                    RGB{Float64}(0.24890842, 0.24013332, 0.45363816),
                                    RGB{Float64}(0.24433654, 0.23539226, 0.4397245),
                                    RGB{Float64}(0.23967922, 0.23067729, 0.4260591),
                                    RGB{Float64}(0.23495608, 0.22598894, 0.41262952),
                                    RGB{Float64}(0.23018113, 0.22132414, 0.39945577),
                                    RGB{Float64}(0.22534609, 0.21670847, 0.38645794),
                                    RGB{Float64}(0.22048761, 0.21211723, 0.37372555),
                                    RGB{Float64}(0.2156198, 0.20755389, 0.36125301),
                                    RGB{Float64}(0.21074637, 0.20302717, 0.34903192),
                                    RGB{Float64}(0.20586893, 0.19855368, 0.33701661),
                                    RGB{Float64}(0.20101757, 0.19411573, 0.32529173),
                                    RGB{Float64}(0.19619947, 0.18972425, 0.31383846),
                                    RGB{Float64}(0.19140726, 0.18540157, 0.30260777),
                                    RGB{Float64}(0.1866769, 0.1811332, 0.29166583),
                                    RGB{Float64}(0.18201285, 0.17694992, 0.28088776),
                                    RGB{Float64}(0.17745228, 0.17282141, 0.27044211),
                                    RGB{Float64}(0.17300684, 0.16876921, 0.26024893),
                                    RGB{Float64}(0.16868273, 0.16479861, 0.25034479),
                                    RGB{Float64}(0.16448691, 0.16091728, 0.24075373),
                                    RGB{Float64}(0.16043195, 0.15714351, 0.23141745),
                                    RGB{Float64}(0.15652427, 0.15348248, 0.22238175),
                                    RGB{Float64}(0.15277065, 0.14994111, 0.21368395),
                                    RGB{Float64}(0.14918274, 0.14653431, 0.20529486),
                                    RGB{Float64}(0.14577095, 0.14327403, 0.19720829),
                                    RGB{Float64}(0.14254381, 0.14016944, 0.18944326),
                                    RGB{Float64}(0.13951035, 0.13723063, 0.18201072),
                                    RGB{Float64}(0.13667798, 0.13446606, 0.17493774),
                                    RGB{Float64}(0.13405762, 0.13188822, 0.16820842),
                                    RGB{Float64}(0.13165767, 0.12950667, 0.16183275),
                                    RGB{Float64}(0.12948748, 0.12733187, 0.15580631),
                                    RGB{Float64}(0.12755435, 0.1253723, 0.15014098),
                                    RGB{Float64}(0.12586516, 0.12363617, 0.1448459),
                                    RGB{Float64}(0.12442647, 0.12213143, 0.13992571),
                                    RGB{Float64}(0.12324241, 0.12086419, 0.13539995),
                                    RGB{Float64}(0.12232067, 0.11984278, 0.13124644),
                                    RGB{Float64}(0.12166209, 0.11907077, 0.12749671),
                                    RGB{Float64}(0.12126982, 0.11855309, 0.12415079),
                                    RGB{Float64}(0.12114244, 0.11829179, 0.1212385),
                                    RGB{Float64}(0.12127766, 0.11828837, 0.11878534),
                                    RGB{Float64}(0.12284806, 0.1179729, 0.11772022),
                                    RGB{Float64}(0.12619498, 0.11721796, 0.11770203),
                                    RGB{Float64}(0.129968, 0.11663788, 0.11792377),
                                    RGB{Float64}(0.13410011, 0.11625146, 0.11839138),
                                    RGB{Float64}(0.13855459, 0.11606618, 0.11910584),
                                    RGB{Float64}(0.14333775, 0.11607038, 0.1200606),
                                    RGB{Float64}(0.148417, 0.11626929, 0.12125453),
                                    RGB{Float64}(0.15377389, 0.11666192, 0.12268364),
                                    RGB{Float64}(0.15941427, 0.11723486, 0.12433911),
                                    RGB{Float64}(0.16533376, 0.11797856, 0.12621303),
                                    RGB{Float64}(0.17152547, 0.11888403, 0.12829735),
                                    RGB{Float64}(0.17797765, 0.11994436, 0.13058435),
                                    RGB{Float64}(0.18468769, 0.12114722, 0.13306426),
                                    RGB{Float64}(0.19165663, 0.12247737, 0.13572616),
                                    RGB{Float64}(0.19884415, 0.12394381, 0.1385669),
                                    RGB{Float64}(0.20627181, 0.12551883, 0.14157124),
                                    RGB{Float64}(0.21394877, 0.12718055, 0.14472604),
                                    RGB{Float64}(0.22184572, 0.12893119, 0.14802579),
                                    RGB{Float64}(0.22994394, 0.13076731, 0.15146314),
                                    RGB{Float64}(0.23823937, 0.13267611, 0.15502793),
                                    RGB{Float64}(0.24676041, 0.13462172, 0.15870321),
                                    RGB{Float64}(0.25546457, 0.13661751, 0.16248722),
                                    RGB{Float64}(0.26433628, 0.13865956, 0.16637301),
                                    RGB{Float64}(0.27341345, 0.14070412, 0.17034221),
                                    RGB{Float64}(0.28264773, 0.14277192, 0.1743957),
                                    RGB{Float64}(0.29202272, 0.14486161, 0.17852793),
                                    RGB{Float64}(0.30159648, 0.14691224, 0.1827169),
                                    RGB{Float64}(0.31129002, 0.14897583, 0.18695213),
                                    RGB{Float64}(0.32111555, 0.15103351, 0.19119629),
                                    RGB{Float64}(0.33107961, 0.1530674, 0.19543758),
                                    RGB{Float64}(0.34119892, 0.15504762, 0.1996803),
                                    RGB{Float64}(0.35142388, 0.15701131, 0.20389086),
                                    RGB{Float64}(0.36178937, 0.1589124, 0.20807639),
                                    RGB{Float64}(0.37229381, 0.16073993, 0.21223189),
                                    RGB{Float64}(0.38288348, 0.16254006, 0.2163249),
                                    RGB{Float64}(0.39359592, 0.16426336, 0.22036577),
                                    RGB{Float64}(0.40444332, 0.16588767, 0.22434027),
                                    RGB{Float64}(0.41537995, 0.16745325, 0.2282297),
                                    RGB{Float64}(0.42640867, 0.16894939, 0.23202755),
                                    RGB{Float64}(0.43754706, 0.17034847, 0.23572899),
                                    RGB{Float64}(0.44878564, 0.1716535, 0.23932344),
                                    RGB{Float64}(0.4601126, 0.17287365, 0.24278607),
                                    RGB{Float64}(0.47151732, 0.17401641, 0.24610337),
                                    RGB{Float64}(0.48300689, 0.17506676, 0.2492737),
                                    RGB{Float64}(0.49458302, 0.17601892, 0.25227688),
                                    RGB{Float64}(0.50623876, 0.17687777, 0.255096),
                                    RGB{Float64}(0.5179623, 0.17765528, 0.2577162),
                                    RGB{Float64}(0.52975234, 0.17835232, 0.2601134),
                                    RGB{Float64}(0.54159776, 0.17898292, 0.26226847),
                                    RGB{Float64}(0.55348804, 0.17956232, 0.26416003),
                                    RGB{Float64}(0.56541729, 0.18010175, 0.26575971),
                                    RGB{Float64}(0.57736669, 0.180631, 0.26704888),
                                    RGB{Float64}(0.58932081, 0.18117827, 0.26800409),
                                    RGB{Float64}(0.60127582, 0.18175888, 0.26858488),
                                    RGB{Float64}(0.61319563, 0.1824336, 0.2687872),
                                    RGB{Float64}(0.62506376, 0.18324015, 0.26858301),
                                    RGB{Float64}(0.63681202, 0.18430173, 0.26795276),
                                    RGB{Float64}(0.64842603, 0.18565472, 0.26689463),
                                    RGB{Float64}(0.65988195, 0.18734638, 0.26543435),
                                    RGB{Float64}(0.67111966, 0.18948885, 0.26357955),
                                    RGB{Float64}(0.68209194, 0.19216636, 0.26137175),
                                    RGB{Float64}(0.69281185, 0.19535326, 0.25887063),
                                    RGB{Float64}(0.70335022, 0.19891271, 0.25617971),
                                    RGB{Float64}(0.71375229, 0.20276438, 0.25331365),
                                    RGB{Float64}(0.72401436, 0.20691287, 0.25027366),
                                    RGB{Float64}(0.73407638, 0.21145051, 0.24710661),
                                    RGB{Float64}(0.74396983, 0.21631913, 0.24380715),
                                    RGB{Float64}(0.75361506, 0.22163653, 0.24043996),
                                    RGB{Float64}(0.7630579, 0.22731637, 0.23700095),
                                    RGB{Float64}(0.77222228, 0.23346231, 0.23356628),
                                    RGB{Float64}(0.78115441, 0.23998404, 0.23013825),
                                    RGB{Float64}(0.78979746, 0.24694858, 0.22678822),
                                    RGB{Float64}(0.79819286, 0.25427223, 0.22352658),
                                    RGB{Float64}(0.80630444, 0.26198807, 0.22040877),
                                    RGB{Float64}(0.81417437, 0.27001406, 0.21744645),
                                    RGB{Float64}(0.82177364, 0.27837336, 0.21468316),
                                    RGB{Float64}(0.82915955, 0.28696963, 0.21210766),
                                    RGB{Float64}(0.83628628, 0.2958499, 0.20977813),
                                    RGB{Float64}(0.84322168, 0.30491136, 0.20766435),
                                    RGB{Float64}(0.84995458, 0.31415945, 0.2057863),
                                    RGB{Float64}(0.85648867, 0.32358058, 0.20415327),
                                    RGB{Float64}(0.86286243, 0.33312058, 0.20274969),
                                    RGB{Float64}(0.86908321, 0.34276705, 0.20157271),
                                    RGB{Float64}(0.87512876, 0.3525416, 0.20064949),
                                    RGB{Float64}(0.88100349, 0.36243385, 0.19999078),
                                    RGB{Float64}(0.8866469, 0.37249496, 0.1997976),
                                    RGB{Float64}(0.89203964, 0.38273475, 0.20013431),
                                    RGB{Float64}(0.89713496, 0.39318156, 0.20121514),
                                    RGB{Float64}(0.90195099, 0.40380687, 0.20301555),
                                    RGB{Float64}(0.90648379, 0.41460191, 0.20558847),
                                    RGB{Float64}(0.9106967, 0.42557857, 0.20918529),
                                    RGB{Float64}(0.91463791, 0.43668557, 0.21367954),
                                    RGB{Float64}(0.91830723, 0.44790913, 0.21916352),
                                    RGB{Float64}(0.92171507, 0.45922856, 0.22568002),
                                    RGB{Float64}(0.92491786, 0.4705936, 0.23308207),
                                    RGB{Float64}(0.92790792, 0.48200153, 0.24145932),
                                    RGB{Float64}(0.93073701, 0.49341219, 0.25065486),
                                    RGB{Float64}(0.93343918, 0.5048017, 0.26056148),
                                    RGB{Float64}(0.93602064, 0.51616486, 0.27118485),
                                    RGB{Float64}(0.93850535, 0.52748892, 0.28242464),
                                    RGB{Float64}(0.94092933, 0.53875462, 0.29416042),
                                    RGB{Float64}(0.94330011, 0.5499628, 0.30634189),
                                    RGB{Float64}(0.94563159, 0.56110987, 0.31891624),
                                    RGB{Float64}(0.94792955, 0.57219822, 0.33184256),
                                    RGB{Float64}(0.95020929, 0.5832232, 0.34508419),
                                    RGB{Float64}(0.95247324, 0.59419035, 0.35859866),
                                    RGB{Float64}(0.95471709, 0.60510869, 0.37236035),
                                    RGB{Float64}(0.95698411, 0.61595766, 0.38629631),
                                    RGB{Float64}(0.95923863, 0.62676473, 0.40043317),
                                    RGB{Float64}(0.9615041, 0.6375203, 0.41474106),
                                    RGB{Float64}(0.96371553, 0.64826619, 0.42928335),
                                    RGB{Float64}(0.96591497, 0.65899621, 0.44380444),
                                    RGB{Float64}(0.96809871, 0.66971662, 0.45830232),
                                    RGB{Float64}(0.9702495, 0.6804394, 0.47280492),
                                    RGB{Float64}(0.9723881, 0.69115622, 0.48729272),
                                    RGB{Float64}(0.97450723, 0.70187358, 0.50178034),
                                    RGB{Float64}(0.9766108, 0.712592, 0.51626837),
                                    RGB{Float64}(0.97871716, 0.72330511, 0.53074053),
                                    RGB{Float64}(0.98082222, 0.73401769, 0.54520694),
                                    RGB{Float64}(0.9829001, 0.74474445, 0.5597019),
                                    RGB{Float64}(0.98497466, 0.75547635, 0.57420239),
                                    RGB{Float64}(0.98705581, 0.76621129, 0.58870185),
                                    RGB{Float64}(0.98913325, 0.77695637, 0.60321626),
                                    RGB{Float64}(0.99119918, 0.78771716, 0.61775821),
                                    RGB{Float64}(0.9932672, 0.79848979, 0.63231691),
                                    RGB{Float64}(0.99535958, 0.80926704, 0.64687278),
                                    RGB{Float64}(0.99740544, 0.82008078, 0.66150571),
                                    RGB{Float64}(0.9992197, 0.83100723, 0.6764127)],
                                    "seaborn", "sequential, ice fire gradient")


loadcolorscheme(:seaborn_flare_gradient,
[
    RGB{Float64}(0.92891402, 0.68494686, 0.50173994),
    RGB{Float64}(0.92864754, 0.68116207, 0.4993754),
    RGB{Float64}(0.92836112, 0.67738527, 0.49701572),
    RGB{Float64}(0.9280599, 0.67361354, 0.49466044),
    RGB{Float64}(0.92775569, 0.66983999, 0.49230866),
    RGB{Float64}(0.9274375, 0.66607098, 0.48996097),
    RGB{Float64}(0.927111, 0.66230315, 0.48761688),
    RGB{Float64}(0.92677996, 0.6585342, 0.485276),
    RGB{Float64}(0.92644317, 0.65476476, 0.48293832),
    RGB{Float64}(0.92609759, 0.65099658, 0.48060392),
    RGB{Float64}(0.925747, 0.64722729, 0.47827244),
    RGB{Float64}(0.92539502, 0.64345456, 0.47594352),
    RGB{Float64}(0.92503106, 0.6396848, 0.47361782),
    RGB{Float64}(0.92466877, 0.6359095, 0.47129427),
    RGB{Float64}(0.92429828, 0.63213463, 0.46897349),
    RGB{Float64}(0.92392172, 0.62835879, 0.46665526),
    RGB{Float64}(0.92354597, 0.62457749, 0.46433898),
    RGB{Float64}(0.9231622, 0.6207962, 0.46202524),
    RGB{Float64}(0.92277222, 0.61701365, 0.45971384),
    RGB{Float64}(0.92237978, 0.61322733, 0.45740444),
    RGB{Float64}(0.92198615, 0.60943622, 0.45509686),
    RGB{Float64}(0.92158735, 0.60564276, 0.45279137),
    RGB{Float64}(0.92118373, 0.60184659, 0.45048789),
    RGB{Float64}(0.92077582, 0.59804722, 0.44818634),
    RGB{Float64}(0.92036413, 0.59424414, 0.44588663),
    RGB{Float64}(0.91994924, 0.5904368, 0.44358868),
    RGB{Float64}(0.91952943, 0.58662619, 0.4412926),
    RGB{Float64}(0.91910675, 0.58281075, 0.43899817),
    RGB{Float64}(0.91868096, 0.57899046, 0.4367054),
    RGB{Float64}(0.91825103, 0.57516584, 0.43441436),
    RGB{Float64}(0.91781857, 0.57133556, 0.43212486),
    RGB{Float64}(0.9173814, 0.56750099, 0.4298371),
    RGB{Float64}(0.91694139, 0.56366058, 0.42755089),
    RGB{Float64}(0.91649756, 0.55981483, 0.42526631),
    RGB{Float64}(0.91604942, 0.55596387, 0.42298339),
    RGB{Float64}(0.9155979, 0.55210684, 0.42070204),
    RGB{Float64}(0.9151409, 0.54824485, 0.4184247),
    RGB{Float64}(0.91466138, 0.54438817, 0.41617858),
    RGB{Float64}(0.91416896, 0.54052962, 0.41396347),
    RGB{Float64}(0.91366559, 0.53666778, 0.41177769),
    RGB{Float64}(0.91315173, 0.53280208, 0.40962196),
    RGB{Float64}(0.91262605, 0.52893336, 0.40749715),
    RGB{Float64}(0.91208866, 0.52506133, 0.40540404),
    RGB{Float64}(0.91153952, 0.52118582, 0.40334346),
    RGB{Float64}(0.91097732, 0.51730767, 0.4013163),
    RGB{Float64}(0.910403, 0.51342591, 0.39932342),
    RGB{Float64}(0.90981494, 0.50954168, 0.39736571),
    RGB{Float64}(0.90921368, 0.5056543, 0.39544411),
    RGB{Float64}(0.90859797, 0.50176463, 0.39355952),
    RGB{Float64}(0.90796841, 0.49787195, 0.39171297),
    RGB{Float64}(0.90732341, 0.4939774, 0.38990532),
    RGB{Float64}(0.90666382, 0.49008006, 0.38813773),
    RGB{Float64}(0.90598815, 0.486181, 0.38641107),
    RGB{Float64}(0.90529624, 0.48228017, 0.38472641),
    RGB{Float64}(0.90458808, 0.47837738, 0.38308489),
    RGB{Float64}(0.90386248, 0.47447348, 0.38148746),
    RGB{Float64}(0.90311921, 0.4705685, 0.37993524),
    RGB{Float64}(0.90235809, 0.46666239, 0.37842943),
    RGB{Float64}(0.90157824, 0.46275577, 0.37697105),
    RGB{Float64}(0.90077904, 0.45884905, 0.37556121),
    RGB{Float64}(0.89995995, 0.45494253, 0.37420106),
    RGB{Float64}(0.89912041, 0.4510366, 0.37289175),
    RGB{Float64}(0.8982602, 0.44713126, 0.37163458),
    RGB{Float64}(0.89737819, 0.44322747, 0.37043052),
    RGB{Float64}(0.89647387, 0.43932557, 0.36928078),
    RGB{Float64}(0.89554477, 0.43542759, 0.36818855),
    RGB{Float64}(0.89458871, 0.4315354, 0.36715654),
    RGB{Float64}(0.89360794, 0.42764714, 0.36618273),
    RGB{Float64}(0.89260152, 0.42376366, 0.36526813),
    RGB{Float64}(0.8915687, 0.41988565, 0.36441384),
    RGB{Float64}(0.89050882, 0.41601371, 0.36362102),
    RGB{Float64}(0.8894159, 0.41215334, 0.36289639),
    RGB{Float64}(0.888292, 0.40830288, 0.36223756),
    RGB{Float64}(0.88713784, 0.40446193, 0.36164328),
    RGB{Float64}(0.88595253, 0.40063149, 0.36111438),
    RGB{Float64}(0.88473115, 0.39681635, 0.3606566),
    RGB{Float64}(0.88347246, 0.39301805, 0.36027074),
    RGB{Float64}(0.88217931, 0.38923439, 0.35995244),
    RGB{Float64}(0.880851, 0.38546632, 0.35970244),
    RGB{Float64}(0.87947728, 0.38172422, 0.35953127),
    RGB{Float64}(0.87806542, 0.37800172, 0.35942941),
    RGB{Float64}(0.87661509, 0.37429964, 0.35939659),
    RGB{Float64}(0.87511668, 0.37062819, 0.35944178),
    RGB{Float64}(0.87357554, 0.36698279, 0.35955811),
    RGB{Float64}(0.87199254, 0.3633634, 0.35974223),
    RGB{Float64}(0.87035691, 0.35978174, 0.36000516),
    RGB{Float64}(0.86867647, 0.35623087, 0.36033559),
    RGB{Float64}(0.86694949, 0.35271349, 0.36073358),
    RGB{Float64}(0.86516775, 0.34923921, 0.36120624),
    RGB{Float64}(0.86333996, 0.34580008, 0.36174113),
    RGB{Float64}(0.86145909, 0.3424046, 0.36234402),
    RGB{Float64}(0.85952586, 0.33905327, 0.36301129),
    RGB{Float64}(0.85754536, 0.33574168, 0.36373567),
    RGB{Float64}(0.855514, 0.33247568, 0.36451271),
    RGB{Float64}(0.85344392, 0.32924217, 0.36533344),
    RGB{Float64}(0.8513284, 0.32604977, 0.36620106),
    RGB{Float64}(0.84916723, 0.32289973, 0.36711424),
    RGB{Float64}(0.84696243, 0.31979068, 0.36806976),
    RGB{Float64}(0.84470627, 0.31673295, 0.36907066),
    RGB{Float64}(0.84240761, 0.31371695, 0.37010969),
    RGB{Float64}(0.84005337, 0.31075974, 0.37119284),
    RGB{Float64}(0.83765537, 0.30784814, 0.3723105),
    RGB{Float64}(0.83520234, 0.30499724, 0.37346726),
    RGB{Float64}(0.83270291, 0.30219766, 0.37465552),
    RGB{Float64}(0.83014895, 0.29946081, 0.37587769),
    RGB{Float64}(0.82754694, 0.29677989, 0.37712733),
    RGB{Float64}(0.82489111, 0.29416352, 0.37840532),
    RGB{Float64}(0.82218644, 0.29160665, 0.37970606),
    RGB{Float64}(0.81942908, 0.28911553, 0.38102921),
    RGB{Float64}(0.81662276, 0.28668665, 0.38236999),
    RGB{Float64}(0.81376555, 0.28432371, 0.383727),
    RGB{Float64}(0.81085964, 0.28202508, 0.38509649),
    RGB{Float64}(0.8079055, 0.27979128, 0.38647583),
    RGB{Float64}(0.80490309, 0.27762348, 0.3878626),
    RGB{Float64}(0.80185613, 0.2755178, 0.38925253),
    RGB{Float64}(0.79876118, 0.27347974, 0.39064559),
    RGB{Float64}(0.79562644, 0.27149928, 0.39203532),
    RGB{Float64}(0.79244362, 0.2695883, 0.39342447),
    RGB{Float64}(0.78922456, 0.26773176, 0.3948046),
    RGB{Float64}(0.78596161, 0.26594053, 0.39617873),
    RGB{Float64}(0.7826624, 0.26420493, 0.39754146),
    RGB{Float64}(0.77932717, 0.26252522, 0.39889102),
    RGB{Float64}(0.77595363, 0.2609049, 0.4002279),
    RGB{Float64}(0.77254999, 0.25933319, 0.40154704),
    RGB{Float64}(0.76911107, 0.25781758, 0.40284959),
    RGB{Float64}(0.76564158, 0.25635173, 0.40413341),
    RGB{Float64}(0.76214598, 0.25492998, 0.40539471),
    RGB{Float64}(0.75861834, 0.25356035, 0.40663694),
    RGB{Float64}(0.75506533, 0.25223402, 0.40785559),
    RGB{Float64}(0.75148963, 0.2509473, 0.40904966),
    RGB{Float64}(0.74788835, 0.24970413, 0.41022028),
    RGB{Float64}(0.74426345, 0.24850191, 0.41136599),
    RGB{Float64}(0.74061927, 0.24733457, 0.41248516),
    RGB{Float64}(0.73695678, 0.24620072, 0.41357737),
    RGB{Float64}(0.73327278, 0.24510469, 0.41464364),
    RGB{Float64}(0.72957096, 0.24404127, 0.4156828),
    RGB{Float64}(0.72585394, 0.24300672, 0.41669383),
    RGB{Float64}(0.7221226, 0.24199971, 0.41767651),
    RGB{Float64}(0.71837612, 0.24102046, 0.41863486),
    RGB{Float64}(0.71463236, 0.24004289, 0.41956983),
    RGB{Float64}(0.7108932, 0.23906316, 0.42048681),
    RGB{Float64}(0.70715842, 0.23808142, 0.42138647),
    RGB{Float64}(0.70342811, 0.2370976, 0.42226844),
    RGB{Float64}(0.69970218, 0.23611179, 0.42313282),
    RGB{Float64}(0.69598055, 0.2351247, 0.42397678),
    RGB{Float64}(0.69226314, 0.23413578, 0.42480327),
    RGB{Float64}(0.68854988, 0.23314511, 0.42561234),
    RGB{Float64}(0.68484064, 0.23215279, 0.42640419),
    RGB{Float64}(0.68113541, 0.23115942, 0.42717615),
    RGB{Float64}(0.67743412, 0.23016472, 0.42792989),
    RGB{Float64}(0.67373662, 0.22916861, 0.42866642),
    RGB{Float64}(0.67004287, 0.22817117, 0.42938576),
    RGB{Float64}(0.66635279, 0.22717328, 0.43008427),
    RGB{Float64}(0.66266621, 0.22617435, 0.43076552),
    RGB{Float64}(0.65898313, 0.22517434, 0.43142956),
    RGB{Float64}(0.65530349, 0.22417381, 0.43207427),
    RGB{Float64}(0.65162696, 0.22317307, 0.4327001),
    RGB{Float64}(0.64795375, 0.22217149, 0.43330852),
    RGB{Float64}(0.64428351, 0.22116972, 0.43389854),
    RGB{Float64}(0.64061624, 0.22016818, 0.43446845),
    RGB{Float64}(0.63695183, 0.21916625, 0.43502123),
    RGB{Float64}(0.63329016, 0.21816454, 0.43555493),
    RGB{Float64}(0.62963102, 0.2171635, 0.43606881),
    RGB{Float64}(0.62597451, 0.21616235, 0.43656529),
    RGB{Float64}(0.62232019, 0.21516239, 0.43704153),
    RGB{Float64}(0.61866821, 0.21416307, 0.43749868),
    RGB{Float64}(0.61501835, 0.21316435, 0.43793808),
    RGB{Float64}(0.61137029, 0.21216761, 0.4383556),
    RGB{Float64}(0.60772426, 0.2111715, 0.43875552),
    RGB{Float64}(0.60407977, 0.21017746, 0.43913439),
    RGB{Float64}(0.60043678, 0.20918503, 0.43949412),
    RGB{Float64}(0.59679524, 0.20819447, 0.43983393),
    RGB{Float64}(0.59315487, 0.20720639, 0.44015254),
    RGB{Float64}(0.58951566, 0.20622027, 0.44045213),
    RGB{Float64}(0.58587715, 0.20523751, 0.44072926),
    RGB{Float64}(0.5822395, 0.20425693, 0.44098758),
    RGB{Float64}(0.57860222, 0.20328034, 0.44122241),
    RGB{Float64}(0.57496549, 0.20230637, 0.44143805),
    RGB{Float64}(0.57132875, 0.20133689, 0.4416298),
    RGB{Float64}(0.56769215, 0.20037071, 0.44180142),
    RGB{Float64}(0.5640552, 0.19940936, 0.44194923),
    RGB{Float64}(0.56041794, 0.19845221, 0.44207535),
    RGB{Float64}(0.55678004, 0.1975, 0.44217824),
    RGB{Float64}(0.55314129, 0.19655316, 0.44225723),
    RGB{Float64}(0.54950166, 0.19561118, 0.44231412),
    RGB{Float64}(0.54585987, 0.19467771, 0.44234111),
    RGB{Float64}(0.54221157, 0.19375869, 0.44233698),
    RGB{Float64}(0.5385549, 0.19285696, 0.44229959),
    RGB{Float64}(0.5348913, 0.19197036, 0.44222958),
    RGB{Float64}(0.53122177, 0.1910974, 0.44212735),
    RGB{Float64}(0.52754464, 0.19024042, 0.44199159),
    RGB{Float64}(0.52386353, 0.18939409, 0.44182449),
    RGB{Float64}(0.52017476, 0.18856368, 0.44162345),
    RGB{Float64}(0.51648277, 0.18774266, 0.44139128),
    RGB{Float64}(0.51278481, 0.18693492, 0.44112605),
    RGB{Float64}(0.50908361, 0.18613639, 0.4408295),
    RGB{Float64}(0.50537784, 0.18534893, 0.44050064),
    RGB{Float64}(0.50166912, 0.18457008, 0.44014054),
    RGB{Float64}(0.49795686, 0.18380056, 0.43974881),
    RGB{Float64}(0.49424218, 0.18303865, 0.43932623),
    RGB{Float64}(0.49052472, 0.18228477, 0.43887255),
    RGB{Float64}(0.48680565, 0.1815371, 0.43838867),
    RGB{Float64}(0.48308419, 0.18079663, 0.43787408),
    RGB{Float64}(0.47936222, 0.18006056, 0.43733022),
    RGB{Float64}(0.47563799, 0.17933127, 0.43675585),
    RGB{Float64}(0.47191466, 0.17860416, 0.43615337),
    RGB{Float64}(0.46818879, 0.17788392, 0.43552047),
    RGB{Float64}(0.46446454, 0.17716458, 0.43486036),
    RGB{Float64}(0.46073893, 0.17645017, 0.43417097),
    RGB{Float64}(0.45701462, 0.17573691, 0.43345429),
    RGB{Float64}(0.45329097, 0.17502549, 0.43271025),
    RGB{Float64}(0.44956744, 0.17431649, 0.4319386),
    RGB{Float64}(0.44584668, 0.17360625, 0.43114133),
    RGB{Float64}(0.44212538, 0.17289906, 0.43031642),
    RGB{Float64}(0.43840678, 0.17219041, 0.42946642),
    RGB{Float64}(0.43469046, 0.17148074, 0.42859124),
    RGB{Float64}(0.4309749, 0.17077192, 0.42769008),
    RGB{Float64}(0.42726297, 0.17006003, 0.42676519),
    RGB{Float64}(0.42355299, 0.16934709, 0.42581586),
    RGB{Float64}(0.41984535, 0.16863258, 0.42484219),
    RGB{Float64}(0.41614149, 0.16791429, 0.42384614),
    RGB{Float64}(0.41244029, 0.16719372, 0.42282661),
    RGB{Float64}(0.40874177, 0.16647061, 0.42178429),
    RGB{Float64}(0.40504765, 0.16574261, 0.42072062),
    RGB{Float64}(0.401357, 0.16501079, 0.41963528),
    RGB{Float64}(0.397669, 0.16427607, 0.418528),
    RGB{Float64}(0.39398585, 0.16353554, 0.41740053),
    RGB{Float64}(0.39030735, 0.16278924, 0.41625344),
    RGB{Float64}(0.3866314, 0.16203977, 0.41508517),
    RGB{Float64}(0.38295904, 0.16128519, 0.41389849),
    RGB{Float64}(0.37928736, 0.16052483, 0.41270599),
    RGB{Float64}(0.37562649, 0.15974704, 0.41151182),
    RGB{Float64}(0.37197803, 0.15895049, 0.41031532),
    RGB{Float64}(0.36833779, 0.15813871, 0.40911916),
    RGB{Float64}(0.36470944, 0.15730861, 0.40792149),
    RGB{Float64}(0.36109117, 0.15646169, 0.40672362),
    RGB{Float64}(0.35748213, 0.15559861, 0.40552633),
    RGB{Float64}(0.353885, 0.15471714, 0.40432831),
    RGB{Float64}(0.35029682, 0.15381967, 0.4031316),
    RGB{Float64}(0.34671861, 0.1529053, 0.40193587),
    RGB{Float64}(0.34315191, 0.15197275, 0.40074049),
    RGB{Float64}(0.33959331, 0.15102466, 0.3995478),
    RGB{Float64}(0.33604378, 0.15006017, 0.39835754),
    RGB{Float64}(0.33250529, 0.14907766, 0.39716879),
    RGB{Float64}(0.32897621, 0.14807831, 0.39598285),
    RGB{Float64}(0.3254559, 0.14706248, 0.39480044),
    RGB{Float64}(0.32194567, 0.14602909, 0.39362106),
    RGB{Float64}(0.31844477, 0.14497857, 0.39244549),
    RGB{Float64}(0.31494974, 0.14391333, 0.39127626),
    RGB{Float64}(0.31146605, 0.14282918, 0.39011024),
    RGB{Float64}(0.30798857, 0.1417297, 0.38895105),
    RGB{Float64}(0.30451661, 0.14061515, 0.38779953),
    RGB{Float64}(0.30105136, 0.13948445, 0.38665531),
    RGB{Float64}(0.2975886, 0.1383403, 0.38552159),
    RGB{Float64}(0.29408557, 0.13721193, 0.38442775),
],
"seaborn",  # The category 
"sequential, gradient, flare"  # Descriptive keywords
)

loadcolorscheme(:seaborn_crest_gradient,
[
    RGB{Float64}(0.64233318, 0.80081141, 0.56639461),
    RGB{Float64}(0.63791969, 0.7987162, 0.56674976),
    RGB{Float64}(0.6335316, 0.79661833, 0.56706128),
    RGB{Float64}(0.62915226, 0.7945212, 0.56735066),
    RGB{Float64}(0.62477862, 0.79242543, 0.56762143),
    RGB{Float64}(0.62042003, 0.79032918, 0.56786129),
    RGB{Float64}(0.61606327, 0.78823508, 0.56808666),
    RGB{Float64}(0.61171322, 0.78614216, 0.56829092),
    RGB{Float64}(0.60736933, 0.78405055, 0.56847436),
    RGB{Float64}(0.60302658, 0.78196121, 0.56864272),
    RGB{Float64}(0.59868708, 0.77987374, 0.56879289),
    RGB{Float64}(0.59435366, 0.77778758, 0.56892099),
    RGB{Float64}(0.59001953, 0.77570403, 0.56903477),
    RGB{Float64}(0.58568753, 0.77362254, 0.56913028),
    RGB{Float64}(0.58135593, 0.77154342, 0.56920908),
    RGB{Float64}(0.57702623, 0.76946638, 0.56926895),
    RGB{Float64}(0.57269165, 0.76739266, 0.5693172),
    RGB{Float64}(0.56835934, 0.76532092, 0.56934507),
    RGB{Float64}(0.56402533, 0.76325185, 0.56935664),
    RGB{Float64}(0.55968429, 0.76118643, 0.56935732),
    RGB{Float64}(0.55534159, 0.75912361, 0.56934052),
    RGB{Float64}(0.55099572, 0.75706366, 0.56930743),
    RGB{Float64}(0.54664626, 0.75500662, 0.56925799),
    RGB{Float64}(0.54228969, 0.75295306, 0.56919546),
    RGB{Float64}(0.53792417, 0.75090328, 0.56912118),
    RGB{Float64}(0.53355172, 0.74885687, 0.5690324),
    RGB{Float64}(0.52917169, 0.74681387, 0.56892926),
    RGB{Float64}(0.52478243, 0.74477453, 0.56881287),
    RGB{Float64}(0.52038338, 0.74273888, 0.56868323),
    RGB{Float64}(0.5159739, 0.74070697, 0.56854039),
    RGB{Float64}(0.51155269, 0.73867895, 0.56838507),
    RGB{Float64}(0.50711872, 0.73665492, 0.56821764),
    RGB{Float64}(0.50267118, 0.73463494, 0.56803826),
    RGB{Float64}(0.49822926, 0.73261388, 0.56785146),
    RGB{Float64}(0.49381422, 0.73058524, 0.56767484),
    RGB{Float64}(0.48942421, 0.72854938, 0.56751036),
    RGB{Float64}(0.48505993, 0.72650623, 0.56735752),
    RGB{Float64}(0.48072207, 0.72445575, 0.56721583),
    RGB{Float64}(0.4764113, 0.72239788, 0.56708475),
    RGB{Float64}(0.47212827, 0.72033258, 0.56696376),
    RGB{Float64}(0.46787361, 0.71825983, 0.56685231),
    RGB{Float64}(0.46364792, 0.71617961, 0.56674986),
    RGB{Float64}(0.45945271, 0.71409167, 0.56665625),
    RGB{Float64}(0.45528878, 0.71199595, 0.56657103),
    RGB{Float64}(0.45115557, 0.70989276, 0.5664931),
    RGB{Float64}(0.44705356, 0.70778212, 0.56642189),
    RGB{Float64}(0.44298321, 0.70566406, 0.56635683),
    RGB{Float64}(0.43894492, 0.70353863, 0.56629734),
    RGB{Float64}(0.43493911, 0.70140588, 0.56624286),
    RGB{Float64}(0.43096612, 0.69926587, 0.5661928),
    RGB{Float64}(0.42702625, 0.69711868, 0.56614659),
    RGB{Float64}(0.42311977, 0.69496438, 0.56610368),
    RGB{Float64}(0.41924689, 0.69280308, 0.56606355),
    RGB{Float64}(0.41540778, 0.69063486, 0.56602564),
    RGB{Float64}(0.41160259, 0.68845984, 0.56598944),
    RGB{Float64}(0.40783143, 0.68627814, 0.56595436),
    RGB{Float64}(0.40409434, 0.68408988, 0.56591994),
    RGB{Float64}(0.40039134, 0.68189518, 0.56588564),
    RGB{Float64}(0.39672238, 0.6796942, 0.56585103),
    RGB{Float64}(0.39308781, 0.67748696, 0.56581581),
    RGB{Float64}(0.38949137, 0.67527276, 0.56578084),
    RGB{Float64}(0.38592889, 0.67305266, 0.56574422),
    RGB{Float64}(0.38240013, 0.67082685, 0.56570561),
    RGB{Float64}(0.37890483, 0.66859548, 0.56566462),
    RGB{Float64}(0.37544276, 0.66635871, 0.56562081),
    RGB{Float64}(0.37201365, 0.66411673, 0.56557372),
    RGB{Float64}(0.36861709, 0.6618697, 0.5655231),
    RGB{Float64}(0.36525264, 0.65961782, 0.56546873),
    RGB{Float64}(0.36191986, 0.65736125, 0.56541032),
    RGB{Float64}(0.35861935, 0.65509998, 0.56534768),
    RGB{Float64}(0.35535621, 0.65283302, 0.56528211),
    RGB{Float64}(0.35212361, 0.65056188, 0.56521171),
    RGB{Float64}(0.34892097, 0.64828676, 0.56513633),
    RGB{Float64}(0.34574785, 0.64600783, 0.56505539),
    RGB{Float64}(0.34260357, 0.64372528, 0.5649689),
    RGB{Float64}(0.33948744, 0.64143931, 0.56487679),
    RGB{Float64}(0.33639887, 0.6391501, 0.56477869),
    RGB{Float64}(0.33334501, 0.63685626, 0.56467661),
    RGB{Float64}(0.33031952, 0.63455911, 0.564569),
    RGB{Float64}(0.3273199, 0.63225924, 0.56445488),
    RGB{Float64}(0.32434526, 0.62995682, 0.56433457),
    RGB{Float64}(0.32139487, 0.62765201, 0.56420795),
    RGB{Float64}(0.31846807, 0.62534504, 0.56407446),
    RGB{Float64}(0.3155731, 0.62303426, 0.56393695),
    RGB{Float64}(0.31270304, 0.62072111, 0.56379321),
    RGB{Float64}(0.30985436, 0.61840624, 0.56364307),
    RGB{Float64}(0.30702635, 0.61608984, 0.56348606),
    RGB{Float64}(0.30421803, 0.61377205, 0.56332267),
    RGB{Float64}(0.30143611, 0.61145167, 0.56315419),
    RGB{Float64}(0.29867863, 0.60912907, 0.56298054),
    RGB{Float64}(0.29593872, 0.60680554, 0.56280022),
    RGB{Float64}(0.29321538, 0.60448121, 0.56261376),
    RGB{Float64}(0.2905079, 0.60215628, 0.56242036),
    RGB{Float64}(0.28782827, 0.5998285, 0.56222366),
    RGB{Float64}(0.28516521, 0.59749996, 0.56202093),
    RGB{Float64}(0.28251558, 0.59517119, 0.56181204),
    RGB{Float64}(0.27987847, 0.59284232, 0.56159709),
    RGB{Float64}(0.27726216, 0.59051189, 0.56137785),
    RGB{Float64}(0.27466434, 0.58818027, 0.56115433),
    RGB{Float64}(0.2720767, 0.58584893, 0.56092486),
    RGB{Float64}(0.26949829, 0.58351797, 0.56068983),
    RGB{Float64}(0.26693801, 0.58118582, 0.56045121),
    RGB{Float64}(0.26439366, 0.57885288, 0.56020858),
    RGB{Float64}(0.26185616, 0.57652063, 0.55996077),
    RGB{Float64}(0.25932459, 0.57418919, 0.55970795),
    RGB{Float64}(0.25681303, 0.57185614, 0.55945297),
    RGB{Float64}(0.25431024, 0.56952337, 0.55919385),
    RGB{Float64}(0.25180492, 0.56719255, 0.5589305),
    RGB{Float64}(0.24929311, 0.56486397, 0.5586654),
    RGB{Float64}(0.24678356, 0.56253666, 0.55839491),
    RGB{Float64}(0.24426587, 0.56021153, 0.55812473),
    RGB{Float64}(0.24174022, 0.55788852, 0.55785448),
    RGB{Float64}(0.23921167, 0.55556705, 0.55758211),
    RGB{Float64}(0.23668315, 0.55324675, 0.55730676),
    RGB{Float64}(0.23414742, 0.55092825, 0.55703167),
    RGB{Float64}(0.23160473, 0.54861143, 0.5567573),
    RGB{Float64}(0.22905996, 0.54629572, 0.55648168),
    RGB{Float64}(0.22651648, 0.54398082, 0.5562029),
    RGB{Float64}(0.22396709, 0.54166721, 0.55592542),
    RGB{Float64}(0.22141221, 0.53935481, 0.55564885),
    RGB{Float64}(0.21885269, 0.53704347, 0.55537294),
    RGB{Float64}(0.21629986, 0.53473208, 0.55509319),
    RGB{Float64}(0.21374297, 0.53242154, 0.5548144),
    RGB{Float64}(0.21118255, 0.53011166, 0.55453708),
    RGB{Float64}(0.2086192, 0.52780237, 0.55426067),
    RGB{Float64}(0.20605624, 0.52549322, 0.55398479),
    RGB{Float64}(0.20350004, 0.5231837, 0.55370601),
    RGB{Float64}(0.20094292, 0.52087429, 0.55342884),
    RGB{Float64}(0.19838567, 0.51856489, 0.55315283),
    RGB{Float64}(0.19582911, 0.51625531, 0.55287818),
    RGB{Float64}(0.19327413, 0.51394542, 0.55260469),
    RGB{Float64}(0.19072933, 0.51163448, 0.5523289),
    RGB{Float64}(0.18819045, 0.50932268, 0.55205372),
    RGB{Float64}(0.18565609, 0.50701014, 0.55177937),
    RGB{Float64}(0.18312739, 0.50469666, 0.55150597),
    RGB{Float64}(0.18060561, 0.50238204, 0.55123374),
    RGB{Float64}(0.178092, 0.50006616, 0.55096224),
    RGB{Float64}(0.17558808, 0.49774882, 0.55069118),
    RGB{Float64}(0.17310341, 0.49542924, 0.5504176),
    RGB{Float64}(0.17063111, 0.49310789, 0.55014445),
    RGB{Float64}(0.1681728, 0.49078458, 0.54987159),
    RGB{Float64}(0.1657302, 0.48845913, 0.54959882),
    RGB{Float64}(0.16330517, 0.48613135, 0.54932605),
    RGB{Float64}(0.16089963, 0.48380104, 0.54905306),
    RGB{Float64}(0.15851561, 0.48146803, 0.54877953),
    RGB{Float64}(0.15615526, 0.47913212, 0.54850526),
    RGB{Float64}(0.15382083, 0.47679313, 0.54822991),
    RGB{Float64}(0.15151471, 0.47445087, 0.54795318),
    RGB{Float64}(0.14924112, 0.47210502, 0.54767411),
    RGB{Float64}(0.1470032, 0.46975537, 0.54739226),
    RGB{Float64}(0.14480101, 0.46740187, 0.54710832),
    RGB{Float64}(0.14263736, 0.46504434, 0.54682188),
    RGB{Float64}(0.14051521, 0.46268258, 0.54653253),
    RGB{Float64}(0.13843761, 0.46031639, 0.54623985),
    RGB{Float64}(0.13640774, 0.45794558, 0.5459434),
    RGB{Float64}(0.13442887, 0.45556994, 0.54564272),
    RGB{Float64}(0.1325044, 0.45318928, 0.54533736),
    RGB{Float64}(0.13063777, 0.4508034, 0.54502674),
    RGB{Float64}(0.12883252, 0.44841211, 0.5447104),
    RGB{Float64}(0.12709242, 0.44601517, 0.54438795),
    RGB{Float64}(0.1254209, 0.44361244, 0.54405855),
    RGB{Float64}(0.12382162, 0.44120373, 0.54372156),
    RGB{Float64}(0.12229818, 0.43878887, 0.54337634),
    RGB{Float64}(0.12085453, 0.4363676, 0.54302253),
    RGB{Float64}(0.11949938, 0.43393955, 0.54265715),
    RGB{Float64}(0.11823166, 0.43150478, 0.54228104),
    RGB{Float64}(0.11705496, 0.42906306, 0.54189388),
    RGB{Float64}(0.115972, 0.42661431, 0.54149449),
    RGB{Float64}(0.11498598, 0.42415835, 0.54108222),
    RGB{Float64}(0.11409965, 0.42169502, 0.54065622),
    RGB{Float64}(0.11331533, 0.41922424, 0.5402155),
    RGB{Float64}(0.11263542, 0.41674582, 0.53975931),
    RGB{Float64}(0.1120615, 0.4142597, 0.53928656),
    RGB{Float64}(0.11159738, 0.41176567, 0.53879549),
    RGB{Float64}(0.11125248, 0.40926325, 0.53828203),
    RGB{Float64}(0.11101698, 0.40675289, 0.53774864),
    RGB{Float64}(0.11089152, 0.40423445, 0.53719455),
    RGB{Float64}(0.11085121, 0.4017095, 0.53662425),
    RGB{Float64}(0.11087217, 0.39917938, 0.53604354),
    RGB{Float64}(0.11095515, 0.39664394, 0.53545166),
    RGB{Float64}(0.11110676, 0.39410282, 0.53484509),
    RGB{Float64}(0.11131735, 0.39155635, 0.53422678),
    RGB{Float64}(0.11158595, 0.38900446, 0.53359634),
    RGB{Float64}(0.11191139, 0.38644711, 0.5329534),
    RGB{Float64}(0.11229224, 0.38388426, 0.53229748),
    RGB{Float64}(0.11273683, 0.38131546, 0.53162393),
    RGB{Float64}(0.11323438, 0.37874109, 0.53093619),
    RGB{Float64}(0.11378271, 0.37616112, 0.53023413),
    RGB{Float64}(0.11437992, 0.37357557, 0.52951727),
    RGB{Float64}(0.11502681, 0.37098429, 0.52878396),
    RGB{Float64}(0.11572661, 0.36838709, 0.52803124),
    RGB{Float64}(0.11646936, 0.36578429, 0.52726234),
    RGB{Float64}(0.11725299, 0.3631759, 0.52647685),
    RGB{Float64}(0.1180755, 0.36056193, 0.52567436),
    RGB{Float64}(0.1189438, 0.35794203, 0.5248497),
    RGB{Float64}(0.11984752, 0.35531657, 0.52400649),
    RGB{Float64}(0.1207833, 0.35268564, 0.52314492),
    RGB{Float64}(0.12174895, 0.35004927, 0.52226461),
    RGB{Float64}(0.12274959, 0.34740723, 0.52136104),
    RGB{Float64}(0.12377809, 0.34475975, 0.52043639),
    RGB{Float64}(0.12482961, 0.34210702, 0.51949179),
    RGB{Float64}(0.125902, 0.33944908, 0.51852688),
    RGB{Float64}(0.12699998, 0.33678574, 0.51753708),
    RGB{Float64}(0.12811691, 0.33411727, 0.51652464),
    RGB{Float64}(0.12924811, 0.33144384, 0.51549084),
    RGB{Float64}(0.13039157, 0.32876552, 0.51443538),
    RGB{Float64}(0.13155228, 0.32608217, 0.51335321),
    RGB{Float64}(0.13272282, 0.32339407, 0.51224759),
    RGB{Float64}(0.13389954, 0.32070138, 0.51111946),
    RGB{Float64}(0.13508064, 0.31800419, 0.50996862),
    RGB{Float64}(0.13627149, 0.31530238, 0.50878942),
    RGB{Float64}(0.13746376, 0.31259627, 0.50758645),
    RGB{Float64}(0.13865499, 0.30988598, 0.50636017),
    RGB{Float64}(0.13984364, 0.30717161, 0.50511042),
    RGB{Float64}(0.14103515, 0.30445309, 0.50383119),
    RGB{Float64}(0.14222093, 0.30173071, 0.50252813),
    RGB{Float64}(0.14339946, 0.2990046, 0.50120127),
    RGB{Float64}(0.14456941, 0.29627483, 0.49985054),
    RGB{Float64}(0.14573579, 0.29354139, 0.49847009),
    RGB{Float64}(0.14689091, 0.29080452, 0.49706566),
    RGB{Float64}(0.1480336, 0.28806432, 0.49563732),
    RGB{Float64}(0.1491628, 0.28532086, 0.49418508),
    RGB{Float64}(0.15028228, 0.28257418, 0.49270402),
    RGB{Float64}(0.15138673, 0.27982444, 0.49119848),
    RGB{Float64}(0.15247457, 0.27707172, 0.48966925),
    RGB{Float64}(0.15354487, 0.2743161, 0.48811641),
    RGB{Float64}(0.15459955, 0.27155765, 0.4865371),
    RGB{Float64}(0.15563716, 0.26879642, 0.4849321),
    RGB{Float64}(0.1566572, 0.26603191, 0.48330429),
    RGB{Float64}(0.15765823, 0.26326032, 0.48167456),
    RGB{Float64}(0.15862147, 0.26048295, 0.48005785),
    RGB{Float64}(0.15954301, 0.25770084, 0.47845341),
    RGB{Float64}(0.16043267, 0.25491144, 0.4768626),
    RGB{Float64}(0.16129262, 0.25211406, 0.4752857),
    RGB{Float64}(0.1621119, 0.24931169, 0.47372076),
    RGB{Float64}(0.16290577, 0.24649998, 0.47217025),
    RGB{Float64}(0.16366819, 0.24368054, 0.47063302),
    RGB{Float64}(0.1644021, 0.24085237, 0.46910949),
    RGB{Float64}(0.16510882, 0.2380149, 0.46759982),
    RGB{Float64}(0.16579015, 0.23516739, 0.46610429),
    RGB{Float64}(0.1664433, 0.2323105, 0.46462219),
    RGB{Float64}(0.16707586, 0.22944155, 0.46315508),
    RGB{Float64}(0.16768475, 0.22656122, 0.46170223),
    RGB{Float64}(0.16826815, 0.22366984, 0.46026308),
    RGB{Float64}(0.16883174, 0.22076514, 0.45883891),
    RGB{Float64}(0.16937589, 0.21784655, 0.45742976),
    RGB{Float64}(0.16990129, 0.21491339, 0.45603578),
    RGB{Float64}(0.1704074, 0.21196535, 0.45465677),
    RGB{Float64}(0.17089473, 0.20900176, 0.4532928),
    RGB{Float64}(0.17136819, 0.20602012, 0.45194524),
    RGB{Float64}(0.17182683, 0.20302012, 0.45061386),
    RGB{Float64}(0.17227059, 0.20000106, 0.44929865),
    RGB{Float64}(0.17270583, 0.19695949, 0.44800165),
    RGB{Float64}(0.17313804, 0.19389201, 0.44672488),
    RGB{Float64}(0.17363177, 0.19076859, 0.44549087),
],
"seaborn",  # The category 
"sequential, gradient, crest"  # Descriptive keywords
)
