# CovarianceEstimation.jl

*Lightweight robust covariance estimation in Julia.*

A package for robustly estimating covariance matrices of real-valued data.

## Package Features

- Standard corrected and uncorrected covariance estimators,
- Linear and Nonlinear shrinkage estimators, including estimators for covariance matrices too large to store in dense form
- Focus on speed and lightweight dependencies

## Manual outline

```@contents
Pages = ["man/methods.md", "man/lshrink.md", "man/nlshrink.md", "man/msecomp.md"]
```

## Library Outline

```@contents
Pages = ["lib/public.md", "lib/internals.md"]
```

### [Index](@id main-index)

```@index
Pages = ["lib/public.md"]
```
