#=--- CpuId / test / mockdb.jl --------------------------------------------=#

####################################################################################
#
#   R e c o r d e d    c p u i d    d u m p s

# Fake
push!(_mockdb, (Dict(
    ((0x00000000, 0x00000000) => (0x00000008, 0x00000000, 0x00000000, 0x00000000)),
    ((0x80000000, 0x00000000) => (0x80000008, 0x00000000, 0x00000000, 0x00000000)),
  ) => Dict{Symbol,Any}(
    :cpuvendor       => :Unknown,
    :cpuarchitecture => :Unknown,
    :cpucores        => 0,
    :cputhreads      => 0,
    :cachesize       => (),
    :cachelinesize   => 0,
    :simdbits        => sizeof(UInt)*8,
  )))
  
# Intel(R) Xeon(R) CPU E5-2670 0 @ 2.60GHz, no hypervisor
push!(_mockdb, (Dict(
    ((0x00000000, 0x00000000) => (0x0000000d, 0x756e6547, 0x6c65746e, 0x49656e69)),
    ((0x00000001, 0x00000000) => (0x000206d7, 0x24200800, 0x1fbee3ff, 0xbfebfbff)),
    ((0x00000002, 0x00000000) => (0x76035a01, 0x00f0b2ff, 0x00000000, 0x00ca0000)),
    ((0x00000003, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x00000004, 0x00000000) => (0x3c004121, 0x01c0003f, 0x0000003f, 0x00000000)),
    ((0x00000004, 0x00000001) => (0x3c004122, 0x01c0003f, 0x0000003f, 0x00000000)),
    ((0x00000004, 0x00000002) => (0x3c004143, 0x01c0003f, 0x000001ff, 0x00000000)),
    ((0x00000004, 0x00000003) => (0x3c07c163, 0x04c0003f, 0x00003fff, 0x00000006)),
    ((0x00000004, 0x00000004) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x00000005, 0x00000000) => (0x00000040, 0x00000040, 0x00000003, 0x00021120)),
    ((0x00000006, 0x00000000) => (0x00000077, 0x00000002, 0x00000009, 0x00000000)),
    ((0x00000007, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x00000008, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x00000009, 0x00000000) => (0x00000001, 0x00000000, 0x00000000, 0x00000000)),
    ((0x0000000a, 0x00000000) => (0x07300403, 0x00000000, 0x00000000, 0x00000603)),
    ((0x0000000b, 0x00000000) => (0x00000001, 0x00000002, 0x00000100, 0x00000024)),
    ((0x0000000b, 0x00000001) => (0x00000005, 0x00000010, 0x00000201, 0x00000024)),
    ((0x0000000b, 0x00000002) => (0x00000000, 0x00000000, 0x00000002, 0x00000024)),
    ((0x0000000c, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x0000000d, 0x00000000) => (0x00000007, 0x00000340, 0x00000340, 0x00000000)),
    ((0x80000000, 0x00000000) => (0x80000008, 0x00000000, 0x00000000, 0x00000000)),
    ((0x80000001, 0x00000000) => (0x00000000, 0x00000000, 0x00000001, 0x2c100800)),
    ((0x80000002, 0x00000000) => (0x20202020, 0x49202020, 0x6c65746e, 0x20295228)),
    ((0x80000003, 0x00000000) => (0x6e6f6558, 0x20295228, 0x20555043, 0x322d3545)),
    ((0x80000004, 0x00000000) => (0x20303736, 0x20402030, 0x30362e32, 0x007a4847)),
    ((0x80000005, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x80000006, 0x00000000) => (0x00000000, 0x00000000, 0x01006040, 0x00000000)),
    ((0x80000007, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000100)),
    ((0x80000008, 0x00000000) => (0x0000302e, 0x00000000, 0x00000000, 0x00000000)),
  ) => Dict{Symbol,Any}(
    :cpuvendor       => :Intel,
    :cpuarchitecture => :SandyBridge,
    :cpucores        => 8,
    :cputhreads      => 16,
    :cachesize       => (32768, 262144, 20971520),
    :cachelinesize   => 64,
    :simdbits        => 256,
  )))
  
# Intel(R) Xeon(R) CPU E5-2680 v2 @ 2.80GHz, with Xen hypervisor
push!(_mockdb, (Dict(
    ((0x00000000, 0x00000000) => (0x0000000d, 0x756e6547, 0x6c65746e, 0x49656e69)),
    ((0x00000001, 0x00000000) => (0x000306e4, 0x24200800, 0xffba2203, 0x178bfbff)),
    ((0x00000002, 0x00000000) => (0x76036301, 0x00f0b2ff, 0x00000000, 0x00ca0000)),
    ((0x00000003, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x00000004, 0x00000000) => (0x3c004121, 0x01c0003f, 0x0000003f, 0x00000000)),
    ((0x00000004, 0x00000001) => (0x3c004122, 0x01c0003f, 0x0000003f, 0x00000000)),
    ((0x00000004, 0x00000002) => (0x3c004143, 0x01c0003f, 0x000001ff, 0x00000000)),
    ((0x00000004, 0x00000003) => (0x3c07c163, 0x04c0003f, 0x00004fff, 0x00000006)),
    ((0x00000004, 0x00000004) => (0x04000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x00000005, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x00000006, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x00000007, 0x00000000) => (0x00000000, 0x00000281, 0x00000000, 0x00000000)),
    ((0x00000008, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x00000009, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x0000000a, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x0000000b, 0x00000000) => (0x00000001, 0x00000002, 0x00000100, 0x00000024)),
    ((0x0000000b, 0x00000001) => (0x00000005, 0x00000010, 0x00000201, 0x00000024)),
    ((0x0000000b, 0x00000002) => (0x00000000, 0x00000000, 0x00000000, 0x00000024)),
    ((0x0000000c, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x0000000d, 0x00000000) => (0x00000007, 0x00000340, 0x00000340, 0x00000000)),
    ((0x40000000, 0x00000000) => (0x40000004, 0x566e6558, 0x65584d4d, 0x4d4d566e)),
    ((0x40000001, 0x00000000) => (0x00040002, 0x00000000, 0x00000000, 0x00000000)),
    ((0x40000002, 0x00000000) => (0x00000001, 0x40000000, 0x00000000, 0x00000000)),
    ((0x40000003, 0x00000000) => (0x00000006, 0x00000000, 0x002ab9d6, 0x00000001)),
    ((0x40000004, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x80000000, 0x00000000) => (0x80000008, 0x00000000, 0x00000000, 0x00000000)),
    ((0x80000001, 0x00000000) => (0x00000000, 0x00000000, 0x00000001, 0x28100800)),
    ((0x80000002, 0x00000000) => (0x20202020, 0x6e492020, 0x286c6574, 0x58202952)),
    ((0x80000003, 0x00000000) => (0x286e6f65, 0x43202952, 0x45205550, 0x36322d35)),
    ((0x80000004, 0x00000000) => (0x76203038, 0x20402032, 0x30382e32, 0x007a4847)),
    ((0x80000005, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x80000006, 0x00000000) => (0x00000000, 0x00000000, 0x01006040, 0x00000000)),
    ((0x80000007, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x80000008, 0x00000000) => (0x0000302e, 0x00000000, 0x00000000, 0x00000000)),
  ) => Dict{Symbol,Any}(
    :cpuvendor       => :Intel,
    :cpuarchitecture => :IvyBridge,
    :cpucores        => 8,
    :cputhreads      => 16,
    :cachesize       => (32768, 262144, 26214400),
    :cachelinesize   => 64,
    :simdbits        => 256,
  )))
  
# Intel(R) Xeon(R) CPU E5-2680 v3 @ 2.50GHz with Microsoft hypervisor
push!( _mockdb, (Dict(
    ((0x00000000, 0x00000000) => (0x0000000d, 0x756e6547, 0x6c65746e, 0x49656e69)),
    ((0x00000001, 0x00000000) => (0x000306f2, 0x00020800, 0xfed83203, 0x1f8bfbff)),
    ((0x00000002, 0x00000000) => (0x76036301, 0x00f0b5ff, 0x00000000, 0x00c10000)),
    ((0x00000003, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x00000004, 0x00000000) => (0x04000121, 0x01c0003f, 0x0000003f, 0x00000000)),
    ((0x00000004, 0x00000001) => (0x04000122, 0x01c0003f, 0x0000003f, 0x00000000)),
    ((0x00000004, 0x00000002) => (0x04000143, 0x01c0003f, 0x000001ff, 0x00000000)),
    ((0x00000004, 0x00000003) => (0x04000163, 0x04c0003f, 0x00005fff, 0x00000002)),
    ((0x00000004, 0x00000004) => (0x04000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x00000005, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x00000006, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x00000007, 0x00000000) => (0x00000000, 0x000023a9, 0x00000000, 0x00000000)),
    ((0x00000008, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x00000009, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x0000000a, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x0000000b, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x0000000b, 0x00000001) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x0000000c, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x0000000d, 0x00000000) => (0x00000007, 0x00000340, 0x00000340, 0x00000000)),
    ((0x40000000, 0x00000000) => (0x40000006, 0x7263694d, 0x666f736f, 0x76482074)),
    ((0x40000001, 0x00000000) => (0x31237648, 0x00000000, 0x00000000, 0x00000000)),
    ((0x40000002, 0x00000000) => (0x00002580, 0x00060003, 0x00000012, 0x00004690)),
    ((0x40000003, 0x00000000) => (0x00000e7f, 0x000008b0, 0x00000002, 0x000017b2)),
    ((0x40000004, 0x00000000) => (0x0000002c, 0x00000fff, 0x00000000, 0x00000000)),
    ((0x40000005, 0x00000000) => (0x00000040, 0x00000200, 0x00002580, 0x00000000)),
    ((0x40000006, 0x00000000) => (0x0000004f, 0x00000000, 0x00000000, 0x00000000)),
    ((0x80000000, 0x00000000) => (0x80000008, 0x00000000, 0x00000000, 0x00000000)),
    ((0x80000001, 0x00000000) => (0x00000000, 0x00000000, 0x00000021, 0x20100800)),
    ((0x80000002, 0x00000000) => (0x65746e49, 0x2952286c, 0x6f655820, 0x2952286e)),
    ((0x80000003, 0x00000000) => (0x55504320, 0x2d354520, 0x30383632, 0x20337620)),
    ((0x80000004, 0x00000000) => (0x2e322040, 0x48473035, 0x0000007a, 0x00000000)),
    ((0x80000005, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x80000006, 0x00000000) => (0x00000000, 0x00000000, 0x01006040, 0x00000000)),
    ((0x80000007, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x80000008, 0x00000000) => (0x0000302a, 0x00000000, 0x00000000, 0x00000000)),
    ) => Dict{Symbol,Any}(
      :cpuvendor       => :Intel,
      :cpuarchitecture => :Haswell,
      :cpucores        => 1,
      :cputhreads      => 2,
      :cachesize       => (32768, 262144, 31457280),
      :cachelinesize   => 64,
      :simdbits        => 256,
    )))

# Intel(R) Xeon(R) CPU E3-1225 v5 @ 3.30GHz
push!(_mockdb, (Dict(
    ((0x00000000, 0x00000000) => (0x0000000d, 0x756e6547, 0x6c65746e, 0x49656e69)),
    ((0x00000001, 0x00000000) => (0x000206d7, 0x24200800, 0x1fbee3ff, 0xbfebfbff)),
    ((0x00000002, 0x00000000) => (0x76035a01, 0x00f0b2ff, 0x00000000, 0x00ca0000)),
    ((0x00000003, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x00000004, 0x00000000) => (0x3c004121, 0x01c0003f, 0x0000003f, 0x00000000)),
    ((0x00000004, 0x00000001) => (0x3c004122, 0x01c0003f, 0x0000003f, 0x00000000)),
    ((0x00000004, 0x00000002) => (0x3c004143, 0x01c0003f, 0x000001ff, 0x00000000)),
    ((0x00000004, 0x00000003) => (0x3c07c163, 0x04c0003f, 0x00003fff, 0x00000006)),
    ((0x00000004, 0x00000004) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x00000005, 0x00000000) => (0x00000040, 0x00000040, 0x00000003, 0x00021120)),
    ((0x00000006, 0x00000000) => (0x00000077, 0x00000002, 0x00000009, 0x00000000)),
    ((0x00000007, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x00000008, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x00000009, 0x00000000) => (0x00000001, 0x00000000, 0x00000000, 0x00000000)),
    ((0x0000000a, 0x00000000) => (0x07300403, 0x00000000, 0x00000000, 0x00000603)),
    ((0x0000000b, 0x00000000) => (0x00000001, 0x00000002, 0x00000100, 0x00000024)),
    ((0x0000000b, 0x00000001) => (0x00000005, 0x00000010, 0x00000201, 0x00000024)),
    ((0x0000000b, 0x00000002) => (0x00000000, 0x00000000, 0x00000002, 0x00000024)),
    ((0x0000000c, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x0000000d, 0x00000000) => (0x00000007, 0x00000340, 0x00000340, 0x00000000)),
    ((0x80000000, 0x00000000) => (0x80000008, 0x00000000, 0x00000000, 0x00000000)),
    ((0x80000001, 0x00000000) => (0x00000000, 0x00000000, 0x00000001, 0x2c100800)),
    ((0x80000002, 0x00000000) => (0x20202020, 0x49202020, 0x6c65746e, 0x20295228)),
    ((0x80000003, 0x00000000) => (0x6e6f6558, 0x20295228, 0x20555043, 0x322d3545)),
    ((0x80000004, 0x00000000) => (0x20303736, 0x20402030, 0x30362e32, 0x007a4847)),
    ((0x80000005, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x80000006, 0x00000000) => (0x00000000, 0x00000000, 0x01006040, 0x00000000)),
    ((0x80000007, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000100)),
    ((0x80000008, 0x00000000) => (0x0000302e, 0x00000000, 0x00000000, 0x00000000)),
  ) => Dict{Symbol,Any}(
    :cpuvendor       => :Intel,
    :cpuarchitecture => :SandyBridge,
    :cpucores        => 8,
    :cputhreads      => 16,
    :cachesize       => (32768, 262144, 20971520),
    :cachelinesize   => 64,
    :simdbits        => 256,
  )))
  

# Intel(R) Xeon(R) CPU X5570 @ 2.93GHz, with VMware hypervisor
push!(_mockdb, (Dict(
    ((0x00000000, 0x00000000) => (0x0000000b, 0x756e6547, 0x6c65746e, 0x49656e69)),
    ((0x00000001, 0x00000000) => (0x000106a5, 0x00010800, 0x81b82209, 0x0fabfbff)),
    ((0x00000002, 0x00000000) => (0x55035a01, 0x00f0b2e4, 0x00000000, 0x09ca212c)),
    ((0x00000003, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x00000004, 0x00000000) => (0x00000121, 0x01c0003f, 0x0000003f, 0x00000000)),
    ((0x00000004, 0x00000000) => (0x00000121, 0x01c0003f, 0x0000003f, 0x00000000)),
    ((0x00000004, 0x00000001) => (0x00000122, 0x00c0003f, 0x0000007f, 0x00000000)),
    ((0x00000004, 0x00000002) => (0x00000143, 0x01c0003f, 0x000001ff, 0x00000000)),
    ((0x00000004, 0x00000003) => (0x00000163, 0x03c0003f, 0x00001fff, 0x00000002)),
    ((0x00000004, 0x00000004) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x00000005, 0x00000000) => (0x00001000, 0x00001000, 0x00000003, 0x00001120)),
    ((0x00000006, 0x00000000) => (0x00000003, 0x00000002, 0x00000001, 0x00000000)),
    ((0x00000007, 0x00000000) => (0x00000000, 0x00000002, 0x00000000, 0x00000000)),
    ((0x00000008, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x00000009, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x0000000a, 0x00000000) => (0x07300401, 0x0000007f, 0x00000000, 0x00000000)),
    ((0x0000000b, 0x00000000) => (0x00000000, 0x00000001, 0x00000100, 0x00000000)),
    ((0x0000000b, 0x00000001) => (0x00000000, 0x00000001, 0x00000201, 0x00000002)),
    ((0x0000000b, 0x00000002) => (0x00000000, 0x00000000, 0x00000002, 0x00000000)),
    ((0x40000000, 0x00000000) => (0x40000010, 0x61774d56, 0x4d566572, 0x65726177)),
    ((0x40000001, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x40000002, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x40000003, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x40000004, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x40000005, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x40000006, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x40000007, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x40000008, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x40000009, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x4000000a, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x4000000b, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x4000000c, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x4000000d, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x4000000e, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x4000000f, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x40000010, 0x00000000) => (0x002ca5b0, 0x000170b3, 0x00000000, 0x00000000)),
    ((0x80000000, 0x00000000) => (0x80000008, 0x00000000, 0x00000000, 0x00000000)),
    ((0x80000001, 0x00000000) => (0x00000000, 0x00000000, 0x00000001, 0x28100800)),
    ((0x80000002, 0x00000000) => (0x65746e49, 0x2952286c, 0x6f655820, 0x2952286e)),
    ((0x80000003, 0x00000000) => (0x55504320, 0x20202020, 0x20202020, 0x58202020)),
    ((0x80000004, 0x00000000) => (0x30373535, 0x20402020, 0x33392e32, 0x007a4847)),
    ((0x80000005, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x80000006, 0x00000000) => (0x00000000, 0x00000000, 0x01006040, 0x00000000)),
    ((0x80000007, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000100)),
    ((0x80000008, 0x00000000) => (0x0000302a, 0x00000000, 0x00000000, 0x00000000)),
  ) => Dict{Symbol,Any}(
    :cpuvendor       => :Intel,
    :cpuarchitecture => :Nehalem,
    :cpucores        => 1,   # physical: 4, but with hypervisor
    :cputhreads      => 1,   # physical: 8, but with hypervisor
    :cachesize       => (32768, 262144, 8388608),
    :cachelinesize   => 64,
    :simdbits        => 128,
  )))
    
# Intel(R) Core(TM) i5-2520M CPU @ 2.50GHz with VMware hypervisor
push!(_mockdb, (Dict(
    ((0x00000000, 0x00000000) => (0x0000000d, 0x756e6547, 0x6c65746e, 0x49656e69)),
    ((0x00000001, 0x00000000) => (0x000206a7, 0x06010800, 0x9fba2223, 0x0fabfbff)),
    ((0x00000002, 0x00000000) => (0x76035a01, 0x00f0b2ff, 0x00000000, 0x00ca0000)),
    ((0x00000003, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x00000004, 0x00000000) => (0x00000121, 0x01c0003f, 0x0000003f, 0x00000000)),
    ((0x00000004, 0x00000001) => (0x00000122, 0x01c0003f, 0x0000003f, 0x00000000)),
    ((0x00000004, 0x00000002) => (0x00000143, 0x01c0003f, 0x000001ff, 0x00000000)),
    ((0x00000004, 0x00000003) => (0x00000163, 0x02c0003f, 0x00000fff, 0x00000006)),
    ((0x00000004, 0x00000004) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x00000005, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x00000006, 0x00000000) => (0x00000077, 0x00000002, 0x00000009, 0x00000000)),
    ((0x00000007, 0x00000000) => (0x00000000, 0x00000002, 0x00000000, 0x00000000)),
    ((0x00000008, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x00000009, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x0000000a, 0x00000000) => (0x07300403, 0x00000000, 0x00000000, 0x00000603)),
    ((0x0000000b, 0x00000000) => (0x00000000, 0x00000001, 0x00000100, 0x00000006)),
    ((0x0000000b, 0x00000001) => (0x00000000, 0x00000001, 0x00000201, 0x00000006)),
    ((0x0000000b, 0x00000002) => (0x00000000, 0x00000000, 0x00000002, 0x00000006)),
    ((0x0000000c, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x0000000d, 0x00000000) => (0x00000007, 0x00000340, 0x00000340, 0x00000000)),
    ((0x40000000, 0x00000000) => (0x40000010, 0x61774d56, 0x4d566572, 0x65726177)),
    ((0x40000001, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x40000002, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x40000003, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x40000004, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x40000005, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x40000006, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x40000007, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x40000008, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x40000009, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x4000000a, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x4000000b, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x4000000c, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x4000000d, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x4000000e, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x4000000f, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x40000010, 0x00000000) => (0x00262988, 0x000101d0, 0x00000000, 0x00000000)),
    ((0x80000000, 0x00000000) => (0x80000008, 0x00000000, 0x00000000, 0x00000000)),
    ((0x80000001, 0x00000000) => (0x00000000, 0x00000000, 0x00000001, 0x28100800)),
    ((0x80000002, 0x00000000) => (0x20202020, 0x49202020, 0x6c65746e, 0x20295228)),
    ((0x80000003, 0x00000000) => (0x65726f43, 0x294d5428, 0x2d356920, 0x30323532)),
    ((0x80000004, 0x00000000) => (0x5043204d, 0x20402055, 0x30352e32, 0x007a4847)),
    ((0x80000005, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x80000006, 0x00000000) => (0x00000000, 0x00000000, 0x01006040, 0x00000000)),
    ((0x80000007, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000100)),
    ((0x80000008, 0x00000000) => (0x0000302a, 0x00000000, 0x00000000, 0x00000000)),
  ) => Dict{Symbol,Any}(
    :cpuvendor       => :Intel,
    :cpuarchitecture => :SandyBridge,
    :cpucores        => 1,  # physical: 2, but with hypervisor
    :cputhreads      => 1,  # physical: 4, but with hypervisor
    :cachesize       => (32768, 262144, 3145728),
    :cachelinesize   => 64,
    :simdbits        => 256,
  )))

# Intel(R) Core(TM) i5-2520M CPU @ 2.50GHz without hypervisor
push!(_mockdb, (Dict(
    ((0x00000000, 0x00000000) => (0x0000000d, 0x756e6547, 0x6c65746e, 0x49656e69)),
    ((0x00000001, 0x00000000) => (0x000206a7, 0x00100800, 0x1fbae3ff, 0xbfebfbff)),
    ((0x00000002, 0x00000000) => (0x76035a01, 0x00f0b2ff, 0x00000000, 0x00ca0000)),
    ((0x00000003, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x00000004, 0x00000000) => (0x1c004121, 0x01c0003f, 0x0000003f, 0x00000000)),
    ((0x00000004, 0x00000001) => (0x1c004122, 0x01c0003f, 0x0000003f, 0x00000000)),
    ((0x00000004, 0x00000002) => (0x1c004143, 0x01c0003f, 0x000001ff, 0x00000000)),
    ((0x00000004, 0x00000003) => (0x1c03c163, 0x02c0003f, 0x00000fff, 0x00000006)),
    ((0x00000004, 0x00000004) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x00000005, 0x00000000) => (0x00000040, 0x00000040, 0x00000003, 0x00021120)),
    ((0x00000006, 0x00000000) => (0x00000077, 0x00000002, 0x00000009, 0x00000000)),
    ((0x00000007, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x00000008, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x00000009, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x0000000a, 0x00000000) => (0x07300403, 0x00000000, 0x00000000, 0x00000603)),
    ((0x0000000b, 0x00000000) => (0x00000001, 0x00000002, 0x00000100, 0x00000000)),
    ((0x0000000b, 0x00000001) => (0x00000004, 0x00000004, 0x00000201, 0x00000003)),
    ((0x0000000b, 0x00000002) => (0x00000000, 0x00000000, 0x00000002, 0x00000003)),
    ((0x0000000c, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x0000000d, 0x00000000) => (0x00000007, 0x00000340, 0x00000340, 0x00000000)),
    ((0x80000000, 0x00000000) => (0x80000008, 0x00000000, 0x00000000, 0x00000000)),
    ((0x80000001, 0x00000000) => (0x00000000, 0x00000000, 0x00000001, 0x28100800)),
    ((0x80000002, 0x00000000) => (0x20202020, 0x49202020, 0x6c65746e, 0x20295228)),
    ((0x80000003, 0x00000000) => (0x65726f43, 0x294d5428, 0x2d356920, 0x30323532)),
    ((0x80000004, 0x00000000) => (0x5043204d, 0x20402055, 0x30352e32, 0x007a4847)),
    ((0x80000005, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x80000006, 0x00000000) => (0x00000000, 0x00000000, 0x01006040, 0x00000000)),
    ((0x80000007, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000100)),
    ((0x80000008, 0x00000000) => (0x00003024, 0x00000000, 0x00000000, 0x00000000)),
  ) => Dict{Symbol,Any}(
    :cpuvendor       => :Intel,
    :cpuarchitecture => :SandyBridge,
    :cpucores        => 2,
    :cputhreads      => 4,
    :cachesize       => (32768, 262144, 3145728),
    :cachelinesize   => 64,
    :simdbits        => 256,
  )))
    
# Intel(R) Xeon Phi(TM) CPU 7250 @ 1.40GHz without hypervisor
push!( _mockdb, (Dict(
    ((0x00000000, 0x00000000) => (0x0000000d, 0x756e6547, 0x6c65746e, 0x49656e69)),
    ((0x00000001, 0x00000000) => (0x00050671, 0x01ff0800, 0x7ff8f3bf, 0xbfebfbff)),
    ((0x00000002, 0x00000000) => (0x6c6b6a01, 0x00ff616d, 0x00000000, 0x00000000)),
    ((0x00000003, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x00000004, 0x00000000) => (0xfc00c121, 0x01c0003f, 0x0000003f, 0x00000000)),
    ((0x00000005, 0x00000000) => (0x00000040, 0x00000040, 0x00000003, 0x00000110)),
    ((0x00000006, 0x00000000) => (0x00000077, 0x00000002, 0x00000009, 0x00000000)),
    ((0x00000007, 0x00000000) => (0x00000000, 0x1c0d23ab, 0x00000001, 0x00000000)),
    ((0x00000008, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x00000009, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x0000000a, 0x00000000) => (0x07280203, 0x00000000, 0x00000000, 0x00000503)),
    ((0x0000000b, 0x00000000) => (0x00000002, 0x00000004, 0x00000100, 0x00000001)),
    ((0x0000000c, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x0000000d, 0x00000000) => (0x000000e7, 0x00000a80, 0x00000a80, 0x00000000)),
    ((0x80000000, 0x00000000) => (0x80000008, 0x00000000, 0x00000000, 0x00000000)),
    ((0x80000001, 0x00000000) => (0x00000000, 0x00000000, 0x00000121, 0x2c100800)),
    ((0x80000002, 0x00000000) => (0x65746e49, 0x2952286c, 0x6f655820, 0x6850206e)),
    ((0x80000003, 0x00000000) => (0x4d542869, 0x50432029, 0x32372055, 0x40203035)),
    ((0x80000004, 0x00000000) => (0x342e3120, 0x7a484730, 0x00000000, 0x00000000)),
    ((0x80000005, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x80000006, 0x00000000) => (0x00000000, 0x00000000, 0x04008040, 0x00000000)),
    ((0x80000007, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000100)),
    ((0x80000008, 0x00000000) => (0x0000302e, 0x00000000, 0x00000000, 0x00000000)),
    ((0x00000004, 0x00000001) => (0xfc00c122, 0x01c0003f, 0x0000003f, 0x00000000)),
    ((0x00000004, 0x00000002) => (0xfc01c143, 0x03c0003f, 0x000003ff, 0x00000013)),
    ((0x00000004, 0x00000003) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x0000000b, 0x00000001) => (0x00000009, 0x00000110, 0x00000201, 0x00000001)),
    ((0x0000000b, 0x00000002) => (0x00000000, 0x00000000, 0x00000002, 0x00000001)),
  ) => Dict{Symbol,Any}(
    :cpuvendor       => :Intel,
    :cpuarchitecture => :KnightsLanding,
    :cpucores        => 68,
    :cputhreads      => 272,
    :cachesize       => (32768, 1048576),
    :cachelinesize   => 64,
    :simdbits        => 512,
  )))
    
# This is used on pkg.julialang.org for testing.
# Intel(R) Xeon(R) CPU E3-1241 v3 @ 3.50GHz without hypervisor
#
# processor         : 0
# vendor_id         : GenuineIntel
# cpu family        : 6
# model             : 60
# model name        : Intel(R) Xeon(R) CPU E3-1241 v3 @ 3.50GHz
# stepping          : 3
# microcode         : 0x19
# cpu MHz           : 3503.064
# cache size        : 6144 KB
# physical id       : 0
# siblings          : 2
# core id           : 0
# cpu cores         : 2
# apicid            : 0
# initial apicid    : 0
# fpu               : yes
# fpu_exception     : yes
# cpuid level       : 5
# wp                : yes
# flags             : fpu vme de pse tsc msr pae mce cx8 apic sep mtrr pge mca cmov
#                       pat pse36 clflush mmx fxsr sse sse2 ht syscall nx rdtscp lm
#                       constant_tsc rep_good nopl pni ssse3 lahf_lm
# bogomips          : 7006.12
# clflush size      : 64
# cache_alignment   : 64
# address sizes     : 39 bits physical, 48 bits virtual
# power management:
#
push!( _mockdb, (Dict(
    ((0x00000000,0x00000000) => (0x00000005,0x756e6547,0x6c65746e,0x49656e69)),
    ((0x00000001,0x00000000) => (0x000306c3,0x01020800,0x00000201,0x178bfbff)),
    ((0x00000002,0x00000000) => (0x76036301,0x00f0b5ff,0x00000000,0x00c10000)),
    ((0x00000003,0x00000000) => (0x00000000,0x00000000,0x00000000,0x00000000)),
    ((0x00000004,0x00000000) => (0x04000021,0x01c0003f,0x0000003f,0x00000000)),
    ((0x00000005,0x00000000) => (0x00000000,0x00000000,0x00000000,0x00000000)),
    ((0x80000000,0x00000000) => (0x80000008,0x00000000,0x00000000,0x00000000)),
    ((0x80000001,0x00000000) => (0x00000000,0x00000000,0x00000001,0x28100800)),
    ((0x80000002,0x00000000) => (0x65746e49,0x2952286c,0x6f655820,0x2952286e)),
    ((0x80000003,0x00000000) => (0x55504320,0x2d334520,0x31343231,0x20337620)),
    ((0x80000004,0x00000000) => (0x2e332040,0x48473035,0x0000007a,0x00000000)),
    ((0x80000005,0x00000000) => (0x00000000,0x00000000,0x00000000,0x00000000)),
    ((0x80000006,0x00000000) => (0x00000000,0x00000000,0x01006040,0x00000000)),
    ((0x80000007,0x00000000) => (0x00000000,0x00000000,0x00000000,0x00000000)),
    ((0x80000008,0x00000000) => (0x00003027,0x00000000,0x00000000,0x00000000)),
    ((0x00000004,0x00000001) => (0x04000021,0x01c0003f,0x0000003f,0x00000000)),
    ((0x00000004,0x00000002) => (0x04004041,0x05c0003f,0x00000fff,0x00000000)),
    ((0x00000004,0x00000003) => (0x04000000,0x00000000,0x00000000,0x00000000)),
  ) => Dict{Symbol,Any}(
    :cpuvendor       => :Intel,
    :cpuarchitecture => :Haswell,
    :cpucores        => 0,  # physical: 4, but with hypervisor
    :cputhreads      => 0,  # physical: 8, but with hypervisor
    :cachesize       => (32768, 32768, 6291456), # 8MB ?
    :cachelinesize   => 64,
    :simdbits        => 128,
  )))
  
# Intel(R) Core(TM) i7-6600U CPU @ 2.60GHz without hypervisor
push!( _mockdb, (Dict(
    ((0x00000000,0x00000000) => (0x00000016,0x756e6547,0x6c65746e,0x49656e69)),
    ((0x00000001,0x00000000) => (0x000406e3,0x00100800,0x7ffafbff,0xbfebfbff)),
    ((0x00000002,0x00000000) => (0x76036301,0x00f0b5ff,0x00000000,0x00c30000)),
    ((0x00000003,0x00000000) => (0x00000000,0x00000000,0x00000000,0x00000000)),
    ((0x00000004,0x00000000) => (0x1c004121,0x01c0003f,0x0000003f,0x00000000)),
    ((0x00000005,0x00000000) => (0x00000040,0x00000040,0x00000003,0x11142120)),
    ((0x00000006,0x00000000) => (0x000027f7,0x00000002,0x00000009,0x00000000)),
    ((0x00000007,0x00000000) => (0x00000000,0x029c6fbf,0x00000000,0x00000000)),
    ((0x00000008,0x00000000) => (0x00000000,0x00000000,0x00000000,0x00000000)),
    ((0x00000009,0x00000000) => (0x00000000,0x00000000,0x00000000,0x00000000)),
    ((0x0000000a,0x00000000) => (0x07300404,0x00000000,0x00000000,0x00000603)),
    ((0x0000000b,0x00000000) => (0x00000001,0x00000002,0x00000100,0x00000003)),
    ((0x0000000c,0x00000000) => (0x00000000,0x00000000,0x00000000,0x00000000)),
    ((0x0000000d,0x00000000) => (0x0000001f,0x00000440,0x00000440,0x00000000)),
    ((0x0000000e,0x00000000) => (0x00000000,0x00000000,0x00000000,0x00000000)),
    ((0x0000000f,0x00000000) => (0x00000000,0x00000000,0x00000000,0x00000000)),
    ((0x00000010,0x00000000) => (0x00000000,0x00000000,0x00000000,0x00000000)),
    ((0x00000011,0x00000000) => (0x00000000,0x00000000,0x00000000,0x00000000)),
    ((0x00000012,0x00000000) => (0x00000000,0x00000000,0x00000000,0x00000000)),
    ((0x00000013,0x00000000) => (0x00000000,0x00000000,0x00000000,0x00000000)),
    ((0x00000014,0x00000000) => (0x00000001,0x0000000f,0x00000007,0x00000000)),
    ((0x00000015,0x00000000) => (0x00000002,0x000000ea,0x00000000,0x00000000)),
    ((0x00000016,0x00000000) => (0x00000af0,0x00000d48,0x00000064,0x00000000)),
    ((0x80000000,0x00000000) => (0x80000008,0x00000000,0x00000000,0x00000000)),
    ((0x80000001,0x00000000) => (0x00000000,0x00000000,0x00000121,0x2c100800)),
    ((0x80000002,0x00000000) => (0x65746e49,0x2952286c,0x726f4320,0x4d542865)),
    ((0x80000003,0x00000000) => (0x37692029,0x3036362d,0x43205530,0x40205550)),
    ((0x80000004,0x00000000) => (0x362e3220,0x7a484730,0x00000000,0x00000000)),
    ((0x80000005,0x00000000) => (0x00000000,0x00000000,0x00000000,0x00000000)),
    ((0x80000006,0x00000000) => (0x00000000,0x00000000,0x01006040,0x00000000)),
    ((0x80000007,0x00000000) => (0x00000000,0x00000000,0x00000000,0x00000100)),
    ((0x80000008,0x00000000) => (0x00003027,0x00000000,0x00000000,0x00000000)),
    ((0x00000004,0x00000001) => (0x1c004122,0x01c0003f,0x0000003f,0x00000000)),
    ((0x00000004,0x00000002) => (0x1c004143,0x00c0003f,0x000003ff,0x00000000)),
    ((0x00000004,0x00000003) => (0x1c03c163,0x03c0003f,0x00000fff,0x00000006)),
    ((0x00000004,0x00000004) => (0x00000000,0x00000000,0x00000000,0x00000000)),
    ((0x0000000b,0x00000001) => (0x00000004,0x00000004,0x00000201,0x00000001)),
    ((0x0000000b,0x00000002) => (0x00000000,0x00000000,0x00000002,0x00000001)),
  ) => Dict{Symbol,Any}(
    :cpuvendor       => :Intel,
    :cpuarchitecture => :Skylake,
    :cpucores        => 2,
    :cputhreads      => 4,
    :cachesize       => (32768, 262144, 4194304),
    :cachelinesize   => 64,
    :simdbits        => 256,
  )))
  
# AMD A10-8700P Radeon R6, 10 Compute Cores 4C+6G without hypervisor
push!( _mockdb, (Dict(
    ((0x00000000, 0x00000000) => (0x0000000d, 0x68747541, 0x444d4163, 0x69746e65)),
    ((0x00000001, 0x00000000) => (0x00660f01, 0x02040800, 0x3ed8320b, 0x178bfbff)),
    ((0x00000002, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x00000003, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x00000004, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x00000005, 0x00000000) => (0x00000040, 0x00000040, 0x00000003, 0x00000000)),
    ((0x00000006, 0x00000000) => (0x00000004, 0x00000000, 0x00000001, 0x00000000)),
    ((0x00000007, 0x00000000) => (0x00000000, 0x000001a9, 0x00000000, 0x00000000)),
    ((0x00000008, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x00000009, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x0000000a, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x0000000b, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x0000000c, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x0000000d, 0x00000000) => (0x00000007, 0x00000340, 0x000003c0, 0x40000000)),
    ((0x80000000, 0x00000000) => (0x8000001e, 0x68747541, 0x444d4163, 0x69746e65)),
    ((0x80000001, 0x00000000) => (0x00660f01, 0x00000000, 0x2febbfff, 0x2fd3fbff)),
    ((0x80000002, 0x00000000) => (0x20444d41, 0x2d303141, 0x30303738, 0x61522050)),
    ((0x80000003, 0x00000000) => (0x6e6f6564, 0x2c365220, 0x20303120, 0x706d6f43)),
    ((0x80000004, 0x00000000) => (0x20657475, 0x65726f43, 0x43342073, 0x0047362b)),
    ((0x80000005, 0x00000000) => (0xff40ff18, 0xff40ff30, 0x20080140, 0x60030140)),
    ((0x80000006, 0x00000000) => (0x64006400, 0x64004200, 0x04008140, 0x00000000)),
    ((0x80000007, 0x00000000) => (0x00000000, 0x00000005, 0x00000400, 0x000037d9)),
    ((0x80000008, 0x00000000) => (0x00003030, 0x00000000, 0x00004003, 0x00000000)),
    ((0x80000009, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x8000000a, 0x00000000) => (0x00000001, 0x00008000, 0x00000000, 0x0001bcff)),
    ((0x8000000b, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x8000000c, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x8000000d, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x8000000e, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x8000000f, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x80000010, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x80000011, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x80000012, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x80000013, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x80000014, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x80000015, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x80000016, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x80000017, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x80000018, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x80000019, 0x00000000) => (0xf040f018, 0x64006400, 0x00000000, 0x00000000)),
    ((0x8000001a, 0x00000000) => (0x00000003, 0x00000000, 0x00000000, 0x00000000)),
    ((0x8000001b, 0x00000000) => (0x000007ff, 0x00000000, 0x00000000, 0x00000000)),
    ((0x8000001c, 0x00000000) => (0x00000000, 0x80032013, 0x00010200, 0xe000000f)),
    ((0x8000001d, 0x00000000) => (0x00000121, 0x01c0003f, 0x0000003f, 0x00000000)),
    ((0x8000001e, 0x00000000) => (0x00000010, 0x00000100, 0x00000000, 0x00000000)),
    ((0x00000004, 0x00000001) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x0000000b, 0x00000001) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
  ) => Dict{Symbol,Any}(
    # http://www.cpu-world.com/CPUs/Bulldozer/AMD-A10-Series%20A10-8700P.html
    :cpuvendor       => :AMD,
    :cpuarchitecture => :Bulldozer, # :Excavator
    :cpucores        => 4,
    :cputhreads      => 4,  # plus 6 GPU cores
    :cachesize       => (32768,), # This is correct since the subleaf 2 is missing of the cpuid dump.
    :cachelinesize   => 64,
    :simdbits        => 256,
  )))
  
# AMD Ryzen Threadripper 1950X 16-Core Processor
push!( _mockdb, (Dict(
    ((0x00000000, 0x00000000) => (0x0000000D, 0x68747541, 0x444D4163, 0x69746E65)),
    ((0x00000001, 0x00000000) => (0x00800F11, 0x00200800, 0x7ED8320B, 0x178BFBFF)),
    ((0x00000002, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x00000003, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x00000005, 0x00000000) => (0x00000040, 0x00000040, 0x00000003, 0x00000000)),
    ((0x00000006, 0x00000000) => (0x00000004, 0x00000000, 0x00000001, 0x00000000)),
    ((0x00000007, 0x00000000) => (0x00000000, 0x209C01A9, 0x00000000, 0x00000000)),
    ((0x00000008, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x00000009, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x0000000A, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x0000000C, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x0000000D, 0x00000000) => (0x00000007, 0x00000340, 0x00000340, 0x00000000)),
    ((0x0000000D, 0x00000001) => (0x0000000F, 0x00000340, 0x00000000, 0x00000000)),
    ((0x0000000D, 0x00000002) => (0x00000100, 0x00000240, 0x00000000, 0x00000000)),
    ((0x80000000, 0x00000000) => (0x8000001F, 0x68747541, 0x444D4163, 0x69746E65)),
    ((0x80000001, 0x00000000) => (0x00800F11, 0x70000000, 0x35C233FF, 0x2FD3FBFF)),
    ((0x80000002, 0x00000000) => (0x20444D41, 0x657A7952, 0x6854206E, 0x64616572)),
    ((0x80000003, 0x00000000) => (0x70706972, 0x31207265, 0x58303539, 0x2D363120)),
    ((0x80000004, 0x00000000) => (0x65726F43, 0x6F725020, 0x73736563, 0x0020726F)),
    ((0x80000005, 0x00000000) => (0xFF40FF40, 0xFF40FF40, 0x20080140, 0x40040140)),
    ((0x80000006, 0x00000000) => (0x36006400, 0x56006400, 0x02006140, 0x0100A140)),
    ((0x80000007, 0x00000000) => (0x00000000, 0x0000001B, 0x00000000, 0x00006799)),
    ((0x80000008, 0x00000000) => (0x00003030, 0x00000007, 0x0000501F, 0x00000000)),
    ((0x80000009, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x8000000A, 0x00000000) => (0x00000001, 0x00008000, 0x00000000, 0x0001BCFF)),
    ((0x8000000B, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x8000000C, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x8000000D, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x8000000E, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x8000000F, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x80000010, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x80000011, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x80000012, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x80000013, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x80000014, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x80000015, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x80000016, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x80000017, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x80000018, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x80000019, 0x00000000) => (0xF040F040, 0x00000000, 0x00000000, 0x00000000)),
    ((0x8000001A, 0x00000000) => (0x00000003, 0x00000000, 0x00000000, 0x00000000)),
    ((0x8000001B, 0x00000000) => (0x000003FF, 0x00000000, 0x00000000, 0x00000000)),
    ((0x8000001C, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
    ((0x8000001D, 0x00000000) => (0x00004121, 0x01C0003F, 0x0000003F, 0x00000000)),
    ((0x8000001D, 0x00000001) => (0x00004122, 0x00C0003F, 0x000000FF, 0x00000000)),
    ((0x8000001D, 0x00000002) => (0x00004143, 0x01C0003F, 0x000003FF, 0x00000002)),
    ((0x8000001D, 0x00000003) => (0x0001C163, 0x03C0003F, 0x00001FFF, 0x00000001)),
    ((0x8000001E, 0x00000000) => (0x00000000, 0x00000100, 0x00000100, 0x00000000)),
    ((0x8000001F, 0x00000000) => (0x00000007, 0x0000016F, 0x0000000F, 0x00000001)),
    ((0x8FFFFFFF, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
  ) => Dict{Symbol,Any}(
    # http://www.cpu-world.com/CPUs/Zen/AMD-Ryzen%20Threadripper%201950X.html
    :cpuvendor       => :AMD,
    :cpuarchitecture => :Zen,
    :cpucores        => (:broken, 16),
    :cputhreads      => 32,
    :cachesize       => (32768, 524288, 8388608),
    :cachelinesize   => 64,
    :simdbits        => 256,
  )))

# AMD A8-6410 APU with AMD Radeon R5 Graphics 
push!( _mockdb, (Dict(
    ((0x00000000, 0x00000000) => (0x0000000D, 0x68747541, 0x444D4163, 0x69746E65)),
    ((0x00000001, 0x00000000) => (0x00730F01, 0x00040800, 0x7ED8220B, 0x178BFBFF)), 
    ((0x00000002, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)), 
    ((0x00000003, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)), 
    ((0x00000005, 0x00000000) => (0x00000040, 0x00000040, 0x00000003, 0x00000000)), 
    ((0x00000006, 0x00000000) => (0x00000000, 0x00000000, 0x00000001, 0x00000000)), 
    ((0x00000007, 0x00000000) => (0x00000000, 0x00000008, 0x00000000, 0x00000000)), 
    ((0x00000008, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)), 
    ((0x00000009, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)), 
    ((0x0000000A, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)), 
    ((0x0000000C, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)), 
    ((0x0000000D, 0x00000000) => (0x00000007, 0x00000340, 0x00000340, 0x00000000)),
    ((0x0000000D, 0x00000001) => (0x00000001, 0x00000000, 0x00000000, 0x00000000)),
    ((0x0000000D, 0x00000002) => (0x00000100, 0x00000240, 0x00000000, 0x00000000)),
    ((0x80000000, 0x00000000) => (0x8000001E, 0x68747541, 0x444D4163, 0x69746E65)),
    ((0x80000001, 0x00000000) => (0x00730F01, 0x00000000, 0x1D4037FF, 0x2FD3FBFF)), 
    ((0x80000002, 0x00000000) => (0x20444D41, 0x362D3841, 0x20303134, 0x20555041)),
    ((0x80000003, 0x00000000) => (0x68746977, 0x444D4120, 0x64615220, 0x206E6F65)),
    ((0x80000004, 0x00000000) => (0x47203552, 0x68706172, 0x20736369, 0x00202020)),
    ((0x80000005, 0x00000000) => (0xFF08FF08, 0xFF28FF20, 0x20080140, 0x20020140)), 
    ((0x80000006, 0x00000000) => (0x21000000, 0x42004200, 0x08008140, 0x00000000)), 
    ((0x80000007, 0x00000000) => (0x00000000, 0x00000001, 0x00002800, 0x000033D9)), 
    ((0x80000008, 0x00000000) => (0x00003028, 0x00000000, 0x00003003, 0x00000000)), 
    ((0x80000009, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)), 
    ((0x8000000A, 0x00000000) => (0x00000001, 0x00000008, 0x00000000, 0x00001CDF)), 
    ((0x8000000B, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)), 
    ((0x8000000C, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)), 
    ((0x8000000D, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)), 
    ((0x8000000E, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)), 
    ((0x8000000F, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)), 
    ((0x80000010, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)), 
    ((0x80000011, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)), 
    ((0x80000012, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)), 
    ((0x80000013, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)), 
    ((0x80000014, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)), 
    ((0x80000015, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)), 
    ((0x80000016, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)), 
    ((0x80000017, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)), 
    ((0x80000018, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)), 
    ((0x80000019, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)), 
    ((0x8000001A, 0x00000000) => (0x00000003, 0x00000000, 0x00000000, 0x00000000)), 
    ((0x8000001B, 0x00000000) => (0x000000FF, 0x00000000, 0x00000000, 0x00000000)), 
    ((0x8000001C, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)), 
    ((0x8000001D, 0x00000000) => (0x00000121, 0x01C0003F, 0x0000003F, 0x00000000)),
    ((0x8000001D, 0x00000001) => (0x00000122, 0x0040003F, 0x000000FF, 0x00000000)),
    ((0x8000001D, 0x00000002) => (0x0000C143, 0x03C0003F, 0x000007FF, 0x00000002)),
    ((0x8000001E, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)), 
  ) => Dict{Symbol,Any}(
    # http://www.cpu-world.com/CPUs/Puma/AMD-A8-Series%20A8-6410.html
    :cpuvendor       => :AMD,
    :cpuarchitecture => :Puma,
    :cpucores        => 4,
    :cputhreads      => 4,
    :cachesize       => (32768, 2097152),
    :cachelinesize   => 64,
    :simdbits        => 256,
  )))

# AMD Athlon(tm) 5350 APU with Radeon(tm) R3
push!( _mockdb, (Dict(
    ((0x00000000, 0x00000000) => (0x0000000D, 0x68747541, 0x444D4163, 0x69746E65)),
    ((0x00000001, 0x00000000) => (0x00700F01, 0x00040800, 0x3ED8220B, 0x178BFBFF)), 
    ((0x00000002, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)), 
    ((0x00000003, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)), 
    ((0x00000005, 0x00000000) => (0x00000040, 0x00000040, 0x00000003, 0x00000000)), 
    ((0x00000006, 0x00000000) => (0x00000000, 0x00000000, 0x00000001, 0x00000000)), 
    ((0x00000007, 0x00000000) => (0x00000000, 0x00000008, 0x00000000, 0x00000000)), 
    ((0x00000008, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)), 
    ((0x00000009, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)), 
    ((0x0000000A, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)), 
    ((0x0000000C, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)), 
    ((0x0000000D, 0x00000000) => (0x00000007, 0x00000340, 0x00000340, 0x00000000)),
    ((0x0000000D, 0x00000001) => (0x00000001, 0x00000000, 0x00000000, 0x00000000)),
    ((0x0000000D, 0x00000002) => (0x00000100, 0x00000240, 0x00000000, 0x00000000)),
    ((0x80000000, 0x00000000) => (0x8000001E, 0x68747541, 0x444D4163, 0x69746E65)),
    ((0x80000001, 0x00000000) => (0x00700F01, 0x10000000, 0x154037FF, 0x2FD3FBFF)), 
    ((0x80000002, 0x00000000) => (0x20444D41, 0x6C687441, 0x74286E6F, 0x3520296D)),
    ((0x80000003, 0x00000000) => (0x20303533, 0x20555041, 0x68746977, 0x64615220)),
    ((0x80000004, 0x00000000) => (0x286E6F65, 0x20296D74, 0x20203352, 0x00202020)),
    ((0x80000005, 0x00000000) => (0xFF08FF08, 0xFF28FF20, 0x20080140, 0x20020140)), 
    ((0x80000006, 0x00000000) => (0x21000000, 0x42004200, 0x08008140, 0x00000000)), 
    ((0x80000007, 0x00000000) => (0x0D6B0101, 0x00000001, 0x00000000, 0x000009D9)), 
    ((0x80000008, 0x00000000) => (0x00003028, 0x00000000, 0x00003003, 0x00000000)), 
    ((0x80000009, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)), 
    ((0x8000000A, 0x00000000) => (0x00000001, 0x00000008, 0x00000000, 0x00001CDF)), 
    ((0x8000000B, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)), 
    ((0x8000000C, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)), 
    ((0x8000000D, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)), 
    ((0x8000000E, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)), 
    ((0x8000000F, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)), 
    ((0x80000010, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)), 
    ((0x80000011, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)), 
    ((0x80000012, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)), 
    ((0x80000013, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)), 
    ((0x80000014, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)), 
    ((0x80000015, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)), 
    ((0x80000016, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)), 
    ((0x80000017, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)), 
    ((0x80000018, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)), 
    ((0x80000019, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)), 
    ((0x8000001A, 0x00000000) => (0x00000003, 0x00000000, 0x00000000, 0x00000000)), 
    ((0x8000001B, 0x00000000) => (0x000000FF, 0x00000000, 0x00000000, 0x00000000)), 
    ((0x8000001C, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)), 
    ((0x8000001D, 0x00000000) => (0x00000121, 0x01C0003F, 0x0000003F, 0x00000000)),
    ((0x8000001D, 0x00000001) => (0x00000122, 0x0040003F, 0x000000FF, 0x00000000)),
    ((0x8000001D, 0x00000002) => (0x0000C143, 0x03C0003F, 0x000007FF, 0x00000002)),
    ((0x8000001E, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)), 
    ((0x8FFFFFFF, 0x00000000) => (0x4C4C4548, 0x494B204F, 0x21595454, 0x5E2D5E20)), 
  ) => Dict{Symbol,Any}(
    # http://www.cpu-world.com/CPUs/Puma/AMD-A8-Series%20A8-6410.html
    :cpuvendor       => :AMD,
    :cpuarchitecture => :Jaguar,
    :cpucores        => 4,
    :cputhreads      => 4,
    :cachesize       => (32768, 2097152),
    :cachelinesize   => 64,
    :simdbits        => 256,
  )))
  
# AMD EPYC 7401P 24-Core Processor without hypervisor
push!( _mockdb, (Dict(
  ((0x00000000, 0x00000000) => (0x0000000d, 0x68747541, 0x444d4163, 0x69746e65)),
  ((0x00000001, 0x00000000) => (0x00800f12, 0x30300800, 0x7ed8320b, 0x178bfbff)),
  ((0x00000002, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
  ((0x00000003, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
  ((0x00000004, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
  ((0x00000005, 0x00000000) => (0x00000040, 0x00000040, 0x00000003, 0x00000011)),
  ((0x00000006, 0x00000000) => (0x00000004, 0x00000000, 0x00000001, 0x00000000)),
  ((0x00000007, 0x00000000) => (0x00000000, 0x209c01a9, 0x00000000, 0x00000000)),
  ((0x00000008, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
  ((0x00000009, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
  ((0x0000000a, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
  ((0x0000000b, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
  ((0x0000000c, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
  ((0x0000000d, 0x00000000) => (0x00000007, 0x00000340, 0x00000340, 0x00000000)),
  ((0x80000000, 0x00000000) => (0x8000001f, 0x68747541, 0x444d4163, 0x69746e65)),
  ((0x80000001, 0x00000000) => (0x00800f12, 0x40000000, 0x35c233ff, 0x2fd3fbff)),
  ((0x80000002, 0x00000000) => (0x20444d41, 0x43595045, 0x30343720, 0x32205031)),
  ((0x80000003, 0x00000000) => (0x6f432d34, 0x50206572, 0x65636f72, 0x726f7373)),
  ((0x80000004, 0x00000000) => (0x20202020, 0x20202020, 0x20202020, 0x00202020)),
  ((0x80000005, 0x00000000) => (0xff40ff40, 0xff40ff40, 0x20080140, 0x40040140)),
  ((0x80000006, 0x00000000) => (0x36006400, 0x56006400, 0x02006140, 0x0200c140)),
  ((0x80000007, 0x00000000) => (0x00000000, 0x0000001b, 0x00000000, 0x00006799)),
  ((0x80000008, 0x00000000) => (0x00003030, 0x00001007, 0x0000602f, 0x00000000)),
  ((0x80000009, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
  ((0x8000000a, 0x00000000) => (0x00000001, 0x00008000, 0x00000000, 0x0001bcff)),
  ((0x8000000b, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
  ((0x8000000c, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
  ((0x8000000d, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
  ((0x8000000e, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
  ((0x8000000f, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
  ((0x80000010, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
  ((0x80000011, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
  ((0x80000012, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
  ((0x80000013, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
  ((0x80000014, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
  ((0x80000015, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
  ((0x80000016, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
  ((0x80000017, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
  ((0x80000018, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
  ((0x80000019, 0x00000000) => (0xf040f040, 0x00000000, 0x00000000, 0x00000000)),
  ((0x8000001a, 0x00000000) => (0x00000003, 0x00000000, 0x00000000, 0x00000000)),
  ((0x8000001b, 0x00000000) => (0x000003ff, 0x00000000, 0x00000000, 0x00000000)),
  ((0x8000001c, 0x00000000) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
  ((0x8000001d, 0x00000000) => (0x00004121, 0x01c0003f, 0x0000003f, 0x00000000)),
  ((0x8000001e, 0x00000000) => (0x00000030, 0x00000118, 0x00000303, 0x00000000)),
  ((0x8000001f, 0x00000000) => (0x0000000f, 0x0000016f, 0x0000000f, 0x00000001)),
  ((0x00000004, 0x00000001) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
  ((0x0000000b, 0x00000001) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
  ((0x8000001d, 0x00000001) => (0x00004122, 0x00c0003f, 0x000000ff, 0x00000000)),
  ((0x8000001d, 0x00000002) => (0x00004143, 0x01c0003f, 0x000003ff, 0x00000002)),
  ((0x8000001d, 0x00000003) => (0x00014163, 0x03c0003f, 0x00001fff, 0x00000001)),
  ((0x8000001d, 0x00000004) => (0x00000000, 0x00000000, 0x00000000, 0x00000000)),
) => Dict{Symbol,Any}(
  # http://www.cpu-world.com/CPUs/Zen/AMD-EPYC%207401P.html
  :cpuvendor       => :AMD,
  :cpuarchitecture => :Zen,
  :cpucores        => (:broken, 24),
  :cputhreads      => 48,
  :cachesize       => (32768, 524288, 8388608),
  :cachelinesize   => 64,
  :simdbits        => 256,
)))

#=--- end of file ---------------------------------------------------------=#
