# DataStructures.IntSet

`DataStructures.IntSet` is a drop-in replacement for the Base `BitSet`
type. It efficiently stores dense collections of small non-negative
`Int`s as a sorted set. The constructor `IntSet([itr])` constructs a
sorted set of the integers generated by the given iterable object, or an
empty set if no argument is given. If the set will be sparse (for
example holding a few very large integers), use `Set` or `SortedSet`
instead.

A complement IntSet may be constructed with `complement` or
`complement!`. The complement of an empty `IntSet` contains
`typemax(Int)` elements from 0 to `typemax(Int)-1`.
