# DocStringExtensions

*Extensions for Julia's docsystem.*

| **Documentation**                                                               | **Build Status**                                                                                |
|:-------------------------------------------------------------------------------:|:-----------------------------------------------------------------------------------------------:|
| [![][docs-stable-img]][docs-stable-url] [![][docs-latest-img]][docs-latest-url] | [![CI][github-action-img]][github-action-url] [![][codecov-img]][codecov-url] |

## Installation

The package can be added using the Julia package manager. From the Julia REPL, type `]`
to enter the Pkg REPL mode and run

```
pkg> add DocStringExtensions
```

## Documentation

- [**STABLE**][docs-stable-url] &mdash; **most recently tagged version of the documentation.**
- [**LATEST**][docs-latest-url] &mdash; *in-development version of the documentation.*

## Project Status

The package is tested and developed against Julia `1.0`, as well as the latest `stable` and `nightly` versions on Linux, OS X, and Windows,
but there are versions of the package that work on older versions of Julia.

## Contributing and Questions

Contributions are very welcome, as are feature requests and suggestions. Please open an [issue][issues-url] if you encounter any problems. If you have a question then feel free to ask for help in the [Gitter chat room][gitter-url].

[gitter-url]: https://gitter.im/juliadocs/users

[docs-latest-img]: https://img.shields.io/badge/docs-latest-blue.svg
[docs-latest-url]: https://DocStringExtensions.juliadocs.org/latest

[docs-stable-img]: https://img.shields.io/badge/docs-stable-blue.svg
[docs-stable-url]: https://DocStringExtensions.juliadocs.org/stable

[github-action-img]: https://github.com/JuliaDocs/DocStringExtensions.jl/actions/workflows/ci.yml/badge.svg
[github-action-url]: https://github.com/JuliaDocs/DocStringExtensions.jl/actions/workflows/ci.yml

[codecov-img]: https://codecov.io/gh/JuliaDocs/DocStringExtensions.jl/branch/master/graph/badge.svg
[codecov-url]: https://codecov.io/gh/JuliaDocs/DocStringExtensions.jl

[issues-url]: https://github.com/JuliaDocs/DocStringExtensions.jl/issues
