#
# This code is auto generated from the GSL headers, do not edit!
#


#### gsl_rng.h ################################################################


@doc md"""
    rng_alloc(T) -> Ptr{gsl_rng}

C signature:
`gsl_rng *gsl_rng_alloc (const gsl_rng_type * T)`

GSL documentation:

### `gsl_rng * gsl_rng_alloc (const gsl_rng_type * T)`

> This function returns a pointer to a newly-created instance of a
> random number generator of type `T`. For example, the following code
> creates an instance of the Tausworthe generator:
>
>     gsl_rng * r = gsl_rng_alloc (gsl_rng_taus);
>
> If there is insufficient memory to create the generator then the
> function returns a null pointer and the error handler is invoked with
> an error code of `GSL_ENOMEM`.
>
> The generator is automatically initialized with the default seed,
> `gsl_rng_default_seed`. This is zero by default but can be changed
> either directly or by using the environment variable `GSL_RNG_SEED`.
>
> The details of the available generator types are described later in
> this chapter.

"""
function rng_alloc(T)
    ccall((:gsl_rng_alloc, libgsl), Ptr{gsl_rng}, (Ptr{gsl_rng_type},), T)
end

@doc md"""
    rng_memcpy(dest, src) -> Cint

C signature:
`int gsl_rng_memcpy (gsl_rng * dest, const gsl_rng * src)`

GSL documentation:

### `int gsl_rng_memcpy (gsl_rng * dest, const gsl_rng * src)`

> This function copies the random number generator `src` into the
> pre-existing generator `dest`, making `dest` into an exact copy of
> `src`. The two generators must be of the same type.

"""
function rng_memcpy(dest, src)
    ccall((:gsl_rng_memcpy, libgsl), Cint, (Ref{gsl_rng}, Ref{gsl_rng}), dest, src)
end

@doc md"""
    rng_clone(r) -> Ptr{gsl_rng}

C signature:
`gsl_rng *gsl_rng_clone (const gsl_rng * r)`

GSL documentation:

### `gsl_rng * gsl_rng_clone (const gsl_rng * r)`

> This function returns a pointer to a newly created generator which is
> an exact copy of the generator `r`.

"""
function rng_clone(r)
    ccall((:gsl_rng_clone, libgsl), Ptr{gsl_rng}, (Ptr{gsl_rng},), r)
end

@doc md"""
    rng_free(r) -> Cvoid

C signature:
`void gsl_rng_free (gsl_rng * r)`

GSL documentation:

### `void gsl_rng_free (gsl_rng * r)`

> This function frees all the memory associated with the generator `r`.

"""
function rng_free(r)
    ccall((:gsl_rng_free, libgsl), Cvoid, (Ptr{gsl_rng},), r)
end

@doc md"""
    rng_set(r, seed) -> Cvoid

C signature:
`void gsl_rng_set (const gsl_rng * r, unsigned long int seed)`

GSL documentation:

### `void gsl_rng_set (const gsl_rng * r, unsigned long int s)`

> This function initializes (or "seeds") the random number generator. If
> the generator is seeded with the same value of `s` on two different
> runs, the same stream of random numbers will be generated by
> successive calls to the routines below. If different values of
> $s \geq 1$ are supplied, then the generated streams of random numbers
> should be completely different. If the seed `s` is zero then the
> standard seed from the original implementation is used instead. For
> example, the original Fortran source code for the `ranlux` generator
> used a seed of 314159265, and so choosing `s` equal to zero reproduces
> this when using `gsl_rng_ranlux`.
>
> When using multiple seeds with the same generator, choose seed values
> greater than zero to avoid collisions with the default setting.
>
> Note that the most generators only accept 32-bit seeds, with higher
> values being reduced modulo $2^{32}$. For generators with smaller
> ranges the maximum seed value will typically be lower.

"""
function rng_set(r, seed)
    ccall((:gsl_rng_set, libgsl), Cvoid, (Ref{gsl_rng}, Culong), r, seed)
end

@doc md"""
    rng_max(r) -> Culong

C signature:
`unsigned long int gsl_rng_max (const gsl_rng * r)`

GSL documentation:

### `unsigned long int gsl_rng_max (const gsl_rng * r)`

> This function returns the largest value that `gsl_rng_get` can return.

"""
function rng_max(r)
    ccall((:gsl_rng_max, libgsl), Culong, (Ptr{gsl_rng},), r)
end

@doc md"""
    rng_min(r) -> Culong

C signature:
`unsigned long int gsl_rng_min (const gsl_rng * r)`

GSL documentation:

### `unsigned long int gsl_rng_min (const gsl_rng * r)`

> This function returns the smallest value that `gsl_rng_get` can
> return. Usually this value is zero. There are some generators with
> algorithms that cannot return zero, and for these generators the
> minimum value is 1.

"""
function rng_min(r)
    ccall((:gsl_rng_min, libgsl), Culong, (Ptr{gsl_rng},), r)
end

@doc md"""
    rng_name(r) -> Ptr{Cchar}

C signature:
`const char *gsl_rng_name (const gsl_rng * r)`

GSL documentation:

### `const char * gsl_rng_name (const gsl_rng * r)`

> This function returns a pointer to the name of the generator. For
> example:
>
>     printf ("r is a '%s' generator\n", gsl_rng_name (r));
>
> would print something like:
>
>     r is a 'taus' generator

"""
function rng_name(r)
    ccall((:gsl_rng_name, libgsl), Ptr{Cchar}, (Ptr{gsl_rng},), r)
end

@doc md"""
    rng_fread(stream, r) -> Cint

C signature:
`int gsl_rng_fread (FILE * stream, gsl_rng * r)`

GSL documentation:

### `int gsl_rng_fread (FILE * stream, gsl_rng * r)`

> This function reads the random number state into the random number
> generator `r` from the open stream `stream` in binary format. The
> random number generator `r` must be preinitialized with the correct
> random number generator type since type information is not saved. The
> return value is 0 for success and `GSL_EFAILED` if there was a problem
> reading from the file. The data is assumed to have been written in the
> native binary format on the same architecture.

"""
function rng_fread(stream, r)
    ccall((:gsl_rng_fread, libgsl), Cint, (Ref{Cvoid}, Ref{gsl_rng}), stream, r)
end

@doc md"""
    rng_fwrite(stream, r) -> Cint

C signature:
`int gsl_rng_fwrite (FILE * stream, const gsl_rng * r)`

GSL documentation:

### `int gsl_rng_fwrite (FILE * stream, const gsl_rng * r)`

> This function writes the random number state of the random number
> generator `r` to the stream `stream` in binary format. The return
> value is 0 for success and `GSL_EFAILED` if there was a problem
> writing to the file. Since the data is written in the native binary
> format it may not be portable between different architectures.

"""
function rng_fwrite(stream, r)
    ccall((:gsl_rng_fwrite, libgsl), Cint, (Ref{Cvoid}, Ref{gsl_rng}), stream, r)
end

@doc md"""
    rng_size(r) -> Csize_t

C signature:
`size_t gsl_rng_size (const gsl_rng * r)`
"""
function rng_size(r)
    ccall((:gsl_rng_size, libgsl), Csize_t, (Ptr{gsl_rng},), r)
end

@doc md"""
    rng_state(r) -> Ptr{Cvoid}

C signature:
`void * gsl_rng_state (const gsl_rng * r)`

GSL documentation:

### `void * gsl_rng_state (const gsl_rng * r)`

> size\_t gsl\_rng\_size (const gsl\_rng \* r)

> These functions return a pointer to the state of generator `r` and its
> size. You can use this information to access the state directly. For
> example, the following code will write the state of a generator to a
> stream:
>
>     void * state = gsl_rng_state (r);
>     size_t n = gsl_rng_size (r);
>     fwrite (state, n, 1, stream);

"""
function rng_state(r)
    ccall((:gsl_rng_state, libgsl), Ptr{Cvoid}, (Ptr{gsl_rng},), r)
end

@doc md"""
    rng_print_state(r) -> Cvoid

C signature:
`void gsl_rng_print_state (const gsl_rng * r)`
"""
function rng_print_state(r)
    ccall((:gsl_rng_print_state, libgsl), Cvoid, (Ptr{gsl_rng},), r)
end

@doc md"""
    rng_env_setup() -> Ptr{gsl_rng_type}

C signature:
`const gsl_rng_type * gsl_rng_env_setup (void)`

GSL documentation:

### `const gsl_rng_type * gsl_rng_env_setup (void)`

> This function reads the environment variables `GSL_RNG_TYPE` and
> `GSL_RNG_SEED` and uses their values to set the corresponding library
> variables `gsl_rng_default` and `gsl_rng_default_seed`.
>
> The value of `GSL_RNG_SEED` is converted to an `unsigned long int`
> using the C library function `strtoul`.
>
> If you don't specify a generator for `GSL_RNG_TYPE` then
> `gsl_rng_mt19937` is used as the default. The initial value of
> `gsl_rng_default_seed` is zero.

Here is a short program which shows how to create a global generator
using the environment variables `GSL_RNG_TYPE` and `GSL_RNG_SEED`,

"""
function rng_env_setup()
    ccall((:gsl_rng_env_setup, libgsl), Ptr{gsl_rng_type}, (), )
end

@doc md"""
    rng_get(r) -> Culong

C signature:
`unsigned long int gsl_rng_get (const gsl_rng * r)`

GSL documentation:

### `unsigned long int gsl_rng_get (const gsl_rng * r)`

> This function returns a random integer from the generator `r`. The
> minimum and maximum values depend on the algorithm used, but all
> integers in the range \[`min`, `max`\] are equally likely. The values
> of `min` and `max` can be determined using the auxiliary functions
> `gsl_rng_max` and `gsl_rng_min`.

"""
function rng_get(r)
    ccall((:gsl_rng_get, libgsl), Culong, (Ptr{gsl_rng},), r)
end

@doc md"""
    rng_uniform(r) -> Cdouble

C signature:
`double gsl_rng_uniform (const gsl_rng * r)`

GSL documentation:

### `double gsl_rng_uniform (const gsl_rng * r)`

> This function returns a double precision floating point number
> uniformly distributed in the range \[0,1). The range includes 0.0 but
> excludes 1.0. The value is typically obtained by dividing the result
> of `gsl_rng_get(r)` by `gsl_rng_max(r) + 1.0` in double precision.
> Some generators compute this ratio internally so that they can provide
> floating point numbers with more than 32 bits of randomness (the
> maximum number of bits that can be portably represented in a single
> `unsigned long int`).

"""
function rng_uniform(r)
    ccall((:gsl_rng_uniform, libgsl), Cdouble, (Ptr{gsl_rng},), r)
end

@doc md"""
    rng_uniform_pos(r) -> Cdouble

C signature:
`double gsl_rng_uniform_pos (const gsl_rng * r)`

GSL documentation:

### `double gsl_rng_uniform_pos (const gsl_rng * r)`

> This function returns a positive double precision floating point
> number uniformly distributed in the range (0,1), excluding both 0.0
> and 1.0. The number is obtained by sampling the generator with the
> algorithm of `gsl_rng_uniform` until a non-zero value is obtained. You
> can use this function if you need to avoid a singularity at 0.0.

"""
function rng_uniform_pos(r)
    ccall((:gsl_rng_uniform_pos, libgsl), Cdouble, (Ptr{gsl_rng},), r)
end

@doc md"""
    rng_uniform_int(r, n) -> Culong

C signature:
`unsigned long int gsl_rng_uniform_int (const gsl_rng * r, unsigned long int n)`

GSL documentation:

### `unsigned long int gsl_rng_uniform_int (const gsl_rng * r, unsigned long int n)`

> This function returns a random integer from 0 to $n-1$ inclusive by
> scaling down and/or discarding samples from the generator `r`. All
> integers in the range $[0,n-1]$ are produced with equal probability.
> For generators with a non-zero minimum value an offset is applied so
> that zero is returned with the correct probability.
>
> Note that this function is designed for sampling from ranges smaller
> than the range of the underlying generator. The parameter `n` must be
> less than or equal to the range of the generator `r`. If `n` is larger
> than the range of the generator then the function calls the error
> handler with an error code of `GSL_EINVAL` and returns zero.
>
> In particular, this function is not intended for generating the full
> range of unsigned integer values $[0,2^{32}-1]$. Instead choose a
> generator with the maximal integer range and zero minimum value, such
> as `gsl_rng_ranlxd1`, `gsl_rng_mt19937` or `gsl_rng_taus`, and sample
> it directly using `gsl_rng_get`. The range of each generator can be
> found using the auxiliary functions described in the next section.

"""
function rng_uniform_int(r, n)
    ccall((:gsl_rng_uniform_int, libgsl), Culong, (Ref{gsl_rng}, Culong), r, n)
end

