@test latexify("α"; convert_unicode=false) == raw"$α$"

@test latexify(['α', :β, "γ/η"], transpose=true, convert_unicode=false) == replace(
raw"\begin{equation}
\left[
\begin{array}{ccc}
α & β & \frac{γ}{η} \\
\end{array}
\right]
\end{equation}
", "\r\n"=>"\n")

@test latexify("αaβ") == raw"${\alpha}a\beta$"

@test latexify("αaβ").s == raw"${\alpha}a\beta$"

@test latexify("ÀéÜ"; parse=false).s == raw"$\textnormal{\`{A}}\textnormal{\'{e}}\textnormal{\\\"{U}}$"

@test latexify("w̋Ṽî"; parse=false).s == raw"$\textnormal{\H{w}}\tilde{V}\hat{i}$"

@test latexify("çĘf̄"; parse=false).s == raw"$\textnormal{\c{c}}\textnormal{\k{E}}\bar{f}$"

@test latexify("ṞȯX̣"; parse=false).s == raw"$\textnormal{\b{R}}\dot{o}\textnormal{\d{X}}$"

@test latexify("ẙĞž"; parse=false).s == raw"$\textnormal{\r{y}}\textnormal{\u{G}}\textnormal{\v{z}}$"

@test latexify("τ̇"; parse=false).s == raw"$\dot{\tau}$"
@test latexify("τ̈"; parse=false).s == raw"$\ddot{\tau}$"
@test latexify("τ⃛"; parse=false).s == raw"$\dddot{\tau}$"
@test latexify("τ⃜"; parse=false).s == raw"$\ddddot{\tau}$"

s = 'y' * Char(0x30a) * 'x' * Char(0x302) * 'a' * Char(0x331)
@test latexify(s; parse=false).s == raw"$\textnormal{\r{y}}\hat{x}\textnormal{\b{a}}$"

s = 'Y' * Char(0x30a) * 'X' * Char(0x302) * 'A' * Char(0x331)
@test latexify(s; parse=false).s == raw"$\textnormal{\r{Y}}\hat{X}\textnormal{\b{A}}$"

s = 'i' * Char(0x308) * 'z' * Char(0x304) * 'e' * Char(0x306)
@test latexify(s; parse=false).s == raw"$\textnormal{\\\"{i}}\bar{z}\textnormal{\u{e}}$"

s = 'I' * Char(0x308) * 'Z' * Char(0x304) * 'E' * Char(0x306)
@test latexify(s; parse=false).s == raw"$\textnormal{\\\"{I}}\bar{Z}\textnormal{\u{E}}$"

@test latexify("ẋ  + ω̂") == raw"$\dot{x} + \hat{\omega}$"

@test latexify(:(iħ * (∂Ψ(𝐫, t) / ∂t) = -ħ^2 / 2m * ΔΨ(𝐫, t) + V * Ψ(𝐫, t))).s ==
    raw"$i\hslash \cdot \frac{\partial\Psi\left( \mathbf{r}, t \right)}{{\partial}t} = " *
    raw"\frac{ - \hslash^{2}}{2 \cdot m} \cdot \Delta\Psi\left( \mathbf{r}, t \right) + V \cdot \Psi\left( \mathbf{r}, t \right)$"

if Sys.islinux()
    mktempdir() do dn
        name = tempname()
        str = map(
            chunk -> string("\\[", join(chunk, " "), "\\]\n"),
            Iterators.partition(values(Latexify.unicodedict), 40)
        ) |> prod
        Latexify._writetex(
            LaTeXString(str),
            name=name,
            documentclass="article",
            preamble="\\usepackage[margin=2cm]{geometry}"
        )
        # should compile, even if some glyphs aren't found in the default font face
        @test pipeline(`latexmk -output-directory=$dn -quiet -pdflatex=lualatex -pdf $name.tex`, stdout=devnull) |> run |> success
    end

    # not checked for correctness, only for rendering without errors
    eq = latexify(:(sin(α) / (β + 1)))

    name = tempname()
    render(eq, MIME("application/pdf"); name=name, open=false)
    @test filesize("$name.pdf") > 100

    name = tempname()
    render(eq, MIME("application/x-dvi"); name=name, open=false)
    @test filesize("$name.dvi") > 100

    name = tempname()
    render(eq, MIME("image/png"); name=name, open=false)
    @test filesize("$name.png") > 100

    name = tempname()
    render(eq, MIME("image/svg"); name=name, open=false)
    @test filesize("$name.svg") > 100
end
